/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.master.cssp.CustomerCollection;
import com.kingdee.eas.basedata.master.cssp.CustomerFactory;
import com.kingdee.eas.basedata.master.cssp.CustomerInfo;
import com.kingdee.eas.basedata.master.cssp.ICustomer;
import com.kingdee.eas.basedata.master.cssp.ISupplier;
import com.kingdee.eas.basedata.master.cssp.SupplierCollection;
import com.kingdee.eas.basedata.master.cssp.SupplierFactory;
import com.kingdee.eas.basedata.master.cssp.SupplierInfo;
import com.kingdee.eas.basedata.master.material.IMultiMeasureUnit;
import com.kingdee.eas.basedata.master.material.MaterialCollection;
import com.kingdee.eas.basedata.master.material.MaterialFactory;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.scm.common.DiscountModeEnum;
import com.kingdee.eas.basedata.scm.im.inv.FetchPriceEnum;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.CoreBillBaseCollection;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.scm.cal.CalculateFacadeFactory;
import com.kingdee.eas.scm.cal.ICalculateFacade;
import com.kingdee.eas.scm.cal.util.CalculateUtil;
import com.kingdee.eas.scm.common.EntryBaseStatusEnum;
import com.kingdee.eas.scm.common.SCMBillBaseInfo;
import com.kingdee.eas.scm.common.SCMBillException;
import com.kingdee.eas.scm.common.util.SCMConstant;
import com.kingdee.eas.scm.im.inv.IPurInWarehsBill;
import com.kingdee.eas.scm.im.inv.ISaleIssueBill;
import com.kingdee.eas.scm.im.inv.InvBillBaseInfo;
import com.kingdee.eas.scm.im.inv.InvBizException;
import com.kingdee.eas.scm.im.inv.PurInWarehsBillCollection;
import com.kingdee.eas.scm.im.inv.PurInWarehsBillFactory;
import com.kingdee.eas.scm.im.inv.PurInWarehsBillInfo;
import com.kingdee.eas.scm.im.inv.PurInWarehsEntryCollection;
import com.kingdee.eas.scm.im.inv.PurInWarehsEntryInfo;
import com.kingdee.eas.scm.im.inv.SaleIssueBillCollection;
import com.kingdee.eas.scm.im.inv.SaleIssueBillFactory;
import com.kingdee.eas.scm.im.inv.SaleIssueBillInfo;
import com.kingdee.eas.scm.im.inv.SaleIssueEntryCollection;
import com.kingdee.eas.scm.im.inv.SaleIssueEntryInfo;
import com.kingdee.eas.scm.im.inv.app.AbstractVirtualBill;
import com.kingdee.eas.scm.im.inv.app.InvServerUtils;
import com.kingdee.eas.scm.sd.sale.ISaleInnerDealPrice;
import com.kingdee.eas.scm.sd.sale.ISaleOrder;
import com.kingdee.eas.scm.sd.sale.ISaleReturnInnerDealPrice;
import com.kingdee.eas.scm.sd.sale.ISaleReturns;
import com.kingdee.eas.scm.sd.sale.SaleInnerDealPriceFactory;
import com.kingdee.eas.scm.sd.sale.SaleInnerDealPriceInfo;
import com.kingdee.eas.scm.sd.sale.SaleOrderEntryCollection;
import com.kingdee.eas.scm.sd.sale.SaleOrderEntryInfo;
import com.kingdee.eas.scm.sd.sale.SaleOrderFactory;
import com.kingdee.eas.scm.sd.sale.SaleOrderInfo;
import com.kingdee.eas.scm.sd.sale.SaleReturnInnerDealPriceFactory;
import com.kingdee.eas.scm.sd.sale.SaleReturnInnerDealPriceInfo;
import com.kingdee.eas.scm.sd.sale.SaleReturnsEntryCollection;
import com.kingdee.eas.scm.sd.sale.SaleReturnsEntryInfo;
import com.kingdee.eas.scm.sd.sale.SaleReturnsFactory;
import com.kingdee.eas.scm.sd.sale.SaleReturnsInfo;
import com.kingdee.eas.scm.sm.pur.PurOrderInfo;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public class SaleIssueVirtualHandler
extends AbstractVirtualBill {
    private static final int INT_YEAR = 0;
    private static final int INT_PERIOD = 1;

    public boolean createVirtualBill(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        SaleIssueBillInfo saleIssueBillInfo = (SaleIssueBillInfo)model;
        if (!this.check(saleIssueBillInfo)) {
            return false;
        }
        ISaleOrder iSaleOrder = SaleOrderFactory.getLocalInstance((Context)ctx);
        ISaleReturns iSaleReturns = SaleReturnsFactory.getLocalInstance((Context)ctx);
        ISaleIssueBill iSaleIssueBill = SaleIssueBillFactory.getLocalInstance(ctx);
        IPurInWarehsBill iPurInWarehsBill = PurInWarehsBillFactory.getLocalInstance(ctx);
        SaleOrderInfo saleOrderInfo = null;
        SaleReturnsInfo saleReturnsInfo = null;
        Map map = this.transform(ctx, model);
        SaleIssueBillInfo destSaleBillInfo = (SaleIssueBillInfo)map.get("7oaZzawjS9GgNiZmMD47+gRRIsQ=");
        SaleIssueBillInfo destBalanceSaleBillInfo = (SaleIssueBillInfo)map.get("vtc6+DmzRZuctXJnN2Xq8QRRIsQ=");
        PurInWarehsBillInfo destPurInBillInfo = (PurInWarehsBillInfo)map.get("gYsvHf7jTfCEbbqwWIMWuwRRIsQ=");
        PurInWarehsBillInfo destBalancePurInBillInfo = (PurInWarehsBillInfo)map.get("1GPQQQpoT6mGd1cRsEbMywRRIsQ=");
        SaleIssueBillCollection saleIssueCol = new SaleIssueBillCollection();
        saleIssueCol.add(destSaleBillInfo);
        saleIssueCol.add(destBalanceSaleBillInfo);
        PurInWarehsBillCollection purInwarehsCol = new PurInWarehsBillCollection();
        purInwarehsCol.add(destPurInBillInfo);
        purInwarehsCol.add(destBalancePurInBillInfo);
        this.resetEntryMaterialInfo(ctx, saleIssueCol);
        this.resetEntryMaterialInfo(ctx, purInwarehsCol);
        HashSet<String> coreIdSet = new HashSet<String>();
        for (int i = 0; i < saleIssueBillInfo.getEntry().size(); ++i) {
            coreIdSet.add(saleIssueBillInfo.getEntry().get(i).getSaleOrder());
        }
        for (String id : coreIdSet) {
            ObjectUuidPK pk = new ObjectUuidPK(id);
            if (this.isSaleReturnCoreBill) {
                saleReturnsInfo = iSaleReturns.getSaleReturnsInfo((IObjectPK)pk);
            } else {
                saleOrderInfo = iSaleOrder.getSaleOrderInfo((IObjectPK)pk);
            }
            this.processPurInWarehs(ctx, destPurInBillInfo, saleOrderInfo, saleReturnsInfo);
            this.processBalancePurInWarehs(ctx, destBalancePurInBillInfo, saleOrderInfo, saleReturnsInfo);
            this.processSaleIssue(ctx, destSaleBillInfo, saleOrderInfo, saleReturnsInfo);
            this.processBalanceSaleIssue(ctx, destBalanceSaleBillInfo, saleOrderInfo, saleReturnsInfo);
        }
        CoreBillBaseCollection coreBillBaseColl1 = new CoreBillBaseCollection();
        destPurInBillInfo.put("isIsSquareBalance", Boolean.TRUE);
        coreBillBaseColl1.add((CoreBillBaseInfo)destPurInBillInfo);
        CoreBillBaseCollection coreBillBaseColl2 = new CoreBillBaseCollection();
        destBalancePurInBillInfo.put("isIsSquareBalance", Boolean.TRUE);
        coreBillBaseColl2.add((CoreBillBaseInfo)destBalancePurInBillInfo);
        iPurInWarehsBill.handleAfterTransform("SAVE", (IObjectCollection)coreBillBaseColl1);
        iPurInWarehsBill.handleAfterTransform("SAVE", (IObjectCollection)coreBillBaseColl2);
        coreBillBaseColl1 = new CoreBillBaseCollection();
        destSaleBillInfo.put("isIsSquareBalance", Boolean.TRUE);
        coreBillBaseColl1.add((CoreBillBaseInfo)destSaleBillInfo);
        iSaleIssueBill.handleAfterTransform("SAVE", (IObjectCollection)coreBillBaseColl1);
        coreBillBaseColl2 = new CoreBillBaseCollection();
        destBalanceSaleBillInfo.put("isIsSquareBalance", Boolean.TRUE);
        coreBillBaseColl2.add((CoreBillBaseInfo)destBalanceSaleBillInfo);
        iSaleIssueBill.handleAfterTransform("SAVE", (IObjectCollection)coreBillBaseColl2);
        this.checkMatCompanyInfo(ctx, destSaleBillInfo);
        this.checkMatCompanyInfo(ctx, destBalanceSaleBillInfo);
        this.checkMatCompanyInfo(ctx, destPurInBillInfo);
        this.checkMatCompanyInfo(ctx, destBalancePurInBillInfo);
        iSaleIssueBill.addnew((CoreBaseInfo)destSaleBillInfo);
        iSaleIssueBill.addnew((CoreBaseInfo)destBalanceSaleBillInfo);
        iPurInWarehsBill.addnew((CoreBaseInfo)destPurInBillInfo);
        iPurInWarehsBill.addnew((CoreBaseInfo)destBalancePurInBillInfo);
        this.afterVirtualBill(ctx, (CoreBillBaseInfo)saleIssueBillInfo, (CoreBillBaseInfo)destSaleBillInfo);
        this.afterVirtualBill(ctx, (CoreBillBaseInfo)saleIssueBillInfo, (CoreBillBaseInfo)destBalanceSaleBillInfo);
        this.afterVirtualBill(ctx, (CoreBillBaseInfo)saleIssueBillInfo, (CoreBillBaseInfo)destPurInBillInfo);
        this.afterVirtualBill(ctx, (CoreBillBaseInfo)saleIssueBillInfo, (CoreBillBaseInfo)destBalancePurInBillInfo);
        ICalculateFacade icf = CalculateFacadeFactory.getLocalInstance((Context)ctx);
        icf.calculate((CoreBillBaseInfo)destPurInBillInfo);
        icf.calculate((CoreBillBaseInfo)destBalancePurInBillInfo);
        icf.calculate((CoreBillBaseInfo)destSaleBillInfo);
        icf.calculate((CoreBillBaseInfo)destBalanceSaleBillInfo);
        return true;
    }

    private void processSaleIssue(Context ctx, SaleIssueBillInfo destSaleBillInfo, SaleOrderInfo saleOrderInfo, SaleReturnsInfo saleReturnsInfo) throws BOSException, EASBizException {
        ISaleInnerDealPrice iSaleInnerDealPrice;
        String saleOrderID;
        destSaleBillInfo.setIsReversed(false);
        destSaleBillInfo.setIsSysBill(true);
        if (null == destSaleBillInfo.getPriceSource()) {
            destSaleBillInfo.setPriceSource(FetchPriceEnum.FROMCOREBILL);
        }
        SaleIssueEntryCollection saleIssueEntry = destSaleBillInfo.getEntry();
        String balanceCompanyOrgUnitID = null;
        destSaleBillInfo.setStorageOrgUnit(saleOrderInfo != null ? saleOrderInfo.getStorageOrgUnit() : saleReturnsInfo.getStorageOrgUnit());
        balanceCompanyOrgUnitID = saleOrderInfo != null ? saleOrderInfo.getBalanceCompanyOrgUnit().getId().toString() : saleReturnsInfo.getBalanceCompanyOrgUnit().getId().toString();
        String string = saleOrderID = saleOrderInfo != null ? saleOrderInfo.getId().toString() : saleReturnsInfo.getId().toString();
        if (saleOrderInfo != null) {
            iSaleInnerDealPrice = SaleInnerDealPriceFactory.getLocalInstance((Context)ctx);
            SaleOrderEntryCollection saleOrderEntry = saleOrderInfo.getEntries();
            int size = saleIssueEntry.size();
            block0: for (int i = 0; i < size; ++i) {
                SaleIssueEntryInfo destSaleIssueEntryInfo = saleIssueEntry.get(i);
                String saleOrderEntryID = destSaleIssueEntryInfo.getSaleOrderEntry();
                destSaleIssueEntryInfo.setBaseStatus(EntryBaseStatusEnum.AUDITED);
                destSaleIssueEntryInfo.setBaseQty(this.formatBigDecimal(destSaleIssueEntryInfo.getBaseQty()));
                destSaleIssueEntryInfo.setReturnBaseQty(this.formatBigDecimal(destSaleIssueEntryInfo.getReturnBaseQty()));
                destSaleIssueEntryInfo.setTotalInWarehsQty(this.formatBigDecimal(destSaleIssueEntryInfo.getTotalInWarehsQty()));
                destSaleIssueEntryInfo.setUnReturnedBaseQty(destSaleIssueEntryInfo.getBaseQty().abs().subtract(destSaleIssueEntryInfo.getReturnBaseQty().abs()));
                destSaleIssueEntryInfo.setAssociateQty(destSaleIssueEntryInfo.getBaseQty().abs());
                destSaleIssueEntryInfo.setAssociateBaseQty(destSaleIssueEntryInfo.getBaseQty().abs());
                destSaleIssueEntryInfo.setUndeliverQty(destSaleIssueEntryInfo.getQty().abs());
                destSaleIssueEntryInfo.setUndeliverBaseQty(destSaleIssueEntryInfo.getBaseQty().abs());
                destSaleIssueEntryInfo.setUnInQty(destSaleIssueEntryInfo.getQty().abs());
                destSaleIssueEntryInfo.setUnInBaseQty(destSaleIssueEntryInfo.getBaseQty().abs());
                for (int j = 0; j < saleOrderEntry.size(); ++j) {
                    SaleOrderEntryInfo saleOrderEntryInfo = saleOrderEntry.get(j);
                    if (!saleOrderEntryID.equals(saleOrderEntryInfo.getId().toString())) continue;
                    SaleInnerDealPriceInfo saleInnerDealPriceInfo = iSaleInnerDealPrice.getInnerDealPrice(saleOrderID, saleOrderEntryID, balanceCompanyOrgUnitID);
                    destSaleIssueEntryInfo.setUnitActualCost(saleInnerDealPriceInfo.getActualPrice());
                    destSaleIssueEntryInfo.setActualCost(destSaleIssueEntryInfo.getQty().multiply(destSaleIssueEntryInfo.getUnitActualCost()).setScale(this.saleLocalPrecision, 4));
                    destSaleIssueEntryInfo.setUnWriteOffAmount(destSaleIssueEntryInfo.getActualCost());
                    destSaleIssueEntryInfo.setUnWriteOffBaseQty(destSaleIssueEntryInfo.getBaseQty());
                    destSaleIssueEntryInfo.setUnWriteOffQty(destSaleIssueEntryInfo.getQty());
                    destSaleIssueEntryInfo.setBalanceCustomer(saleOrderEntryInfo.getReceiveCustomer());
                    destSaleIssueEntryInfo.setPaymentCustomer(saleOrderEntryInfo.getPaymentCustomer());
                    destSaleIssueEntryInfo.setWarehouse(saleOrderInfo.getWarehouse());
                    destSaleIssueEntryInfo.setStorageOrgUnit(saleOrderInfo.getStorageOrgUnit());
                    destSaleIssueEntryInfo.setCompanyOrgUnit(saleOrderInfo.getCompanyOrgUnit());
                    if (!destSaleBillInfo.getPriceSource().equals((Object)FetchPriceEnum.FROMCOREBILL) || saleOrderEntryInfo.getPrice().compareTo(SysConstant.BIGZERO) == 0 || saleOrderEntryInfo.getTaxPrice().compareTo(SysConstant.BIGZERO) == 0) continue block0;
                    destSaleIssueEntryInfo.setSalePrice(saleOrderEntryInfo.getPrice());
                    destSaleIssueEntryInfo.setTaxPrice(saleOrderEntryInfo.getTaxPrice());
                    destSaleIssueEntryInfo.setDiscount(saleOrderEntryInfo.getDiscount());
                    destSaleIssueEntryInfo.setDiscountType(saleOrderEntryInfo.getDiscountType());
                    destSaleIssueEntryInfo.setTaxRate(saleOrderEntryInfo.getTaxRate());
                    if (saleOrderEntryInfo.getUnit() == null || destSaleIssueEntryInfo.getUnit() == null || saleOrderEntryInfo.getUnit().getId().toString().equals(destSaleIssueEntryInfo.getUnit().getId().toString())) continue block0;
                    this.dealPriceConvert(ctx, destSaleIssueEntryInfo, saleOrderEntryInfo.getUnit());
                    continue block0;
                }
            }
        } else {
            iSaleInnerDealPrice = SaleReturnInnerDealPriceFactory.getLocalInstance((Context)ctx);
            SaleReturnsEntryCollection saleReturnsEntry = saleReturnsInfo.getEntries();
            int size = saleIssueEntry.size();
            block2: for (int i = 0; i < size; ++i) {
                SaleIssueEntryInfo destSaleIssueEntryInfo = saleIssueEntry.get(i);
                String saleOrderEntryID = destSaleIssueEntryInfo.getSaleOrderEntry();
                destSaleIssueEntryInfo.setBaseStatus(EntryBaseStatusEnum.AUDITED);
                destSaleIssueEntryInfo.setBaseQty(this.formatBigDecimal(destSaleIssueEntryInfo.getBaseQty()));
                destSaleIssueEntryInfo.setReturnBaseQty(this.formatBigDecimal(destSaleIssueEntryInfo.getReturnBaseQty()));
                destSaleIssueEntryInfo.setTotalInWarehsQty(this.formatBigDecimal(destSaleIssueEntryInfo.getTotalInWarehsQty()));
                destSaleIssueEntryInfo.setUnReturnedBaseQty(destSaleIssueEntryInfo.getBaseQty().abs().subtract(destSaleIssueEntryInfo.getReturnBaseQty().abs()));
                destSaleIssueEntryInfo.setAssociateQty(destSaleIssueEntryInfo.getBaseQty().abs());
                destSaleIssueEntryInfo.setAssociateBaseQty(destSaleIssueEntryInfo.getBaseQty().abs());
                destSaleIssueEntryInfo.setUndeliverQty(destSaleIssueEntryInfo.getQty().abs());
                destSaleIssueEntryInfo.setUndeliverBaseQty(destSaleIssueEntryInfo.getBaseQty().abs());
                destSaleIssueEntryInfo.setUnInQty(destSaleIssueEntryInfo.getQty().abs());
                destSaleIssueEntryInfo.setUnInBaseQty(destSaleIssueEntryInfo.getBaseQty().abs());
                for (int j = 0; j < saleReturnsEntry.size(); ++j) {
                    SaleReturnsEntryInfo saleReturnsEntryInfo = saleReturnsEntry.get(j);
                    if (!saleOrderEntryID.equals(saleReturnsEntryInfo.getId().toString())) continue;
                    SaleReturnInnerDealPriceInfo saleInnerDealPriceInfo = iSaleInnerDealPrice.getInnerDealPrice(saleOrderID, saleOrderEntryID, balanceCompanyOrgUnitID);
                    destSaleIssueEntryInfo.setUnitActualCost(saleInnerDealPriceInfo.getActualPrice());
                    destSaleIssueEntryInfo.setActualCost(destSaleIssueEntryInfo.getQty().multiply(destSaleIssueEntryInfo.getUnitActualCost()).setScale(this.saleLocalPrecision, 4));
                    destSaleIssueEntryInfo.setUnWriteOffAmount(destSaleIssueEntryInfo.getActualCost());
                    destSaleIssueEntryInfo.setUnWriteOffBaseQty(destSaleIssueEntryInfo.getBaseQty());
                    destSaleIssueEntryInfo.setUnWriteOffQty(destSaleIssueEntryInfo.getQty());
                    destSaleIssueEntryInfo.setBalanceCustomer(saleReturnsEntryInfo.getReceiveCustomer());
                    destSaleIssueEntryInfo.setPaymentCustomer(saleReturnsEntryInfo.getPaymentCustomer());
                    destSaleIssueEntryInfo.setWarehouse(saleReturnsInfo.getWarehouse());
                    destSaleIssueEntryInfo.setStorageOrgUnit(saleReturnsInfo.getStorageOrgUnit());
                    destSaleIssueEntryInfo.setCompanyOrgUnit(saleReturnsInfo.getCompanyOrgUnit());
                    destSaleIssueEntryInfo.setSalePrice(saleReturnsEntryInfo.getPrice());
                    destSaleIssueEntryInfo.setTaxPrice(saleReturnsEntryInfo.getTaxPrice());
                    destSaleIssueEntryInfo.setDiscount(SysConstant.BIGZERO);
                    destSaleIssueEntryInfo.setDiscountType(DiscountModeEnum.PERCENT);
                    if (saleReturnsEntryInfo.getUnit() == null || destSaleIssueEntryInfo.getUnit() == null || saleReturnsEntryInfo.getUnit().getId().toString().equals(destSaleIssueEntryInfo.getUnit().getId().toString())) continue block2;
                    this.dealPriceConvert(ctx, destSaleIssueEntryInfo, saleReturnsEntryInfo.getUnit());
                    continue block2;
                }
            }
        }
        int[] period = this.convertBizPeriod(ctx, saleOrderInfo != null ? saleOrderInfo.getCompanyOrgUnit() : saleReturnsInfo.getCompanyOrgUnit(), (IObjectValue)destSaleBillInfo);
        destSaleBillInfo.setYear(period[0]);
        destSaleBillInfo.setPeriod(period[1]);
    }

    private void processBalanceSaleIssue(Context ctx, SaleIssueBillInfo destBalanceSaleBillInfo, SaleOrderInfo saleOrderInfo, SaleReturnsInfo saleReturnsInfo) throws BOSException, EASBizException {
        destBalanceSaleBillInfo.setIsReversed(false);
        destBalanceSaleBillInfo.setIsSysBill(true);
        if (null == destBalanceSaleBillInfo.getPriceSource()) {
            destBalanceSaleBillInfo.setPriceSource(FetchPriceEnum.FROMCOREBILL);
        }
        ICustomer iCustomer = CustomerFactory.getLocalInstance((Context)ctx);
        CustomerInfo innerCustomer = null;
        String companyOrgUnitID = null;
        String saleOrderID = saleOrderInfo != null ? saleOrderInfo.getId().toString() : saleReturnsInfo.getId().toString();
        String saleCompanyOrgUnitID = saleOrderInfo != null ? saleOrderInfo.getCompanyOrgUnit().getId().toString() : saleReturnsInfo.getCompanyOrgUnit().getId().toString();
        String balanceCompanyOrgUnitID = saleOrderInfo != null ? saleOrderInfo.getBalanceCompanyOrgUnit().getId().toString() : saleReturnsInfo.getBalanceCompanyOrgUnit().getId().toString();
        CustomerCollection innerCustomerCollection = iCustomer.getInterCustomerCollection(saleCompanyOrgUnitID, null);
        if (innerCustomerCollection != null && innerCustomerCollection.size() > 0) {
            innerCustomer = innerCustomerCollection.get(0);
        }
        destBalanceSaleBillInfo.setStorageOrgUnit(saleOrderInfo != null ? saleOrderInfo.getBalanceStorageOrgUnit() : saleReturnsInfo.getBalanceStorageOrgUnit());
        destBalanceSaleBillInfo.setCustomer(innerCustomer);
        SaleIssueEntryCollection destSaleIssueEntry = destBalanceSaleBillInfo.getEntry();
        if (saleOrderInfo != null) {
            ISaleInnerDealPrice iSaleInnerDealPrice = SaleInnerDealPriceFactory.getLocalInstance((Context)ctx);
            SaleInnerDealPriceInfo innerDealPriceInfo = null;
            SaleInnerDealPriceInfo balanceInnerDealPriceInfo = null;
            SaleOrderEntryCollection saleOrderEntry = saleOrderInfo.getEntries();
            int size = destSaleIssueEntry.size();
            block0: for (int i = 0; i < size; ++i) {
                SaleIssueEntryInfo destSaleIssueEntryInfo = destSaleIssueEntry.get(i);
                destSaleIssueEntryInfo.setBaseStatus(EntryBaseStatusEnum.AUDITED);
                String saleOrderEntryID = destSaleIssueEntryInfo.getSaleOrderEntry();
                destSaleIssueEntryInfo.setBaseQty(this.formatBigDecimal(destSaleIssueEntryInfo.getBaseQty()));
                destSaleIssueEntryInfo.setReturnBaseQty(this.formatBigDecimal(destSaleIssueEntryInfo.getReturnBaseQty()));
                destSaleIssueEntryInfo.setTotalInWarehsQty(this.formatBigDecimal(destSaleIssueEntryInfo.getTotalInWarehsQty()));
                destSaleIssueEntryInfo.setUnReturnedBaseQty(destSaleIssueEntryInfo.getBaseQty().abs().subtract(destSaleIssueEntryInfo.getReturnBaseQty().abs()));
                destSaleIssueEntryInfo.setAssociateQty(destSaleIssueEntryInfo.getBaseQty().abs());
                destSaleIssueEntryInfo.setAssociateBaseQty(destSaleIssueEntryInfo.getBaseQty().abs());
                destSaleIssueEntryInfo.setUndeliverQty(destSaleIssueEntryInfo.getQty().abs());
                destSaleIssueEntryInfo.setUndeliverBaseQty(destSaleIssueEntryInfo.getBaseQty().abs());
                destSaleIssueEntryInfo.setUnInQty(destSaleIssueEntryInfo.getQty().abs());
                destSaleIssueEntryInfo.setUnInBaseQty(destSaleIssueEntryInfo.getBaseQty().abs());
                for (int j = 0; j < saleOrderEntry.size(); ++j) {
                    SaleOrderEntryInfo saleOrderEntryInfo = saleOrderEntry.get(j);
                    if (null == companyOrgUnitID) {
                        companyOrgUnitID = saleOrderEntryInfo.getCompanyOrgUnit().getId().toString();
                    }
                    if (!saleOrderEntryID.equals(saleOrderEntryInfo.getId().toString())) continue;
                    innerDealPriceInfo = iSaleInnerDealPrice.getInnerDealPrice(saleOrderID, saleOrderEntryID, companyOrgUnitID);
                    balanceInnerDealPriceInfo = iSaleInnerDealPrice.getInnerDealPrice(saleOrderID, saleOrderEntryID, balanceCompanyOrgUnitID);
                    if (innerDealPriceInfo != null) {
                        destSaleIssueEntryInfo.setUnitActualCost(innerDealPriceInfo.getActualPrice());
                    }
                    destSaleIssueEntryInfo.setActualCost(destSaleIssueEntryInfo.getQty().multiply(destSaleIssueEntryInfo.getUnitActualCost()).setScale(this.balanceLocalPrecision, 4));
                    destSaleIssueEntryInfo.setUnWriteOffAmount(destSaleIssueEntryInfo.getActualCost());
                    destSaleIssueEntryInfo.setUnWriteOffBaseQty(destSaleIssueEntryInfo.getBaseQty());
                    destSaleIssueEntryInfo.setUnWriteOffQty(destSaleIssueEntryInfo.getQty());
                    if (balanceInnerDealPriceInfo != null && destBalanceSaleBillInfo.getPriceSource().equals((Object)FetchPriceEnum.FROMCOREBILL) && balanceInnerDealPriceInfo.getPrice().compareTo(SysConstant.BIGZERO) != 0 && balanceInnerDealPriceInfo.getTaxPrice().compareTo(SysConstant.BIGZERO) != 0) {
                        destSaleIssueEntryInfo.setSalePrice(balanceInnerDealPriceInfo.getPrice());
                        destSaleIssueEntryInfo.setTaxPrice(balanceInnerDealPriceInfo.getTaxPrice());
                        destSaleIssueEntryInfo.setDiscount(balanceInnerDealPriceInfo.getDiscount());
                        destSaleIssueEntryInfo.setDiscountType(balanceInnerDealPriceInfo.getDiscountMode());
                        destSaleIssueEntryInfo.setTaxRate(balanceInnerDealPriceInfo.getTaxRate());
                    }
                    destSaleIssueEntryInfo.setBalanceCustomer(innerCustomer);
                    destSaleIssueEntryInfo.setPaymentCustomer(innerCustomer);
                    destSaleIssueEntryInfo.setWarehouse(saleOrderInfo.getBalanceWarehouse());
                    destSaleIssueEntryInfo.setStorageOrgUnit(saleOrderInfo.getBalanceStorageOrgUnit());
                    destSaleIssueEntryInfo.setCompanyOrgUnit(saleOrderInfo.getBalanceCompanyOrgUnit());
                    if (!destBalanceSaleBillInfo.getPriceSource().equals((Object)FetchPriceEnum.FROMCOREBILL) || saleOrderEntryInfo.getPrice().compareTo(SysConstant.BIGZERO) == 0 || saleOrderEntryInfo.getTaxPrice().compareTo(SysConstant.BIGZERO) == 0 || saleOrderEntryInfo.getUnit() == null || destSaleIssueEntryInfo.getUnit() == null || saleOrderEntryInfo.getUnit().getId().toString().equals(destSaleIssueEntryInfo.getUnit().getId().toString())) continue block0;
                    this.dealPriceConvert(ctx, destSaleIssueEntryInfo, saleOrderEntryInfo.getUnit());
                    continue block0;
                }
            }
        } else {
            SaleReturnsEntryCollection saleReturnsEntry = saleReturnsInfo.getEntries();
            ISaleReturnInnerDealPrice iSaleReturnInnerDealPrice = SaleReturnInnerDealPriceFactory.getLocalInstance((Context)ctx);
            int size = destSaleIssueEntry.size();
            block2: for (int i = 0; i < size; ++i) {
                SaleIssueEntryInfo destSaleIssueEntryInfo = destSaleIssueEntry.get(i);
                destSaleIssueEntryInfo.setBaseStatus(EntryBaseStatusEnum.AUDITED);
                String saleOrderEntryID = destSaleIssueEntryInfo.getSaleOrderEntry();
                destSaleIssueEntryInfo.setBaseQty(this.formatBigDecimal(destSaleIssueEntryInfo.getBaseQty()));
                destSaleIssueEntryInfo.setReturnBaseQty(this.formatBigDecimal(destSaleIssueEntryInfo.getReturnBaseQty()));
                destSaleIssueEntryInfo.setTotalInWarehsQty(this.formatBigDecimal(destSaleIssueEntryInfo.getTotalInWarehsQty()));
                destSaleIssueEntryInfo.setUnReturnedBaseQty(destSaleIssueEntryInfo.getBaseQty().abs().subtract(destSaleIssueEntryInfo.getReturnBaseQty().abs()));
                destSaleIssueEntryInfo.setAssociateQty(destSaleIssueEntryInfo.getBaseQty().abs());
                destSaleIssueEntryInfo.setAssociateBaseQty(destSaleIssueEntryInfo.getBaseQty().abs());
                destSaleIssueEntryInfo.setUndeliverQty(destSaleIssueEntryInfo.getQty().abs());
                destSaleIssueEntryInfo.setUndeliverBaseQty(destSaleIssueEntryInfo.getBaseQty().abs());
                destSaleIssueEntryInfo.setUnInQty(destSaleIssueEntryInfo.getQty().abs());
                destSaleIssueEntryInfo.setUnInBaseQty(destSaleIssueEntryInfo.getBaseQty().abs());
                for (int j = 0; j < saleReturnsEntry.size(); ++j) {
                    SaleReturnsEntryInfo saleReturnsEntryInfo = saleReturnsEntry.get(j);
                    if (null == companyOrgUnitID) {
                        companyOrgUnitID = saleReturnsEntryInfo.getCompanyOrgUnit().getId().toString();
                    }
                    if (!saleOrderEntryID.equals(saleReturnsEntryInfo.getId().toString())) continue;
                    SaleReturnInnerDealPriceInfo innerDealPriceInfo = iSaleReturnInnerDealPrice.getInnerDealPrice(saleOrderID, saleOrderEntryID, companyOrgUnitID);
                    SaleReturnInnerDealPriceInfo balanceInnerDealPriceInfo = iSaleReturnInnerDealPrice.getInnerDealPrice(saleOrderID, saleOrderEntryID, balanceCompanyOrgUnitID);
                    if (innerDealPriceInfo != null) {
                        destSaleIssueEntryInfo.setUnitActualCost(innerDealPriceInfo.getActualPrice());
                    }
                    destSaleIssueEntryInfo.setActualCost(destSaleIssueEntryInfo.getQty().multiply(destSaleIssueEntryInfo.getUnitActualCost()).setScale(this.balanceLocalPrecision, 4));
                    destSaleIssueEntryInfo.setUnWriteOffAmount(destSaleIssueEntryInfo.getActualCost());
                    destSaleIssueEntryInfo.setUnWriteOffBaseQty(destSaleIssueEntryInfo.getBaseQty());
                    destSaleIssueEntryInfo.setUnWriteOffQty(destSaleIssueEntryInfo.getQty());
                    if (balanceInnerDealPriceInfo != null) {
                        destSaleIssueEntryInfo.setSalePrice(balanceInnerDealPriceInfo.getPrice());
                        destSaleIssueEntryInfo.setTaxPrice(balanceInnerDealPriceInfo.getTaxPrice());
                        destSaleIssueEntryInfo.setDiscount(balanceInnerDealPriceInfo.getDiscount());
                        destSaleIssueEntryInfo.setDiscountType(balanceInnerDealPriceInfo.getDiscountMode());
                    }
                    destSaleIssueEntryInfo.setBalanceCustomer(innerCustomer);
                    destSaleIssueEntryInfo.setPaymentCustomer(innerCustomer);
                    destSaleIssueEntryInfo.setWarehouse(saleReturnsInfo.getBalanceWarehouse());
                    destSaleIssueEntryInfo.setStorageOrgUnit(saleReturnsInfo.getBalanceStorageOrgUnit());
                    destSaleIssueEntryInfo.setCompanyOrgUnit(saleReturnsInfo.getBalanceCompanyOrgUnit());
                    if (saleReturnsEntryInfo.getUnit() == null || destSaleIssueEntryInfo.getUnit() == null || saleReturnsEntryInfo.getUnit().getId().toString().equals(destSaleIssueEntryInfo.getUnit().getId().toString())) continue block2;
                    this.dealPriceConvert(ctx, destSaleIssueEntryInfo, saleReturnsEntryInfo.getUnit());
                    continue block2;
                }
            }
        }
        int[] period = this.convertBizPeriod(ctx, saleOrderInfo != null ? saleOrderInfo.getBalanceCompanyOrgUnit() : saleReturnsInfo.getBalanceCompanyOrgUnit(), (IObjectValue)destBalanceSaleBillInfo);
        destBalanceSaleBillInfo.setYear(period[0]);
        destBalanceSaleBillInfo.setPeriod(period[1]);
    }

    private void processPurInWarehs(Context ctx, PurInWarehsBillInfo destPurInBillInfo, SaleOrderInfo saleOrderInfo, SaleReturnsInfo saleReturnsInfo) throws BOSException, EASBizException {
        ISaleInnerDealPrice iSaleInnerDealPrice;
        destPurInBillInfo.setIsReversed(false);
        destPurInBillInfo.setIsSysBill(true);
        if (null == destPurInBillInfo.getPriceSource()) {
            destPurInBillInfo.setPriceSource(FetchPriceEnum.FROMCOREBILL);
        }
        ISupplier iSupplier = SupplierFactory.getLocalInstance((Context)ctx);
        SupplierInfo innerSupplier = null;
        String balanceCompanyOrgUnitID = saleOrderInfo != null ? saleOrderInfo.getBalanceCompanyOrgUnit().getId().toString() : saleReturnsInfo.getBalanceCompanyOrgUnit().getId().toString();
        SupplierCollection innerSupplierCollection = iSupplier.getInterSupplierCollection(balanceCompanyOrgUnitID, null);
        if (null != innerSupplierCollection && innerSupplierCollection.size() > 0) {
            innerSupplier = innerSupplierCollection.get(0);
        }
        destPurInBillInfo.setSupplier(innerSupplier);
        destPurInBillInfo.setStorageOrgUnit(saleOrderInfo != null ? saleOrderInfo.getStorageOrgUnit() : saleReturnsInfo.getStorageOrgUnit());
        this.saleLocalPrecision = CalculateUtil.getLocalCurrencyPrecision2((Context)ctx, (CompanyOrgUnitInfo)(saleOrderInfo != null ? saleOrderInfo.getCompanyOrgUnit() : saleReturnsInfo.getCompanyOrgUnit()));
        PurInWarehsEntryCollection destPurInWarehsEntry = destPurInBillInfo.getEntry();
        if (saleOrderInfo != null) {
            iSaleInnerDealPrice = SaleInnerDealPriceFactory.getLocalInstance((Context)ctx);
            SaleInnerDealPriceInfo balanceInnerDealPriceInfo = null;
            SaleOrderEntryCollection saleOrderEntry = saleOrderInfo.getEntries();
            int size = destPurInWarehsEntry.size();
            for (int i = 0; i < size; ++i) {
                PurInWarehsEntryInfo destPurInWarehsEntryInfo = destPurInWarehsEntry.get(i);
                if (!destPurInWarehsEntryInfo.getPurOrder().equals(saleOrderInfo.getId().toString())) continue;
                destPurInWarehsEntryInfo.setStorageOrgUnit(saleOrderInfo.getStorageOrgUnit());
                destPurInWarehsEntryInfo.setWarehouse(saleOrderInfo.getWarehouse());
                for (int j = 0; j < saleOrderEntry.size(); ++j) {
                    SaleOrderEntryInfo saleOrderEntryInfo = saleOrderEntry.get(j);
                    if (!destPurInWarehsEntryInfo.getPurOrderEntry().equals(saleOrderEntryInfo.getId().toString())) continue;
                    balanceInnerDealPriceInfo = iSaleInnerDealPrice.getInnerDealPrice(destPurInWarehsEntryInfo.getPurOrder(), destPurInWarehsEntryInfo.getPurOrderEntry(), balanceCompanyOrgUnitID);
                    destPurInWarehsEntryInfo.setDiscountRate(balanceInnerDealPriceInfo.getDiscount());
                    destPurInWarehsEntryInfo.setUnitActualCost(balanceInnerDealPriceInfo.getActualPrice());
                    destPurInWarehsEntryInfo.setActualCost(destPurInWarehsEntryInfo.getQty().multiply(destPurInWarehsEntryInfo.getUnitActualCost()).setScale(this.saleLocalPrecision, 4));
                    destPurInWarehsEntryInfo.setUnWriteOffAmount(destPurInWarehsEntryInfo.getActualCost());
                    destPurInWarehsEntryInfo.setUnWriteOffBaseQty(destPurInWarehsEntryInfo.getBaseQty());
                    destPurInWarehsEntryInfo.setUnWriteOffQty(destPurInWarehsEntryInfo.getQty());
                    destPurInWarehsEntryInfo.setBalanceSupplier(innerSupplier);
                    destPurInWarehsEntryInfo.setStorageOrgUnit(saleOrderInfo.getStorageOrgUnit());
                    destPurInWarehsEntryInfo.setCompanyOrgUnit(saleOrderInfo.getCompanyOrgUnit());
                    if (!destPurInBillInfo.getPriceSource().equals((Object)FetchPriceEnum.FROMCOREBILL) || balanceInnerDealPriceInfo.getPrice().compareTo(SysConstant.BIGZERO) == 0 || balanceInnerDealPriceInfo.getTaxPrice().compareTo(SysConstant.BIGZERO) == 0) continue;
                    destPurInWarehsEntryInfo.setPrice(balanceInnerDealPriceInfo.getPrice());
                    destPurInWarehsEntryInfo.setTaxPrice(balanceInnerDealPriceInfo.getTaxPrice());
                    if (saleOrderEntryInfo.getUnit() == null || destPurInWarehsEntryInfo.getUnit() == null || saleOrderEntryInfo.getUnit().getId().toString().equals(destPurInWarehsEntryInfo.getUnit().getId().toString())) continue;
                    this.dealPriceConvert(ctx, destPurInWarehsEntryInfo, saleOrderEntryInfo.getUnit());
                }
            }
        } else {
            iSaleInnerDealPrice = SaleReturnInnerDealPriceFactory.getLocalInstance((Context)ctx);
            SaleReturnsEntryCollection saleReturnsEntry = saleReturnsInfo.getEntries();
            int size = destPurInWarehsEntry.size();
            for (int i = 0; i < size; ++i) {
                PurInWarehsEntryInfo destPurInWarehsEntryInfo = destPurInWarehsEntry.get(i);
                if (!destPurInWarehsEntryInfo.getPurOrder().equals(saleReturnsInfo.getId().toString())) continue;
                destPurInWarehsEntryInfo.setStorageOrgUnit(saleReturnsInfo.getStorageOrgUnit());
                destPurInWarehsEntryInfo.setWarehouse(saleReturnsInfo.getWarehouse());
                for (int j = 0; j < saleReturnsEntry.size(); ++j) {
                    SaleReturnsEntryInfo saleReturnsEntryInfo = saleReturnsEntry.get(j);
                    if (!destPurInWarehsEntryInfo.getPurOrderEntry().equals(saleReturnsEntryInfo.getId().toString())) continue;
                    SaleReturnInnerDealPriceInfo balanceInnerDealPriceInfo = iSaleInnerDealPrice.getInnerDealPrice(destPurInWarehsEntryInfo.getPurOrder(), destPurInWarehsEntryInfo.getPurOrderEntry(), balanceCompanyOrgUnitID);
                    if (balanceInnerDealPriceInfo != null) {
                        destPurInWarehsEntryInfo.setUnitActualCost(balanceInnerDealPriceInfo.getActualPrice());
                        destPurInWarehsEntryInfo.setPrice(balanceInnerDealPriceInfo.getPrice());
                        destPurInWarehsEntryInfo.setTaxPrice(balanceInnerDealPriceInfo.getTaxPrice());
                    }
                    destPurInWarehsEntryInfo.setActualCost(destPurInWarehsEntryInfo.getQty().multiply(destPurInWarehsEntryInfo.getUnitActualCost()).setScale(this.saleLocalPrecision, 4));
                    destPurInWarehsEntryInfo.setUnWriteOffAmount(destPurInWarehsEntryInfo.getActualCost());
                    destPurInWarehsEntryInfo.setUnWriteOffBaseQty(destPurInWarehsEntryInfo.getBaseQty());
                    destPurInWarehsEntryInfo.setUnWriteOffQty(destPurInWarehsEntryInfo.getQty());
                    destPurInWarehsEntryInfo.setBalanceSupplier(innerSupplier);
                    destPurInWarehsEntryInfo.setStorageOrgUnit(saleReturnsInfo.getStorageOrgUnit());
                    destPurInWarehsEntryInfo.setCompanyOrgUnit(saleReturnsInfo.getCompanyOrgUnit());
                    if (saleReturnsEntryInfo.getUnit() == null || destPurInWarehsEntryInfo.getUnit() == null || saleReturnsEntryInfo.getUnit().getId().toString().equals(destPurInWarehsEntryInfo.getUnit().getId().toString())) continue;
                    this.dealPriceConvert(ctx, destPurInWarehsEntryInfo, saleReturnsEntryInfo.getUnit());
                }
            }
        }
        int[] period = this.convertBizPeriod(ctx, saleOrderInfo != null ? saleOrderInfo.getCompanyOrgUnit() : saleReturnsInfo.getCompanyOrgUnit(), (IObjectValue)destPurInBillInfo);
        destPurInBillInfo.setYear(period[0]);
        destPurInBillInfo.setPeriod(period[1]);
    }

    private void processBalancePurInWarehs(Context ctx, PurInWarehsBillInfo destBalancePurInBillInfo, SaleOrderInfo saleOrderInfo, SaleReturnsInfo saleReturnsInfo) throws BOSException, EASBizException {
        ISaleInnerDealPrice iSaleInnerDealPrice;
        destBalancePurInBillInfo.setIsReversed(false);
        destBalancePurInBillInfo.setIsSysBill(true);
        if (null == destBalancePurInBillInfo.getPriceSource()) {
            destBalancePurInBillInfo.setPriceSource(FetchPriceEnum.FROMCOREBILL);
        }
        ISupplier iSupplier = SupplierFactory.getLocalInstance((Context)ctx);
        SupplierInfo innerSupplier = null;
        String companyOrgUnitID = null;
        PurInWarehsEntryCollection destPurInWarehsEntry = destBalancePurInBillInfo.getEntry();
        if (saleOrderInfo != null) {
            iSaleInnerDealPrice = SaleInnerDealPriceFactory.getLocalInstance((Context)ctx);
            SaleInnerDealPriceInfo innerDealPriceInfo = null;
            SaleOrderEntryCollection saleOrderEntry = saleOrderInfo.getEntries();
            int size = destPurInWarehsEntry.size();
            for (int i = 0; i < size; ++i) {
                PurInWarehsEntryInfo destPurInWarehsEntryInfo = destPurInWarehsEntry.get(i);
                if (!destPurInWarehsEntryInfo.getPurOrder().equals(saleOrderInfo.getId().toString())) continue;
                destPurInWarehsEntryInfo.setBaseStatus(EntryBaseStatusEnum.AUDITED);
                destPurInWarehsEntryInfo.setStorageOrgUnit(saleOrderInfo.getBalanceStorageOrgUnit());
                destPurInWarehsEntryInfo.setWarehouse(saleOrderInfo.getBalanceWarehouse());
                for (int j = 0; j < saleOrderEntry.size(); ++j) {
                    SupplierCollection innerSupplierCollection;
                    SaleOrderEntryInfo saleOrderEntryInfo = saleOrderEntry.get(j);
                    if (null == companyOrgUnitID && null != (innerSupplierCollection = iSupplier.getInterSupplierCollection(companyOrgUnitID = saleOrderEntryInfo.getCompanyOrgUnit().getId().toString(), null)) && innerSupplierCollection.size() > 0) {
                        innerSupplier = innerSupplierCollection.get(0);
                    }
                    if (!destPurInWarehsEntryInfo.getPurOrderEntry().equals(saleOrderEntryInfo.getId().toString())) continue;
                    innerDealPriceInfo = iSaleInnerDealPrice.getInnerDealPrice(destPurInWarehsEntryInfo.getPurOrder(), destPurInWarehsEntryInfo.getPurOrderEntry(), companyOrgUnitID);
                    if (innerDealPriceInfo != null) {
                        destPurInWarehsEntryInfo.setUnitActualCost(innerDealPriceInfo.getActualPrice());
                    }
                    destPurInWarehsEntryInfo.setActualCost(destPurInWarehsEntryInfo.getQty().multiply(destPurInWarehsEntryInfo.getUnitActualCost()).setScale(this.saleLocalPrecision, 4));
                    destPurInWarehsEntryInfo.setUnWriteOffAmount(destPurInWarehsEntryInfo.getActualCost());
                    destPurInWarehsEntryInfo.setUnWriteOffBaseQty(destPurInWarehsEntryInfo.getBaseQty());
                    destPurInWarehsEntryInfo.setUnWriteOffQty(destPurInWarehsEntryInfo.getQty());
                    destPurInWarehsEntryInfo.setBalanceSupplier(innerSupplier);
                    destPurInWarehsEntryInfo.setStorageOrgUnit(saleOrderInfo.getBalanceStorageOrgUnit());
                    destPurInWarehsEntryInfo.setCompanyOrgUnit(saleOrderInfo.getBalanceCompanyOrgUnit());
                    if (!destBalancePurInBillInfo.getPriceSource().equals((Object)FetchPriceEnum.FROMCOREBILL) || innerDealPriceInfo == null || innerDealPriceInfo.getPrice().compareTo(SysConstant.BIGZERO) == 0 || innerDealPriceInfo.getTaxPrice().compareTo(SysConstant.BIGZERO) == 0) continue;
                    destPurInWarehsEntryInfo.setPrice(innerDealPriceInfo.getPrice());
                    destPurInWarehsEntryInfo.setTaxPrice(innerDealPriceInfo.getTaxPrice());
                    if (saleOrderEntryInfo.getUnit() == null || destPurInWarehsEntryInfo.getUnit() == null || saleOrderEntryInfo.getUnit().getId().toString().equals(destPurInWarehsEntryInfo.getUnit().getId().toString())) continue;
                    this.dealPriceConvert(ctx, destPurInWarehsEntryInfo, saleOrderEntryInfo.getUnit());
                }
            }
        } else {
            iSaleInnerDealPrice = SaleReturnInnerDealPriceFactory.getLocalInstance((Context)ctx);
            SaleReturnsEntryCollection saleReturnsEntry = saleReturnsInfo.getEntries();
            int size = destPurInWarehsEntry.size();
            for (int i = 0; i < size; ++i) {
                PurInWarehsEntryInfo destPurInWarehsEntryInfo = destPurInWarehsEntry.get(i);
                if (!destPurInWarehsEntryInfo.getPurOrder().equals(saleReturnsInfo.getId().toString())) continue;
                destPurInWarehsEntryInfo.setBaseStatus(EntryBaseStatusEnum.AUDITED);
                destPurInWarehsEntryInfo.setStorageOrgUnit(saleReturnsInfo.getBalanceStorageOrgUnit());
                destPurInWarehsEntryInfo.setWarehouse(saleReturnsInfo.getBalanceWarehouse());
                for (int j = 0; j < saleReturnsEntry.size(); ++j) {
                    SupplierCollection innerSupplierCollection;
                    SaleReturnsEntryInfo saleReturnsEntryInfo = saleReturnsEntry.get(j);
                    if (null == companyOrgUnitID && null != (innerSupplierCollection = iSupplier.getInterSupplierCollection(companyOrgUnitID = saleReturnsEntryInfo.getCompanyOrgUnit().getId().toString(), null)) && innerSupplierCollection.size() > 0) {
                        innerSupplier = innerSupplierCollection.get(0);
                    }
                    if (!destPurInWarehsEntryInfo.getPurOrderEntry().equals(saleReturnsEntryInfo.getId().toString())) continue;
                    SaleReturnInnerDealPriceInfo innerDealPriceInfo = iSaleInnerDealPrice.getInnerDealPrice(destPurInWarehsEntryInfo.getPurOrder(), destPurInWarehsEntryInfo.getPurOrderEntry(), companyOrgUnitID);
                    destPurInWarehsEntryInfo.setUnitActualCost(innerDealPriceInfo.getActualPrice());
                    destPurInWarehsEntryInfo.setActualCost(destPurInWarehsEntryInfo.getQty().multiply(destPurInWarehsEntryInfo.getUnitActualCost()).setScale(this.saleLocalPrecision, 4));
                    destPurInWarehsEntryInfo.setUnWriteOffAmount(destPurInWarehsEntryInfo.getActualCost());
                    destPurInWarehsEntryInfo.setUnWriteOffBaseQty(destPurInWarehsEntryInfo.getBaseQty());
                    destPurInWarehsEntryInfo.setUnWriteOffQty(destPurInWarehsEntryInfo.getQty());
                    destPurInWarehsEntryInfo.setBalanceSupplier(innerSupplier);
                    destPurInWarehsEntryInfo.setStorageOrgUnit(saleReturnsInfo.getBalanceStorageOrgUnit());
                    destPurInWarehsEntryInfo.setCompanyOrgUnit(saleReturnsInfo.getBalanceCompanyOrgUnit());
                    destPurInWarehsEntryInfo.setPrice(innerDealPriceInfo.getPrice());
                    destPurInWarehsEntryInfo.setTaxPrice(innerDealPriceInfo.getTaxPrice());
                    if (saleReturnsEntryInfo.getUnit() == null || destPurInWarehsEntryInfo.getUnit() == null || saleReturnsEntryInfo.getUnit().getId().toString().equals(destPurInWarehsEntryInfo.getUnit().getId().toString())) continue;
                    this.dealPriceConvert(ctx, destPurInWarehsEntryInfo, saleReturnsEntryInfo.getUnit());
                }
            }
        }
        destBalancePurInBillInfo.setStorageOrgUnit(saleOrderInfo != null ? saleOrderInfo.getBalanceStorageOrgUnit() : saleReturnsInfo.getBalanceStorageOrgUnit());
        destBalancePurInBillInfo.setSupplier(innerSupplier);
        int[] period = this.convertBizPeriod(ctx, saleOrderInfo != null ? saleOrderInfo.getBalanceCompanyOrgUnit() : saleReturnsInfo.getBalanceCompanyOrgUnit(), (IObjectValue)destBalancePurInBillInfo);
        destBalancePurInBillInfo.setYear(period[0]);
        destBalancePurInBillInfo.setPeriod(period[1]);
    }

    private boolean isSaleReturn(SaleIssueBillInfo saleIssueBillInfo) {
        boolean flag = false;
        String bizTypeID = saleIssueBillInfo.getBizType().getId().toString();
        if ("d8e80652-0110-1000-e000-04c5c0a812202407435C".equals(bizTypeID) || "wIZPS7oOQaOl1CeE/8cZOSQHQ1w=".equals(bizTypeID)) {
            flag = true;
        }
        return flag;
    }

    private boolean check(SaleIssueBillInfo saleIssueBillInfo) {
        if (saleIssueBillInfo.isIsReversed() || saleIssueBillInfo.isIsSysBill()) {
            return false;
        }
        boolean flag = false;
        if (saleIssueBillInfo.getEntry().get(0).getCoreBillType() != null && ("510b6503-0105-1000-e000-0113c0a812fd463ED552".equals(saleIssueBillInfo.getEntry().get(0).getCoreBillType().getId().toString()) || "50957179-0105-1000-e008-8152c0a812fd463ED552".equals(saleIssueBillInfo.getEntry().get(0).getCoreBillType().getId().toString()))) {
            flag = saleIssueBillInfo.getEntry().get(0).isIsCenterBalance() && saleIssueBillInfo.getEntry().get(0).isIsSquareBalance() && saleIssueBillInfo.getEntry().get(0).isIsBetweenCompanySend();
            this.isSaleReturn = this.isSaleReturn(saleIssueBillInfo);
            this.isSaleReturnCoreBill = "50957179-0105-1000-e008-8152c0a812fd463ED552".equals(saleIssueBillInfo.getEntry().get(0).getCoreBillType().getId().toString());
        }
        return flag;
    }

    public IObjectValue processArApBill(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        return null;
    }

    private BigDecimal formatBigDecimal(BigDecimal value) {
        return value == null ? ZERO : value;
    }

    private int[] convertBizPeriod(Context ctx, CompanyOrgUnitInfo company, IObjectValue model) throws EASBizException, BOSException {
        SCMBillBaseInfo v = (SCMBillBaseInfo)model;
        if (v.getBizDate() == null) {
            throw new SCMBillException(SCMBillException.BIZDATEISNULL);
        }
        int[] period = new int[]{2199, 1};
        if (company != null && company.getId() != null) {
            PeriodInfo pInfo = PeriodUtils.getPeriodInfo((Context)ctx, (Date)v.getBizDate(), (CompanyOrgUnitInfo)company);
            if (pInfo != null && pInfo.getPeriodYear() > 0 && pInfo.getPeriodNumber() > 0) {
                period[0] = pInfo.getPeriodYear();
                period[1] = pInfo.getPeriodNumber();
            } else {
                InvBillBaseInfo aInvBillBaseInfo;
                boolean isStartBill = false;
                if (v instanceof InvBillBaseInfo && (aInvBillBaseInfo = (InvBillBaseInfo)v).isIsInitBill()) {
                    isStartBill = true;
                }
                if (isStartBill) {
                    PeriodInfo currPeriodInfo = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.INVENTORYMANAGEMENT, (CompanyOrgUnitInfo)company);
                    if (currPeriodInfo == null) {
                        throw new SCMBillException(SCMBillException.CURRENTPERIODISNULL);
                    }
                    int startYear = currPeriodInfo.getPeriodYear();
                    int startNumber = currPeriodInfo.getPeriodNumber();
                    if (startNumber == 1) {
                        startNumber = 12;
                    }
                    period[0] = --startYear;
                    period[1] = --startNumber;
                } else if (!(model instanceof PurOrderInfo) && !(model instanceof SaleOrderInfo)) {
                    throw new SCMBillException(SCMBillException.GETBIZPERIODFAIL);
                }
            }
        }
        return period;
    }

    private void dealPriceConvert(Context ctx, SaleIssueEntryInfo issueEntryInfo, MeasureUnitInfo coreEntryUnitInfo) throws EASBizException, BOSException {
        BigDecimal conversionRate = this.getConversionRate(ctx, issueEntryInfo.getMaterial(), coreEntryUnitInfo, issueEntryInfo.getUnit());
        if (conversionRate == null || SCMConstant.BIGDECIMAL_ONE.compareTo(conversionRate) == 0) {
            return;
        }
        BigDecimal taxPrice = issueEntryInfo.getTaxPrice() == null ? SysConstant.BIGZERO : issueEntryInfo.getTaxPrice();
        taxPrice = taxPrice.divide(conversionRate, issueEntryInfo.getMaterial().getPricePrecision(), 4);
        issueEntryInfo.setTaxPrice(taxPrice);
        BigDecimal salePrice = issueEntryInfo.getSalePrice() == null ? SysConstant.BIGZERO : issueEntryInfo.getSalePrice();
        salePrice = salePrice.divide(conversionRate, issueEntryInfo.getMaterial().getPricePrecision(), 4);
        issueEntryInfo.setSalePrice(salePrice);
    }

    private void dealPriceConvert(Context ctx, PurInWarehsEntryInfo purInwareEntryInfo, MeasureUnitInfo coreEntryUnitInfo) throws EASBizException, BOSException {
        BigDecimal conversionRate = this.getConversionRate(ctx, purInwareEntryInfo.getMaterial(), coreEntryUnitInfo, purInwareEntryInfo.getUnit());
        if (conversionRate == null || SCMConstant.BIGDECIMAL_ONE.compareTo(conversionRate) == 0) {
            return;
        }
        BigDecimal taxPrice = purInwareEntryInfo.getTaxPrice() == null ? SysConstant.BIGZERO : purInwareEntryInfo.getTaxPrice();
        taxPrice = taxPrice.divide(conversionRate, purInwareEntryInfo.getMaterial().getPricePrecision(), 4);
        purInwareEntryInfo.setTaxPrice(taxPrice);
        BigDecimal price = purInwareEntryInfo.getPrice() == null ? SysConstant.BIGZERO : purInwareEntryInfo.getPrice();
        price = price.divide(conversionRate, purInwareEntryInfo.getMaterial().getPricePrecision(), 4);
        purInwareEntryInfo.setPrice(price);
    }

    private BigDecimal getConversionRate(Context ctx, MaterialInfo materialInfo, MeasureUnitInfo fromUnit, MeasureUnitInfo toUnit) throws EASBizException, BOSException {
        if (materialInfo == null || fromUnit == null || toUnit == null) {
            return SCMConstant.BIGDECIMAL_ONE;
        }
        IMultiMeasureUnit iMultiMeasureUnit = MultiMeasureUnitFactory.getLocalInstance((Context)ctx);
        String[] materialIds = new String[]{materialInfo.getId().toString(), materialInfo.getId().toString()};
        String[] unitIds = new String[]{fromUnit.getId().toString(), toUnit.getId().toString()};
        Map conversionRateMap = iMultiMeasureUnit.getConvRatesByMaterial(materialIds, unitIds);
        BigDecimal fromBaseConv = (BigDecimal)conversionRateMap.get(materialInfo.getId().toString() + fromUnit.getId().toString());
        BigDecimal toBaseConv = (BigDecimal)conversionRateMap.get(materialInfo.getId().toString() + toUnit.getId().toString());
        if (fromBaseConv == null || toBaseConv == null) {
            return SCMConstant.BIGDECIMAL_ONE;
        }
        return fromBaseConv.divide(toBaseConv, 16, 4);
    }

    private void resetEntryMaterialInfo(Context ctx, SaleIssueBillCollection saleIssueBillCol) throws BOSException {
        MaterialInfo materialInfo;
        SaleIssueEntryInfo entryInfo;
        SaleIssueEntryCollection entryCol;
        SaleIssueBillInfo billInfo;
        if (null == saleIssueBillCol || saleIssueBillCol.size() == 0) {
            return;
        }
        HashSet<String> materialIdSet = new HashSet<String>();
        int size = saleIssueBillCol.size();
        for (int i = 0; i < size; ++i) {
            billInfo = saleIssueBillCol.get(i);
            entryCol = billInfo.getEntry();
            if (entryCol == null || entryCol.size() <= 0) continue;
            int len = entryCol.size();
            for (int index = 0; index < len; ++index) {
                entryInfo = entryCol.get(index);
                if (entryInfo.getMaterial() == null) continue;
                materialIdSet.add(entryInfo.getMaterial().getId().toString());
            }
        }
        if (materialIdSet.size() == 0) {
            return;
        }
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", materialIdSet, CompareType.INCLUDE));
        entityViewInfo.setFilter(filter);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("id");
        selector.add("pricePrecision");
        entityViewInfo.setSelector(selector);
        MaterialCollection materialCol = MaterialFactory.getLocalInstance((Context)ctx).getMaterialCollection(entityViewInfo);
        if (materialCol == null || materialCol.size() == 0) {
            return;
        }
        HashMap<String, MaterialInfo> id2MaterialMap = new HashMap<String, MaterialInfo>();
        int size2 = materialCol.size();
        for (int i = 0; i < size2; ++i) {
            materialInfo = materialCol.get(i);
            id2MaterialMap.put(materialInfo.getId().toString(), materialInfo);
        }
        int size3 = saleIssueBillCol.size();
        for (int i = 0; i < size3; ++i) {
            billInfo = saleIssueBillCol.get(i);
            entryCol = billInfo.getEntry();
            if (entryCol == null || entryCol.size() <= 0) continue;
            int len = entryCol.size();
            for (int index = 0; index < len; ++index) {
                String materialId;
                entryInfo = entryCol.get(index);
                if (entryInfo.getMaterial() == null || (materialInfo = (MaterialInfo)id2MaterialMap.get(materialId = entryInfo.getMaterial().getId().toString())) == null) continue;
                entryInfo.setMaterial(materialInfo);
            }
        }
    }

    private void resetEntryMaterialInfo(Context ctx, PurInWarehsBillCollection purInWarehsBillCol) throws BOSException {
        MaterialInfo materialInfo;
        PurInWarehsEntryInfo entryInfo;
        PurInWarehsEntryCollection entryCol;
        PurInWarehsBillInfo billInfo;
        if (null == purInWarehsBillCol || purInWarehsBillCol.size() == 0) {
            return;
        }
        HashSet<String> materialIdSet = new HashSet<String>();
        int size = purInWarehsBillCol.size();
        for (int i = 0; i < size; ++i) {
            billInfo = purInWarehsBillCol.get(i);
            entryCol = billInfo.getEntry();
            if (entryCol == null || entryCol.size() <= 0) continue;
            int len = entryCol.size();
            for (int index = 0; index < len; ++index) {
                entryInfo = entryCol.get(index);
                if (entryInfo.getMaterial() == null) continue;
                materialIdSet.add(entryInfo.getMaterial().getId().toString());
            }
        }
        if (materialIdSet.size() == 0) {
            return;
        }
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", materialIdSet, CompareType.INCLUDE));
        entityViewInfo.setFilter(filter);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("id");
        selector.add("pricePrecision");
        entityViewInfo.setSelector(selector);
        MaterialCollection materialCol = MaterialFactory.getLocalInstance((Context)ctx).getMaterialCollection(entityViewInfo);
        if (materialCol == null || materialCol.size() == 0) {
            return;
        }
        HashMap<String, MaterialInfo> id2MaterialMap = new HashMap<String, MaterialInfo>();
        int size2 = materialCol.size();
        for (int i = 0; i < size2; ++i) {
            materialInfo = materialCol.get(i);
            id2MaterialMap.put(materialInfo.getId().toString(), materialInfo);
        }
        int size3 = purInWarehsBillCol.size();
        for (int i = 0; i < size3; ++i) {
            billInfo = purInWarehsBillCol.get(i);
            entryCol = billInfo.getEntry();
            if (entryCol == null || entryCol.size() <= 0) continue;
            int len = entryCol.size();
            for (int index = 0; index < len; ++index) {
                String materialId;
                entryInfo = entryCol.get(index);
                if (entryInfo.getMaterial() == null || (materialInfo = (MaterialInfo)id2MaterialMap.get(materialId = entryInfo.getMaterial().getId().toString())) == null) continue;
                entryInfo.setMaterial(materialInfo);
            }
        }
    }

    private void checkMatCompanyInfo(Context ctx, InvBillBaseInfo info) throws BOSException, EASBizException {
        InvServerUtils.checkMatCompanyInfo(ctx, info, InvBizException.MATERIAL_COMPANY_NULL_VIRTUAL);
    }
}

