/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.batch.BatchExecuteParamsEntry;
import com.kingdee.bos.framework.ejb.BizController;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.dynbusiness.adv.chain.app.BusinessChainExecutorFactory;
import com.kingdee.eas.dynbusiness.adv.chain.app.IBusinessChainExecutor;
import com.kingdee.eas.dynbusiness.app.processor.ExecuteContext;
import com.kingdee.eas.dynbusiness.app.processor.ParamEntryExecuteContext;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.framework.batchaction.BatchActionEnum;
import com.kingdee.eas.framework.batchaction.BatchActionResults;
import com.kingdee.eas.scm.common.ISCMBillParam;
import com.kingdee.eas.scm.common.SCMBillBaseInfo;
import com.kingdee.eas.scm.common.SCMBillException;
import com.kingdee.eas.scm.common.SCMBillParamFactory;
import com.kingdee.eas.scm.common.app.SCMServerUtils;
import com.kingdee.eas.scm.im.inv.StockReqEntryInfo;
import com.kingdee.eas.scm.im.inv.StockReqInfo;
import com.kingdee.eas.scm.im.inv.app.AbstractStockReqControllerBean;
import com.kingdee.eas.scm.util.SCMSelectorFactory;
import com.kingdee.util.BaseException;
import java.math.BigDecimal;

public class StockReqControllerBean
extends AbstractStockReqControllerBean {
    private static final BigDecimal zero = new BigDecimal(0.0);

    protected CompanyOrgUnitInfo _getCompanyOrgUnit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        return null;
    }

    protected CompanyOrgUnitInfo _getCompanyOrgUnit(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        return null;
    }

    protected String _getBizUnitOrgID(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        OrgUnitInfo orgUnitInfo = this.getMainBizOrgUnit(ctx, (CoreBillBaseInfo)model);
        if (orgUnitInfo != null) {
            return orgUnitInfo.getId().toString();
        }
        return null;
    }

    protected SelectorItemCollection getSelector(boolean isNeedEntrySelector) {
        return SCMSelectorFactory.getStockReqSelector((boolean)isNeedEntrySelector);
    }

    protected void _audit(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        StockReqInfo info = this.getStockReqInfo(ctx, pk, this.getSelector());
        this.passAudit(ctx, pk, (CoreBillBaseInfo)info);
    }

    protected void _passAudit(Context ctx, IObjectPK pk, IObjectValue model) throws EASBizException, BOSException {
        BatchExecuteParamsEntry[] entries = new BatchExecuteParamsEntry[]{new BatchExecuteParamsEntry(new Class[]{IObjectValue.class}, new Object[]{model})};
        this.batchExecute(ctx, entries, BatchActionEnum.AUDIT);
    }

    protected void _unAudit(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        StockReqInfo info = this.getStockReqInfo(ctx, pk, this.getSelector());
        this.unpassAudit(ctx, pk, (CoreBillBaseInfo)info);
    }

    protected void _unpassAudit(Context ctx, IObjectPK pk, IObjectValue model) throws EASBizException, BOSException {
        BatchExecuteParamsEntry[] entries = new BatchExecuteParamsEntry[]{new BatchExecuteParamsEntry(new Class[]{IObjectValue.class}, new Object[]{model})};
        this.batchExecute(ctx, entries, BatchActionEnum.UNAUDIT);
    }

    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        if (model.get("CONTEXT_KEY_CALLBACK_4_DAO") != null) {
            return super.saveWithoutBusiness(ctx, model);
        }
        BatchExecuteParamsEntry[] entries = new BatchExecuteParamsEntry[]{new BatchExecuteParamsEntry(new Class[]{IObjectValue.class})};
        entries[0].add((Object)model);
        this.batchSaveRelations(ctx, entries);
        return new ObjectUuidPK(((SCMBillBaseInfo)model).getId());
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        if (model.get("CONTEXT_KEY_CALLBACK_4_DAO") != null) {
            return super.submitWithoutBusiness(ctx, model);
        }
        BatchExecuteParamsEntry[] entries = new BatchExecuteParamsEntry[]{new BatchExecuteParamsEntry(new Class[]{IObjectValue.class})};
        entries[0].add((Object)model);
        this.batchSubmitRelations(ctx, entries);
        return new ObjectUuidPK(((SCMBillBaseInfo)model).getId());
    }

    protected BatchActionResults batchExecute(Context ctx, BatchExecuteParamsEntry[] entries, BatchActionEnum batchActionEnum) throws EASBizException, BOSException {
        IBusinessChainExecutor executor = BusinessChainExecutorFactory.getBusinessChainExecutor();
        ParamEntryExecuteContext executeContext = new ParamEntryExecuteContext(ctx, this.getBOSType(), batchActionEnum, (BizController)this, entries);
        executeContext.setBillTypeID(this.getBillTypeId());
        BatchActionResults batchResults = executor.batchExecute((ExecuteContext)executeContext);
        return batchResults;
    }

    public BatchActionResults batchSubmitOrSave(Context ctx, BatchExecuteParamsEntry[] entries, BatchActionEnum batchActionEnum) throws EASBizException, BOSException {
        return this.batchExecute(ctx, entries, batchActionEnum);
    }

    private void initBotpData(Context ctx, IObjectValue model) throws EASBizException, BOSException {
        StockReqInfo info = (StockReqInfo)model;
        info.setBillType(SCMServerUtils.getBillType((String)"MmEE6VBsR0KaUDQmebwhP0Y+1VI="));
        if (info.getEntry() == null) {
            return;
        }
        for (int i = 0; i < info.getEntry().size(); ++i) {
            StockReqEntryInfo entry = info.getEntry().get(i);
            MaterialInfo material = entry.getMaterial();
            if (material == null) continue;
            MeasureUnitInfo unit = entry.getUnit();
            MeasureUnitInfo baseUnit = entry.getBaseUnit();
            MeasureUnitInfo asstUnit = entry.getAssistUnit();
            BigDecimal baseQty = entry.getBaseQty();
            if (baseQty == null) {
                entry.setBaseQty(zero);
            }
            BigDecimal qty = SCMServerUtils.getUnitQty((Context)ctx, (BigDecimal)baseQty, (String)material.getId().toString(), (String)baseUnit.getId().toString(), (String)unit.getId().toString());
            entry.setQty(qty);
            if (asstUnit != null) {
                BigDecimal asstQty = SCMServerUtils.getUnitQty((Context)ctx, (BigDecimal)baseQty, (String)material.getId().toString(), (String)baseUnit.getId().toString(), (String)asstUnit.getId().toString());
                entry.setAssistQty(asstQty);
                entry.setApprovedAssitQty(asstQty);
            }
            entry.setAuditQty(qty);
        }
    }

    public String getParamCon4Audit() {
        return "INM103";
    }

    public String getParamCon4UnAudit() {
        return "INM104";
    }

    protected boolean _checkUnAuditInParam(Context ctx, IObjectValue model) throws EASBizException, BOSException {
        StockReqInfo info = (StockReqInfo)model;
        if (info.getBillType() != null) {
            String billTypeId = info.getBillType().getId().toString();
            String orgUnitID = info.getReqStorage().getId().toString();
            boolean isCanUnAudit = false;
            ISCMBillParam scmParam = SCMBillParamFactory.getLocalInstance((Context)ctx);
            String strCanUnAudit = scmParam.getParamByBillTypeID("SCM_UnAudit_01", 4, orgUnitID, billTypeId);
            if (strCanUnAudit != null && strCanUnAudit.trim().length() != 0 && strCanUnAudit.trim().equalsIgnoreCase("1")) {
                isCanUnAudit = true;
            }
            if (!isCanUnAudit) {
                throw new SCMBillException(SCMBillException.CHECK_UNAUDIT_PARAM);
            }
        }
        return true;
    }

    public void _handleAfterTransform(Context ctx, String action, IObjectCollection collection) throws EASBizException, BOSException {
        if (collection == null || collection.size() == 0) {
            return;
        }
        int n = collection.size();
        for (int i = 0; i < n; ++i) {
            IObjectValue model = collection.getObject(i);
            this.initBotpData(ctx, model);
        }
    }

    protected String getBatchMethodName(Context ctx, String name) throws BaseException {
        if (Boolean.FALSE.equals(ctx.get((Object)"CONTEXT_KEY_ISBATCHACTION"))) {
            return null;
        }
        return "batch" + name.substring(0, 1).toUpperCase() + name.substring(1);
    }

    protected void _submit(Context ctx, String id) throws BOSException, EASBizException {
        BatchExecuteParamsEntry[] entries = new BatchExecuteParamsEntry[1];
        Class[] parameterTypes = new Class[]{IObjectValue.class};
        StockReqInfo model = this.getStockReqInfo(ctx, (IObjectPK)new ObjectStringPK(id), this.getSelector());
        entries[0] = new BatchExecuteParamsEntry(parameterTypes, new Object[]{model});
        this.batchExecute(ctx, entries, BatchActionEnum.SUBMIT);
    }
}

