/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.basedata.scm.common.BillTypeInfo;
import com.kingdee.eas.basedata.scm.common.BizTypeInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.scm.basedatautil.master.OrgUnitUtil;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.common.EntryBaseStatusEnum;
import com.kingdee.eas.scm.common.ISCMBillBase;
import com.kingdee.eas.scm.im.inv.DealStatusEnum;
import com.kingdee.eas.scm.im.inv.StockReqEntryInfo;
import com.kingdee.eas.scm.im.inv.StockReqFactory;
import com.kingdee.eas.scm.im.inv.StockReqInfo;
import com.kingdee.eas.scm.im.inv.StockTypeEnum;
import com.kingdee.eas.scm.im.inv.app.AbstractStockReqWebFacadeControllerBean;
import com.kingdee.eas.scm.im.inv.app.InvAppUtils;
import com.kingdee.eas.scm.util.constant.OprtStateConstant;
import com.kingdee.eas.util.app.ContextUtil;
import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Date;
import java.util.Map;
import org.apache.log4j.Logger;

public class StockReqWebFacadeControllerBean
extends AbstractStockReqWebFacadeControllerBean {
    private static final long serialVersionUID = 8297475107839950560L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.scm.im.inv.app.StockReqWebFacadeControllerBean");
    private static final BigDecimal ZERO = SysConstant.BIGZERO;

    public IObjectValue createModel(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        StockReqInfo info = (StockReqInfo)model;
        if (info == null) {
            info = new StockReqInfo();
        }
        StorageOrgUnitInfo reqStorage = (StorageOrgUnitInfo)InvAppUtils.getDefaultMainBizOrg(ctx, this.getMainOrgType(), this.getPermissionItem());
        CompanyOrgUnitInfo reqCompany = OrgUnitUtil.getCompanyFromStorage((Context)ctx, (StorageOrgUnitInfo)info.getReqStorage());
        BizTypeInfo bizTypeInfo = this.getDefaultBizTypeInfo(null, "P6/avnd3QEeGPCqlUsZnjyQHQ1w=", "MmEE6VBsR0KaUDQmebwhP0Y+1VI=");
        info.setBizType(bizTypeInfo);
        BillTypeInfo billType = new BillTypeInfo();
        billType.setId(BOSUuid.read((String)"MmEE6VBsR0KaUDQmebwhP0Y+1VI="));
        info.setBillType(billType);
        Date now = this.getServerDate2(ctx);
        UserInfo user = ContextUtil.getCurrentUserInfo((Context)ctx);
        info.setProposer(user.getPerson());
        info.setCreator(user);
        info.setBizDate(now);
        info.setReqStorage(reqStorage);
        info.setReqCompany(reqCompany);
        info.setCU(reqStorage.getCU());
        info.setBaseStatus(BillBaseStatusEnum.ADD);
        if (info.getEntry() != null) {
            StockReqEntryInfo entry = null;
            for (int i = 0; i < 5; ++i) {
                entry = (StockReqEntryInfo)this.createNewDetailData(ctx, (IObjectValue)info);
                info.getEntry().add(entry);
                entry.setDeliveryDate(info.getBizDate());
                entry.setReceiveStorage(info.getReqStorage());
                entry.setReceiveCompany(info.getReqCompany());
            }
        }
        return info;
    }

    public IObjectValue createNewDetailData(Context context, IObjectValue model) throws BOSException, EASBizException {
        StockReqEntryInfo entry = new StockReqEntryInfo();
        entry.setQty(ZERO);
        entry.setBaseQty(ZERO);
        entry.setAuditBaseQty(ZERO);
        entry.setAssistQty(ZERO);
        entry.setStockType(StockTypeEnum.STOCK);
        entry.setTotalStockQty(ZERO);
        entry.setTotalStockBaseQty(ZERO);
        entry.setAssociateQty(ZERO);
        entry.setIsUnControlQty(true);
        entry.setLessDeliveryRate(ZERO);
        entry.setOverDeliveryRate(ZERO);
        entry.setDealStatus(DealStatusEnum.UNDEAL);
        Calendar reqDateFrom = this.getReqDateFrom(context);
        Calendar reqDateTo = (Calendar)reqDateFrom.clone();
        reqDateTo.add(5, 6);
        entry.setReqDateFrom(reqDateFrom.getTime());
        entry.setReqDateTo(reqDateTo.getTime());
        entry.setBaseStatus(EntryBaseStatusEnum.ADD);
        return entry;
    }

    public Calendar getReqDateFrom(Context ctx) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(this.getServerDate2(ctx));
        calendar.add(5, 7);
        calendar.set(7, 2);
        return calendar;
    }

    public Date getServerDate2(Context ctx) {
        try {
            return this.getServerDate(ctx);
        }
        catch (Exception e) {
            logger.error((Object)e);
            return null;
        }
    }

    public String getPermissionItem() {
        if (OprtStateConstant.ADDNEW.equals(this.oprtState)) {
            return "stockReq_new";
        }
        if (OprtStateConstant.EDIT.equals(this.oprtState)) {
            return "stockReq_update";
        }
        if (OprtStateConstant.VIEW.equals(this.oprtState)) {
            return "stockReq_view";
        }
        return "stockReq_new";
    }

    public OrgType getMainOrgType() {
        return OrgType.Storage;
    }

    public String getMainOrgUnitName() {
        return "reqStorage";
    }

    protected ISCMBillBase getLocalInstance(Context context) throws BOSException {
        return StockReqFactory.getLocalInstance(context);
    }

    public Map handleMainOrgChange(Context ctx, String mainOrgId) throws BOSException, EASBizException {
        return super.handleMainOrgChange(ctx, mainOrgId);
    }

    public void initData(Context context, Map initData, IObjectValue model) throws EASBizException, BOSException {
        super.initData(context, initData, model);
        StorageOrgUnitInfo sou = (StorageOrgUnitInfo)model.get(this.getMainOrgUnitName());
        CompanyOrgUnitInfo cou = (CompanyOrgUnitInfo)model.get("reqCompany");
        if (sou == null || cou == null) {
            return;
        }
    }
}

