/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.batch.BatchExecuteParamsEntry;
import com.kingdee.bos.framework.ejb.BizController;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.bot.BOTMappingFactory;
import com.kingdee.bos.metadata.bot.BOTMappingInfo;
import com.kingdee.bos.metadata.bot.BOTRelationFactory;
import com.kingdee.bos.metadata.bot.BOTRelationInfo;
import com.kingdee.bos.metadata.bot.IBOTMapping;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.service.ServiceStateManager;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.btp.BTPManagerFactory;
import com.kingdee.eas.base.btp.BTPTransformResult;
import com.kingdee.eas.base.btp.IBTPManager;
import com.kingdee.eas.base.btp.app.BOTOrgUtils;
import com.kingdee.eas.base.param.IParamControl;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.cssp.CustomerCollection;
import com.kingdee.eas.basedata.master.cssp.CustomerFactory;
import com.kingdee.eas.basedata.master.cssp.SupplierCollection;
import com.kingdee.eas.basedata.master.cssp.SupplierFactory;
import com.kingdee.eas.basedata.master.cssp.SupplierInfo;
import com.kingdee.eas.basedata.master.material.AccountType;
import com.kingdee.eas.basedata.master.material.IMaterial;
import com.kingdee.eas.basedata.master.material.IMaterialInventory;
import com.kingdee.eas.basedata.master.material.IMaterialPlan;
import com.kingdee.eas.basedata.master.material.MaterialCompanyInfoCollection;
import com.kingdee.eas.basedata.master.material.MaterialCompanyInfoFactory;
import com.kingdee.eas.basedata.master.material.MaterialCompanyInfoInfo;
import com.kingdee.eas.basedata.master.material.MaterialFactory;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.MaterialInventoryCollection;
import com.kingdee.eas.basedata.master.material.MaterialInventoryFactory;
import com.kingdee.eas.basedata.master.material.MaterialInventoryInfo;
import com.kingdee.eas.basedata.master.material.MaterialPlanCollection;
import com.kingdee.eas.basedata.master.material.MaterialPlanFactory;
import com.kingdee.eas.basedata.master.material.MaterialPlanInfo;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitFactory;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitInfo;
import com.kingdee.eas.basedata.master.material.PlanningModeEnum;
import com.kingdee.eas.basedata.master.material.UsedStatusEnum;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.IOrgUnitRelation;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitRelationFactory;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.basedata.scm.common.BillTypeInfo;
import com.kingdee.eas.basedata.scm.common.BizTypeFactory;
import com.kingdee.eas.basedata.scm.common.BizTypeInfo;
import com.kingdee.eas.basedata.scm.common.IBizType;
import com.kingdee.eas.basedata.scm.common.TransBizTypeCollection;
import com.kingdee.eas.basedata.scm.common.TransBizTypeFactory;
import com.kingdee.eas.basedata.scm.common.TransactionTypeInfo;
import com.kingdee.eas.basedata.scm.common.util.SCMBaseCommonUtil;
import com.kingdee.eas.basedata.scm.im.inv.IMaterialStorageAssign;
import com.kingdee.eas.basedata.scm.im.inv.InvUpdateTypeInfo;
import com.kingdee.eas.basedata.scm.im.inv.LocationInfo;
import com.kingdee.eas.basedata.scm.im.inv.MaterialStorageAssignCollection;
import com.kingdee.eas.basedata.scm.im.inv.MaterialStorageAssignFactory;
import com.kingdee.eas.basedata.scm.im.inv.MaterialStorageAssignInfo;
import com.kingdee.eas.basedata.scm.im.inv.StoreFlagEnum;
import com.kingdee.eas.basedata.scm.im.inv.StoreStateFactory;
import com.kingdee.eas.basedata.scm.im.inv.StoreStateInfo;
import com.kingdee.eas.basedata.scm.im.inv.StoreTypeFactory;
import com.kingdee.eas.basedata.scm.im.inv.StoreTypeInfo;
import com.kingdee.eas.basedata.scm.im.inv.WarehouseFactory;
import com.kingdee.eas.basedata.scm.im.inv.WarehouseInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.dynbusiness.adv.chain.app.BusinessChainExecutorFactory;
import com.kingdee.eas.dynbusiness.adv.chain.app.IBusinessChainExecutor;
import com.kingdee.eas.dynbusiness.app.processor.ExecuteContext;
import com.kingdee.eas.dynbusiness.app.processor.ParamEntryExecuteContext;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.CoreBillBaseCollection;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.framework.batchaction.BatchActionEnum;
import com.kingdee.eas.framework.batchaction.BatchActionResults;
import com.kingdee.eas.mm.control.IStockGatherMove;
import com.kingdee.eas.mm.control.StockGatherMoveFactory;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.common.BizActionEnum;
import com.kingdee.eas.scm.common.EntryBaseStatusEnum;
import com.kingdee.eas.scm.common.ISCMBillParam;
import com.kingdee.eas.scm.common.ISCMFetchDataFacade;
import com.kingdee.eas.scm.common.SCMBillBaseInfo;
import com.kingdee.eas.scm.common.SCMBillEntryBaseInfo;
import com.kingdee.eas.scm.common.SCMBillException;
import com.kingdee.eas.scm.common.SCMBillParamFactory;
import com.kingdee.eas.scm.common.SCMFetchData;
import com.kingdee.eas.scm.common.SCMFetchDataCondition;
import com.kingdee.eas.scm.common.SCMFetchDataFacadeFactory;
import com.kingdee.eas.scm.common.SCMGroupFacadeFactory;
import com.kingdee.eas.scm.common.app.SCMServerUtils;
import com.kingdee.eas.scm.common.loadmass.SCMBizDataVO;
import com.kingdee.eas.scm.common.loadmass.SCMEntryDataVO;
import com.kingdee.eas.scm.common.util.SCMCommonUtil;
import com.kingdee.eas.scm.common.util.SCMUtils;
import com.kingdee.eas.scm.framework.bizflow.util.BizBillValueChangeUtil;
import com.kingdee.eas.scm.im.inv.AbstractStockTransferBillEntryInfo;
import com.kingdee.eas.scm.im.inv.IMaterialSerialNumber;
import com.kingdee.eas.scm.im.inv.IMoveInWarehsBill;
import com.kingdee.eas.scm.im.inv.IMoveIssueBill;
import com.kingdee.eas.scm.im.inv.IPurInWarehsEntry;
import com.kingdee.eas.scm.im.inv.InvBillBaseEntryInfo;
import com.kingdee.eas.scm.im.inv.InvBillBaseInfo;
import com.kingdee.eas.scm.im.inv.InvBizException;
import com.kingdee.eas.scm.im.inv.InvUpdateException;
import com.kingdee.eas.scm.im.inv.MaterialSerialNumberCollection;
import com.kingdee.eas.scm.im.inv.MaterialSerialNumberEntryCollection;
import com.kingdee.eas.scm.im.inv.MaterialSerialNumberEntryInfo;
import com.kingdee.eas.scm.im.inv.MaterialSerialNumberFactory;
import com.kingdee.eas.scm.im.inv.MaterialSerialNumberInfo;
import com.kingdee.eas.scm.im.inv.MoveInWarehsBillEntryInfo;
import com.kingdee.eas.scm.im.inv.MoveInWarehsBillFactory;
import com.kingdee.eas.scm.im.inv.MoveInWarehsBillInfo;
import com.kingdee.eas.scm.im.inv.MoveIssueBillEntryInfo;
import com.kingdee.eas.scm.im.inv.MoveIssueBillFactory;
import com.kingdee.eas.scm.im.inv.MoveIssueBillInfo;
import com.kingdee.eas.scm.im.inv.PurInWarehsEntryFactory;
import com.kingdee.eas.scm.im.inv.PurInWarehsEntryInfo;
import com.kingdee.eas.scm.im.inv.SerialNumberStatusEnum;
import com.kingdee.eas.scm.im.inv.StockTransferBillAgent;
import com.kingdee.eas.scm.im.inv.StockTransferBillEntryAgent;
import com.kingdee.eas.scm.im.inv.StockTransferBillEntryCollection;
import com.kingdee.eas.scm.im.inv.StockTransferBillEntryInfo;
import com.kingdee.eas.scm.im.inv.StockTransferBillException;
import com.kingdee.eas.scm.im.inv.StockTransferBillFactory;
import com.kingdee.eas.scm.im.inv.StockTransferBillInfo;
import com.kingdee.eas.scm.im.inv.TransferOrderBillException;
import com.kingdee.eas.scm.im.inv.app.AbstractStockTransferBillControllerBean;
import com.kingdee.eas.scm.im.inv.app.InvAppUtils;
import com.kingdee.eas.scm.im.inv.app.InvServerUtils;
import com.kingdee.eas.scm.sm.pur.IPurOrderEntry;
import com.kingdee.eas.scm.sm.pur.PurOrderEntryFactory;
import com.kingdee.eas.scm.sm.pur.PurOrderEntryInfo;
import com.kingdee.eas.scm.util.SCMUtil;
import com.kingdee.eas.scm.util.app.db.KsqlUtil;
import com.kingdee.eas.scm.util.collection.CollectionUtil;
import com.kingdee.eas.scm.util.string.StringUtil;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.BaseException;
import com.kingdee.util.NumericExceptionSubItem;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class StockTransferBillControllerBean
extends AbstractStockTransferBillControllerBean {
    private static final long serialVersionUID = 8199606442042585667L;
    private static final BigDecimal ZERO = new BigDecimal("0.00");
    private static final String MOVEISSUE_BOSTYPE = "71D272F1";
    private static final String MOVEINWAREHS_BOSTYPE = "E3DAFF63";
    private static final String TRANSTOMOVEISSUE_BOTP = "709becee-0108-1000-e000-2b10c0a812fd045122C4";
    private static final String TRANSTOMOVEINWAREHS_BOTP = "709becee-0108-1000-e000-2980c0a812fd045122C4";
    private HashMap<String, Object> dataBuffer = new HashMap();
    private Map<String, MaterialInventoryInfo> matInvMap = new HashMap<String, MaterialInventoryInfo>();
    private Map<String, MaterialCompanyInfoInfo> matCouMap = new HashMap<String, MaterialCompanyInfoInfo>();

    @Override
    protected void _generateVoucher(Context ctx, IObjectValue billinfo) throws BOSException, EASBizException {
    }

    @Override
    protected String[] _autoTransfer(Context ctx, StockTransferBillInfo bill) throws BOSException, EASBizException {
        int i;
        if (bill == null) {
            return null;
        }
        bill = StockTransferBillFactory.getLocalInstance(ctx).getStockTransferBillInfo((IObjectPK)new ObjectUuidPK(bill.getId()), this.getSelector());
        this.checkForAutoTransfer(ctx, bill);
        bill.put("autoTransfer", Boolean.TRUE);
        MaterialSerialNumberFactory.getLocalInstance(ctx).checkSerialNumberIsNull(bill);
        List<MoveIssueBillInfo> moveIssueList = this.createMoveIssueBills(ctx, bill);
        bill = StockTransferBillFactory.getLocalInstance(ctx).getStockTransferBillInfo((IObjectPK)new ObjectUuidPK(bill.getId()), this.getSelector());
        List<MoveInWarehsBillInfo> moveInWarehsList = this.createMoveInWarehsBills(ctx, bill);
        bill.setBaseStatus(BillBaseStatusEnum.CLOSED);
        MaterialSerialNumberFactory.getLocalInstance(ctx).updateMaterialSN(bill);
        StringBuffer moveIssueBillNumbers = new StringBuffer();
        StringBuffer moveInwarehsBillNumbers = new StringBuffer();
        for (i = 0; i < moveIssueList.size(); ++i) {
            if (i != 0) {
                moveIssueBillNumbers.append(",");
            }
            moveIssueBillNumbers.append(moveIssueList.get(i).getNumber());
        }
        for (i = 0; i < moveInWarehsList.size(); ++i) {
            if (i != 0) {
                moveInwarehsBillNumbers.append(",");
            }
            moveInwarehsBillNumbers.append(moveInWarehsList.get(i).getNumber());
        }
        return new String[]{moveIssueBillNumbers.toString(), moveInwarehsBillNumbers.toString()};
    }

    private void checkForAutoTransfer(Context ctx, StockTransferBillInfo bill) throws EASBizException, BOSException {
        this.checkAutoTransferForLot(ctx, bill.getId().toString());
        StockTransferBillEntryCollection coll = bill.getEntry();
        for (int i = 0; i < coll.size(); ++i) {
            StockTransferBillEntryInfo entry = coll.get(i);
            if (entry.getMaterial().getAssistAttr() == null || entry.getAssistProperty() != null) continue;
            throw new StockTransferBillException(StockTransferBillException.ASSISTNUMCANNOTBENULL, new Object[]{++i});
        }
    }

    private List<MoveInWarehsBillInfo> createMoveInWarehsBills(Context ctx, StockTransferBillInfo bill) throws BOSException, EASBizException {
        IObjectCollection objectValues = null;
        objectValues = this.getObjectCollection(ctx, bill, MOVEINWAREHS_BOSTYPE, TRANSTOMOVEINWAREHS_BOTP);
        ArrayList<MoveInWarehsBillInfo> result = new ArrayList<MoveInWarehsBillInfo>();
        for (int i = 0; i < objectValues.size(); ++i) {
            result.add(this.createMoveInWarehsBill(ctx, bill, (MoveInWarehsBillInfo)objectValues.getObject(i)));
        }
        return result;
    }

    private List<MoveIssueBillInfo> createMoveIssueBills(Context ctx, StockTransferBillInfo bill) throws BOSException, EASBizException {
        IObjectCollection objectValues = null;
        objectValues = this.getObjectCollection(ctx, bill, MOVEISSUE_BOSTYPE, TRANSTOMOVEISSUE_BOTP);
        ArrayList<MoveIssueBillInfo> result = new ArrayList<MoveIssueBillInfo>();
        for (int i = 0; i < objectValues.size(); ++i) {
            result.add(this.createMoveIssueBill(ctx, bill, (MoveIssueBillInfo)objectValues.getObject(i)));
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MoveIssueBillInfo createMoveIssueBill(Context ctx, StockTransferBillInfo bill, MoveIssueBillInfo moveIssueBillInfo) throws BOSException, EASBizException {
        boolean isNotAutoAudit;
        StorageOrgUnitInfo issueStoOrg = bill.getIssueStorageOrgUnit();
        StorageOrgUnitInfo receiptStoOrg = bill.getReceiptStorageOrgUnit();
        MaterialSerialNumberInfo moveIssueSnInfo = null;
        MaterialSerialNumberInfo snInfo = null;
        String moveBillID = moveIssueBillInfo.getId().toString();
        MoveIssueBillEntryInfo moveEntryInfo = null;
        String moveBillEntryID = "";
        StockTransferBillInfo stockInfo = null;
        StockTransferBillEntryInfo stockEntryInfo = null;
        MaterialInfo materialInfo = null;
        MaterialInventoryInfo materialInventoryIssue = null;
        MaterialInventoryInfo materialInventoryReceipt = null;
        moveIssueBillInfo.put("autoTransfer", Boolean.TRUE);
        this.initMoveIssueBill(ctx, moveIssueBillInfo);
        StockTransferBillEntryCollection stockEntryColl = bill.getEntry();
        int n = moveIssueBillInfo.getEntry().size();
        for (int i = 0; i < n; ++i) {
            moveEntryInfo = moveIssueBillInfo.getEntry().get(i);
            BOSUuid moveBillEntryId = moveEntryInfo.getId();
            moveBillEntryID = moveBillEntryId.toString();
            stockInfo = moveEntryInfo.getStockTransferBill();
            String billID = stockInfo.getId().toString();
            stockEntryInfo = moveEntryInfo.getStockTransBillEntry();
            stockEntryInfo = this.getTransferBillEntry(ctx, stockEntryColl, stockEntryInfo.getId().toString());
            materialInfo = stockEntryInfo.getMaterial();
            materialInventoryIssue = this.getMaterialInventoryInfo(ctx, materialInfo.getId().toString(), issueStoOrg.getId().toString());
            materialInventoryReceipt = this.getMaterialInventoryInfo(ctx, materialInfo.getId().toString(), receiptStoOrg.getId().toString());
            if (materialInventoryIssue == null || !materialInventoryIssue.isIsSequenceNo() || materialInventoryReceipt == null || !materialInventoryReceipt.isIsSequenceNo()) continue;
            EntityViewInfo viewInfo = new EntityViewInfo();
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("billID", (Object)moveBillID));
            filterInfo.getFilterItems().add(new FilterItemInfo("billEntryID", (Object)moveEntryInfo.getId().toString()));
            viewInfo.setFilter(filterInfo);
            MaterialSerialNumberCollection snColls = MaterialSerialNumberFactory.getLocalInstance(ctx).getMaterialSerialNumberCollection(viewInfo);
            if (snColls != null && snColls.size() > 0) continue;
            EntityViewInfo ev = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("billID", (Object)billID));
            filter.getFilterItems().add(new FilterItemInfo("billEntryID", (Object)stockEntryInfo.getId().toString()));
            filter.getFilterItems().add(new FilterItemInfo("material", (Object)materialInfo.getId().toString()));
            ev.setFilter(filter);
            ev.getSelector().add(new SelectorItemInfo("*"));
            ev.getSelector().add(new SelectorItemInfo("snUnit.number"));
            ev.getSelector().add(new SelectorItemInfo("snUnit.name"));
            ev.getSelector().add(new SelectorItemInfo("material.number"));
            ev.getSelector().add(new SelectorItemInfo("material.name"));
            ev.getSelector().add(new SelectorItemInfo("entry.*"));
            ev.getSorter().add(new SorterItemInfo("entry.seq"));
            IMaterialSerialNumber iMaterialSerialNumber = MaterialSerialNumberFactory.getLocalInstance(ctx);
            MaterialSerialNumberCollection snColl = iMaterialSerialNumber.getMaterialSerialNumberCollection(ev);
            if (snColl == null || snColl.size() <= 0) continue;
            snInfo = snColl.get(0);
            MaterialSerialNumberEntryCollection entryColl = snInfo.getEntry();
            MaterialSerialNumberEntryInfo entryInfo = null;
            if (entryColl != null) {
                int size = entryColl.size();
                for (int j = 0; j < size; ++j) {
                    entryInfo = entryColl.get(j);
                    if (entryInfo == null) continue;
                    entryInfo.setId(BOSUuid.create((BOSObjectType)entryInfo.getBOSType()));
                }
            }
            moveIssueSnInfo = (MaterialSerialNumberInfo)snInfo.clone();
            moveIssueSnInfo.setBillID(moveBillID);
            moveIssueSnInfo.setBillEntryID(moveBillEntryID);
            moveIssueSnInfo.setMaterial(moveEntryInfo.getMaterial());
            moveIssueSnInfo.setBillNumber(moveIssueBillInfo.getNumber());
            moveIssueSnInfo.setBillEntrySeq(moveEntryInfo.getSeq());
            BillTypeInfo aBillTypeInfo = new BillTypeInfo();
            aBillTypeInfo.setId(BOSUuid.read((String)"50957179-0105-1000-e000-016ec0a812fd463ED552"));
            moveIssueSnInfo.setBillType(aBillTypeInfo);
            moveIssueSnInfo.setSnQty(moveEntryInfo.getQty());
            moveIssueSnInfo.setIsReversed(moveIssueBillInfo.isIsReversed());
            moveIssueSnInfo.setBillBizDate(moveIssueBillInfo.getBizDate());
            moveIssueSnInfo.setTransactionType(moveIssueBillInfo.getTransactionType());
            moveIssueSnInfo.setBillBaseStatus(moveIssueBillInfo.getBaseStatus());
            moveIssueSnInfo.setWarehouse(moveEntryInfo.getWarehouse());
            moveIssueSnInfo.setLocation(moveEntryInfo.getLocation());
            moveIssueSnInfo.setAuditTime(moveIssueBillInfo.getAuditTime());
            moveIssueSnInfo.setSnStatus(SerialNumberStatusEnum.SALE);
            StorageOrgUnitInfo aStorageOrgUnitInfo = moveEntryInfo.getStorageOrgUnit();
            moveIssueSnInfo.setStorageOrgUnit(aStorageOrgUnitInfo);
            moveIssueSnInfo.setId(BOSUuid.create((BOSObjectType)moveIssueSnInfo.getBOSType()));
            iMaterialSerialNumber.addnew((CoreBaseInfo)moveIssueSnInfo);
        }
        IMoveIssueBill imb = MoveIssueBillFactory.getLocalInstance(ctx);
        moveIssueBillInfo.put("isautoTransfer", Boolean.TRUE);
        IObjectPK pk = null;
        boolean bl = isNotAutoAudit = !this.isAuditWhenSubmit(ctx, moveIssueBillInfo.getStorageOrgUnit().getId().toString(), 4, "106");
        if (isNotAutoAudit) {
            moveIssueBillInfo.put("autoTransfer", Boolean.TRUE);
        }
        boolean isSaveBotpRelation = moveIssueBillInfo.getBaseStatus() == BillBaseStatusEnum.ADD;
        ctx.put((Object)"autoTransfer", (Object)Boolean.TRUE);
        try {
            pk = imb.transferAutoSubmit(moveIssueBillInfo);
        }
        finally {
            ctx.remove((Object)"autoTransfer");
        }
        if (isSaveBotpRelation) {
            BOTRelationInfo info = new BOTRelationInfo();
            info.setSrcObjectID(bill.getId().toString());
            info.setSrcEntityID(bill.getBOSType().toString());
            info.setDestEntityID(MOVEISSUE_BOSTYPE);
            info.setDestObjectID(pk.toString());
            info.setOperatorID("unknown");
            info.setType(0);
            BOTRelationFactory.getLocalInstance((Context)ctx).addnew(info);
        }
        moveIssueBillInfo = imb.getMoveIssueBillInfo(pk);
        if (isNotAutoAudit) {
            ctx.put((Object)"autoTransfer", (Object)Boolean.TRUE);
            try {
                imb.passAudit(pk, (CoreBillBaseInfo)moveIssueBillInfo);
            }
            finally {
                ctx.remove((Object)"autoTransfer");
            }
        }
        return moveIssueBillInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MoveInWarehsBillInfo createMoveInWarehsBill(Context ctx, StockTransferBillInfo bill, MoveInWarehsBillInfo moveInWarehsBillInfo) throws BOSException, EASBizException {
        boolean isNotAutoAudit2;
        StorageOrgUnitInfo issueStoOrg = bill.getIssueStorageOrgUnit();
        StorageOrgUnitInfo receiptStoOrg = bill.getReceiptStorageOrgUnit();
        MaterialSerialNumberInfo moveIssueSnInfo = null;
        MaterialSerialNumberInfo snInfo = null;
        String moveBillID = moveInWarehsBillInfo.getId().toString();
        MoveInWarehsBillEntryInfo moveEntryInfo = null;
        String moveBillEntryID = "";
        moveInWarehsBillInfo.put("autoTransfer", Boolean.TRUE);
        this.initMoveInWarehsBill(ctx, moveInWarehsBillInfo);
        StockTransferBillEntryCollection stockEntryColl = bill.getEntry();
        int n = moveInWarehsBillInfo.getEntry().size();
        for (int i = 0; i < n; ++i) {
            moveEntryInfo = moveInWarehsBillInfo.getEntry().get(i);
            BOSUuid moveBillEntryId = moveEntryInfo.getId();
            moveBillEntryID = moveBillEntryId.toString();
            StockTransferBillInfo stockInfo = moveEntryInfo.getStockTransferBill();
            String billID = stockInfo.getId().toString();
            StockTransferBillEntryInfo stockEntryInfo = moveEntryInfo.getStockTransBillEntry();
            stockEntryInfo = this.getTransferBillEntry(ctx, stockEntryColl, stockEntryInfo.getId().toString());
            MaterialInfo materialInfo = stockEntryInfo.getMaterial();
            MaterialInventoryInfo materialInventoryIssue = null;
            MaterialInventoryInfo materialInventoryReceipt = null;
            materialInventoryIssue = this.getMaterialInventoryInfo(ctx, materialInfo.getId().toString(), issueStoOrg.getId().toString());
            materialInventoryReceipt = this.getMaterialInventoryInfo(ctx, materialInfo.getId().toString(), receiptStoOrg.getId().toString());
            if (materialInventoryIssue == null || !materialInventoryIssue.isIsSequenceNo() || materialInventoryReceipt == null || !materialInventoryReceipt.isIsSequenceNo()) continue;
            EntityViewInfo viewInfo = new EntityViewInfo();
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("billID", (Object)moveBillID));
            filterInfo.getFilterItems().add(new FilterItemInfo("billEntryID", (Object)moveEntryInfo.getId().toString()));
            viewInfo.setFilter(filterInfo);
            MaterialSerialNumberCollection snColls = MaterialSerialNumberFactory.getLocalInstance(ctx).getMaterialSerialNumberCollection(viewInfo);
            if (snColls != null && snColls.size() > 0) continue;
            EntityViewInfo ev = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("billID", (Object)billID));
            filter.getFilterItems().add(new FilterItemInfo("billEntryID", (Object)stockEntryInfo.getId().toString()));
            filter.getFilterItems().add(new FilterItemInfo("material", (Object)materialInfo.getId().toString()));
            ev.setFilter(filter);
            ev.getSelector().add(new SelectorItemInfo("*"));
            ev.getSelector().add(new SelectorItemInfo("snUnit.number"));
            ev.getSelector().add(new SelectorItemInfo("snUnit.name"));
            ev.getSelector().add(new SelectorItemInfo("material.number"));
            ev.getSelector().add(new SelectorItemInfo("material.name"));
            ev.getSelector().add(new SelectorItemInfo("entry.*"));
            ev.getSorter().add(new SorterItemInfo("entry.seq"));
            IMaterialSerialNumber iMaterialSerialNumber = MaterialSerialNumberFactory.getLocalInstance(ctx);
            MaterialSerialNumberCollection snColl = iMaterialSerialNumber.getMaterialSerialNumberCollection(ev);
            if (snColl == null || snColl.size() <= 0) continue;
            snInfo = snColl.get(0);
            MaterialSerialNumberEntryCollection entryColl = snInfo.getEntry();
            MaterialSerialNumberEntryInfo entryInfo = null;
            if (entryColl != null) {
                int size = entryColl.size();
                for (int j = 0; j < size; ++j) {
                    entryInfo = entryColl.get(j);
                    if (entryInfo == null) continue;
                    entryInfo.setId(BOSUuid.create((BOSObjectType)entryInfo.getBOSType()));
                }
            }
            moveIssueSnInfo = (MaterialSerialNumberInfo)snInfo.clone();
            moveIssueSnInfo.setBillID(moveBillID);
            moveIssueSnInfo.setBillEntryID(moveBillEntryID);
            moveIssueSnInfo.setMaterial(moveEntryInfo.getMaterial());
            moveIssueSnInfo.setBillNumber(moveInWarehsBillInfo.getNumber());
            moveIssueSnInfo.setBillEntrySeq(moveEntryInfo.getSeq());
            moveIssueSnInfo.setSnQty(moveEntryInfo.getQty());
            moveIssueSnInfo.setIsReversed(moveInWarehsBillInfo.isIsReversed());
            moveIssueSnInfo.setBillBizDate(moveInWarehsBillInfo.getBizDate());
            moveIssueSnInfo.setTransactionType(moveInWarehsBillInfo.getTransactionType());
            moveIssueSnInfo.setBillBaseStatus(moveInWarehsBillInfo.getBaseStatus());
            moveIssueSnInfo.setWarehouse(moveEntryInfo.getWarehouse());
            moveIssueSnInfo.setLocation(moveEntryInfo.getLocation());
            moveIssueSnInfo.setAuditTime(moveInWarehsBillInfo.getAuditTime());
            moveIssueSnInfo.setSnStatus(SerialNumberStatusEnum.INWAREHOUSE);
            BillTypeInfo aBillTypeInfo = new BillTypeInfo();
            aBillTypeInfo.setId(BOSUuid.read((String)"50957179-0105-1000-e000-0172c0a812fd463ED552"));
            moveIssueSnInfo.setBillType(aBillTypeInfo);
            StorageOrgUnitInfo aStorageOrgUnitInfo = moveEntryInfo.getStorageOrgUnit();
            moveIssueSnInfo.setStorageOrgUnit(aStorageOrgUnitInfo);
            moveIssueSnInfo.setId(BOSUuid.create((BOSObjectType)moveIssueSnInfo.getBOSType()));
            iMaterialSerialNumber.addnew((CoreBaseInfo)moveIssueSnInfo);
        }
        String storageOrgId = moveInWarehsBillInfo.getStorageOrgUnit().getId().toString();
        Context mainOrgCtx = null;
        try {
            mainOrgCtx = BOTOrgUtils.switchOrg((Context)ctx, (String)storageOrgId);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        IMoveInWarehsBill imi = MoveInWarehsBillFactory.getLocalInstance(mainOrgCtx);
        IObjectPK pk = null;
        boolean bl = isNotAutoAudit2 = !this.isAuditWhenSubmit(ctx, moveInWarehsBillInfo.getStorageOrgUnit().getId().toString(), 4, "107");
        if (isNotAutoAudit2) {
            moveInWarehsBillInfo.put("autoTransfer", Boolean.TRUE);
        }
        boolean isSaveBotpRelation = moveInWarehsBillInfo.getBaseStatus() == BillBaseStatusEnum.ADD;
        ctx.put((Object)"autoTransfer", (Object)Boolean.TRUE);
        mainOrgCtx.put((Object)"autoTransfer", (Object)Boolean.TRUE);
        try {
            pk = imi.transferAutoSubmit(moveInWarehsBillInfo);
        }
        finally {
            ctx.remove((Object)"autoTransfer");
            mainOrgCtx.remove((Object)"autoTransfer");
        }
        if (isSaveBotpRelation) {
            BOTRelationInfo info = new BOTRelationInfo();
            info.setSrcObjectID(bill.getId().toString());
            info.setSrcEntityID(bill.getBOSType().toString());
            info.setDestEntityID(MOVEINWAREHS_BOSTYPE);
            info.setDestObjectID(pk.toString());
            info.setOperatorID("unknown");
            info.setType(0);
            BOTRelationFactory.getLocalInstance((Context)ctx).addnew(info);
        }
        if (isNotAutoAudit2) {
            ctx.put((Object)"autoTransfer", (Object)Boolean.TRUE);
            mainOrgCtx.put((Object)"autoTransfer", (Object)Boolean.TRUE);
            try {
                imi.passAudit(pk, (CoreBillBaseInfo)moveInWarehsBillInfo);
            }
            finally {
                ctx.remove((Object)"autoTransfer");
                mainOrgCtx.remove((Object)"autoTransfer");
            }
        }
        return moveInWarehsBillInfo;
    }

    private void initMoveIssueBill(Context ctx, MoveIssueBillInfo bill) throws BOSException, EASBizException {
        CompanyOrgUnitInfo cou = this.getComanyInfo(ctx, bill.getStorageOrgUnit().getId().toString());
        bill.setIsInitBill(false);
        bill.setIsReversed(false);
        bill.setIssueCompanyOrgUnit(cou);
        bill.setReceiptCompanyOrgUnit(cou);
        BillTypeInfo billType = new BillTypeInfo();
        billType.setId(BOSUuid.read((String)"50957179-0105-1000-e000-016ec0a812fd463ED552"));
        billType.setNumber("106");
        bill.setBillType(billType);
        MoveIssueBillEntryInfo entry = null;
        String materialId = null;
        int amtPrecision = cou.getBaseCurrency().getPrecision();
        int n = bill.getEntry().size();
        for (int i = 0; i < n; ++i) {
            entry = bill.getEntry().get(i);
            BigDecimal qty = entry.getQty();
            entry.setTotalInWarehsQty(entry.getTotalInWarehsQty() == null ? ZERO : entry.getTotalInWarehsQty());
            entry.setStorageOrgUnit(bill.getStorageOrgUnit());
            entry.setCompanyOrgUnit(cou);
            MaterialInfo material = entry.getMaterial();
            if (material != null) {
                materialId = material.getId().toString();
                if (qty != null) {
                    MultiMeasureUnitInfo mmu = this.getMultiUnitInfo(ctx, materialId, entry.getUnit().getId().toString());
                    MultiMeasureUnitInfo basemmu = this.getMultiUnitInfo(ctx, materialId, entry.getBaseUnit().getId().toString());
                    if (mmu != null) {
                        entry.setBaseQty(qty.multiply(mmu.getBaseConvsRate()).setScale(basemmu.getQtyPrecision(), 4));
                    } else {
                        entry.setBaseQty(qty.setScale(basemmu.getQtyPrecision(), 4));
                    }
                    if (entry.getAssistQty() == null && entry.getAssistUnit() != null) {
                        MultiMeasureUnitInfo assistmmu = this.getMultiUnitInfo(ctx, materialId, entry.getAssistUnit().getId().toString());
                        entry.setAssistQty(entry.getBaseQty().divide(assistmmu.getBaseConvsRate(), assistmmu.getQtyPrecision(), 4));
                    }
                    this.initEntryCost4Botp(ctx, entry, bill.getBizType(), bill.getTransactionType(), amtPrecision, 1);
                    entry.setCanInwarehsBaseQty(entry.getBaseQty());
                }
            }
            if (entry.getWarehouse() == null) {
                MaterialInventoryInfo materialInventory = this.getMaterialInventoryInfo(ctx, materialId, bill.getStorageOrgUnit().getId().toString());
                entry.setWarehouse(materialInventory.getDefaultWarehouse());
            }
            if (entry.getWarehouse() == null) continue;
            if (entry.getLocation() == null) {
                entry.setLocation(this.getDefaultLocation(ctx, materialId, entry.getWarehouse().getId().toString(), cou.getId().toString()));
            }
            if (entry.getStocker() != null) continue;
            entry.setStocker(this.getDefaultStocker(ctx, entry.getWarehouse().getId().toString()));
        }
    }

    private void initMoveInWarehsBill(Context ctx, MoveInWarehsBillInfo bill) throws BOSException, EASBizException {
        CompanyOrgUnitInfo cou = this.getComanyInfo(ctx, bill.getStorageOrgUnit().getId().toString());
        bill.setIsInitBill(false);
        bill.setIsReversed(false);
        bill.setIssueCompanyOrgUnit(cou);
        bill.setReceiptCompanyOrgUnit(cou);
        BillTypeInfo billType = new BillTypeInfo();
        billType.setId(BOSUuid.read((String)"50957179-0105-1000-e000-0172c0a812fd463ED552"));
        billType.setNumber("107");
        bill.setBillType(billType);
        MoveInWarehsBillEntryInfo entry = null;
        String materialId = null;
        int amtPrecision = cou.getBaseCurrency().getPrecision();
        for (int i = 0; i < bill.getEntry().size(); ++i) {
            entry = bill.getEntry().get(i);
            BigDecimal qty = entry.getQty();
            entry.setStorageOrgUnit(bill.getStorageOrgUnit());
            entry.setCompanyOrgUnit(cou);
            MaterialInfo material = entry.getMaterial();
            if (material != null) {
                materialId = material.getId().toString();
                if (qty != null) {
                    MaterialInventoryInfo materialInvInfo;
                    MultiMeasureUnitInfo mmu = this.getMultiUnitInfo(ctx, materialId, entry.getUnit().getId().toString());
                    MultiMeasureUnitInfo basemmu = this.getMultiUnitInfo(ctx, materialId, entry.getBaseUnit().getId().toString());
                    if (mmu != null) {
                        entry.setBaseQty(qty.multiply(mmu.getBaseConvsRate()).setScale(basemmu.getQtyPrecision(), 4));
                    } else {
                        entry.setBaseQty(qty.setScale(basemmu.getQtyPrecision(), 4));
                    }
                    if (entry.getAssistQty() == null && entry.getAssistUnit() != null) {
                        MultiMeasureUnitInfo assistmmu = this.getMultiUnitInfo(ctx, materialId, entry.getAssistUnit().getId().toString());
                        entry.setAssistQty(entry.getBaseQty().divide(assistmmu.getBaseConvsRate(), assistmmu.getQtyPrecision(), 4));
                    }
                    if ((materialInvInfo = this.getMaterialInventoryInfo(ctx, materialId, bill.getStorageOrgUnit().getId().toString())) == null || !materialInvInfo.isIsLotNumber()) {
                        entry.setLot(null);
                    }
                    if (materialInvInfo == null || !materialInvInfo.isIsPeriodValid()) {
                        entry.setExp(null);
                        entry.setMfg(null);
                    }
                    this.initEntryCost4Botp(ctx, entry, bill.getBizType(), bill.getTransactionType(), amtPrecision, 2);
                }
            }
            if (entry.getWarehouse() == null) {
                MaterialInventoryInfo materialInventory = this.getMaterialInventoryInfo(ctx, materialId, bill.getStorageOrgUnit().getId().toString());
                entry.setWarehouse(materialInventory.getDefaultWarehouse());
            }
            if (entry.getWarehouse() == null) continue;
            if (entry.getLocation() == null) {
                entry.setLocation(this.getDefaultLocation(ctx, materialId, entry.getWarehouse().getId().toString(), cou.getId().toString()));
            }
            if (entry.getStocker() != null) continue;
            entry.setStocker(this.getDefaultStocker(ctx, entry.getWarehouse().getId().toString()));
        }
    }

    private TransactionTypeInfo getTransactionTypeInfo(Context ctx, InvBillBaseInfo bill, boolean isMoveIssue) throws BOSException {
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        if (bill.getBillType() != null) {
            filter.appendFilterItem("transactionType.BILLTYPE.ID", (Object)bill.getBillType().getId().toString());
        }
        if (bill.getBizType() != null && bill.getSourceBillType() != null) {
            filter.appendFilterItem("BIZTYPE.ID", (Object)bill.getBizType().getId().toString());
        } else if (bill.getBizType() == null && bill.getSourceBillType() != null) {
            filter.appendFilterItem("BIZTYPE.ID", (Object)"111111111111111111111111111=");
        }
        filter.appendFilterItem("transactionType.Status", (Object)new Integer(1));
        filter.appendFilterItem("transactionType.isCalculate", (Object)new Integer(1));
        SorterItemInfo sif = new SorterItemInfo("transactionType.scheduled");
        sif.setSortType(SortType.DESCEND);
        evi.getSorter().add(sif);
        SorterItemInfo sort = new SorterItemInfo("transactiontype.number");
        sort.setSortType(SortType.DESCEND);
        evi.getSorter().add(sort);
        evi.setFilter(filter);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("transactionType.*");
        selector.add("transactionType.riType.*");
        selector.add("bizType.*");
        evi.setSelector(selector);
        TransBizTypeCollection tic = TransBizTypeFactory.getLocalInstance((Context)ctx).getTransBizTypeCollection(evi);
        if (tic != null && tic.size() > 0) {
            return tic.get(0).getTransactionType();
        }
        return null;
    }

    private void initEntryCost4Botp(Context ctx, InvBillBaseEntryInfo entryInfo, BizTypeInfo bizTypeInfo, TransactionTypeInfo ttInfo, int amtPrecision, int billType) throws EASBizException, BOSException {
        boolean isPresent;
        MaterialInfo materialInfo = entryInfo.getMaterial();
        if (materialInfo == null) {
            return;
        }
        int pricePrecision = materialInfo.getPricePrecision();
        boolean bl = isPresent = SCMUtils.isPresentStoreType((InvUpdateTypeInfo)entryInfo.getInvUpdateType(), (int)billType) || entryInfo.isIsPresent();
        if (isPresent) {
            this.initPresentEntryCost(ctx, entryInfo, ttInfo, amtPrecision, billType, pricePrecision);
        } else {
            this.initNonPresnetEntryCost(ctx, entryInfo, bizTypeInfo, amtPrecision, pricePrecision);
        }
    }

    private void initPresentEntryCost(Context ctx, InvBillBaseEntryInfo entryInfo, TransactionTypeInfo ttInfo, int amtPrecision, int billType, int pricePrecision) throws EASBizException, BOSException {
        if (this.isUpdatePresent(entryInfo, ttInfo, billType)) {
            entryInfo.setUnitStandardCost(ZERO.setScale(pricePrecision, 4));
            entryInfo.setStandardCost(ZERO.setScale(amtPrecision, 4));
            entryInfo.setUnitActualCost(ZERO.setScale(pricePrecision, 4));
            entryInfo.setActualCost(ZERO.setScale(amtPrecision, 4));
        } else {
            if (this.isStandardCostType(ctx, entryInfo)) {
                this.calEntryUnitStandardCost(ctx, entryInfo, pricePrecision);
                this.calEntryStandardCostByUnitCost(entryInfo, amtPrecision);
            }
            if (billType == 2) {
                entryInfo.setUnitActualCost(ZERO);
                entryInfo.setActualCost(ZERO);
            } else if (billType == 1 && this.isStandardCostType(ctx, entryInfo)) {
                if (entryInfo.getUnitActualCost() == null || entryInfo.getUnitActualCost().compareTo(ZERO) == 0) {
                    entryInfo.setUnitActualCost(entryInfo.getUnitStandardCost());
                }
                if (entryInfo.getActualCost() == null || entryInfo.getActualCost().compareTo(ZERO) == 0) {
                    entryInfo.setActualCost(entryInfo.getStandardCost());
                }
            }
        }
    }

    private void initNonPresnetEntryCost(Context ctx, InvBillBaseEntryInfo entryInfo, BizTypeInfo bizTypeInfo, int amtPrecision, int pricePrecision) throws EASBizException, BOSException {
        if (this.isStandardCostType(ctx, entryInfo)) {
            this.calEntryUnitStandardCost(ctx, entryInfo, pricePrecision);
            this.calEntryStandardCostByUnitCost(entryInfo, amtPrecision);
            if (entryInfo instanceof MoveIssueBillEntryInfo) {
                entryInfo.setUnitActualCost(entryInfo.getUnitStandardCost());
            }
            if (entryInfo instanceof MoveInWarehsBillEntryInfo && this.isCostPriceMove(bizTypeInfo)) {
                entryInfo.setUnitActualCost(entryInfo.getUnitStandardCost());
            }
        } else {
            entryInfo.setStandardCost(ZERO);
            entryInfo.setUnitStandardCost(ZERO);
        }
        this.calEntryActualCostByUnitCost(entryInfo, amtPrecision);
    }

    public boolean isCostPriceMove(BizTypeInfo bizTypeInfo) {
        return "d8e80652-011b-1000-e000-04c5c0a812202407435C".equals(bizTypeInfo.getId().toString()) || "d8e80652-011a-1000-e000-04c5c0a812202407435C".equals(bizTypeInfo.getId().toString());
    }

    private boolean isStandardCostType(Context ctx, InvBillBaseEntryInfo entryInfo) throws BOSException {
        MaterialCompanyInfoInfo mcInfo = this.getMaterialCompanyInfo(ctx, entryInfo);
        return mcInfo != null && AccountType.STANDARDCOST.equals((Object)mcInfo.getAccountType());
    }

    private void calEntryUnitStandardCost(Context ctx, InvBillBaseEntryInfo entryInfo, int pricePrecision) throws EASBizException, BOSException {
        String materialId;
        MaterialCompanyInfoInfo mcInfo = this.getMaterialCompanyInfo(ctx, entryInfo);
        String string = materialId = entryInfo.getMaterial() == null ? null : entryInfo.getMaterial().getId().toString();
        if (mcInfo == null || materialId == null) {
            return;
        }
        String unitId = entryInfo.getUnit() == null ? null : entryInfo.getUnit().getId().toString();
        MultiMeasureUnitInfo multiUnitInfo = this.getMultiUnitInfo(ctx, materialId, unitId);
        BigDecimal unitStandardCost = mcInfo.getStandardCost().multiply(multiUnitInfo.getBaseConvsRate()).setScale(pricePrecision, 4);
        entryInfo.setUnitStandardCost(unitStandardCost);
    }

    private void calEntryActualCostByUnitCost(InvBillBaseEntryInfo entryInfo, int amtPrecision) throws EASBizException, BOSException {
        BigDecimal unitActualCost = entryInfo.getUnitActualCost() == null ? ZERO : entryInfo.getUnitActualCost();
        BigDecimal qty = entryInfo.getQty() == null ? ZERO : entryInfo.getQty();
        BigDecimal actualCost = unitActualCost.multiply(qty);
        actualCost = actualCost.setScale(amtPrecision, 4);
        entryInfo.setActualCost(actualCost);
    }

    private LocationInfo getDefaultLocation(Context ctx, String materialId, String warehsId, String souID) throws EASBizException, BOSException {
        if (materialId == null || warehsId == null || souID == null) {
            return null;
        }
        String key = "Location_" + materialId + warehsId + souID;
        LocationInfo location = (LocationInfo)this.dataBuffer.get(key);
        if (!this.dataBuffer.containsKey(key)) {
            IMaterialStorageAssign imsa = MaterialStorageAssignFactory.getLocalInstance((Context)ctx);
            StringBuffer oql = new StringBuffer();
            oql.append("select id,material.id,storageOrg.id,warehouse.id,location.id,location.name,location.number ").append("where storageOrg = '").append(souID).append("' and ").append("material  = '").append(materialId).append("' and ").append("warehouse = '").append(warehsId).append("' and ").append("ISDEFAULTLOCATION = 1 ");
            MaterialStorageAssignCollection msaCol = imsa.getMaterialStorageAssignCollection(oql.toString());
            if (msaCol.size() > 0) {
                MaterialStorageAssignInfo info = msaCol.get(0);
                location = info.getLocation();
                this.dataBuffer.put(key, location);
            } else {
                this.dataBuffer.put(key, null);
            }
        }
        return (LocationInfo)this.dataBuffer.get(key);
    }

    private PersonInfo getDefaultStocker(Context ctx, String warehouseID) throws EASBizException, BOSException {
        String key = "Stocker_" + warehouseID;
        PersonInfo stocker = null;
        if (!this.dataBuffer.containsKey(key)) {
            String oql = "select id,hasLocation,whman.id, whman.number, whman.name where id = '" + warehouseID + "'";
            WarehouseInfo wh = WarehouseFactory.getLocalInstance((Context)ctx).getWarehouseInfo(oql);
            if (wh != null) {
                stocker = wh.getWhman();
                this.dataBuffer.put(key, stocker);
            } else {
                this.dataBuffer.put(key, null);
            }
        }
        return (PersonInfo)this.dataBuffer.get(key);
    }

    private MaterialCompanyInfoInfo getMaterialCompanyInfo(Context ctx, InvBillBaseEntryInfo entryInfo) throws BOSException {
        MaterialInfo materialInfo = entryInfo.getMaterial();
        String materialId = materialInfo.getId().toString();
        String couId = entryInfo.getCompanyOrgUnit().getId().toString();
        String key = "MaterialCompany_" + materialId + couId;
        if (this.dataBuffer.get(key) == null) {
            MaterialCompanyInfoInfo materialCompany = MaterialFactory.getLocalInstance((Context)ctx).getCompanyInfo(materialId, couId);
            this.dataBuffer.put(key, materialCompany);
        }
        return (MaterialCompanyInfoInfo)this.dataBuffer.get(key);
    }

    protected void calEntryStandardCostByUnitCost(InvBillBaseEntryInfo entryInfo, int amtPrecision) {
        BigDecimal unitStandardCost = entryInfo.getUnitStandardCost();
        BigDecimal qty = entryInfo.getQty() == null ? ZERO : entryInfo.getQty();
        BigDecimal standardCost = unitStandardCost.multiply(qty);
        standardCost = standardCost.setScale(amtPrecision, 4);
        entryInfo.setStandardCost(standardCost);
    }

    private boolean isUpdatePresent(InvBillBaseEntryInfo entryInfo, TransactionTypeInfo ttInfo, int billType) {
        return SCMUtils.isPresentStoreType((InvUpdateTypeInfo)entryInfo.getInvUpdateType(), (int)billType);
    }

    private MaterialInventoryInfo getMaterialInventoryInfo(Context ctx, String materialId, String storageId) throws EASBizException, BOSException {
        if (materialId == null || materialId.length() == 0 || storageId == null || storageId.length() == 0) {
            return null;
        }
        String key = "MaterialInventory_" + materialId + storageId;
        if (this.dataBuffer.get(key) == null) {
            MaterialInventoryInfo materialInventory = MaterialInventoryFactory.getLocalInstance((Context)ctx).getInventoryInfo(materialId, storageId);
            this.dataBuffer.put(key, materialInventory);
        }
        return (MaterialInventoryInfo)this.dataBuffer.get(key);
    }

    private CompanyOrgUnitInfo getComanyInfo(Context ctx, String storageId) throws BOSException, EASBizException {
        String key = "Company_" + storageId;
        if (this.dataBuffer.get(key) == null) {
            IOrgUnitRelation iUnitRel = OrgUnitRelationFactory.getLocalInstance((Context)ctx);
            OrgUnitCollection orgCol = iUnitRel.getToUnit(storageId, 4, 1);
            CompanyOrgUnitInfo cou = (CompanyOrgUnitInfo)orgCol.get(0);
            if (cou == null) {
                throw new StockTransferBillException(StockTransferBillException.COMPANY_IS_NULL);
            }
            cou.setBaseCurrency(CurrencyFactory.getLocalInstance((Context)ctx).getCurrencyInfo((IObjectPK)new ObjectUuidPK(cou.getBaseCurrency().getId())));
            this.dataBuffer.put(key, cou);
        }
        return (CompanyOrgUnitInfo)this.dataBuffer.get(key);
    }

    private InvUpdateTypeInfo getInvUpdateType(Context ctx, String transactionTypeID, String aStoreTypeID, String aStoreStateID) throws EASBizException, BOSException {
        String key = "InvUpdateType_" + transactionTypeID + aStoreTypeID + aStoreStateID;
        if (!this.dataBuffer.containsKey(key)) {
            InvUpdateTypeInfo invUpdateType = SCMBaseCommonUtil.getInvUpdateType((Context)ctx, (String)transactionTypeID, (String)aStoreTypeID, (String)aStoreStateID);
            this.dataBuffer.put(key, invUpdateType);
        }
        return (InvUpdateTypeInfo)this.dataBuffer.get(key);
    }

    private StockTransferBillEntryInfo getTransferBillEntry(Context ctx, StockTransferBillEntryCollection stockEntryColl, String entryId) throws BOSException, EASBizException {
        int size = stockEntryColl.size();
        for (int i = 0; i < size; ++i) {
            if (!stockEntryColl.get(i).getId().toString().equals(entryId)) continue;
            return stockEntryColl.get(i);
        }
        return null;
    }

    private MultiMeasureUnitInfo getMultiUnitInfo(Context ctx, String materialId, String unitId) throws BOSException, EASBizException {
        String key = "BaseConvstRate_" + materialId + unitId;
        if (this.dataBuffer.get(key) == null) {
            MultiMeasureUnitInfo mmu = MultiMeasureUnitFactory.getLocalInstance((Context)ctx).getMultiUnit(materialId, unitId);
            this.dataBuffer.put(key, mmu);
        }
        return (MultiMeasureUnitInfo)this.dataBuffer.get(key);
    }

    private IObjectCollection getObjectCollection(Context ctx, StockTransferBillInfo bill, String bosType, String botpID) throws EASBizException, BOSException {
        IObjectCollection destBillCols = null;
        BTPTransformResult btpResult = null;
        IBOTMapping ibt = BOTMappingFactory.getLocalInstance((Context)ctx);
        BOTMappingInfo botMappingInfo = ibt.getBOTMappingInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)botpID)));
        if (!botMappingInfo.getExtRule().isIsEffected()) {
            throw new StockTransferBillException(StockTransferBillException.BOTP_NOT_START);
        }
        IBTPManager iBTPManager = BTPManagerFactory.getLocalInstance((Context)ctx);
        CoreBillBaseCollection cbc = new CoreBillBaseCollection();
        cbc.addObject((IObjectValue)bill);
        btpResult = iBTPManager.transformForBotp(cbc, bosType, (IObjectPK)new ObjectUuidPK(botpID));
        destBillCols = btpResult.getBills();
        return destBillCols;
    }

    private boolean isAuditWhenSubmit(Context ctx, String orgUnitID, int orgType, String billTypeNumber) throws EASBizException, BOSException {
        String paramNumber = "SCM_Submit_01";
        boolean isAutoAudit = false;
        ISCMBillParam scmParam = null;
        scmParam = SCMBillParamFactory.getLocalInstance((Context)ctx);
        String strAutoAudit = scmParam.getParamByBillTypeNumber(paramNumber, orgType, orgUnitID, billTypeNumber);
        if (strAutoAudit != null && strAutoAudit.trim().length() != 0 && strAutoAudit.trim().equalsIgnoreCase("1")) {
            isAutoAudit = true;
        }
        return isAutoAudit;
    }

    protected SelectorItemCollection getSelector(boolean needEntrySelector) {
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("*"));
        selector.add(new SelectorItemInfo("number"));
        selector.add(new SelectorItemInfo("exchangeRate"));
        selector.add(new SelectorItemInfo("receiptStorageOrgUnit.id"));
        selector.add(new SelectorItemInfo("receiptStorageOrgUnit.number"));
        selector.add(new SelectorItemInfo("receiptStorageOrgUnit.name"));
        selector.add(new SelectorItemInfo("issueStorageOrgUnit.id"));
        selector.add(new SelectorItemInfo("issueStorageOrgUnit.number"));
        selector.add(new SelectorItemInfo("issueStorageOrgUnit.name"));
        selector.add(new SelectorItemInfo("issueAdminOrgUnit.id"));
        selector.add(new SelectorItemInfo("issueAdminOrgUnit.number"));
        selector.add(new SelectorItemInfo("issueAdminOrgUnit.name"));
        selector.add(new SelectorItemInfo("receiptAdminOrgUnit.id"));
        selector.add(new SelectorItemInfo("receiptAdminOrgUnit.number"));
        selector.add(new SelectorItemInfo("receiptAdminOrgUnit.name"));
        selector.add(new SelectorItemInfo("billType.id"));
        selector.add(new SelectorItemInfo("billType.number"));
        selector.add(new SelectorItemInfo("billType.name"));
        selector.add(new SelectorItemInfo("currency.id"));
        selector.add(new SelectorItemInfo("currency.number"));
        selector.add(new SelectorItemInfo("currency.name"));
        selector.add(new SelectorItemInfo("currency.precision"));
        selector.add(new SelectorItemInfo("bizType.id"));
        selector.add(new SelectorItemInfo("bizType.number"));
        selector.add(new SelectorItemInfo("bizType.name"));
        if (needEntrySelector) {
            selector.add(new SelectorItemInfo("entry.*"));
            selector.add(new SelectorItemInfo("entry.id"));
            selector.add(new SelectorItemInfo("entry.number"));
            selector.add(new SelectorItemInfo("entry.seq"));
            selector.add(new SelectorItemInfo("entry.issueWarehouse.id"));
            selector.add(new SelectorItemInfo("entry.issueWarehouse.number"));
            selector.add(new SelectorItemInfo("entry.issueWarehouse.name"));
            selector.add(new SelectorItemInfo("entry.issueWarehouse.hasLocation"));
            selector.add(new SelectorItemInfo("entry.issueWarehouse.whman.id"));
            selector.add(new SelectorItemInfo("entry.issueWarehouse.whman.name"));
            selector.add(new SelectorItemInfo("entry.issueWarehouse.whman.number"));
            selector.add(new SelectorItemInfo("entry.receiptWarehouse.id"));
            selector.add(new SelectorItemInfo("entry.receiptWarehouse.number"));
            selector.add(new SelectorItemInfo("entry.receiptWarehouse.name"));
            selector.add(new SelectorItemInfo("entry.receiptWarehouse.hasLocation"));
            selector.add(new SelectorItemInfo("entry.receiptWarehouse.whman.id"));
            selector.add(new SelectorItemInfo("entry.receiptWarehouse.whman.name"));
            selector.add(new SelectorItemInfo("entry.receiptWarehouse.whman.number"));
            selector.add(new SelectorItemInfo("entry.receiptLocation.id"));
            selector.add(new SelectorItemInfo("entry.receiptLocation.name"));
            selector.add(new SelectorItemInfo("entry.receiptLocation.number"));
            selector.add(new SelectorItemInfo("entry.issueLocation.id"));
            selector.add(new SelectorItemInfo("entry.issueLocation.name"));
            selector.add(new SelectorItemInfo("entry.issueLocation.number"));
            selector.add(new SelectorItemInfo("entry.qty"));
            selector.add(new SelectorItemInfo("entry.lot"));
            selector.add(new SelectorItemInfo("entry.assistProperty.id"));
            selector.add(new SelectorItemInfo("entry.assistProperty.name"));
            selector.add(new SelectorItemInfo("entry.assistProperty.number"));
            selector.add(new SelectorItemInfo("entry.assistQty"));
            selector.add(new SelectorItemInfo("entry.price"));
            selector.add(new SelectorItemInfo("entry.issueQty"));
            selector.add(new SelectorItemInfo("entry.receiptQty"));
            selector.add(new SelectorItemInfo("entry.associateQty"));
            selector.add(new SelectorItemInfo("entry.unit.id"));
            selector.add(new SelectorItemInfo("entry.unit.number"));
            selector.add(new SelectorItemInfo("entry.unit.name"));
            selector.add(new SelectorItemInfo("entry.assistUnit.id"));
            selector.add(new SelectorItemInfo("entry.assistUnit.number"));
            selector.add(new SelectorItemInfo("entry.assistUnit.name"));
            selector.add(new SelectorItemInfo("entry.baseUnit.id"));
            selector.add(new SelectorItemInfo("entry.baseUnit.number"));
            selector.add(new SelectorItemInfo("entry.baseUnit.name"));
            selector.add(new SelectorItemInfo("entry.material.id"));
            selector.add(new SelectorItemInfo("entry.material.number"));
            selector.add(new SelectorItemInfo("entry.material.name"));
            selector.add(new SelectorItemInfo("entry.material.model"));
            selector.add(new SelectorItemInfo("entry.material.pricePrecision"));
            selector.add(new SelectorItemInfo("entry.material.assistAttr.id"));
            selector.add(new SelectorItemInfo("entry.material.assistUnit.id"));
            selector.add(new SelectorItemInfo("entry.material.baseUnit"));
            selector.add(new SelectorItemInfo("entry.storeType.id"));
            selector.add(new SelectorItemInfo("entry.storeType.number"));
            selector.add(new SelectorItemInfo("entry.storeType.name"));
            selector.add(new SelectorItemInfo("entry.storeState.id"));
            selector.add(new SelectorItemInfo("entry.storeState.number"));
            selector.add(new SelectorItemInfo("entry.storeState.name"));
        }
        return selector;
    }

    protected SelectorItemCollection getSelector() {
        return this.getSelector(true);
    }

    protected CompanyOrgUnitInfo _getCompanyOrgUnit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        return null;
    }

    protected void _audit(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        StockTransferBillInfo info = this.getStockTransferBillInfo(ctx, pk, this.getSelector());
        this.passAudit(ctx, pk, (CoreBillBaseInfo)info);
    }

    protected void _passAudit(Context ctx, IObjectPK pk, IObjectValue model) throws EASBizException, BOSException {
        StockTransferBillInfo info = this.getStockTransferBillInfo(ctx, pk, this.getSelector());
        if (info.getBaseStatus().getValue() == -2) {
            this._agreeAlter(ctx, pk);
            this.setTransOrderStatus(ctx, pk.toString());
            return;
        }
        BatchExecuteParamsEntry[] entries = new BatchExecuteParamsEntry[]{new BatchExecuteParamsEntry(new Class[]{IObjectValue.class}, new Object[]{info})};
        this.batchExecute(ctx, entries, BatchActionEnum.AUDIT);
    }

    protected void _unAudit(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        StockTransferBillInfo info = this.getStockTransferBillInfo(ctx, pk, this.getSelector());
        this.unpassAudit(ctx, pk, (CoreBillBaseInfo)info);
    }

    protected void _unpassAudit(Context ctx, IObjectPK pk, IObjectValue model) throws EASBizException, BOSException {
        BatchExecuteParamsEntry[] entries = new BatchExecuteParamsEntry[]{new BatchExecuteParamsEntry(new Class[]{IObjectValue.class}, new Object[]{model})};
        this.batchExecute(ctx, entries, BatchActionEnum.UNAUDIT);
    }

    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        if (model.get("CONTEXT_KEY_CALLBACK_4_DAO") != null) {
            return super.saveWithoutBusiness(ctx, model);
        }
        BatchExecuteParamsEntry[] entries = new BatchExecuteParamsEntry[]{new BatchExecuteParamsEntry(new Class[]{IObjectValue.class})};
        entries[0].add((Object)model);
        this.batchSaveRelations(ctx, entries);
        return new ObjectUuidPK(((SCMBillBaseInfo)model).getId());
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        if (model.get("CONTEXT_KEY_CALLBACK_4_DAO") != null) {
            return super.submitWithoutBusiness(ctx, model);
        }
        BatchExecuteParamsEntry[] entries = new BatchExecuteParamsEntry[]{new BatchExecuteParamsEntry(new Class[]{IObjectValue.class})};
        entries[0].add((Object)model);
        this.batchSubmitRelations(ctx, entries);
        return new ObjectUuidPK(((SCMBillBaseInfo)model).getId());
    }

    protected BatchActionResults batchExecute(Context ctx, BatchExecuteParamsEntry[] entries, BatchActionEnum batchActionEnum) throws EASBizException, BOSException {
        IBusinessChainExecutor executor = BusinessChainExecutorFactory.getBusinessChainExecutor();
        ParamEntryExecuteContext executeContext = new ParamEntryExecuteContext(ctx, this.getBOSType(), batchActionEnum, (BizController)this, entries);
        executeContext.setBillTypeID(this.getBillTypeId());
        BatchActionResults batchResults = executor.batchExecute((ExecuteContext)executeContext);
        return batchResults;
    }

    public BatchActionResults batchSubmitOrSave(Context ctx, BatchExecuteParamsEntry[] entries, BatchActionEnum batchActionEnum) throws EASBizException, BOSException {
        return this.batchExecute(ctx, entries, batchActionEnum);
    }

    protected CompanyOrgUnitInfo _getCompanyOrgUnit(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        return null;
    }

    protected String _getComOrgID(Context ctx, String pk) throws BOSException {
        return null;
    }

    @Override
    protected IObjectValue _getInnerCusSup(Context ctx, String pk, boolean isSupplier) throws BOSException, EASBizException {
        String outCompanyId = null;
        String inCompanyId = null;
        ObjectUuidPK billPK = new ObjectUuidPK(pk);
        StockTransferBillInfo billInfo = this.getStockTransferBillInfo(ctx, (IObjectPK)billPK);
        outCompanyId = billInfo.getIssueCompanyOrgUnit().getId().toString();
        inCompanyId = billInfo.getReceiptCompanyOrgUnit().getId().toString();
        SupplierInfo csuSup = null;
        if (isSupplier) {
            SupplierCollection csuSups = SupplierFactory.getLocalInstance((Context)ctx).getSupplierCollectionByInter(outCompanyId);
            if (csuSups != null && csuSups.size() > 0) {
                csuSup = csuSups.get(0);
            }
        } else {
            CustomerCollection csuSups = CustomerFactory.getLocalInstance((Context)ctx).getCustomerCollectionByInter(inCompanyId);
            if (csuSups != null && csuSups.size() > 0) {
                csuSup = csuSups.get(0);
            }
        }
        return csuSup;
    }

    protected String _getBizUnitOrgID(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        StorageOrgUnitInfo storage = ((StockTransferBillInfo)model).getIssueStorageOrgUnit();
        String storageID = null;
        if (storage != null) {
            storageID = storage.getId().toString();
        }
        return storageID;
    }

    @Override
    protected void _checkAutoTransfer(Context ctx, String billID) throws BOSException, EASBizException {
        ISCMFetchDataFacade iSCMFetchDataFacade = SCMFetchDataFacadeFactory.getLocalInstance((Context)ctx);
        if (billID == null) {
            throw new StockTransferBillException(StockTransferBillException.IDISNULL);
        }
        StockTransferBillInfo bill = (StockTransferBillInfo)this._getValue(ctx, (IObjectPK)new ObjectUuidPK(billID));
        StorageOrgUnitInfo sou = bill.getIssueStorageOrgUnit();
        SCMFetchData fetchData = iSCMFetchDataFacade.fetchData(StockTransferBillControllerBean.buildCondition(ctx, bill).toEntiryView());
        for (int i = 0; i < bill.getEntry().size(); ++i) {
            StockTransferBillEntryInfo entry = bill.getEntry().get(i);
            String materialID = entry.getMaterial().getId().toString();
            if (!fetchData.getIsLotNumber(materialID, sou.getId().toString()) || !StringUtils.isEmpty((String)entry.getLot())) continue;
            throw new StockTransferBillException(StockTransferBillException.LOTISNULL, new Object[]{new Integer(entry.getSeq())});
        }
    }

    protected SelectorItemCollection getSelectors(Context ctx) {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("*");
        sic.add("entry.*");
        sic.add("entry.issueWarehouse.hasLocation");
        sic.add("entry.receiptWarehouse.hasLocation");
        return sic;
    }

    protected static SCMFetchDataCondition buildCondition(Context ctx, StockTransferBillInfo bill) {
        SCMFetchDataCondition condition = new SCMFetchDataCondition();
        ArrayList<String> materialPKList = new ArrayList<String>();
        for (int i = 0; i < bill.getEntry().size(); ++i) {
            materialPKList.add(bill.getEntry().get(i).getMaterial().getId().toString());
        }
        String[] materialPKs = new String[materialPKList.size()];
        materialPKList.toArray(materialPKs);
        condition.setMaterialPKs(materialPKs);
        condition.setSou(bill.getIssueStorageOrgUnit());
        condition.setFetchSou(true);
        condition.setFetchIsLotNumber(true);
        condition.setFetchIsPeriodValid(true);
        return condition;
    }

    @Override
    protected boolean _checkTransferCanSumbit(Context ctx, IObjectValue model) throws EASBizException, BOSException {
        block11: {
            if (model == null) {
                return true;
            }
            StockTransferBillInfo billInfo = (StockTransferBillInfo)model;
            if (billInfo.getSourceBillType() == null || billInfo.getSourceBillType().getId() == null) break block11;
            int size = billInfo.getEntry().size();
            StockTransferBillEntryInfo entry = null;
            if (size > 0) {
                entry = billInfo.getEntry().get(0);
                BigDecimal validQty = new BigDecimal("0.00");
                BigDecimal totalMoveQty = null;
                if ("50957179-0105-1000-e000-015fc0a812fd463ED552".equals(billInfo.getSourceBillType().getId().toString())) {
                    IPurInWarehsEntry ipe = PurInWarehsEntryFactory.getLocalInstance(ctx);
                    PurInWarehsEntryInfo purInWarehsEntryInfo = null;
                    IPurOrderEntry ipo = PurOrderEntryFactory.getLocalInstance((Context)ctx);
                    PurOrderEntryInfo purOrderEntryInfo = null;
                    BigDecimal stockQty = new BigDecimal("0.00");
                    for (int i = 0; i < size; ++i) {
                        entry = billInfo.getEntry().get(i);
                        purInWarehsEntryInfo = ipe.getPurInWarehsEntryInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)entry.getSourceBillEntryId())));
                        if (purInWarehsEntryInfo.getCoreBillType() == null || !purInWarehsEntryInfo.getCoreBillType().equals((Object)"510b6503-0105-1000-e000-010bc0a812fd463ED552") || purInWarehsEntryInfo == null || purInWarehsEntryInfo.getPurOrderEntry() == null) continue;
                        stockQty = entry.getQty();
                        purOrderEntryInfo = ipo.getPurOrderEntryInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)purInWarehsEntryInfo.getPurOrderEntry())));
                        if (!purOrderEntryInfo.getUnit().getId().equals((Object)entry.getUnit().getId())) {
                            stockQty = InvAppUtils.getMultiUnitQty(ctx, entry.getUnit(), purOrderEntryInfo.getUnit(), entry.getMaterial(), entry.getQty());
                        }
                        if ((totalMoveQty = purOrderEntryInfo.getTotalMoveQty()) == null) {
                            totalMoveQty = new BigDecimal("0.00");
                        }
                        if ((validQty = purOrderEntryInfo.getQty().subtract(totalMoveQty.add(stockQty))).signum() >= 0) continue;
                        return false;
                    }
                } else if ("510b6503-0105-1000-e000-010bc0a812fd463ED552".equals(billInfo.getSourceBillType().getId().toString())) {
                    PurOrderEntryInfo purOrderEntryInfo = null;
                    IPurOrderEntry ipo = PurOrderEntryFactory.getLocalInstance((Context)ctx);
                    BigDecimal stockQty = new BigDecimal("0.00");
                    for (int i = 0; i < size; ++i) {
                        entry = billInfo.getEntry().get(i);
                        stockQty = entry.getQty();
                        purOrderEntryInfo = ipo.getPurOrderEntryInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)entry.getSourceBillEntryId())));
                        if (!purOrderEntryInfo.getUnit().getId().equals((Object)entry.getUnit().getId())) {
                            stockQty = InvAppUtils.getMultiUnitQty(ctx, entry.getUnit(), purOrderEntryInfo.getUnit(), entry.getMaterial(), entry.getQty());
                        }
                        if ((totalMoveQty = purOrderEntryInfo.getTotalMoveQty()) == null) {
                            totalMoveQty = new BigDecimal("0.00");
                        }
                        if ((validQty = purOrderEntryInfo.getQty().subtract(totalMoveQty.add(stockQty))).signum() >= 0) continue;
                        return false;
                    }
                }
            }
        }
        return true;
    }

    protected IObjectValue _createNewData(Context ctx, boolean isUseAgent) throws BOSException, EASBizException {
        StockTransferBillInfo stocktransferBillInfo = null;
        stocktransferBillInfo = isUseAgent ? StockTransferBillAgent.create() : new StockTransferBillInfo();
        Calendar cal = Calendar.getInstance();
        Date curDate = cal.getTime();
        stocktransferBillInfo.setBizDate(curDate);
        stocktransferBillInfo.setCreateTime(new Timestamp(cal.getTimeInMillis()));
        stocktransferBillInfo.setBizType(BizTypeFactory.getLocalInstance((Context)ctx).getBizTypeInfo((IObjectPK)new ObjectUuidPK("d8e80652-0119-1000-e000-04c5c0a812202407435C")));
        StockTransferBillEntryInfo entryInfo = (StockTransferBillEntryInfo)this.createNewDetailData(isUseAgent, ctx);
        stocktransferBillInfo.getEntry().add(entryInfo);
        return stocktransferBillInfo;
    }

    private IObjectValue createNewDetailData(boolean isUseAgent, Context ctx) throws BOSException, EASBizException {
        StockTransferBillEntryInfo entryInfo = null;
        BigDecimal ZERO = BigDecimal.ZERO;
        entryInfo = isUseAgent ? StockTransferBillEntryAgent.create() : new StockTransferBillEntryInfo();
        entryInfo.setReason("");
        entryInfo.setAssociateQty(ZERO);
        entryInfo.setIssueQty(ZERO);
        entryInfo.setReceiptQty(ZERO);
        entryInfo.setBaseQty(ZERO);
        entryInfo.setReceiptPlanDate(new Date());
        entryInfo.setIssuePlanDate(new Date());
        entryInfo.setBaseStatus(EntryBaseStatusEnum.ADD);
        entryInfo.setAssistQty(ZERO);
        entryInfo.setTotalPlanDQty(ZERO);
        StoreStateInfo storeState = StoreStateFactory.getLocalInstance((Context)ctx).getStoreStateInfo((IObjectPK)new ObjectUuidPK("181875d5-0105-1000-e000-012ec0a812fd62A73FA5"));
        entryInfo.setStoreState(storeState);
        StoreTypeInfo storeTypeInfo = StoreTypeFactory.getLocalInstance((Context)ctx).getStoreTypeInfo((IObjectPK)new ObjectUuidPK("181875d5-0105-1000-e000-0111c0a812fd97D461A6"));
        entryInfo.setStoreType(storeTypeInfo);
        entryInfo.setIsMrpCal(true);
        return entryInfo;
    }

    protected boolean checkAutoTransferForLot(Context ctx, String billID) throws BOSException, EASBizException {
        StringBuffer selectSql = new StringBuffer();
        selectSql.append("select billentry.fseq as seq");
        selectSql.append(",invIssue.FISLOTNUMBER as isssueIsLotNumber,invIssue.FISPERIODVALID as issueIsPeriod\r\n");
        selectSql.append(",invIssue.FISTRACKINGNUMBER as issueIsTrack ,invIssue.FISPROJECTNUMBER as issueIsProject\r\n");
        selectSql.append(",invRec.FISLOTNUMBER as recIsLotNumber,invRec.FISPERIODVALID as recIsPeriod\r\n");
        selectSql.append(",invRec.FISTRACKINGNUMBER as recIsTrack ,invRec.FISPROJECTNUMBER as recIsProject\r\n");
        StringBuffer fromSql = new StringBuffer();
        fromSql.append("from t_im_stocktransferbill bill\r\n");
        fromSql.append("inner join t_im_stocktransferbillentry billentry\r\n");
        fromSql.append("on bill.fid = billentry.FPARENTID\r\n");
        fromSql.append("left join t_bd_materialinventory invIssue\r\n");
        fromSql.append("on (billentry.FMATERIALID = invIssue.FMATERIALID\r\n");
        fromSql.append("and bill.FISSUESTORAGEORGUNITID = invIssue.FORGUNIT)\r\n");
        fromSql.append("left join t_bd_materialinventory invRec\r\n");
        fromSql.append("on (billentry.FMATERIALID = invRec.FMATERIALID\r\n");
        fromSql.append("and bill.FRECEIPTSTORAGEORGUNITID = invRec.FORGUNIT)\r\n");
        fromSql.append("where bill.FID = '" + billID + "'");
        String orderBy = " order by billentry.FSEQ asc ";
        StringBuffer lotNullSql = new StringBuffer();
        lotNullSql.append("select billentry.fseq as seq ");
        lotNullSql.append(fromSql);
        lotNullSql.append(" and invIssue.FISLOTNUMBER = 1\r\n");
        lotNullSql.append(" and invRec.FISLOTNUMBER = 1 and billentry.FLOT is null\r\n");
        lotNullSql.append(orderBy);
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)selectSql.append(fromSql).append(orderBy).toString());
        StringBuffer errorStr = new StringBuffer();
        String[][] fileds = new String[][]{{"isssueIsLotNumber", "recIsLotNumber"}, {"issueIsPeriod", "recIsPeriod"}, {"issueIsTrack", "recIsTrack"}, {"issueIsProject", "recIsProject"}};
        NumericExceptionSubItem[] exception = new NumericExceptionSubItem[]{StockTransferBillException.MOVEINOUTORGNOTSAMEATLOT, StockTransferBillException.MOVEINOUTORGNOTSAMEATPERIOD, StockTransferBillException.MOVEINOUTORGNOTSAMEATTRACK, StockTransferBillException.MOVEINOUTORGNOTSAMEATPROJECT};
        try {
            for (int i = 0; i < fileds.length; ++i) {
                if (!rs.isFirst()) {
                    rs.beforeFirst();
                }
                if ((errorStr = this.getErrorStr((ResultSet)rs, fileds[i][0], fileds[i][1])).length() == 0) continue;
                throw new StockTransferBillException(exception[i], new Object[]{errorStr.toString()});
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            KsqlUtil.cleanup((ResultSet)rs);
        }
        rs = DbUtil.executeQuery((Context)ctx, (String)lotNullSql.toString());
        int tag = 0;
        try {
            while (rs.next()) {
                if (tag != 0) {
                    errorStr.append(",");
                }
                errorStr.append(rs.getInt("Seq"));
                ++tag;
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            KsqlUtil.cleanup((ResultSet)rs);
        }
        if (errorStr.length() == 0) {
            return true;
        }
        throw new StockTransferBillException(StockTransferBillException.LOTNUMCANNOTBENULL, new Object[]{errorStr.toString()});
    }

    protected String getWebAutoTransferChekResultForLot(Context ctx, String billID) throws BOSException, EASBizException {
        int seq;
        StringBuffer selectSql = new StringBuffer();
        selectSql.append("select billentry.fseq as seq");
        selectSql.append(",invIssue.FISLOTNUMBER as isssueIsLotNumber,invIssue.FISPERIODVALID as issueIsPeriod\r\n");
        selectSql.append(",invIssue.FISTRACKINGNUMBER as issueIsTrack ,invIssue.FISPROJECTNUMBER as issueIsProject\r\n");
        selectSql.append(",invRec.FISLOTNUMBER as recIsLotNumber,invRec.FISPERIODVALID as recIsPeriod\r\n");
        selectSql.append(",invRec.FISTRACKINGNUMBER as recIsTrack ,invRec.FISPROJECTNUMBER as recIsProject\r\n");
        StringBuffer fromSql = new StringBuffer();
        fromSql.append("from t_im_stocktransferbill bill\r\n");
        fromSql.append("inner join t_im_stocktransferbillentry billentry\r\n");
        fromSql.append("on bill.fid = billentry.FPARENTID\r\n");
        fromSql.append("left join t_bd_materialinventory invIssue\r\n");
        fromSql.append("on (billentry.FMATERIALID = invIssue.FMATERIALID\r\n");
        fromSql.append("and bill.FISSUESTORAGEORGUNITID = invIssue.FORGUNIT)\r\n");
        fromSql.append("left join t_bd_materialinventory invRec\r\n");
        fromSql.append("on (billentry.FMATERIALID = invRec.FMATERIALID\r\n");
        fromSql.append("and bill.FRECEIPTSTORAGEORGUNITID = invRec.FORGUNIT)\r\n");
        fromSql.append("where bill.FID = '" + billID + "'");
        String orderBy = " order by billentry.FSEQ asc ";
        StringBuffer lotNullSql = new StringBuffer();
        lotNullSql.append("select billentry.fseq as seq ");
        lotNullSql.append(fromSql);
        lotNullSql.append(" and invIssue.FISLOTNUMBER = 1\r\n");
        lotNullSql.append(" and invRec.FISLOTNUMBER = 1 and billentry.FLOT is null\r\n");
        lotNullSql.append(orderBy);
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)selectSql.append(fromSql).append(orderBy).toString());
        StringBuffer errorStr = new StringBuffer();
        try {
            while (rs.next()) {
                seq = rs.getInt("seq");
                if (rs.getInt("isssueIsLotNumber") != rs.getInt("recIsLotNumber")) {
                    errorStr.append(new StockTransferBillException(StockTransferBillException.MOVEINOUTORGNOTSAMEATLOT, new Object[]{seq}).getMessage()).append("\n");
                }
                if (rs.getInt("issueIsPeriod") != rs.getInt("recIsPeriod")) {
                    errorStr.append(new StockTransferBillException(StockTransferBillException.MOVEINOUTORGNOTSAMEATPERIOD, new Object[]{seq}).getMessage()).append("\n");
                }
                if (rs.getInt("issueIsTrack") != rs.getInt("recIsTrack")) {
                    errorStr.append(new StockTransferBillException(StockTransferBillException.MOVEINOUTORGNOTSAMEATTRACK, new Object[]{seq}).getMessage()).append("\n");
                }
                if (rs.getInt("issueIsProject") == rs.getInt("recIsProject")) continue;
                errorStr.append(new StockTransferBillException(StockTransferBillException.MOVEINOUTORGNOTSAMEATPROJECT, new Object[]{seq}).getMessage()).append("\n");
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            KsqlUtil.cleanup((ResultSet)rs);
        }
        rs = DbUtil.executeQuery((Context)ctx, (String)lotNullSql.toString());
        try {
            while (rs.next()) {
                seq = rs.getInt("seq");
                errorStr.append(new StockTransferBillException(StockTransferBillException.LOTNUMCANNOTBENULL, new Object[]{seq}).getMessage()).append("\n");
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            KsqlUtil.cleanup((ResultSet)rs);
        }
        return errorStr.toString();
    }

    private StringBuffer getErrorStr(ResultSet rs, String issueField, String recField) throws SQLException {
        StringBuffer errorStr = new StringBuffer();
        while (rs.next()) {
            if (rs.getInt(issueField) == rs.getInt(recField)) continue;
            if (errorStr.length() > 0) {
                errorStr.append(",");
            }
            errorStr.append(rs.getInt("seq"));
        }
        return errorStr;
    }

    public void _handleAfterTransform(Context ctx, String action, IObjectCollection collection) throws EASBizException, BOSException {
        if (collection == null || collection.size() == 0) {
            return;
        }
        int n = collection.size();
        for (int i = 0; i < n; ++i) {
            StockTransferBillInfo billInfo = (StockTransferBillInfo)collection.getObject(i);
            this.calByUnitSource(ctx, billInfo, (IObjectCollection)billInfo.getEntry());
            this.initBotpData(ctx, (IObjectValue)billInfo);
            if (billInfo == null || billInfo.getEntry() == null || billInfo.getEntry().size() <= 0) continue;
            if (billInfo.getReceiptCompanyOrgUnit() != null && billInfo.getIssueCompanyOrgUnit() != null && billInfo.getBizType() == null) {
                IBizType ib = BizTypeFactory.getLocalInstance((Context)ctx);
                if (billInfo.getReceiptCompanyOrgUnit().getId().toString().equals(billInfo.getIssueCompanyOrgUnit().getId().toString())) {
                    billInfo.setBizType(ib.getBizTypeInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)"d8e80652-0118-1000-e000-04c5c0a812202407435C"))));
                } else {
                    billInfo.setBizType(ib.getBizTypeInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)"d8e80652-0117-1000-e000-04c5c0a812202407435C"))));
                }
            }
            Map materialPlanMap = new HashMap();
            materialPlanMap = this.getMaterialPlanMap(ctx, billInfo);
            StockTransferBillEntryCollection Entries = billInfo.getEntry();
            StockTransferBillEntryInfo EntryInfo = null;
            int num = Entries.size();
            for (int j = 0; j < num; ++j) {
                EntryInfo = Entries.get(j);
                MaterialPlanInfo matPlanInfo = null;
                if (billInfo.getSourceBillType() != null && "tMCsjuu0TMO+jMoUTkrsSkY+1VI=".equals(billInfo.getSourceBillType().getId().toString())) {
                    EntryInfo.setIsMrpCal(false);
                    continue;
                }
                if (billInfo.getIssueStorageOrgUnit() != null && billInfo.getIssueStorageOrgUnit().getId() != null && EntryInfo.getMaterial() != null && EntryInfo.getMaterial().getId() != null) {
                    String materialID = EntryInfo.getMaterial().getId().toString();
                    String orgUnitID = billInfo.getIssueStorageOrgUnit().getId().toString();
                    if (materialPlanMap.containsKey(materialID + orgUnitID)) {
                        matPlanInfo = (MaterialPlanInfo)materialPlanMap.get(materialID + orgUnitID);
                        if (matPlanInfo != null && matPlanInfo.getStatus() == UsedStatusEnum.APPROVED && matPlanInfo.getPlanningMode() != null && (matPlanInfo.getPlanningMode().equals((Object)PlanningModeEnum.MRP) || matPlanInfo.getPlanningMode().equals((Object)PlanningModeEnum.MPS))) {
                            EntryInfo.setIsMrpCal(true);
                            continue;
                        }
                        EntryInfo.setIsMrpCal(false);
                        continue;
                    }
                    EntryInfo.setIsMrpCal(false);
                    continue;
                }
                EntryInfo.setIsMrpCal(false);
            }
            SCMBizDataVO dataVO = new SCMBizDataVO();
            SCMEntryDataVO scmEntryDataVO = new SCMEntryDataVO();
            dataVO.setScmEntryDataVO(scmEntryDataVO);
            this.initSCMBizDataVO(ctx, dataVO, billInfo.getEntry());
            scmEntryDataVO = SCMGroupFacadeFactory.getLocalInstance((Context)ctx).loadMmuPrecision(dataVO.getScmEntryDataVO());
            try {
                Class<StockTransferBillEntryInfo> clazz = StockTransferBillEntryInfo.class;
                StockTransferBillControllerBean.formatQtyPrecision((AbstractObjectCollection)billInfo.getEntry(), (Method)clazz.getMethod("getQty", new Class[0]), (Method)clazz.getMethod("setBaseQty", BigDecimal.class), (Method)clazz.getMethod("setAssistQty", BigDecimal.class), (Method)clazz.getMethod("setAssistUnit", MeasureUnitInfo.class), (Method)clazz.getMethod("getAssistQty", new Class[0]), (SCMEntryDataVO)scmEntryDataVO);
                continue;
            }
            catch (Exception e) {
                throw new BOSException((Throwable)e);
            }
        }
    }

    protected void initBotpData(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        if (null == model) {
            return;
        }
        SCMUtil.succeedSourceBillReservationInfo((Context)ctx, (IObjectValue)model);
        StockTransferBillInfo billInfo = (StockTransferBillInfo)model;
        StockTransferBillEntryCollection entries = billInfo.getEntry();
        if (CollectionUtil.isEmpty((AbstractObjectCollection)entries)) {
            return;
        }
        StockTransferBillEntryInfo entry = null;
        StoreTypeInfo defaultStoreType = null;
        StoreStateInfo defaultStoreState = null;
        int num = entries.size();
        for (int i = 0; i < num; ++i) {
            entry = entries.get(i);
            if (null == entry) continue;
            if (null == entry.getStoreType()) {
                if (defaultStoreType == null) {
                    defaultStoreType = StoreTypeFactory.getLocalInstance((Context)ctx).getStoreTypeInfo((IObjectPK)new ObjectUuidPK("181875d5-0105-1000-e000-0111c0a812fd97D461A6"));
                }
                entry.setStoreType(defaultStoreType);
            }
            if (null != entry.getStoreState()) continue;
            if (defaultStoreState == null) {
                defaultStoreState = StoreStateFactory.getLocalInstance((Context)ctx).getStoreStateInfo((IObjectPK)new ObjectUuidPK("181875d5-0105-1000-e000-012ec0a812fd62A73FA5"));
            }
            entry.setStoreState(defaultStoreState);
        }
    }

    private void writeBackNumberProductionOrder(Context ctx, StockTransferBillInfo stockTransferBillInfo) throws BOSException, EASBizException {
        if (stockTransferBillInfo != null && stockTransferBillInfo.getSourceBillType() != null && stockTransferBillInfo.getSourceBillType().getId() != null && "PJSZtgEhEADgAAJ8fwAAAUY+1VI=".equalsIgnoreCase(stockTransferBillInfo.getSourceBillType().getId().toString())) {
            String billId = stockTransferBillInfo.getId().toString();
            String sourceBillId = stockTransferBillInfo.getSourceBillId().toString();
            StockTransferBillEntryCollection stbEntryCollection = stockTransferBillInfo.getEntry();
            if (stbEntryCollection != null && stbEntryCollection.size() > 0) {
                StockTransferBillEntryInfo stbEntryInfo = null;
                HashSet<String> souceEntryIds = new HashSet<String>();
                int n = stbEntryCollection.size();
                for (int i = 0; i < n; ++i) {
                    stbEntryInfo = stbEntryCollection.get(i);
                    if (stbEntryInfo.getSourceBillEntryId() == null) continue;
                    souceEntryIds.add(stbEntryInfo.getSourceBillEntryId().toString());
                }
                IStockGatherMove stockGatherMove = StockGatherMoveFactory.getLocalInstance((Context)ctx);
                stockGatherMove.backWriteDeleteTransferBill(billId, sourceBillId, souceEntryIds, true);
            }
        }
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        InvServerUtils.handleReqPlan(pk.toString(), "50957179-0105-1000-e003-3152c0a812fd463ED552", BizActionEnum.DELETE, ctx);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("sourceBillType.id"));
        sic.add(new SelectorItemInfo("sourceBillId"));
        sic.add(new SelectorItemInfo("entry.id"));
        sic.add(new SelectorItemInfo("entry.sourceBillEntryId"));
        StockTransferBillInfo billInfo = this.getStockTransferBillInfo(ctx, pk, sic);
        this.writeBackNumberProductionOrder(ctx, billInfo);
        InvServerUtils.deleteSerialNumber(ctx, pk);
        super._delete(ctx, pk);
    }

    protected void _reverseSave(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
    }

    public String getParamCon4Audit() {
        return "INM103";
    }

    public String getParamCon4UnAudit() {
        return "INM104";
    }

    private Map getMaterialPlanMap(Context ctx, StockTransferBillInfo billInfo) throws BOSException, EASBizException {
        HashMap<String, MaterialPlanInfo> materialPlanMap = new HashMap<String, MaterialPlanInfo>();
        StockTransferBillEntryCollection tmpEntries = billInfo.getEntry();
        StockTransferBillEntryInfo entryInfo = null;
        StringBuffer storageId = new StringBuffer();
        StringBuffer materialId = new StringBuffer();
        MaterialPlanCollection materialPlanCollection = null;
        if (billInfo.getIssueStorageOrgUnit() != null && billInfo.getIssueStorageOrgUnit().getId() != null) {
            storageId.append("'").append(billInfo.getIssueStorageOrgUnit().getId().toString()).append("',");
        }
        int num = tmpEntries.size();
        for (int i = 0; i < num; ++i) {
            entryInfo = tmpEntries.get(i);
            if (entryInfo.getMaterial() == null || entryInfo.getMaterial().getId() == null) continue;
            materialId.append("'").append(entryInfo.getMaterial().getId().toString()).append("',");
        }
        if (storageId != null && storageId.length() > 0) {
            storageId.setLength(storageId.length() - 1);
        }
        if (materialId != null && materialId.length() > 0) {
            materialId.setLength(materialId.length() - 1);
        }
        IMaterialPlan iMaterialPlan = MaterialPlanFactory.getLocalInstance((Context)ctx);
        if (materialId != null && storageId != null) {
            materialPlanCollection = iMaterialPlan.getMaterialPlanCollection(" select id,material.id,orgUnit.id,manufactureStrategy.id,manufactureStrategy.number,isolatedRule,status,planningMode  where material.id in ( " + materialId.toString() + " ) and orgUnit.id in ( " + storageId.toString() + ")");
        }
        if (materialPlanCollection != null) {
            for (int i = 0; i < materialPlanCollection.size(); ++i) {
                MaterialPlanInfo info = materialPlanCollection.get(i);
                if (info == null || info.getMaterial() == null || info.getMaterial().getId() == null || info.getOrgUnit() == null || info.getOrgUnit().getId() == null) continue;
                materialPlanMap.put(info.getMaterial().getId().toString() + info.getOrgUnit().getId().toString(), info);
            }
        }
        return materialPlanMap;
    }

    protected String getBatchMethodName(Context ctx, String name) throws BaseException {
        if (Boolean.FALSE.equals(ctx.get((Object)"CONTEXT_KEY_ISBATCHACTION"))) {
            return null;
        }
        return "batch" + name.substring(0, 1).toUpperCase() + name.substring(1);
    }

    protected void _submit(Context ctx, String id) throws BOSException, EASBizException {
        BatchExecuteParamsEntry[] entries = new BatchExecuteParamsEntry[1];
        Class[] parameterTypes = new Class[]{IObjectValue.class};
        StockTransferBillInfo model = this.getStockTransferBillInfo(ctx, (IObjectPK)new ObjectStringPK(id), this.getSelector());
        entries[0] = new BatchExecuteParamsEntry(parameterTypes, new Object[]{model});
        this.batchExecute(ctx, entries, BatchActionEnum.SUBMIT);
    }

    protected void calByUnitSource(Context ctx, SCMBillBaseInfo scmBillBaseInfo, SCMBillEntryBaseInfo scmBillEntryBaseInfo) throws BOSException, EASBizException {
        String sourceUnitId;
        super.calByUnitSource(ctx, scmBillBaseInfo, scmBillEntryBaseInfo);
        StockTransferBillEntryInfo stockTransferBillEntryInfo = (StockTransferBillEntryInfo)scmBillEntryBaseInfo;
        String sourceBillEntryId = stockTransferBillEntryInfo.getSourceBillEntryId();
        if (StringUtil.isEmpty((String)sourceBillEntryId)) {
            return;
        }
        if (!(this.sourceBillEntryMap.get(sourceBillEntryId) instanceof SCMBillEntryBaseInfo)) {
            return;
        }
        SCMBillEntryBaseInfo sourceBillEntryInfo = (SCMBillEntryBaseInfo)this.sourceBillEntryMap.get(sourceBillEntryId);
        String unitId = stockTransferBillEntryInfo.getUnit().getId().toString();
        if (unitId.equals(sourceUnitId = sourceBillEntryInfo.getUnit().getId().toString())) {
            return;
        }
        BigDecimal qty = BigDecimal.ZERO;
        qty = stockTransferBillEntryInfo.getBaseQty() != null ? SCMCommonUtil.calQtyByBaseQty((Context)ctx, (BigDecimal)stockTransferBillEntryInfo.getBaseQty(), (SCMBillEntryBaseInfo)scmBillEntryBaseInfo) : SCMCommonUtil.reCalQty((Context)ctx, (BigDecimal)stockTransferBillEntryInfo.getQty(), (SCMBillEntryBaseInfo)scmBillEntryBaseInfo, (String)sourceUnitId);
        stockTransferBillEntryInfo.setQty(qty);
    }

    @Override
    protected ArrayList _autoTransfer(Context ctx, String id) throws BOSException, EASBizException {
        if (StringUtils.isEmpty((String)id)) {
            return null;
        }
        ArrayList<String[]> successNumber = new ArrayList<String[]>();
        String[] num = null;
        ObjectUuidPK pk = new ObjectUuidPK(id);
        StockTransferBillInfo bill = this.getStockTransferBillInfo(ctx, (IObjectPK)pk);
        if (!bill.getBaseStatus().equals((Object)BillBaseStatusEnum.AUDITED)) {
            throw new StockTransferBillException(StockTransferBillException.BILL_NOT_AUDIT);
        }
        IObjectPK userPK = ctx.getCaller();
        ObjectUuidPK moveOutStoragePK = new ObjectUuidPK(bill.getIssueStorageOrgUnit().getId());
        ObjectUuidPK moveInStoragePK = new ObjectUuidPK(bill.getReceiptStorageOrgUnit().getId());
        this.checkFunctionPermission(ctx, userPK, (IObjectPK)moveOutStoragePK, "moveissue_new");
        this.checkFunctionPermission(ctx, userPK, (IObjectPK)moveOutStoragePK, "moveissue_audit");
        this.checkFunctionPermission(ctx, userPK, (IObjectPK)moveInStoragePK, "moveinwarehs_new");
        this.checkFunctionPermission(ctx, userPK, (IObjectPK)moveInStoragePK, "moveinwarehs_audit");
        if (bill != null && bill.getId() != null) {
            StockTransferBillEntryCollection coll = bill.getEntry();
            for (int i = 0; i < coll.size(); ++i) {
                LocationInfo location;
                LocationInfo location2;
                StockTransferBillEntryInfo entry = coll.get(i);
                int seq = entry.getSeq();
                WarehouseInfo issueHouse = entry.getIssueWarehouse();
                if (issueHouse == null) {
                    throw new StockTransferBillException(StockTransferBillException.ISSUEHOUSE_CANNOT_BE_NULL, new Object[]{seq});
                }
                if (issueHouse.isHasLocation() && ((location2 = entry.getIssueLocation()) == null || location2.getId() == null)) {
                    throw new StockTransferBillException(StockTransferBillException.ISSUELOCATION_CANNOT_BE_NULL, new Object[]{seq});
                }
                WarehouseInfo receiptWarehouse = entry.getReceiptWarehouse();
                if (receiptWarehouse == null) {
                    throw new StockTransferBillException(StockTransferBillException.RECEHOUSE_CANNOT_BE_NULL, new Object[]{seq});
                }
                if (receiptWarehouse.isHasLocation() && ((location = entry.getReceiptLocation()) == null || location.getId() == null)) {
                    throw new StockTransferBillException(StockTransferBillException.RECELOCATION_CANNOT_BE_NULL, new Object[]{seq});
                }
                StoreTypeInfo storeType = entry.getStoreType();
                if (this.isAboutCustomerStore(storeType) && entry.getCustomer() == null) {
                    throw new StockTransferBillException(StockTransferBillException.CUSTOMER_CANNOT_BE_NOT, new Object[]{seq});
                }
                if (!this.isAboutSupplierStore(storeType) || entry.getSupplier() != null) continue;
                throw new StockTransferBillException(StockTransferBillException.SUPPLIER_CANNOT_BE_NOT, new Object[]{seq});
            }
            num = this._autoTransfer(ctx, bill);
        }
        successNumber.add(num);
        return successNumber;
    }

    private boolean isAboutCustomerStore(StoreTypeInfo storeTypeInfo) {
        StoreFlagEnum storeFlag = storeTypeInfo == null ? null : storeTypeInfo.getStoreFlag();
        int storeFlagValue = storeFlag == null ? -1 : storeFlag.getValue();
        return storeFlagValue == 3 || storeFlagValue == 4;
    }

    private boolean isAboutSupplierStore(StoreTypeInfo storeTypeInfo) {
        StoreFlagEnum storeFlag = storeTypeInfo == null ? null : storeTypeInfo.getStoreFlag();
        int storeFlagValue = storeFlag == null ? -1 : storeFlag.getValue();
        return storeFlagValue == 2 || storeFlagValue == 5;
    }

    public void checkFunctionPermission(Context ctx, IObjectPK userPK, IObjectPK orgPK, String permissionItem) throws BOSException, EASBizException {
        IPermission iPer = PermissionFactory.getLocalInstance((Context)ctx);
        iPer.checkFunctionPermission(userPK, orgPK, permissionItem);
    }

    @Override
    protected String _checkAutoTransferForWeb(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        StockTransferBillInfo info = (StockTransferBillInfo)model;
        StockTransferBillEntryInfo entry = null;
        StringBuffer errorSb = new StringBuffer();
        StringBuffer billError = new StringBuffer();
        if (!info.getBaseStatus().equals((Object)BillBaseStatusEnum.AUDITED)) {
            billError.append(new StockTransferBillException(StockTransferBillException.BILL_NOT_AUDIT).getMessage()).append("\n");
        }
        IObjectPK userPK = ctx.getCaller();
        ObjectUuidPK moveOutStoragePK = new ObjectUuidPK(info.getIssueStorageOrgUnit().getId());
        ObjectUuidPK moveInStoragePK = new ObjectUuidPK(info.getReceiptStorageOrgUnit().getId());
        this.checkFunctionPermission(ctx, userPK, (IObjectPK)moveOutStoragePK, "moveissue_new");
        this.checkFunctionPermission(ctx, userPK, (IObjectPK)moveOutStoragePK, "moveissue_audit");
        this.checkFunctionPermission(ctx, userPK, (IObjectPK)moveInStoragePK, "moveinwarehs_new");
        this.checkFunctionPermission(ctx, userPK, (IObjectPK)moveInStoragePK, "moveinwarehs_audit");
        StockTransferBillEntryCollection coll = info.getEntry();
        if (billError == null && billError.length() == 0) {
            for (int j = 0; j < coll.size(); ++j) {
                LocationInfo location;
                LocationInfo location2;
                entry = coll.get(j);
                int seq = entry.getSeq();
                WarehouseInfo issueHouse = entry.getIssueWarehouse();
                if (issueHouse == null) {
                    billError.append(new StockTransferBillException(StockTransferBillException.ISSUEHOUSE_CANNOT_BE_NULL, new Object[]{seq}).getMessage()).append("\n");
                } else if (issueHouse.isHasLocation() && ((location2 = entry.getIssueLocation()) == null || location2.getId() == null)) {
                    billError.append(new StockTransferBillException(StockTransferBillException.ISSUELOCATION_CANNOT_BE_NULL, new Object[]{seq}).getMessage()).append("\n");
                }
                WarehouseInfo receiptWarehouse = entry.getReceiptWarehouse();
                if (receiptWarehouse == null) {
                    billError.append(new StockTransferBillException(StockTransferBillException.RECEHOUSE_CANNOT_BE_NULL, new Object[]{seq}).getMessage()).append("\n");
                } else if (receiptWarehouse.isHasLocation() && ((location = entry.getReceiptLocation()) == null || location.getId() == null)) {
                    billError.append(new StockTransferBillException(StockTransferBillException.RECELOCATION_CANNOT_BE_NULL, new Object[]{seq}).getMessage()).append("\n");
                }
                StoreTypeInfo storeType = entry.getStoreType();
                if (this.isAboutCustomerStore(storeType) && entry.getCustomer() == null) {
                    billError.append(new StockTransferBillException(StockTransferBillException.CUSTOMER_CANNOT_BE_NOT, new Object[]{seq}).getMessage()).append("\n");
                }
                if (this.isAboutSupplierStore(storeType) && entry.getSupplier() == null) {
                    billError.append(new StockTransferBillException(StockTransferBillException.SUPPLIER_CANNOT_BE_NOT, new Object[]{seq}).getMessage()).append("\n");
                }
                if (entry.getMaterial().getAssistAttr() == null || entry.getAssistProperty() != null) continue;
                billError.append(new StockTransferBillException(StockTransferBillException.ASSISTNUMCANNOTBENULL, new Object[]{seq}).getMessage()).append("\n");
            }
        }
        String lotCheckResult = this.getWebAutoTransferChekResultForLot(ctx, info.getId().toString());
        if (billError.length() > 0) {
            errorSb.append(info.getNumber()).append("\uff1a\n").append(billError);
            errorSb.append(lotCheckResult);
        }
        return errorSb.toString();
    }

    @Override
    protected void _checkAlter(Context ctx, IObjectPK id) throws BOSException, EASBizException {
        StockTransferBillInfo info = this.getStockTransferBillInfo(ctx, id);
        PermissionFactory.getLocalInstance((Context)ctx).checkFunctionPermission(ctx.getCaller(), (IObjectPK)new ObjectUuidPK(info.getIssueStorageOrgUnit().getId().toString()), "stocktransfer_alter");
        BillBaseStatusEnum baseStatus = info.getBaseStatus();
        if (baseStatus != null && baseStatus.getValue() != 4) {
            throw new StockTransferBillException(StockTransferBillException.BILLBASESTATUS_CANNOT_ALERT, new String[]{baseStatus.toString()});
        }
    }

    @Override
    protected void _alter(Context ctx, IObjectPK id, IObjectValue info) throws BOSException, EASBizException {
        int i;
        StockTransferBillInfo oldInfo = this.getStockTransferBillInfo(ctx, id);
        StockTransferBillInfo newInfo = (StockTransferBillInfo)info;
        StockTransferBillEntryCollection oldEntries = oldInfo.getEntry();
        StockTransferBillEntryCollection newEntries = newInfo.getEntry();
        StockTransferBillEntryInfo oldEntryInfo = null;
        StockTransferBillEntryInfo newEntryInfo = null;
        this._checkAlter(ctx, id);
        this._checkAlterData(ctx, oldInfo, newInfo);
        int oldVersion = oldInfo.getVersion();
        if (oldVersion <= 0) {
            oldVersion = 1;
        }
        newInfo.setVersion(oldVersion + 1);
        newInfo.setOldBillStatus(newInfo.getBaseStatus());
        newInfo.setBaseStatus(BillBaseStatusEnum.ALTERING);
        String requireSouId = newInfo.getReceiptStorageOrgUnit().getId().toString();
        String requireCouId = newInfo.getReceiptCompanyOrgUnit().getId().toString();
        String supplyCouId = newInfo.getIssueCompanyOrgUnit().getId().toString();
        this.checkMaterialInvAndComInfo(ctx, MaterialFactory.getLocalInstance((Context)ctx), newEntries, requireSouId, requireCouId, supplyCouId);
        int num = newEntries.size();
        for (i = 0; i < num; ++i) {
            newEntryInfo = newEntries.get(i);
            EntryBaseStatusEnum entryBaseStatus = newEntryInfo.getBaseStatus();
            if (entryBaseStatus == null || entryBaseStatus.getValue() == 0 || entryBaseStatus.getValue() == 1 || entryBaseStatus.getValue() == 2) {
                entryBaseStatus = EntryBaseStatusEnum.AUDITED;
                newEntryInfo.setBaseStatus(entryBaseStatus);
                newEntryInfo.setUnIssueBaseQty(newEntryInfo.getBaseQty());
                newEntryInfo.setArAssociateBaseQty(newEntryInfo.getBaseQty());
                newEntryInfo.setApAssociateBaseQty(newEntryInfo.getBaseQty());
            }
            newEntryInfo.setOldBillEntryStatus(entryBaseStatus);
            if (entryBaseStatus.getValue() != 4) continue;
            newEntryInfo.setBaseStatus(EntryBaseStatusEnum.ALTERING);
        }
        oldInfo.setOldBillID(oldInfo.getId());
        oldInfo.setId(null);
        oldInfo.setVersion(oldVersion);
        oldInfo.setAlterPerson(ContextUtil.getCurrentUserInfo((Context)ctx));
        oldInfo.setAlterDate(new Timestamp(new Date().getTime()));
        oldInfo.setOldBillStatus(oldInfo.getBaseStatus());
        oldInfo.setBaseStatus(BillBaseStatusEnum.VERSION);
        num = oldEntries.size();
        for (i = 0; i < num; ++i) {
            oldEntryInfo = oldEntries.get(i);
            oldEntryInfo.setOldBillEntryID(oldEntryInfo.getId());
            oldEntryInfo.setId(null);
            oldEntryInfo.setOldBillEntryStatus(oldEntryInfo.getBaseStatus());
            oldEntryInfo.setBaseStatus(EntryBaseStatusEnum.VERSION);
        }
        this.innerAddnew(ctx, (IObjectValue)oldInfo);
        this.innerUpdate(ctx, id, (IObjectValue)newInfo);
        SCMServerUtils.setBizFlowRelationForAlter((Context)ctx, (IObjectValue)oldInfo, (IObjectValue)newInfo);
        InvServerUtils.handleReqPlan(newInfo.getId().toString(), "50957179-0105-1000-e003-3152c0a812fd463ED552", BizActionEnum.ALTER, ctx);
        this._fixBizFlowNO(ctx, info.getString("id"), "t_im_stocktransferbill", "t_im_stocktransferbillentry", "FOLDBILLENTRYID");
    }

    private void _checkAlterData(Context ctx, StockTransferBillInfo oldInfo, StockTransferBillInfo newInfo) throws BOSException, EASBizException {
        StockTransferBillEntryCollection oldEntries = oldInfo.getEntry();
        StockTransferBillEntryCollection newEntries = newInfo.getEntry();
        int num = oldEntries.size();
        for (int i = 0; i < num; ++i) {
            StockTransferBillEntryInfo oldEntryInfo = oldEntries.get(i);
            if (oldEntryInfo.getBaseStatus().getValue() == 6 || oldEntryInfo.getBaseStatus().getValue() == 7) continue;
            BigDecimal oldQty = oldEntryInfo.getBaseQty();
            AbstractStockTransferBillEntryInfo newEntryInfo = null;
            for (int x = 0; x < newEntries.size(); ++x) {
                if (oldEntryInfo == null || oldEntryInfo.getId() == null || newEntries.get(x) == null || newEntries.get(x).getId() == null || !oldEntryInfo.getId().toString().equals(newEntries.get(x).getId().toString())) continue;
                newEntryInfo = newEntries.get(x);
            }
            if (newEntryInfo == null) continue;
            BigDecimal newQty = newEntryInfo.getBaseQty();
            boolean isAlterCanGreatQty = this.isAlterCanGreatQty(ctx, oldInfo.getIssueStorageOrgUnit().getId().toString());
            if (!isAlterCanGreatQty && newQty.compareTo(oldQty) > 0) {
                throw new StockTransferBillException(StockTransferBillException.ALERT_QTY_CANNOT_GT_OLDQTY);
            }
            if (oldQty.compareTo(newQty) == 0) continue;
            BigDecimal issueQty = SCMUtils.effectualNumeric((BigDecimal)oldEntryInfo.getIssueBaseQty()).abs();
            BigDecimal receiptQty = SCMUtils.effectualNumeric((BigDecimal)oldEntryInfo.getReceiptBaseQty()).abs();
            BigDecimal saleInvoiceQty = SCMUtils.effectualNumeric((BigDecimal)oldEntryInfo.getSaleInvoiceBaseQty()).abs();
            BigDecimal purInvoiceQty = SCMUtils.effectualNumeric((BigDecimal)oldEntryInfo.getPurInvoiceBaseQty()).abs();
            BigDecimal biggestQty = issueQty.compareTo(receiptQty) > 0 ? issueQty : receiptQty;
            biggestQty = biggestQty.compareTo(saleInvoiceQty) > 0 ? biggestQty : saleInvoiceQty;
            BigDecimal bigDecimal = biggestQty = biggestQty.compareTo(purInvoiceQty) > 0 ? biggestQty : purInvoiceQty;
            if (newQty.compareTo(biggestQty) >= 0) continue;
            throw new TransferOrderBillException(TransferOrderBillException.ALERT_QTY_CANNOT_LT_IMPLQTY, new String[]{newEntryInfo.getSeq() + ""});
        }
    }

    protected boolean isAlterCanGreatQty(Context ctx, String orgUnitID) throws BOSException, EASBizException {
        ObjectUuidPK orgUnitPK;
        boolean isAlterCanGreatQty = true;
        IParamControl paramControl = ParamControlFactory.getLocalInstance((Context)ctx);
        String paramValue = paramControl.getParamValue((IObjectPK)(orgUnitPK = orgUnitID == null ? null : new ObjectUuidPK(orgUnitID)), "INM111");
        if (paramValue != null && paramValue.trim().length() != 0 && paramValue.trim().equalsIgnoreCase("true")) {
            isAlterCanGreatQty = true;
        }
        if (paramValue != null && paramValue.trim().length() != 0 && paramValue.trim().equalsIgnoreCase("false")) {
            isAlterCanGreatQty = false;
        }
        return isAlterCanGreatQty;
    }

    @Override
    protected void _agreeAlter(Context ctx, IObjectPK id) throws BOSException, EASBizException {
        StockTransferBillInfo info = this.getStockTransferBillInfo(ctx, id, this.getSelector());
        info.setBaseStatus(info.getOldBillStatus());
        StockTransferBillEntryCollection entries = info.getEntry();
        int num = entries.size();
        for (int i = 0; i < num; ++i) {
            StockTransferBillEntryInfo entryInfo = entries.get(i);
            entryInfo.setBaseStatus(entryInfo.getOldBillEntryStatus());
            BigDecimal baseQty = SCMUtils.effectualNumeric((BigDecimal)entryInfo.getBaseQty());
            entryInfo.setUnIssueBaseQty(baseQty.subtract(SCMUtils.effectualNumeric((BigDecimal)entryInfo.getIssueBaseQty())));
            entryInfo.setArAssociateBaseQty(baseQty.subtract(SCMUtils.effectualNumeric((BigDecimal)entryInfo.getSaleInvoiceBaseQty())));
            entryInfo.setApAssociateBaseQty(baseQty.subtract(SCMUtils.effectualNumeric((BigDecimal)entryInfo.getPurInvoiceBaseQty())));
        }
        this._update(ctx, id, (IObjectValue)info);
        BizBillValueChangeUtil.handleBillAlter((Context)ctx, (IObjectValue)info, (String)"version", (String)"oldBillID", (String)"oldBillEntryID");
        SCMServerUtils.executeBizFlow((Context)ctx, (IObjectValue)info, (BatchActionEnum)BatchActionEnum.ALTER);
    }

    @Override
    protected void _disagreeAlter(Context ctx, IObjectPK id) throws BOSException, EASBizException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("version");
        StockTransferBillInfo info = this.getStockTransferBillInfo(ctx, id, sic);
        StockTransferBillInfo oldInfo = this.getPreviousVersionInfo(ctx, info);
        if (oldInfo != null) {
            oldInfo.setAlterPerson(null);
            oldInfo.setAlterDate(null);
            oldInfo.setBaseStatus(oldInfo.getOldBillStatus());
            StockTransferBillEntryCollection oldEntries = oldInfo.getEntry();
            StockTransferBillEntryInfo oldEntryInfo = null;
            int num = oldEntries.size();
            for (int i = 0; i < num; ++i) {
                oldEntryInfo = oldEntries.get(i);
                oldEntryInfo.setId(oldEntryInfo.getOldBillEntryID());
                oldEntryInfo.setBaseStatus(oldEntryInfo.getOldBillEntryStatus());
            }
            ObjectUuidPK oldPK = new ObjectUuidPK(oldInfo.getId().toString());
            this.innerDelete(ctx, new IObjectPK[]{id, oldPK});
            oldInfo.setId(oldInfo.getOldBillID());
            oldInfo.setOldBillID(null);
            oldInfo.setOldBillStatus(BillBaseStatusEnum.ADD);
            this.innerAddnew(ctx, id, (IObjectValue)oldInfo);
        }
    }

    private StockTransferBillInfo getPreviousVersionInfo(Context ctx, StockTransferBillInfo info) throws EASBizException, BOSException {
        String billID = info.getId().toString();
        int oldVersion = info.getVersion() - 1;
        String oql = "where oldBillID = '" + billID + "' and version = " + String.valueOf(oldVersion);
        return this.getStockTransferBillInfo(ctx, oql);
    }

    private void checkMaterialInvAndComInfo(Context ctx, IMaterial ima, StockTransferBillEntryCollection entryCol, String requireSouId, String requireCouId, String supplyCouId) throws InvBizException, BOSException, EASBizException {
        StockTransferBillEntryInfo entryInfo = null;
        IMaterialInventory imi = MaterialInventoryFactory.getLocalInstance((Context)ctx);
        int size = entryCol.size();
        this.init4Check(ctx, entryCol, requireSouId, requireCouId, supplyCouId);
        for (int i = 0; i < size; ++i) {
            entryInfo = entryCol.get(i);
            MaterialInfo material = entryInfo.getMaterial();
            String materialId = entryInfo.getMaterial().getId().toString();
            if (material.getNumber() == null) {
                material = ima.getMaterialInfo((IObjectPK)new ObjectUuidPK(materialId));
            }
            String matNumber = material.getNumber();
            if (this.getCompanyInfo(ima, materialId, supplyCouId) == null || this.getCompanyInfo(ima, materialId, supplyCouId).getStatus().equals((Object)UsedStatusEnum.UNAPPROVE)) {
                throw new InvBizException(InvBizException.MATERIAL_MOVEISSUE_COM_NULL, new String[]{matNumber});
            }
            if (this.getInventoryInfo(imi, materialId, requireSouId) == null || this.getInventoryInfo(imi, materialId, requireSouId).getStatus().equals((Object)UsedStatusEnum.UNAPPROVE)) {
                throw new InvBizException(InvBizException.MATERIAL_MOVEIN_INV_NULL, new String[]{matNumber});
            }
            if (this.getCompanyInfo(ima, materialId, requireCouId) != null && !this.getCompanyInfo(ima, materialId, requireCouId).getStatus().equals((Object)UsedStatusEnum.UNAPPROVE)) continue;
            throw new InvBizException(InvBizException.MATERIAL_MOVEIN_COM_NULL, new String[]{matNumber});
        }
    }

    private void init4Check(Context ctx, StockTransferBillEntryCollection entryCol, String requireSouId, String requireCouId, String supplyCouId) throws BOSException {
        HashSet<String> matSet = new HashSet<String>();
        HashSet<String> souSet = new HashSet<String>();
        souSet.add(requireSouId);
        HashSet<String> couSet = new HashSet<String>();
        couSet.add(supplyCouId);
        couSet.add(requireCouId);
        int size = entryCol.size();
        StockTransferBillEntryInfo entryInfo = null;
        for (int i = 0; i < size; ++i) {
            entryInfo = entryCol.get(i);
            matSet.add(entryInfo.getMaterial().getId().toString());
        }
        FilterInfo souFilter = new FilterInfo();
        souFilter.getFilterItems().add(new FilterItemInfo("material", matSet, CompareType.INCLUDE));
        souFilter.getFilterItems().add(new FilterItemInfo("orgUnit", souSet, CompareType.INCLUDE));
        FilterInfo couFilter = new FilterInfo();
        couFilter.getFilterItems().add(new FilterItemInfo("mateial", matSet, CompareType.INCLUDE));
        couFilter.getFilterItems().add(new FilterItemInfo("company", couSet, CompareType.INCLUDE));
        EntityViewInfo matInvView = new EntityViewInfo();
        matInvView.setFilter(souFilter);
        matInvView.getSelector().add("id");
        matInvView.getSelector().add("orgUnit");
        matInvView.getSelector().add("orgUnit.number");
        matInvView.getSelector().add("orgUnit.name");
        matInvView.getSelector().add("material");
        matInvView.getSelector().add("material.number");
        matInvView.getSelector().add("material.name");
        matInvView.getSelector().add("status");
        MaterialInventoryCollection matInvCol = MaterialInventoryFactory.getLocalInstance((Context)ctx).getMaterialInventoryCollection(matInvView);
        int length = matInvCol.size();
        for (int i = 0; i < length; ++i) {
            MaterialInventoryInfo matInvInfo = matInvCol.get(i);
            this.matInvMap.put(matInvInfo.getMaterial().getId().toString() + matInvInfo.getOrgUnit().getId().toString(), matInvInfo);
        }
        EntityViewInfo matCouView = new EntityViewInfo();
        matCouView.setFilter(couFilter);
        matCouView.getSelector().add("id");
        matCouView.getSelector().add("company");
        matCouView.getSelector().add("mateial");
        matCouView.getSelector().add("status");
        MaterialCompanyInfoCollection matCouCol = MaterialCompanyInfoFactory.getLocalInstance((Context)ctx).getMaterialCompanyInfoCollection(matCouView);
        int length2 = matCouCol.size();
        for (int i = 0; i < length2; ++i) {
            MaterialCompanyInfoInfo matCouInfo = matCouCol.get(i);
            this.matCouMap.put(matCouInfo.getMateial().getId().toString() + matCouInfo.getCompany().getId().toString(), matCouInfo);
        }
    }

    private MaterialCompanyInfoInfo getCompanyInfo(IMaterial ima, String materialId, String couId) throws BOSException {
        String key = materialId + couId;
        if (!this.matCouMap.containsKey(key)) {
            this.matCouMap.put(key, ima.getCompanyInfo(materialId, couId));
        }
        return this.matCouMap.get(key);
    }

    private MaterialInventoryInfo getInventoryInfo(IMaterialInventory ima, String materialId, String souId) throws BOSException, EASBizException {
        String key = materialId + souId;
        if (!this.matInvMap.containsKey(key)) {
            this.matInvMap.put(key, ima.getInventoryInfo(materialId, souId));
        }
        return this.matInvMap.get(key);
    }

    public BatchActionResults batchSubmitRelations(Context ctx, BatchExecuteParamsEntry[] entries) throws EASBizException, BOSException {
        SCMBillBaseInfo scmInfo = null;
        if (entries != null && entries.length > 0) {
            Object obj = entries[0].get(0);
            if (obj instanceof IObjectValue) {
                scmInfo = (SCMBillBaseInfo)entries[0].get(0);
            } else if (obj instanceof String) {
                scmInfo = this.getStockTransferBillInfo(ctx, (IObjectPK)new ObjectUuidPK(obj.toString()));
            }
        }
        if (scmInfo == null) {
            return null;
        }
        ObjectUuidPK pk = new ObjectUuidPK(scmInfo.getId());
        if (1 == scmInfo.getOperateState()) {
            ServiceStateManager.getInstance().enableNextCallServices();
            this.alter(ctx, (IObjectPK)pk, (StockTransferBillInfo)scmInfo);
            return null;
        }
        return super.batchSubmitRelations(ctx, entries);
    }

    protected boolean _checkOtherWhenDel(Context ctx, IObjectValue model) throws EASBizException, BOSException {
        SCMBillBaseInfo aSCMBillBaseInfo = (SCMBillBaseInfo)model;
        if (aSCMBillBaseInfo.getBaseStatus() != null && aSCMBillBaseInfo.getBaseStatus().getValue() != 0 && aSCMBillBaseInfo.getBaseStatus().getValue() != 1 && aSCMBillBaseInfo.getBaseStatus().getValue() != 2) {
            throw new SCMBillException(SCMBillException.CANNOT_DELETE, new Object[]{aSCMBillBaseInfo.getBaseStatus().toString()});
        }
        return true;
    }

    protected void setTransOrderStatus(Context ctx, String billID) throws InvUpdateException, EASBizException, BOSException {
        Connection conn = null;
        PreparedStatement closeEntrypreStmt = null;
        PreparedStatement closeBillpreStmt = null;
        PreparedStatement closePeriodPreStmt = null;
        int updateLine = 0;
        int updateLine3 = 0;
        boolean closeOrder = true;
        StringBuffer sqlBuff = new StringBuffer();
        IRowSet rs = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            sqlBuff.append("SELECT ");
            sqlBuff.append("stbe.FID as FID,stbe.FBaseStatus as FBaseStatus, ");
            sqlBuff.append("decimal(stbe.FBaseQty* (  1 -  decimal(ISNULL(stbe.FQuarityArreRate,0) / 100,21,8)),21,8) - stbe.FReceiptBaseQty as FBaseQty ");
            sqlBuff.append("FROM T_IM_StockTransferBillEntry stbe ");
            sqlBuff.append("WHERE ");
            sqlBuff.append("stbe.FParentID = '" + billID + "'");
            rs = DbUtil.executeQuery((Context)ctx, (String)sqlBuff.toString());
            closeEntrypreStmt = conn.prepareStatement("UPDATE T_IM_StockTransferBillEntry SET FBaseStatus = 7  WHERE FID = ?");
            closeBillpreStmt = conn.prepareStatement("UPDATE T_IM_StockTransferBill SET FBaseStatus = 7  WHERE FID = ?");
            closePeriodPreStmt = conn.prepareStatement("UPDATE T_IM_StockTransferBillEntry SET FClosePeriod = ( SELECT ISNULL(MAX(a.FYEAR*100 + a.FPERIOD),199901)  FROM T_IM_MOVEINWAREHSBILL a  INNER join T_IM_MOVEINWAREHSBILLENTRY  b on a.fid = b.FPARENTID  WHERE b.FSTOCKTRANSBILLENTRYID = ?) where fid = ?");
            while (rs.next()) {
                if (rs.getBigDecimal("FBaseQty").signum() <= 0) {
                    if (rs.getInt("FBaseStatus") == 7) continue;
                    closeEntrypreStmt.setString(1, rs.getString("FID"));
                    closeEntrypreStmt.addBatch();
                    closePeriodPreStmt.setString(1, rs.getString("FID"));
                    closePeriodPreStmt.setString(2, rs.getString("FID"));
                    closePeriodPreStmt.addBatch();
                    ++updateLine;
                    continue;
                }
                closeOrder = false;
            }
            if (closeOrder) {
                closeBillpreStmt.setString(1, billID);
                closeBillpreStmt.addBatch();
                ++updateLine3;
            }
            if (updateLine > 0) {
                closeEntrypreStmt.executeBatch();
                closePeriodPreStmt.executeBatch();
            }
            if (updateLine3 > 0) {
                closeBillpreStmt.executeBatch();
            }
        }
        catch (SQLException ex) {
            try {
                throw new BOSException((Throwable)ex);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup((Connection)conn);
                SQLUtils.cleanup(closeEntrypreStmt);
                SQLUtils.cleanup(closeBillpreStmt);
                SQLUtils.cleanup(closePeriodPreStmt);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Connection)conn);
        SQLUtils.cleanup((Statement)closeEntrypreStmt);
        SQLUtils.cleanup((Statement)closeBillpreStmt);
        SQLUtils.cleanup((Statement)closePeriodPreStmt);
    }
}

