/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ExchangeRateInfo;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.material.AccountType;
import com.kingdee.eas.basedata.master.material.AsstAttrValueInfo;
import com.kingdee.eas.basedata.master.material.MaterialCompanyInfoInfo;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.SaleOrgUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.basedata.scm.common.BizTypeInfo;
import com.kingdee.eas.basedata.scm.im.inv.WarehouseInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.batchHandler.RequestContext;
import com.kingdee.eas.framework.batchHandler.ResponseContext;
import com.kingdee.eas.scm.common.SCMBillCommonFacadeFactory;
import com.kingdee.eas.scm.common.SCMFetchData;
import com.kingdee.eas.scm.common.SCMFetchDataCondition;
import com.kingdee.eas.scm.common.SCMFetchDataFacadeFactory;
import com.kingdee.eas.scm.im.inv.BizRoleTypeEnum;
import com.kingdee.eas.scm.im.inv.ISupplyRelation;
import com.kingdee.eas.scm.im.inv.ITransferRule;
import com.kingdee.eas.scm.im.inv.InventoryInfo;
import com.kingdee.eas.scm.im.inv.MultiSidesTransferPriceFacadeFactory;
import com.kingdee.eas.scm.im.inv.PriceParamInfo;
import com.kingdee.eas.scm.im.inv.StockTransferBillInfo;
import com.kingdee.eas.scm.im.inv.SupplyRelationCollection;
import com.kingdee.eas.scm.im.inv.SupplyRelationFactory;
import com.kingdee.eas.scm.im.inv.SupplyRelationInfo;
import com.kingdee.eas.scm.im.inv.TransferOrderBillInfo;
import com.kingdee.eas.scm.im.inv.TransferRule2Factory;
import com.kingdee.eas.scm.im.inv.TransferRule3Factory;
import com.kingdee.eas.scm.im.inv.TransferRule3Info;
import com.kingdee.eas.scm.im.inv.TransferRule4Factory;
import com.kingdee.eas.scm.im.inv.TransferRule4Info;
import com.kingdee.eas.scm.im.inv.TransferRuleCollection;
import com.kingdee.eas.scm.im.inv.TransferRuleInfo;
import com.kingdee.eas.scm.im.inv.app.AbstractStockTransferBillEditUIHandler;
import java.math.BigDecimal;
import java.util.HashMap;

public class StockTransferBillEditUIHandler
extends AbstractStockTransferBillEditUIHandler {
    protected HashMap initFetchPara = new HashMap();

    protected void _handleInit(RequestContext request, ResponseContext response, Context context) throws Exception {
        super._handleInit(request, response, context);
        this.fillCouBySou(request, response, context);
    }

    @Override
    protected void _handleActionClose(RequestContext request, ResponseContext response, Context context) throws Exception {
    }

    @Override
    protected void _handleActionQuickAddLine(RequestContext request, ResponseContext response, Context context) throws Exception {
    }

    @Override
    protected void _handleActionAutoTransfer(RequestContext request, ResponseContext response, Context context) throws Exception {
    }

    public void handleActionQuickAddLine1(RequestContext request, ResponseContext response, Context context) throws Exception {
        TransferOrderBillInfo toBillInfo = (TransferOrderBillInfo)request.getValue();
        InventoryInfo[] invtInfos = (InventoryInfo[])request.get("invtInfos");
        if (toBillInfo != null && invtInfos != null) {
            StorageOrgUnitInfo supplySou = toBillInfo.getIssueStorageOrgUnit();
            StorageOrgUnitInfo requireSou = toBillInfo.getReceiptStorageOrgUnit();
            CompanyOrgUnitInfo supplyCouInfo = toBillInfo.getIssueCompanyOrgUnit();
            CurrencyInfo currencyInfo = toBillInfo.getCurrency();
            ExchangeRateInfo exchangeRateInfo = (ExchangeRateInfo)request.get("exchangeRateInfo");
            StorageOrgUnitInfo issueSou = supplySou;
            StorageOrgUnitInfo receiveSou = requireSou;
            SCMFetchDataCondition condition = this.buildCondition(invtInfos);
            this.initFetchPara.put("Condition", condition);
            SCMFetchData fetchData = SCMFetchDataFacadeFactory.getLocalInstance((Context)context).fetchData(condition.toEntiryView(), this.initFetchPara);
            if (supplySou == null || requireSou == null || currencyInfo == null) {
                return;
            }
            String bizType = toBillInfo.getBizType() == null ? "d8e80652-0117-1000-e000-04c5c0a812202407435C" : toBillInfo.getBizType().getId().toString();
            for (InventoryInfo invtInfo : invtInfos) {
                MaterialInfo mi = invtInfo.getMaterial();
                if (mi == null) {
                    return;
                }
                BigDecimal qty = invtInfo.getCurStoreQty();
                if (qty == null || qty.signum() == 0) {
                    return;
                }
                MeasureUnitInfo unit = invtInfo.getUnit();
                if (unit == null) {
                    return;
                }
                MeasureUnitInfo baseUnit = invtInfo.getBaseUnit();
                if (baseUnit == null) {
                    return;
                }
                AsstAttrValueInfo asstAttrInfo = invtInfo.getAssistProperty();
                SupplyRelationInfo srInfo = this.getSupplyRelation(context, supplySou.getId().toString(), requireSou.getId().toString(), issueSou.getId().toString(), receiveSou.getId().toString());
                TransferRuleInfo trInfo = this.getTransferRule(context, bizType, supplySou.getId().toString(), requireSou.getId().toString(), issueSou.getId().toString(), receiveSou.getId().toString());
                if (trInfo == null) {
                    return;
                }
                SaleOrgUnitInfo issueLouInfo = trInfo.getIssueSaleOrgUnit();
                SaleOrgUnitInfo supplyLouInfo = null;
                SaleOrgUnitInfo requireLouInfo = null;
                if (!"d8e80652-0117-1000-e000-04c5c0a812202407435C".equals(bizType)) {
                    if ("LyS5ouN3YEPgQAB/AQBJsCQHQ1w=".equals(bizType)) {
                        supplyLouInfo = ((TransferRule3Info)trInfo).getSupplySaleOrgUnit();
                    } else if ("LyS5ouN4YEPgQAB/AQBJsCQHQ1w=".equals(bizType)) {
                        supplyLouInfo = ((TransferRule4Info)trInfo).getSupplySaleOrgUnit();
                        requireLouInfo = ((TransferRule4Info)trInfo).getRequireSaleOrgUnit();
                    }
                }
                PriceParamInfo priceParamInfo = new PriceParamInfo();
                priceParamInfo.setCompanyOrgUnit(supplyCouInfo);
                priceParamInfo.setStorageOrgUnit(supplySou);
                priceParamInfo.setIssueCompanyOrgUnitInfo(supplyCouInfo);
                priceParamInfo.setMateial(mi);
                priceParamInfo.setCurrencyInfo(currencyInfo);
                priceParamInfo.setAssistAttirute(asstAttrInfo);
                priceParamInfo.setPricePrecision(mi.getPricePrecision());
                priceParamInfo.setSupplyRelation(srInfo);
                priceParamInfo.setQty(qty);
                priceParamInfo.setUnit(unit);
                priceParamInfo.setBaseUnit(baseUnit);
                BizTypeInfo bizTypeInfo = new BizTypeInfo();
                bizTypeInfo.setId(BOSUuid.read((String)bizType));
                priceParamInfo.setBizTypeInfo(bizTypeInfo);
                if ("d8e80652-0117-1000-e000-04c5c0a812202407435C".equals(bizType)) {
                    priceParamInfo.setBizRole(BizRoleTypeEnum.IssueSide);
                } else if ("LyS5ouN3YEPgQAB/AQBJsCQHQ1w=".equals(bizType)) {
                    priceParamInfo.setBizRole(BizRoleTypeEnum.SupplySide);
                } else if ("LyS5ouN4YEPgQAB/AQBJsCQHQ1w=".equals(bizType)) {
                    priceParamInfo.setBizRole(BizRoleTypeEnum.SupplySide);
                }
                priceParamInfo.setIssueSaleOrgUnitInfo(issueLouInfo);
                priceParamInfo.setSupplySaleOrgUnitInfo(supplyLouInfo);
                priceParamInfo.setRequireSaleOrgUnitInfo(requireLouInfo);
                priceParamInfo.setIssueStorageOrgUnitInfo(issueSou);
                priceParamInfo.setIssueWarehsInfo(invtInfo.getWarehouse());
                priceParamInfo.setExchangeRageInfo(exchangeRateInfo);
                CompanyOrgUnitInfo issueCou = supplyCouInfo;
                if (issueSou == null || issueCou == null) {
                    priceParamInfo.setCalType(null);
                    priceParamInfo.setMoveAverage(false);
                } else {
                    priceParamInfo.setMoveAverage(this.isMoveAverage(mi.getId().toString(), issueCou.getId().toString(), fetchData, context));
                    priceParamInfo.setCalType(fetchData.getParamValue(issueCou.getId().toString(), "SCM_CAL_002"));
                }
                MultiSidesTransferPriceFacadeFactory.getLocalInstance(context).getPrice(priceParamInfo);
            }
        }
    }

    private boolean isMoveAverage(String materialId, String companyId, SCMFetchData fetchData, Context ctx) throws BOSException {
        MaterialCompanyInfoInfo matCouInfo = fetchData.getMaterialCompany(materialId, companyId);
        return matCouInfo == null ? false : AccountType.MOVE_ADD_AVERAGE.equals((Object)matCouInfo.getAccountType());
    }

    public SupplyRelationInfo getSupplyRelation(Context ctx, String supplySouId, String reqSouId, String issueSouId, String recSouId) throws EASBizException, BOSException {
        FilterInfo filter = new FilterInfo();
        filter.appendFilterItem("supplyStorageOrgUnit", (Object)supplySouId);
        filter.appendFilterItem("requireStorageOrgUnit", (Object)reqSouId);
        filter.appendFilterItem("issueStorageOrgUnit", (Object)issueSouId);
        filter.appendFilterItem("receiveStorageOrgUnit", (Object)recSouId);
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filter);
        view.getSelector().addObjectCollection((IObjectCollection)this.getSupplyRelationSelector());
        ISupplyRelation isr = SupplyRelationFactory.getLocalInstance(ctx);
        SupplyRelationCollection col = isr.getSupplyRelationCollection(view);
        if (col != null && col.size() > 0) {
            return col.get(0);
        }
        return null;
    }

    private SelectorItemCollection getSupplyRelationSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("supplyStorageOrgUnit.id");
        sic.add("supplyStorageOrgUnit.name");
        sic.add("supplyStorageOrgUnit.number");
        sic.add("requireStorageOrgUnit.id");
        sic.add("requireStorageOrgUnit.name");
        sic.add("requireStorageOrgUnit.number");
        sic.add("issueStorageOrgUnit.id");
        sic.add("issueStorageOrgUnit.name");
        sic.add("issueStorageOrgUnit.number");
        sic.add("receiveStorageOrgUnit.id");
        sic.add("receiveStorageOrgUnit.name");
        sic.add("receiveStorageOrgUnit.number");
        sic.add("supplyCompanyOrgUnit.id");
        sic.add("supplyCompanyOrgUnit.name");
        sic.add("supplyCompanyOrgUnit.number");
        sic.add("requireCompanyOrgUnit.id");
        sic.add("requireCompanyOrgUnit.name");
        sic.add("requireCompanyOrgUnit.number");
        sic.add("issueCompanyOrgUnit.id");
        sic.add("issueCompanyOrgUnit.name");
        sic.add("issueCompanyOrgUnit.number");
        sic.add("receiveCompanyOrgUnit.id");
        sic.add("receiveCompanyOrgUnit.name");
        sic.add("receiveCompanyOrgUnit.number");
        return sic;
    }

    private ITransferRule getTransferRuleByType(Context ctx, String bizTypeId) throws BOSException {
        if ("d8e80652-0117-1000-e000-04c5c0a812202407435C".equals(bizTypeId)) {
            return TransferRule2Factory.getLocalInstance(ctx);
        }
        if ("LyS5ouN3YEPgQAB/AQBJsCQHQ1w=".equals(bizTypeId)) {
            return TransferRule3Factory.getLocalInstance(ctx);
        }
        if ("LyS5ouN4YEPgQAB/AQBJsCQHQ1w=".equals(bizTypeId)) {
            return TransferRule4Factory.getLocalInstance(ctx);
        }
        return null;
    }

    public TransferRuleInfo getTransferRule(Context ctx, String bizTypeId, String supplySouId, String reqSouId, String issueSouId, String recSouId) throws EASBizException, BOSException {
        if (bizTypeId == null || supplySouId == null) {
            return null;
        }
        FilterInfo filter = new FilterInfo();
        filter.appendFilterItem("bizType", (Object)bizTypeId);
        filter.appendFilterItem("status", (Object)new Integer(1));
        filter.appendFilterItem("supplyRelation.supplyStorageOrgUnit", (Object)supplySouId);
        filter.appendFilterItem("supplyRelation.requireStorageOrgUnit", (Object)reqSouId);
        filter.appendFilterItem("supplyRelation.issueStorageOrgUnit", (Object)issueSouId);
        filter.appendFilterItem("supplyRelation.receiveStorageOrgUnit", (Object)recSouId);
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filter);
        view.getSelector().addObjectCollection((IObjectCollection)this.getTransferRuleSelector(bizTypeId));
        TransferRuleCollection col = this.getTransferRuleByType(ctx, bizTypeId).getTransferRuleCollection(view);
        if (col != null && col.size() > 0) {
            return col.get(0);
        }
        return null;
    }

    private SelectorItemCollection getTransferRuleSelector(String bizTypeId) {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("supplyRelation.supplyStorageOrgUnit.id");
        sic.add("supplyRelation.supplyStorageOrgUnit.name");
        sic.add("supplyRelation.supplyStorageOrgUnit.number");
        sic.add("supplyRelation.requireStorageOrgUnit.id");
        sic.add("supplyRelation.requireStorageOrgUnit.name");
        sic.add("supplyRelation.requireStorageOrgUnit.number");
        sic.add("supplyRelation.issueStorageOrgUnit.id");
        sic.add("supplyRelation.issueStorageOrgUnit.name");
        sic.add("supplyRelation.issueStorageOrgUnit.number");
        sic.add("supplyRelation.receiveStorageOrgUnit.id");
        sic.add("supplyRelation.receiveStorageOrgUnit.name");
        sic.add("supplyRelation.receiveStorageOrgUnit.number");
        sic.add("supplyRelation.id");
        sic.add("issueSaleOrgUnit.id");
        sic.add("issueSaleOrgUnit.name");
        sic.add("issueSaleOrgUnit.number");
        sic.add("bizType.id");
        sic.add("bizType.name");
        sic.add("bizType.number");
        if ("LyS5ouN3YEPgQAB/AQBJsCQHQ1w=".equals(bizTypeId) || "LyS5ouN4YEPgQAB/AQBJsCQHQ1w=".equals(bizTypeId)) {
            sic.add("supplySaleOrgUnit.id");
            sic.add("supplySaleOrgUnit.name");
            sic.add("supplySaleOrgUnit.number");
            if ("LyS5ouN4YEPgQAB/AQBJsCQHQ1w=".equals(bizTypeId)) {
                sic.add("requireSaleOrgUnit.id");
                sic.add("requireSaleOrgUnit.name");
                sic.add("requireSaleOrgUnit.number");
            }
        }
        return sic;
    }

    protected SCMFetchDataCondition buildCondition(InventoryInfo[] invs) {
        SCMFetchDataCondition condition = new SCMFetchDataCondition();
        if (this.isFetchData()) {
            condition.setFetchMaterial(true);
            condition.setFetchID(true);
            condition.setFetchNumber(true);
            condition.setFetchName(true);
            condition.setFetchBaseUnit(true);
            condition.setFetchAssistUnit(true);
            condition.setFetchAsstAttrType(true);
            condition.setFetchModel(true);
            condition.setFetchPricePrecision(true);
            condition.setFetchSou(true);
            condition.setFetchIsLotNumber(true);
            condition.setFetchIsSequenceNo(true);
            condition.setFetchIsPeriodValid(true);
            condition.setFetchIsNegative(true);
            condition.setFetchInventoryUnit(true);
            condition.setFetchIssuePriorityMode(true);
            condition.setFetchCompany(true);
            condition.setFetchAccountType(true);
            condition.setFetchStandardCost(true);
            condition.setFetchCompanyStatus(true);
            condition.setFetchStocker(true);
            condition.setFetchUnitPrecision(true);
            condition.setFetchBaseUnitPrecision(true);
            condition.setFetchAsstUnitPrecision(true);
            condition.setFetchDefaultLocation(true);
            this.setConditionContents(condition, invs);
        }
        return condition;
    }

    protected boolean isFetchData() {
        return true;
    }

    protected void setConditionContents(SCMFetchDataCondition condition, InventoryInfo[] invs) {
        int arryLength = invs.length;
        String[] materialPKs = new String[arryLength];
        String[] unitPKs = new String[arryLength];
        String[] baseUnitPKs = new String[arryLength];
        String[] asstUnitPKs = new String[arryLength];
        String[] warehousePKs = new String[arryLength];
        int cursor = 0;
        for (int i = 0; i < arryLength; ++i) {
            WarehouseInfo warehouse;
            MeasureUnitInfo asstUnit;
            MeasureUnitInfo baseUnit;
            MaterialInfo material = invs[i].getMaterial();
            if (material == null) continue;
            materialPKs[cursor] = material.getId().toString();
            MeasureUnitInfo unit = invs[i].getUnit();
            if (unit != null) {
                unitPKs[cursor] = unit.getId().toString();
            }
            if ((baseUnit = invs[i].getBaseUnit()) != null) {
                baseUnitPKs[cursor] = baseUnit.getId().toString();
            }
            if ((asstUnit = invs[i].getAssistUnit()) != null && asstUnit.toString() != null && asstUnit.toString().length() > 0) {
                asstUnitPKs[cursor] = asstUnit.getId().toString();
            }
            if ((warehouse = invs[i].getWarehouse()) != null) {
                warehousePKs[cursor] = warehouse.getId().toString();
            }
            ++cursor;
        }
        condition.setMaterialPKs(materialPKs);
        condition.setUnitPKs(unitPKs);
        condition.setBaseUnitPKs(baseUnitPKs);
        condition.setAsstUnitPKs(asstUnitPKs);
        condition.setWarehousePKs(warehousePKs);
        condition.setSou(invs[0].getStorageOrgUnit());
        condition.setCou(invs[0].getCompanyOrgUnit());
    }

    @Override
    protected void _handleActionSNsplit(RequestContext request, ResponseContext response, Context context) throws Exception {
    }

    @Override
    protected void _handleActionSerialNumber(RequestContext request, ResponseContext response, Context context) throws Exception {
    }

    @Override
    protected void _handleActionCalculateLot(RequestContext request, ResponseContext response, Context context) throws Exception {
    }

    @Override
    protected void _handleActionCalculateDynQty(RequestContext request, ResponseContext response, Context context) throws Exception {
    }

    protected void fillCouBySou(RequestContext request, ResponseContext response, Context ctx) throws Exception {
        StockTransferBillInfo invInfo = (StockTransferBillInfo)request.getValue();
        String souId = (String)request.get("STORAGE_ORGUNIT_ID");
        if ((invInfo == null || invInfo.getIssueStorageOrgUnit() == null) && souId == null || request.get("INV_MAIN_COU") != null) {
            return;
        }
        BOSUuid souPk = souId == null ? invInfo.getIssueStorageOrgUnit().getId() : BOSUuid.read((String)souId);
        SCMBillCommonFacadeFactory.getLocalInstance((Context)ctx).getCompanyInfo(souPk);
    }
}

