/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.codingrule.CodingRuleInfo;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.framework.CUIDGetterFacadeFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.StorageOrgUnitFactory;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.basedata.scm.common.BillTypeInfo;
import com.kingdee.eas.basedata.scm.common.BizTypeInfo;
import com.kingdee.eas.basedata.scm.common.util.SCMBaseCommonUtil;
import com.kingdee.eas.basedata.scm.im.inv.StoreStateFactory;
import com.kingdee.eas.basedata.scm.im.inv.StoreStateInfo;
import com.kingdee.eas.basedata.scm.im.inv.StoreTypeFactory;
import com.kingdee.eas.basedata.scm.im.inv.StoreTypeInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.scm.basedatautil.master.OrgUnitUtil;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.common.EntryBaseStatusEnum;
import com.kingdee.eas.scm.common.ISCMBillBase;
import com.kingdee.eas.scm.common.SMSDBillConfigInfo;
import com.kingdee.eas.scm.im.inv.StockTransferBillEntryInfo;
import com.kingdee.eas.scm.im.inv.StockTransferBillFactory;
import com.kingdee.eas.scm.im.inv.StockTransferBillInfo;
import com.kingdee.eas.scm.im.inv.app.AbstractStockTransferWebFacadeControllerBean;
import com.kingdee.eas.scm.util.InvWebUtils;
import com.kingdee.eas.scm.util.constant.OprtStateConstant;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class StockTransferWebFacadeControllerBean
extends AbstractStockTransferWebFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.scm.im.inv.app.StockTransferWebFacadeControllerBean");
    private static final BigDecimal ZERO = new BigDecimal("0.00");
    private static final String CLASSNAME = "com.kingdee.eas.scm.im.inv.client.StockTransferBillEditUI";

    public IObjectValue createNewData(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        StorageOrgUnitInfo sou = null;
        CompanyOrgUnitInfo cou = null;
        PeriodInfo periodInfo = null;
        StockTransferBillInfo info = new StockTransferBillInfo();
        UserInfo userInfo = UserFactory.getLocalInstance((Context)ctx).getUserInfo(ctx.getCaller());
        info.setNumber(null);
        info.setBaseStatus(BillBaseStatusEnum.ADD);
        info.setBizDate(new Date());
        Map userConfigMap = InvWebUtils.takeConfigType((String)CLASSNAME, (String)userInfo.getId().toString());
        SMSDBillConfigInfo configInfo = (SMSDBillConfigInfo)userConfigMap.get("stockTransferBillDefalutBizType");
        String defaultBizType = "d8e80652-011b-1000-e000-04c5c0a812202407435C";
        if (configInfo != null) {
            defaultBizType = configInfo.getConfigValue();
        }
        BizTypeInfo bizType = SCMBaseCommonUtil.getDefaultBizTypeInfo(null, (String)defaultBizType, (String)"50957179-0105-1000-e003-3152c0a812fd463ED552");
        info.setBizType(bizType);
        sou = (StorageOrgUnitInfo)this.getDefaultMainBizOrg(ctx);
        if (sou == null) {
            return info;
        }
        cou = OrgUnitUtil.getCompanyFromStorage((Context)ctx, (StorageOrgUnitInfo)sou);
        if (cou != null) {
            info.setIssueStorageOrgUnit(sou);
            info.setReceiptStorageOrgUnit(sou);
            info.setIssueCompanyOrgUnit(cou);
            info.setReceiptCompanyOrgUnit(cou);
            periodInfo = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.INVENTORYMANAGEMENT, (CompanyOrgUnitInfo)cou);
        }
        info.setCreator(userInfo);
        info.setCreateTime(new Timestamp(new Date().getTime()));
        BillTypeInfo billTypeInfo = new BillTypeInfo();
        billTypeInfo.setId(BOSUuid.read((String)"50957179-0105-1000-e003-3152c0a812fd463ED552"));
        info.setBillType(billTypeInfo);
        if (periodInfo != null) {
            info.setYear(periodInfo.getPeriodYear());
            info.setPeriod(periodInfo.getPeriodNumber());
        } else {
            info.setYear(Calendar.getInstance().get(1));
            info.setPeriod(Calendar.getInstance().get(3));
        }
        if (info.getEntry() != null) {
            StockTransferBillEntryInfo entry = null;
            for (int i = 0; i < 5; ++i) {
                entry = (StockTransferBillEntryInfo)this.createNewDetailData(ctx, model);
                entry.setIssueCompanyOrgUnit(cou);
                entry.setIssueStorageOrgUnit(sou);
                entry.setReceiveCompanyOrgUnit(cou);
                entry.setReceiveStorageOrgUnit(sou);
                info.getEntry().add(entry);
            }
        }
        info.setCU(info.getIssueStorageOrgUnit().getCU());
        return info;
    }

    public IObjectValue createNewDetailData(Context ctx, IObjectValue model) throws EASBizException, BOSException {
        StockTransferBillEntryInfo entry = new StockTransferBillEntryInfo();
        entry.setIsMrpCal(true);
        entry.setAssistQty(ZERO);
        StoreTypeInfo storeType = StoreTypeFactory.getLocalInstance((Context)ctx).getStoreTypeInfo((IObjectPK)new ObjectUuidPK("181875d5-0105-1000-e000-0111c0a812fd97D461A6"));
        entry.setStoreType(storeType);
        StoreStateInfo storeState = StoreStateFactory.getLocalInstance((Context)ctx).getStoreStateInfo((IObjectPK)new ObjectUuidPK("181875d5-0105-1000-e000-012ec0a812fd62A73FA5"));
        entry.setStoreState(storeState);
        entry.setIsPresent(false);
        entry.setPrice(ZERO);
        entry.setAmount(ZERO);
        entry.setReceiptPlanDate(new Date());
        entry.setIssuePlanDate(new Date());
        entry.setTotalPlanDQty(ZERO);
        entry.setIssueQty(ZERO);
        entry.setReceiptQty(ZERO);
        entry.setBaseStatus(EntryBaseStatusEnum.ADD);
        entry.setQuarityUnCtrl(false);
        entry.setQuarityOverRate(ZERO);
        entry.setQuarityArreRate(ZERO);
        return entry;
    }

    public Map getInitData(Context ctx, IObjectValue model, String oprtState) throws BOSException, EASBizException {
        Map initData = super.getInitData(ctx, model, oprtState);
        StockTransferBillInfo info = (StockTransferBillInfo)model;
        Date serverDate = info.getBizDate();
        StoreTypeInfo storeType = StoreTypeFactory.getLocalInstance((Context)ctx).getStoreTypeInfo((IObjectPK)new ObjectUuidPK("181875d5-0105-1000-e000-0111c0a812fd97D461A6"));
        StoreStateInfo storeState = StoreStateFactory.getLocalInstance((Context)ctx).getStoreStateInfo((IObjectPK)new ObjectUuidPK("181875d5-0105-1000-e000-012ec0a812fd62A73FA5"));
        initData.put("storeType", storeType);
        initData.put("storeState", storeState);
        initData.put("baseStatus", EntryBaseStatusEnum.ADD);
        initData.put("serverDate", serverDate);
        if (info.getIssueStorageOrgUnit() == null) {
            return initData;
        }
        CompanyOrgUnitInfo cou = this.getCouBySou(ctx, info.getIssueStorageOrgUnit().getId().toString());
        initData.put("cou", cou);
        initData.put("baseCurrency", this.getBaseCurrencyByCou(ctx, cou));
        info.setCU(info.getIssueStorageOrgUnit().getCU());
        ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
        CodingRuleInfo ruleInfo = iCodingRuleManager.getCodingRule((IObjectValue)new StockTransferBillInfo(), info.getIssueStorageOrgUnit().getId().toString());
        if (ruleInfo != null) {
            initData.put("numberIsEdit", ruleInfo.isIsModifiable());
            if (info.getSourceBillType() != null && info.getBaseStatus().equals((Object)BillBaseStatusEnum.ADD) && ruleInfo.isIsAddView()) {
                initData.put("addNewNumber", iCodingRuleManager.getNumber(model, info.getIssueStorageOrgUnit().getId().toString()));
            }
        }
        Map paramMap = this.batchGetParamValue(ctx, info.getIssueStorageOrgUnit().getId().toString(), new String[]{"INM004", "INM008"});
        initData.put("params", paramMap);
        return initData;
    }

    @Override
    protected Map _getDataForOrgChanged(Context ctx, Map requestMap) throws BOSException, EASBizException {
        HashMap<String, Object> responseMap = new HashMap<String, Object>();
        String orgId = (String)requestMap.get("orgId");
        CompanyOrgUnitInfo cou = this.getCouBySou(ctx, orgId);
        if (cou == null) {
            return responseMap;
        }
        CurrencyInfo baseCurr = this.getBaseCurrencyByCou(ctx, cou);
        int baseCurrPresion = 2;
        if (null != baseCurr) {
            baseCurrPresion = baseCurr.getPrecision();
        }
        responseMap.put("cou", cou);
        String bizOrgCUID = CUIDGetterFacadeFactory.getLocalInstance((Context)ctx).getCUID(orgId);
        responseMap.put("bizOrgCUID", bizOrgCUID);
        StorageOrgUnitInfo sou = StorageOrgUnitFactory.getLocalInstance((Context)ctx).getStorageOrgUnitInfo((IObjectPK)new ObjectUuidPK(orgId));
        ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
        CodingRuleInfo ruleInfo = iCodingRuleManager.getCodingRule((IObjectValue)new StockTransferBillInfo(), sou.getId().toString());
        if (ruleInfo != null) {
            responseMap.put("numberIsEdit", ruleInfo.isIsModifiable());
            responseMap.put("isIsAddView", ruleInfo.isIsAddView());
            responseMap.put("addNewNumber", iCodingRuleManager.getNumber((IObjectValue)new StockTransferBillInfo(), sou.getId().toString()));
        }
        Map paramMap = this.batchGetParamValue(ctx, orgId, new String[]{"INM004"});
        responseMap.put("params", paramMap);
        responseMap.put("baseCurrency", baseCurr);
        return responseMap;
    }

    protected ISCMBillBase getLocalInstance(Context context) throws BOSException {
        return StockTransferBillFactory.getLocalInstance(context);
    }

    public String getPermissionItem() {
        if (OprtStateConstant.ADDNEW.equals(this.oprtState)) {
            return "stocktransfer_new";
        }
        if (OprtStateConstant.EDIT.equals(this.oprtState)) {
            return "stocktransfer_udpate";
        }
        if (OprtStateConstant.VIEW.equals(this.oprtState)) {
            return "stocktransfer_view";
        }
        return "stocktransfer_new";
    }

    public OrgType getMainOrgType() {
        return OrgType.Storage;
    }

    public String getMainOrgUnitName() {
        return "issueStorageOrgUnit";
    }
}

