/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.scm.im.inv.ISupplyRelation;
import com.kingdee.eas.scm.im.inv.MultiSidesTransferException;
import com.kingdee.eas.scm.im.inv.SupplyRelationCollection;
import com.kingdee.eas.scm.im.inv.SupplyRelationFactory;
import com.kingdee.eas.scm.im.inv.SupplyRelationInfo;
import com.kingdee.eas.scm.im.inv.app.AbstractSupplyRelationControllerBean;
import org.apache.log4j.Logger;

public class SupplyRelationControllerBean
extends AbstractSupplyRelationControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.scm.im.inv.app.SupplyRelationControllerBean");

    @Override
    protected IObjectCollection _getCollectionByReqStorage(Context ctx, String reqStorageID) throws BOSException, EASBizException {
        SupplyRelationCollection supplyRelations = new SupplyRelationCollection();
        ISupplyRelation isr = SupplyRelationFactory.getLocalInstance(ctx);
        supplyRelations = isr.getSupplyRelationCollection(this.getOql("requireStorageOrgUnit", reqStorageID));
        return supplyRelations;
    }

    @Override
    protected IObjectCollection _getCollectionBySupStorage(Context ctx, String supStorageID) throws BOSException, EASBizException {
        SupplyRelationCollection supplyRelations = new SupplyRelationCollection();
        ISupplyRelation isr = SupplyRelationFactory.getLocalInstance(ctx);
        supplyRelations = isr.getSupplyRelationCollection(this.getOql("supplyStorageOrgUnit", supStorageID));
        return supplyRelations;
    }

    private String getOql(String fieldName, String storageID) {
        StringBuffer sb = new StringBuffer();
        sb.append(" select id, requireCompanyOrgUnit.id, requireCompanyOrgUnit.number, requireCompanyOrgUnit.name,");
        sb.append(" requireCompanyOrgUnit.cu.id, requireCompanyOrgUnit.cu.number, requireCompanyOrgUnit.cu.name,");
        sb.append(" receiveCompanyOrgUnit.id, receiveCompanyOrgUnit.number, receiveCompanyOrgUnit.name,");
        sb.append(" receiveCompanyOrgUnit.cu.id, receiveCompanyOrgUnit.cu.number, receiveCompanyOrgUnit.cu.name,");
        sb.append(" supplyCompanyOrgUnit.id, supplyCompanyOrgUnit.number, supplyCompanyOrgUnit.name,");
        sb.append(" supplyCompanyOrgUnit.cu.id, supplyCompanyOrgUnit.cu.number, supplyCompanyOrgUnit.cu.name,");
        sb.append(" issueCompanyOrgUnit.id, issueCompanyOrgUnit.number, issueCompanyOrgUnit.name,");
        sb.append(" issueCompanyOrgUnit.cu.id, issueCompanyOrgUnit.cu.number, issueCompanyOrgUnit.cu.name,");
        sb.append(" issueStorageOrgUnit.id, issueStorageOrgUnit.number, issueStorageOrgUnit.name,");
        sb.append(" issueStorageOrgUnit.cu.id, issueStorageOrgUnit.cu.number, issueStorageOrgUnit.cu.name,");
        sb.append(" supplyStorageOrgUnit.id, supplyStorageOrgUnit.number, supplyStorageOrgUnit.name,");
        sb.append(" supplyStorageOrgUnit.cu.id, supplyStorageOrgUnit.cu.number, supplyStorageOrgUnit.cu.name,");
        sb.append(" receiveStorageOrgUnit.id,receiveStorageOrgUnit.number,receiveStorageOrgUnit.name,");
        sb.append(" receiveStorageOrgUnit.cu.id, receiveStorageOrgUnit.cu.number, receiveStorageOrgUnit.cu.name,");
        sb.append(" requireStorageOrgUnit.id,requireStorageOrgUnit.number,requireStorageOrgUnit.name,");
        sb.append(" requireStorageOrgUnit.cu.id, requireStorageOrgUnit.cu.number, requireStorageOrgUnit.cu.name");
        sb.append(" where ");
        sb.append(fieldName);
        sb.append(".id = '");
        sb.append(storageID);
        sb.append("'");
        return sb.toString();
    }

    private void verifyDuplicate(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        SupplyRelationInfo supplyRelation = (SupplyRelationInfo)model;
        String requireStorageOrgUnitID = supplyRelation.getRequireStorageOrgUnit().getId().toString();
        String receiveStorageOrgUnitID = supplyRelation.getReceiveStorageOrgUnit().getId().toString();
        String supplyStorageOrgUnitID = supplyRelation.getSupplyStorageOrgUnit().getId().toString();
        String issueStorageOrgUnitID = supplyRelation.getIssueStorageOrgUnit().getId().toString();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("requireStorageOrgUnit.id", (Object)requireStorageOrgUnitID));
        filter.getFilterItems().add(new FilterItemInfo("receiveStorageOrgUnit.id", (Object)receiveStorageOrgUnitID));
        filter.getFilterItems().add(new FilterItemInfo("supplyStorageOrgUnit.id", (Object)supplyStorageOrgUnitID));
        filter.getFilterItems().add(new FilterItemInfo("issueStorageOrgUnit.id", (Object)issueStorageOrgUnitID));
        if (pk != null) {
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)pk.toString(), CompareType.NOTEQUALS));
        }
        if (this._exists(ctx, filter)) {
            throw new MultiSidesTransferException(MultiSidesTransferException.STORAGEORGDUPLICATE);
        }
    }

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        this.verifyDuplicate(ctx, null, model);
        return super._addnew(ctx, model);
    }

    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        this.verifyDuplicate(ctx, pk, model);
        super._update(ctx, pk, model);
    }
}

