/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.basedata.assistant.ConvertModeEnum;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ExchangeRateInfo;
import com.kingdee.eas.basedata.assistant.ExchangeTableInfo;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.material.AccountType;
import com.kingdee.eas.basedata.master.material.AsstAttrValueInfo;
import com.kingdee.eas.basedata.master.material.IMaterialCompanyInfo;
import com.kingdee.eas.basedata.master.material.MaterialCompanyInfoCollection;
import com.kingdee.eas.basedata.master.material.MaterialCompanyInfoFactory;
import com.kingdee.eas.basedata.master.material.MaterialCompanyInfoInfo;
import com.kingdee.eas.basedata.master.material.MaterialFactory;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.UsedStatusEnum;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.SaleOrgUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.basedata.scm.common.BizTypeInfo;
import com.kingdee.eas.basedata.scm.im.inv.WarehouseInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.scm.common.SCMBillCommonFacadeFactory;
import com.kingdee.eas.scm.common.app.SCMServerUtils;
import com.kingdee.eas.scm.common.util.SCMConstant;
import com.kingdee.eas.scm.im.inv.BizRoleTypeEnum;
import com.kingdee.eas.scm.im.inv.IMultiSidesTransferPriceFacade;
import com.kingdee.eas.scm.im.inv.ISupplyRelation;
import com.kingdee.eas.scm.im.inv.ITransferRule;
import com.kingdee.eas.scm.im.inv.InvBizException;
import com.kingdee.eas.scm.im.inv.MultiSidesTransferPriceFacadeFactory;
import com.kingdee.eas.scm.im.inv.PriceInfo;
import com.kingdee.eas.scm.im.inv.PriceParamInfo;
import com.kingdee.eas.scm.im.inv.StockReqFactory;
import com.kingdee.eas.scm.im.inv.StockReqInfo;
import com.kingdee.eas.scm.im.inv.SupplyRelationCollection;
import com.kingdee.eas.scm.im.inv.SupplyRelationFactory;
import com.kingdee.eas.scm.im.inv.SupplyRelationInfo;
import com.kingdee.eas.scm.im.inv.TransferOrderAlgorithm;
import com.kingdee.eas.scm.im.inv.TransferOrderBillEntryInfo;
import com.kingdee.eas.scm.im.inv.TransferOrderBillInfo;
import com.kingdee.eas.scm.im.inv.TransferRule2Factory;
import com.kingdee.eas.scm.im.inv.TransferRule3Factory;
import com.kingdee.eas.scm.im.inv.TransferRule3Info;
import com.kingdee.eas.scm.im.inv.TransferRule4Factory;
import com.kingdee.eas.scm.im.inv.TransferRule4Info;
import com.kingdee.eas.scm.im.inv.TransferRuleCollection;
import com.kingdee.eas.scm.im.inv.TransferRuleInfo;
import com.kingdee.eas.scm.im.inv.app.PurInWarehsServerutils;
import com.kingdee.eas.util.app.ContextUtil;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;

class TransferOrderAlgorithmForInfo
extends TransferOrderAlgorithm {
    private TransferOrderBillInfo info;
    private int amountPrecision = 2;
    private int localAmountPrecision = 2;
    private Map<String, MaterialCompanyInfoInfo> matCouMap = new HashMap<String, MaterialCompanyInfoInfo>();

    public TransferOrderAlgorithmForInfo(TransferOrderBillInfo info, Context ctx) {
        this.info = info;
        this.ctx = ctx;
    }

    public void revalue() throws Exception {
        StorageOrgUnitInfo sou = this.info.getIssueStorageOrgUnit();
        if (sou == null) {
            sou = (StorageOrgUnitInfo)ContextUtil.getCurrentOrgUnit((Context)this.ctx, (OrgType)OrgType.Storage);
        }
        this.info.setIssueStorageOrgUnit(sou);
        if (this.info.getReceiptStorageOrgUnit() == null && this.ctx.get((Object)"TO_REQUIRESTOREAGEORGUNIT") != null && this.ctx.get((Object)"TO_REQUIRESTOREAGEORGUNIT") instanceof StorageOrgUnitInfo) {
            this.info.setReceiptStorageOrgUnit((StorageOrgUnitInfo)this.ctx.get((Object)"TO_REQUIRESTOREAGEORGUNIT"));
        }
        if (this.info.getReceiptCompanyOrgUnit() == null && this.ctx.get((Object)"TO_REQUIRECOMPNAYORGUNIT") != null && this.ctx.get((Object)"TO_REQUIRECOMPNAYORGUNIT") instanceof CompanyOrgUnitInfo) {
            this.info.setReceiptCompanyOrgUnit((CompanyOrgUnitInfo)this.ctx.get((Object)"TO_REQUIRECOMPNAYORGUNIT"));
        }
        if (this.info.getReceiptStorageOrgUnit() == null && this.info.getSourceBillType() != null && "MmEE6VBsR0KaUDQmebwhP0Y+1VI=".equals(this.info.getSourceBillType().getId().toString()) && this.info.getEntry() != null && this.info.getEntry().get(0) != null && this.info.getEntry().get(0).getSourceBillId() != null) {
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("reqStorage.id"));
            sic.add(new SelectorItemInfo("reqStorage.number"));
            sic.add(new SelectorItemInfo("reqStorage.name"));
            sic.add(new SelectorItemInfo("reqCompany.id"));
            sic.add(new SelectorItemInfo("reqCompany.number"));
            sic.add(new SelectorItemInfo("reqCompany.name"));
            StockReqInfo sourceInfo = StockReqFactory.getLocalInstance(this.ctx).getStockReqInfo((IObjectPK)new ObjectUuidPK(this.info.getEntry().get(0).getSourceBillId()), sic);
            if (sourceInfo != null) {
                if (sourceInfo.getReqStorage() != null) {
                    this.info.setReceiptStorageOrgUnit(sourceInfo.getReqStorage());
                }
                if (sourceInfo.getReqCompany() != null) {
                    this.info.setReceiptCompanyOrgUnit(sourceInfo.getReqCompany());
                }
            }
        }
        CompanyOrgUnitInfo cou = null;
        if (sou != null) {
            cou = PurInWarehsServerutils.getCompany(this.ctx, sou);
        } else if (this.info.getEntry().get(0).getIssueCompanyOrgUnit() != null) {
            cou = this.info.getEntry().get(0).getIssueCompanyOrgUnit();
        }
        if (cou == null) {
            throw new InvBizException(InvBizException.COMPANYISNULL);
        }
        String oql = "SELECT id, number, name, baseCurrency.id, baseCurrency.number, baseCurrency.name, baseCurrency.precision WHERE id ='" + cou.getId().toString() + "'";
        cou = CompanyOrgUnitFactory.getLocalInstance((Context)this.ctx).getCompanyOrgUnitInfo(oql);
        this.info.setIssueCompanyOrgUnit(cou);
        this.localAmountPrecision = cou.getBaseCurrency().getPrecision();
        if (this.info.getCurrency() == null) {
            this.info.setCurrency(this.info.getIssueCompanyOrgUnit().getBaseCurrency());
        }
        if (this.info.getSourceBillType() != null && "MmEE6VBsR0KaUDQmebwhP0Y+1VI=".equals(this.info.getSourceBillType().getId().toString()) && (this.info.getExchangeRate() == null || BigDecimal.ZERO.compareTo(this.info.getExchangeRate()) == 0)) {
            if (this.info.getCurrency().getId().equals((Object)cou.getBaseCurrency().getId())) {
                this.info.setExchangeRate(new BigDecimal("1.00"));
            } else {
                ObjectUuidPK sourceCurrPK = null;
                ObjectUuidPK destCurrPK = null;
                sourceCurrPK = new ObjectUuidPK(this.info.getCurrency().getId());
                ExchangeRateInfo tempexrateinfo = SCMServerUtils.getExchangeRate((Context)this.ctx, (CompanyOrgUnitInfo)cou, (IObjectPK)sourceCurrPK, (IObjectPK)(destCurrPK = new ObjectUuidPK(cou.getBaseCurrency().getId())));
                if (tempexrateinfo != null) {
                    this.info.setExchangeRate(tempexrateinfo.getConvertRate());
                }
            }
        }
        CurrencyInfo currency = (CurrencyInfo)CurrencyFactory.getLocalInstance((Context)this.ctx).getValue("SELECT id, precision WHERE id = '" + this.info.getCurrency().getId().toString() + "'");
        this.info.setCurrency(currency);
        this.amountPrecision = this.info.getCurrency().getPrecision();
        this.resetEntryMaterialInfo();
        if (this.info.get("isInTax") == null) {
            this.info.setIsInTax(true);
        }
        if (this.info.isIsInTax() && this.info.getEntry().get(0).getTaxPrice() == null || this.info.getEntry().get(0).getTaxPrice() != null && this.info.getEntry().get(0).getTaxPrice().compareTo(SysConstant.BIGZERO) == 0 || !this.info.isIsInTax() && this.info.getEntry().get(0).getPrice() == null || this.info.getEntry().get(0).getPrice() != null && this.info.getEntry().get(0).getPrice().compareTo(SysConstant.BIGZERO) == 0) {
            this.reValueTransferPrice();
        }
        this.reCalEntryFields();
    }

    @Override
    protected BigDecimal getAmount(int i) {
        return this.getBigDecimal("amount", i);
    }

    @Override
    protected int getAmountPrecision() {
        return this.amountPrecision;
    }

    @Override
    protected MeasureUnitInfo getAssistUnit(int i) {
        return this.info.getEntry().get(i).getAssistUnit();
    }

    @Override
    protected BigDecimal getBaseQty(int i) {
        return this.getBigDecimal("baseQty", i);
    }

    @Override
    protected ConvertModeEnum getConvertMode() {
        return ConvertModeEnum.DIRECTEXCHANGERATE;
    }

    @Override
    protected BigDecimal getDiscountAmount(int i) {
        return this.getBigDecimal("discountAmount", i);
    }

    @Override
    protected BigDecimal getDiscountRate(int i) {
        return this.getBigDecimal("discountRate", i);
    }

    @Override
    protected int getEntrySize() {
        return this.info.getEntry().size();
    }

    @Override
    protected BigDecimal getExchangeRate() {
        return this.info.getExchangeRate() == null ? SCMConstant.BIGDECIMAL_ONE : this.info.getExchangeRate();
    }

    @Override
    protected int getLocalAmountPrecision() {
        return this.localAmountPrecision;
    }

    @Override
    protected MaterialInfo getMaterial(int i) {
        return this.info.getEntry().get(i).getMaterial();
    }

    @Override
    protected WarehouseInfo getWarehouse(int i) {
        return this.info.getEntry().get(i).getIssueWarehouse();
    }

    @Override
    protected BigDecimal getPrice(int i) {
        return this.getBigDecimal("price", i);
    }

    @Override
    protected int getPricePrecision(int i) {
        return this.info.getEntry().get(i).getMaterial().getPricePrecision();
    }

    @Override
    protected BigDecimal getQty(int i) {
        return this.getBigDecimal("qty", i);
    }

    @Override
    protected BigDecimal getTax(int i) {
        return this.getBigDecimal("tax", i);
    }

    @Override
    protected BigDecimal getTaxAmount(int i) {
        return this.getBigDecimal("taxAmount", i);
    }

    @Override
    protected BigDecimal getTaxPrice(int i) {
        return this.getBigDecimal("taxPrice", i);
    }

    @Override
    protected BigDecimal getTaxRate(int i) {
        return this.getBigDecimal("taxRate", i);
    }

    @Override
    protected MeasureUnitInfo getUnit(int i) {
        return this.info.getEntry().get(i).getUnit();
    }

    @Override
    protected boolean isInTax() {
        return this.info.isIsInTax();
    }

    @Override
    protected void setMaterial(MaterialInfo materialInfo, int i) {
        this.info.getEntry().get(i).setMaterial(materialInfo);
    }

    @Override
    protected void setActualPrice(BigDecimal actualPrice, int i) {
        this.info.getEntry().get(i).setActualPrice(actualPrice);
    }

    @Override
    protected void setActualTaxPrice(BigDecimal taxPrice, int i) {
        this.info.getEntry().get(i).setActualTaxPrice(taxPrice);
    }

    @Override
    protected void setAmount(BigDecimal amount, int i) {
        this.info.getEntry().get(i).setAmount(amount);
    }

    @Override
    protected void setAssistQty(BigDecimal assistQty, int i) {
        this.info.getEntry().get(i).setAssistQty(assistQty);
    }

    @Override
    protected void setBaseQty(BigDecimal baseQty, int i) {
        this.info.getEntry().get(i).setBaseQty(baseQty);
    }

    @Override
    protected void setQty(BigDecimal qty, int i) {
        this.info.getEntry().get(i).setBaseQty(qty);
    }

    @Override
    protected void setDiscountAmount(BigDecimal discountAmount, int i) {
        this.info.getEntry().get(i).setDiscountAmount(discountAmount);
    }

    @Override
    protected void setLocalAmount(BigDecimal localAmount, int i) {
        this.info.getEntry().get(i).setLocalAmount(localAmount);
    }

    @Override
    protected void setLocalTax(BigDecimal localTax, int i) {
        this.info.getEntry().get(i).setLocalTax(localTax);
    }

    @Override
    protected void setLocalTaxAmount(BigDecimal localTaxAmount, int i) {
        this.info.getEntry().get(i).setLocalTaxAmount(localTaxAmount);
    }

    @Override
    protected void setPrice(BigDecimal price, int i) {
        this.info.getEntry().get(i).setPrice(price);
    }

    @Override
    protected void setTax(BigDecimal tax, int i) {
        this.info.getEntry().get(i).setTax(tax);
    }

    @Override
    protected void setTaxAmount(BigDecimal taxAmount, int i) {
        this.info.getEntry().get(i).setTaxAmount(taxAmount);
    }

    @Override
    protected void setTaxPrice(BigDecimal taxPrice, int i) {
        this.info.getEntry().get(i).setTaxPrice(taxPrice);
    }

    private BigDecimal getBigDecimal(String fieldName, int i) {
        return this.nullToZero(this.info.getEntry().get(i).getBigDecimal(fieldName));
    }

    private String getCalType(CompanyOrgUnitInfo issueCou) throws EASBizException, BOSException {
        return ParamControlFactory.getLocalInstance((Context)this.ctx).getParamValue((IObjectPK)new ObjectUuidPK(issueCou.getId().toString()), "SCM_CAL_002");
    }

    private ExchangeRateInfo getExchangeRate(CompanyOrgUnitInfo companyOrgUnitInfo, IObjectPK sourceCurrPK, IObjectPK destCurrPK) throws EASBizException, BOSException {
        if (destCurrPK == null) {
            destCurrPK = sourceCurrPK;
        }
        ExchangeTableInfo exchangeTableInfo = companyOrgUnitInfo.getBaseExchangeTable();
        ObjectUuidPK excTablepk = null;
        if (exchangeTableInfo == null) {
            return null;
        }
        excTablepk = new ObjectUuidPK(exchangeTableInfo.getId());
        ExchangeRateInfo exchangeRateInfo = SCMBillCommonFacadeFactory.getLocalInstance((Context)this.ctx).getCurrentExchangeRate((IObjectPK)excTablepk, sourceCurrPK, destCurrPK);
        return exchangeRateInfo;
    }

    private SupplyRelationInfo getSupplyRelation(String supplySouId, String reqSouId, String issueSouId, String recSouId) throws EASBizException, BOSException {
        FilterInfo filter = new FilterInfo();
        filter.appendFilterItem("supplyStorageOrgUnit", (Object)supplySouId);
        filter.appendFilterItem("requireStorageOrgUnit", (Object)reqSouId);
        filter.appendFilterItem("issueStorageOrgUnit", (Object)issueSouId);
        filter.appendFilterItem("receiveStorageOrgUnit", (Object)recSouId);
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filter);
        view.getSelector().addObjectCollection((IObjectCollection)this.getSupplyRelationSelector());
        ISupplyRelation isr = SupplyRelationFactory.getLocalInstance(this.ctx);
        SupplyRelationCollection col = isr.getSupplyRelationCollection(view);
        return col.size() > 0 ? col.get(0) : null;
    }

    private SelectorItemCollection getSupplyRelationSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("supplyStorageOrgUnit.id");
        sic.add("supplyStorageOrgUnit.name");
        sic.add("supplyStorageOrgUnit.number");
        sic.add("requireStorageOrgUnit.id");
        sic.add("requireStorageOrgUnit.name");
        sic.add("requireStorageOrgUnit.number");
        sic.add("issueStorageOrgUnit.id");
        sic.add("issueStorageOrgUnit.name");
        sic.add("issueStorageOrgUnit.number");
        sic.add("receiveStorageOrgUnit.id");
        sic.add("receiveStorageOrgUnit.name");
        sic.add("receiveStorageOrgUnit.number");
        sic.add("supplyCompanyOrgUnit.id");
        sic.add("supplyCompanyOrgUnit.name");
        sic.add("supplyCompanyOrgUnit.number");
        sic.add("requireCompanyOrgUnit.id");
        sic.add("requireCompanyOrgUnit.name");
        sic.add("requireCompanyOrgUnit.number");
        sic.add("issueCompanyOrgUnit.id");
        sic.add("issueCompanyOrgUnit.name");
        sic.add("issueCompanyOrgUnit.number");
        sic.add("receiveCompanyOrgUnit.id");
        sic.add("receiveCompanyOrgUnit.name");
        sic.add("receiveCompanyOrgUnit.number");
        return sic;
    }

    private TransferRuleInfo getTransferRule(String bizTypeId, String supplySouId, String reqSouId, String issueSouId, String recSouId) throws EASBizException, BOSException {
        if (bizTypeId == null || supplySouId == null) {
            return null;
        }
        FilterInfo filter = new FilterInfo();
        filter.appendFilterItem("bizType", (Object)bizTypeId);
        filter.appendFilterItem("status", (Object)new Integer(1));
        filter.appendFilterItem("supplyRelation.supplyStorageOrgUnit", (Object)supplySouId);
        filter.appendFilterItem("supplyRelation.requireStorageOrgUnit", (Object)reqSouId);
        filter.appendFilterItem("supplyRelation.issueStorageOrgUnit", (Object)issueSouId);
        filter.appendFilterItem("supplyRelation.receiveStorageOrgUnit", (Object)recSouId);
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filter);
        view.getSelector().addObjectCollection((IObjectCollection)this.getTransferRuleSelector(bizTypeId));
        TransferRuleCollection col = this.getTransferRuleByType(bizTypeId) == null ? null : this.getTransferRuleByType(bizTypeId).getTransferRuleCollection(view);
        return col != null && col.size() > 0 ? col.get(0) : null;
    }

    private ITransferRule getTransferRuleByType(String bizTypeId) throws BOSException {
        if (bizTypeId != null) {
            if ("d8e80652-0117-1000-e000-04c5c0a812202407435C".equals(bizTypeId) || "ltQJK8kihHPgQKjAYj1jAyQHQ1w=".equals(bizTypeId)) {
                return TransferRule2Factory.getLocalInstance(this.ctx);
            }
            if ("LyS5ouN3YEPgQAB/AQBJsCQHQ1w=".equals(bizTypeId) || "ltQJdddQMebgQKjAYj1j1yQHQ1w=".equals(bizTypeId)) {
                return TransferRule3Factory.getLocalInstance(this.ctx);
            }
            if ("LyS5ouN4YEPgQAB/AQBJsCQHQ1w=".equals(bizTypeId) || "ltQJ0s1RqWzgQKjAYj1j3CQHQ1w=".equals(bizTypeId)) {
                return TransferRule4Factory.getLocalInstance(this.ctx);
            }
        }
        return null;
    }

    private SelectorItemCollection getTransferRuleSelector(String bizTypeId) {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("supplyRelation.supplyStorageOrgUnit.id");
        sic.add("supplyRelation.supplyStorageOrgUnit.name");
        sic.add("supplyRelation.supplyStorageOrgUnit.number");
        sic.add("supplyRelation.requireStorageOrgUnit.id");
        sic.add("supplyRelation.requireStorageOrgUnit.name");
        sic.add("supplyRelation.requireStorageOrgUnit.number");
        sic.add("supplyRelation.issueStorageOrgUnit.id");
        sic.add("supplyRelation.issueStorageOrgUnit.name");
        sic.add("supplyRelation.issueStorageOrgUnit.number");
        sic.add("supplyRelation.receiveStorageOrgUnit.id");
        sic.add("supplyRelation.receiveStorageOrgUnit.name");
        sic.add("supplyRelation.receiveStorageOrgUnit.number");
        sic.add("supplyRelation.id");
        sic.add("issueSaleOrgUnit.id");
        sic.add("issueSaleOrgUnit.name");
        sic.add("issueSaleOrgUnit.number");
        sic.add("bizType.id");
        sic.add("bizType.name");
        sic.add("bizType.number");
        if ("LyS5ouN3YEPgQAB/AQBJsCQHQ1w=".equals(bizTypeId) || "LyS5ouN4YEPgQAB/AQBJsCQHQ1w=".equals(bizTypeId)) {
            sic.add("supplySaleOrgUnit.id");
            sic.add("supplySaleOrgUnit.name");
            sic.add("supplySaleOrgUnit.number");
            if ("LyS5ouN4YEPgQAB/AQBJsCQHQ1w=".equals(bizTypeId)) {
                sic.add("requireSaleOrgUnit.id");
                sic.add("requireSaleOrgUnit.name");
                sic.add("requireSaleOrgUnit.number");
            }
        }
        return sic;
    }

    private boolean isMoveAverage(String materialId, String companyId) throws Exception {
        MaterialCompanyInfoInfo matCouInfo = MaterialFactory.getLocalInstance((Context)this.ctx).getCompanyInfo(materialId, companyId);
        return matCouInfo == null ? false : AccountType.MOVE_ADD_AVERAGE.equals((Object)matCouInfo.getAccountType());
    }

    private void reValueTransferPrice() throws Exception {
        this.setPrice(this.info);
    }

    public PriceInfo getPriceInfo(PriceParamInfo priceParamInfo) throws BOSException, EASBizException {
        IMultiSidesTransferPriceFacade iPrice = MultiSidesTransferPriceFacadeFactory.getLocalInstance(this.ctx);
        PriceInfo priceInfo = iPrice.getPrice(priceParamInfo);
        return priceInfo;
    }

    public void setPrice(TransferOrderBillInfo tranInfo) throws Exception {
        TransferOrderBillEntryInfo entry;
        int i;
        PriceParamInfo[] params = new PriceParamInfo[this.getEntrySize()];
        StorageOrgUnitInfo supplySou = tranInfo.getIssueStorageOrgUnit();
        StorageOrgUnitInfo requireSou = tranInfo.getReceiptStorageOrgUnit();
        if (requireSou == null) {
            return;
        }
        if (supplySou == null) {
            return;
        }
        for (i = 0; i < this.getEntrySize(); ++i) {
            String bizType;
            entry = tranInfo.getEntry().get(i);
            StorageOrgUnitInfo issueSou = entry.getIssueStorageOrgUnit();
            StorageOrgUnitInfo receiveSou = entry.getReceiveStorageOrgUnit();
            MeasureUnitInfo baseUnit = entry.getBaseUnit();
            MeasureUnitInfo unit = entry.getUnit();
            BigDecimal qty = entry.getQty();
            MaterialInfo mi = entry.getMaterial();
            if (issueSou == null || receiveSou == null || mi == null || qty == null || SysConstant.BIGZERO.compareTo(qty) == 0 || unit == null || baseUnit == null) continue;
            SupplyRelationInfo srInfo = this.getSupplyRelation(supplySou.getId().toString(), requireSou.getId().toString(), issueSou.getId().toString(), receiveSou.getId().toString());
            String tempBizTypeID = bizType = this.info.getBizType().getId().toString();
            if (bizType != null) {
                if (bizType.equals("ltQJK8kihHPgQKjAYj1jAyQHQ1w=")) {
                    tempBizTypeID = "d8e80652-0117-1000-e000-04c5c0a812202407435C";
                } else if (bizType.equals("ltQJdddQMebgQKjAYj1j1yQHQ1w=")) {
                    tempBizTypeID = "LyS5ouN3YEPgQAB/AQBJsCQHQ1w=";
                } else if (bizType.equals("ltQJ0s1RqWzgQKjAYj1j3CQHQ1w=")) {
                    tempBizTypeID = "LyS5ouN4YEPgQAB/AQBJsCQHQ1w=";
                }
            }
            TransferRuleInfo trInfo = this.getTransferRule(tempBizTypeID, supplySou.getId().toString(), requireSou.getId().toString(), issueSou.getId().toString(), receiveSou.getId().toString());
            if (srInfo == null || trInfo == null) continue;
            SaleOrgUnitInfo supplyLouInfo = null;
            SaleOrgUnitInfo requireLouInfo = null;
            if (!"d8e80652-0117-1000-e000-04c5c0a812202407435C".equals(bizType) && !"ltQJK8kihHPgQKjAYj1jAyQHQ1w=".equals(bizType)) {
                if ("LyS5ouN3YEPgQAB/AQBJsCQHQ1w=".equals(bizType) || "ltQJdddQMebgQKjAYj1j1yQHQ1w=".equals(bizType)) {
                    supplyLouInfo = ((TransferRule3Info)trInfo).getSupplySaleOrgUnit();
                } else if ("LyS5ouN4YEPgQAB/AQBJsCQHQ1w=".equals(bizType) || "ltQJ0s1RqWzgQKjAYj1j3CQHQ1w=".equals(bizType)) {
                    supplyLouInfo = ((TransferRule4Info)trInfo).getSupplySaleOrgUnit();
                    requireLouInfo = ((TransferRule4Info)trInfo).getRequireSaleOrgUnit();
                }
            }
            entry.setIssueSaleOrgUnit(trInfo.getIssueSaleOrgUnit());
            entry.setSupplySaleOrgUnit(supplyLouInfo);
            entry.setRequireSaleOrgUnit(requireLouInfo);
            if (entry.isIsPresent()) continue;
            PriceParamInfo priceParamInfo = new PriceParamInfo();
            priceParamInfo.setCompanyOrgUnit(this.info.getIssueCompanyOrgUnit());
            priceParamInfo.setStorageOrgUnit(this.info.getIssueStorageOrgUnit());
            if (entry.getIssueCompanyOrgUnit() == null) {
                entry.setIssueCompanyOrgUnit(this.info.getIssueCompanyOrgUnit());
            }
            priceParamInfo.setIssueCompanyOrgUnitInfo(entry.getIssueCompanyOrgUnit());
            priceParamInfo.setMateial(mi);
            priceParamInfo.setCurrencyInfo(this.info.getCurrency());
            priceParamInfo.setAssistAttirute(entry.getAssistProperty());
            priceParamInfo.setPricePrecision(this.getPricePrecision(i));
            priceParamInfo.setSupplyRelation(srInfo);
            priceParamInfo.setQty(qty);
            priceParamInfo.setUnit(unit);
            priceParamInfo.setBaseUnit(baseUnit);
            BizTypeInfo bizTypeInfo = new BizTypeInfo();
            bizTypeInfo.setId(BOSUuid.read((String)tempBizTypeID));
            priceParamInfo.setBizTypeInfo(bizTypeInfo);
            if ("d8e80652-0117-1000-e000-04c5c0a812202407435C".equals(bizType) || "ltQJK8kihHPgQKjAYj1jAyQHQ1w=".equals(bizType)) {
                priceParamInfo.setBizRole(BizRoleTypeEnum.IssueSide);
            } else if ("LyS5ouN3YEPgQAB/AQBJsCQHQ1w=".equals(bizType) || "ltQJdddQMebgQKjAYj1j1yQHQ1w=".equals(bizType)) {
                priceParamInfo.setBizRole(BizRoleTypeEnum.SupplySide);
            } else if ("LyS5ouN4YEPgQAB/AQBJsCQHQ1w=".equals(bizType) || "ltQJ0s1RqWzgQKjAYj1j3CQHQ1w=".equals(bizType)) {
                priceParamInfo.setBizRole(BizRoleTypeEnum.SupplySide);
            }
            priceParamInfo.setIssueSaleOrgUnitInfo(trInfo.getIssueSaleOrgUnit());
            priceParamInfo.setSupplySaleOrgUnitInfo(supplyLouInfo);
            priceParamInfo.setRequireSaleOrgUnitInfo(requireLouInfo);
            priceParamInfo.setIssueStorageOrgUnitInfo(issueSou);
            priceParamInfo.setIssueWarehsInfo(entry.getIssueWarehouse());
            priceParamInfo.setExchangeRageInfo(this.getExchangeRate(this.info.getIssueCompanyOrgUnit(), (IObjectPK)new ObjectUuidPK(this.info.getCurrency().getId()), (IObjectPK)new ObjectUuidPK(this.info.getIssueCompanyOrgUnit().getBaseCurrency().getId())));
            CompanyOrgUnitInfo issueCou = entry.getIssueCompanyOrgUnit();
            if (issueSou == null || issueCou == null) {
                priceParamInfo.setCalType(null);
                priceParamInfo.setMoveAverage(false);
            } else {
                priceParamInfo.setMoveAverage(this.isMoveAverage(mi.getId().toString(), issueCou.getId().toString()));
                priceParamInfo.setCalType(this.getCalType(issueCou));
            }
            priceParamInfo.setTransferOrderBillTaxRate(entry.getTaxRate());
            priceParamInfo.setBizDate(this.info.getBizDate());
            this.setLotCalculate(priceParamInfo, mi.getId().toString(), entry);
            params[i] = priceParamInfo;
        }
        for (i = 0; i < this.getEntrySize(); ++i) {
            PriceInfo priceInfo;
            entry = this.info.getEntry().get(i);
            if (null == params[i] || (priceInfo = this.getPriceInfo(params[i])) == null || priceInfo.getPrice() == null || priceInfo.getPrice().compareTo(SysConstant.BIGZERO) <= 0 || priceInfo.getTaxPrice() == null || priceInfo.getTaxPrice().compareTo(SysConstant.BIGZERO) <= 0) continue;
            entry.setTaxPrice(priceInfo.getTaxPrice());
            if (priceInfo.getTaxRate() != null && priceInfo.getTaxRate().compareTo(SysConstant.BIGZERO) > 0) {
                entry.setTaxRate(priceInfo.getTaxRate());
            }
            entry.setDiscountType(priceInfo.getDiscountType());
            if (priceInfo.getDiscountRate() != null && priceInfo.getDiscountRate().compareTo(SysConstant.BIGZERO) > 0) {
                entry.setDiscountRate(priceInfo.getDiscountRate());
            }
            entry.setPrice(priceInfo.getPrice());
            entry.setActualTaxPrice(priceInfo.getActualTaxPrice());
            entry.setActualPrice(priceInfo.getActualPrice());
            if (!priceInfo.isCostAdd()) continue;
            entry.setBalanceCostPrice(priceInfo.getPrice());
            entry.setBalanceCostRate(priceInfo.getCostAddRate());
        }
    }

    private void setLotCalculate(PriceParamInfo priceParamInfo, String materialId, TransferOrderBillEntryInfo entry) throws BOSException {
        String companyOrgUnitID = null;
        if (priceParamInfo.getCostBizRole().equals((Object)BizRoleTypeEnum.SupplySide)) {
            companyOrgUnitID = priceParamInfo.getCompanyOrgUnit().getId().toString();
        } else if (priceParamInfo.getCostBizRole().equals((Object)BizRoleTypeEnum.IssueSide)) {
            companyOrgUnitID = priceParamInfo.getIssueCompanyOrgUnitInfo().getId().toString();
        } else if (priceParamInfo.getCostBizRole().equals((Object)BizRoleTypeEnum.RequireSide)) {
            companyOrgUnitID = priceParamInfo.getRequireCompanyOrgUnitInfo().getId().toString();
        }
        MaterialCompanyInfoInfo matCouInfo = this.getMaterialCompany(materialId, companyOrgUnitID);
        if (matCouInfo != null && AccountType.SPECIAL_ACCT.equals((Object)matCouInfo.getAccountType())) {
            AsstAttrValueInfo info;
            priceParamInfo.setSpecialAcct(true);
            priceParamInfo.setLot(matCouInfo.isIsLot());
            priceParamInfo.setAssistProperty(matCouInfo.isIsAssistProperty());
            priceParamInfo.setProject(matCouInfo.isIsProject());
            priceParamInfo.setTrackNumber(matCouInfo.isIsTrackNumber());
            if (entry.getLot() != null) {
                priceParamInfo.setLot(entry.getLot());
            }
            if (entry.getAssistProperty() != null) {
                info = entry.getAssistProperty();
                priceParamInfo.setAssistProperty(info.getId().toString());
            }
            if (entry.getProject() != null) {
                info = entry.getProject();
                priceParamInfo.setProject(info.getId().toString());
            }
            if (entry.getTrackNumber() != null) {
                info = entry.getTrackNumber();
                priceParamInfo.setTrackNumber(info.getId().toString());
            }
        }
    }

    private MaterialCompanyInfoInfo getMaterialCompany(String materialId, String companyOrgUnitID) throws BOSException {
        if (this.matCouMap.containsKey(materialId + companyOrgUnitID)) {
            return this.matCouMap.get(materialId + companyOrgUnitID);
        }
        IMaterialCompanyInfo imaterialCompany = MaterialCompanyInfoFactory.getLocalInstance((Context)this.ctx);
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("mateial.id", (Object)materialId, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)companyOrgUnitID, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("status", (Object)new Integer(UsedStatusEnum.APPROVED.getValue()), CompareType.EQUALS));
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("KAClass.id"));
        sic.add(new SelectorItemInfo("KAClass.name"));
        sic.add(new SelectorItemInfo("KAClass.number"));
        sic.add(new SelectorItemInfo("standardCost"));
        sic.add(new SelectorItemInfo("accountType"));
        sic.add(new SelectorItemInfo("calculateType"));
        sic.add(new SelectorItemInfo("materialId"));
        sic.add(new SelectorItemInfo("createTime"));
        sic.add(new SelectorItemInfo("lastUpdateTime"));
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("company.id"));
        sic.add(new SelectorItemInfo("company.name"));
        sic.add(new SelectorItemInfo("company.number"));
        sic.add(new SelectorItemInfo("mateial.longNumber"));
        sic.add(new SelectorItemInfo("mateial.id"));
        sic.add(new SelectorItemInfo("mateial.name"));
        sic.add(new SelectorItemInfo("mateial.number"));
        sic.add(new SelectorItemInfo("mateial.shortName"));
        sic.add(new SelectorItemInfo("effectedStatus"));
        sic.add(new SelectorItemInfo("creator.name"));
        sic.add(new SelectorItemInfo("lastUpdateUser.name"));
        sic.add(new SelectorItemInfo("freezeOrgUnit.name"));
        sic.add(new SelectorItemInfo("status"));
        sic.add(new SelectorItemInfo("isLot"));
        sic.add(new SelectorItemInfo("isAssistProperty"));
        sic.add(new SelectorItemInfo("isProject"));
        sic.add(new SelectorItemInfo("isTrackNumber"));
        ev.setSelector(sic);
        ev.setFilter(filter);
        MaterialCompanyInfoCollection coll = imaterialCompany.getMaterialCompanyInfoCollection(ev);
        this.matCouMap.put(materialId + companyOrgUnitID, coll.get(0));
        return coll.get(0);
    }
}

