/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.kdf.data.logging.Logger;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ExchangeRateInfo;
import com.kingdee.eas.basedata.assistant.ExchangeTableInfo;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.material.AccountType;
import com.kingdee.eas.basedata.master.material.AsstAttrValueInfo;
import com.kingdee.eas.basedata.master.material.MaterialCompanyInfoInfo;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.SaleOrgUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.basedata.scm.common.BillTypeInfo;
import com.kingdee.eas.basedata.scm.common.BizTypeInfo;
import com.kingdee.eas.basedata.scm.im.inv.LocationInfo;
import com.kingdee.eas.basedata.scm.im.inv.WarehouseInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.batchHandler.RequestContext;
import com.kingdee.eas.framework.batchHandler.ResponseContext;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.common.MultiOrgsFetchDataCondition;
import com.kingdee.eas.scm.common.MultiOrgsFetchDataFacadeFactory;
import com.kingdee.eas.scm.common.SCMBillCommonFacadeFactory;
import com.kingdee.eas.scm.common.SCMFetchData;
import com.kingdee.eas.scm.common.SCMFetchDataCondition;
import com.kingdee.eas.scm.common.SCMFetchDataFacadeFactory;
import com.kingdee.eas.scm.common.loadmass.InvBizDataVO;
import com.kingdee.eas.scm.im.inv.BizRoleTypeEnum;
import com.kingdee.eas.scm.im.inv.ISupplyRelation;
import com.kingdee.eas.scm.im.inv.ITransferRule;
import com.kingdee.eas.scm.im.inv.InventoryInfo;
import com.kingdee.eas.scm.im.inv.MultiSidesTransferPriceFacadeFactory;
import com.kingdee.eas.scm.im.inv.PriceParamInfo;
import com.kingdee.eas.scm.im.inv.SupplyRelationCollection;
import com.kingdee.eas.scm.im.inv.SupplyRelationFactory;
import com.kingdee.eas.scm.im.inv.SupplyRelationInfo;
import com.kingdee.eas.scm.im.inv.TransferOrderBillAgent;
import com.kingdee.eas.scm.im.inv.TransferOrderBillEntryCollection;
import com.kingdee.eas.scm.im.inv.TransferOrderBillEntryInfo;
import com.kingdee.eas.scm.im.inv.TransferOrderBillFactory;
import com.kingdee.eas.scm.im.inv.TransferOrderBillInfo;
import com.kingdee.eas.scm.im.inv.TransferRule2Factory;
import com.kingdee.eas.scm.im.inv.TransferRule3Factory;
import com.kingdee.eas.scm.im.inv.TransferRule3Info;
import com.kingdee.eas.scm.im.inv.TransferRule4Factory;
import com.kingdee.eas.scm.im.inv.TransferRule4Info;
import com.kingdee.eas.scm.im.inv.TransferRuleCollection;
import com.kingdee.eas.scm.im.inv.TransferRuleInfo;
import com.kingdee.eas.scm.im.inv.app.AbstractTransferOrderBillEditUIHandler;
import com.kingdee.eas.util.app.ContextUtil;
import java.math.BigDecimal;
import java.util.HashMap;

public class TransferOrderBillEditUIHandler
extends AbstractTransferOrderBillEditUIHandler {
    private static BigDecimal ZERO = new BigDecimal("0.00");
    protected HashMap initFetchPara = new HashMap();

    @Override
    protected void _handleActionClose(RequestContext request, ResponseContext response, Context context) throws Exception {
        this.initFetchData(request, response, context);
    }

    @Override
    protected void _handleActionQuickAddLine(RequestContext request, ResponseContext response, Context context) throws Exception {
    }

    protected void _handleActionAddNew(RequestContext request, ResponseContext response, Context context) throws Exception {
        super._handleActionAddNew(request, response, context);
        this.initFetchData(request, response, context);
    }

    protected void _handleActionAudit(RequestContext request, ResponseContext response, Context context) throws Exception {
        super._handleActionAudit(request, response, context);
        this.initFetchData(request, response, context);
    }

    protected void _handleActionCopy(RequestContext request, ResponseContext response, Context context) throws Exception {
        super._handleActionCopy(request, response, context);
        this.createNewData(request, response, context);
        String baseCurId = (String)request.get("BASE_CURRENCY_ID");
        if (baseCurId != null) {
            ObjectUuidPK pk = new ObjectUuidPK(baseCurId);
            CurrencyFactory.getLocalInstance((Context)context).getCurrencyInfo((IObjectPK)pk);
        }
    }

    protected void _handleActionCreateFrom(RequestContext request, ResponseContext response, Context context) throws Exception {
        super._handleActionCreateFrom(request, response, context);
    }

    public void _handleActionEdit(RequestContext request, ResponseContext response, Context context) throws Exception {
        super._handleActionEdit(request, response, context);
    }

    protected void _handleActionMaterialView(RequestContext request, ResponseContext response, Context context) throws Exception {
        super._handleActionMaterialView(request, response, context);
    }

    public void _handleActionNext(RequestContext request, ResponseContext response, Context context) throws Exception {
        super._handleActionNext(request, response, context);
        super.loadSCMBizData(request, response, context);
        this.initFetchData(request, response, context);
    }

    protected void _handleActionNextPerson(RequestContext request, ResponseContext response, Context context) throws Exception {
        super._handleActionNextPerson(request, response, context);
        this.initFetchData(request, response, context);
    }

    public void _handleActionPre(RequestContext request, ResponseContext response, Context context) throws Exception {
        super._handleActionPre(request, response, context);
        super.loadSCMBizData(request, response, context);
        this.initFetchData(request, response, context);
    }

    protected void _handleActionQueryByMaterial(RequestContext request, ResponseContext response, Context context) throws Exception {
        super._handleActionQueryByMaterial(request, response, context);
    }

    public void _handleActionRemove(RequestContext request, ResponseContext response, Context context) throws Exception {
    }

    protected void _handleActionSave(RequestContext request, ResponseContext response, Context context) throws Exception {
        super._handleActionSave(request, response, context);
    }

    protected void _handleActionSubmit(RequestContext request, ResponseContext response, Context context) throws Exception {
        super._handleActionSubmit(request, response, context);
        this.initFetchData(request, response, context);
    }

    protected void _handleActionTraceDown(RequestContext request, ResponseContext response, Context context) throws Exception {
        super._handleActionTraceDown(request, response, context);
    }

    protected void _handleActionUnAudit(RequestContext request, ResponseContext response, Context context) throws Exception {
        super._handleActionUnAudit(request, response, context);
        this.initFetchData(request, response, context);
    }

    protected void _handleActionWorkFlowG(RequestContext request, ResponseContext response, Context context) throws Exception {
        super._handleActionWorkFlowG(request, response, context);
    }

    protected void _handleInit(RequestContext request, ResponseContext response, Context context) throws Exception {
        super._handleInit(request, response, context);
        String baseCurId = (String)request.get("BASE_CURRENCY_ID");
        if (baseCurId != null) {
            ObjectUuidPK pk = new ObjectUuidPK(baseCurId);
            CurrencyFactory.getLocalInstance((Context)context).getCurrencyInfo((IObjectPK)pk);
        }
    }

    protected IObjectValue createNewData(RequestContext request, ResponseContext response, Context context) throws Exception {
        TransferOrderBillInfo billInfo = (TransferOrderBillInfo)super.createNewData(request, response, context);
        if (billInfo == null) {
            billInfo = TransferOrderBillAgent.create();
            billInfo.setBaseStatus(BillBaseStatusEnum.ADD);
            BillTypeInfo billType = new BillTypeInfo();
            billType.setId(BOSUuid.read((String)"Eg5BUQEVEADgAAABwKgOEEY+1VI="));
            billInfo.setBillType(billType);
            billInfo.setIsShipment(true);
            billInfo.setIsInTax(true);
        }
        billInfo.setIssueStorageOrgUnit((StorageOrgUnitInfo)this.getDefaultMainBizOrg(request, response, context));
        TransferOrderBillFactory.getLocalInstance(context).createNewData(billInfo);
        request.put("STORAGE_ORGUNIT_ID", billInfo.getIssueStorageOrgUnit() == null ? null : billInfo.getIssueStorageOrgUnit().getId().toString());
        CompanyOrgUnitInfo couInfo = ContextUtil.getCurrentFIUnit((Context)context);
        if (couInfo != null && couInfo.getBaseCurrency() != null) {
            CurrencyFactory.getLocalInstance((Context)context).getCurrencyInfo((IObjectPK)new ObjectUuidPK(couInfo.getBaseCurrency().getId()));
        }
        this.fillAuthCompanyView(request, response, context);
        return billInfo;
    }

    private void fillAuthCompanyView(RequestContext request, ResponseContext response, Context context) throws Exception {
        SCMBillCommonFacadeFactory.getLocalInstance((Context)context).getAuthCompanyView(request.getUserPK(), OrgType.Storage, "transferorder_new");
    }

    protected void initFetchData(RequestContext request, ResponseContext response, Context ctx) throws Exception {
        this.fillAuthCompanyView(request, response, ctx);
        SCMFetchDataCondition condition = this.buildCondition(request, ctx);
        if (condition == null) {
            return;
        }
        SCMFetchData fetchData = MultiOrgsFetchDataFacadeFactory.getLocalInstance((Context)ctx).fetchData(new InvBizDataVO(condition.toEntiryView(), this.initFetchPara));
        TransferOrderBillInfo toInfo = (TransferOrderBillInfo)request.getValue();
        this.loadMultiSidesTransferPrices(ctx, toInfo, fetchData, response);
    }

    protected void loadMultiSidesTransferPrices(Context ctx, TransferOrderBillInfo toInfo, SCMFetchData fetchData, ResponseContext response) throws EASBizException, BOSException {
        if (toInfo.getBaseStatus() == BillBaseStatusEnum.AUDITED || toInfo.getBaseStatus() == BillBaseStatusEnum.CLOSED || toInfo.getBaseStatus() == BillBaseStatusEnum.SUBMITED || toInfo.getBaseStatus() == BillBaseStatusEnum.ALTERING) {
            return;
        }
        int count = toInfo.getEntry().size();
        int pricePrecision = 2;
        String bizType = toInfo.getBizType() == null ? "d8e80652-0117-1000-e000-04c5c0a812202407435C" : toInfo.getBizType().getId().toString();
        StorageOrgUnitInfo supplySou = toInfo.getIssueStorageOrgUnit();
        StorageOrgUnitInfo requireSou = toInfo.getReceiptStorageOrgUnit();
        CurrencyInfo currencyInfo = toInfo.getCurrency();
        PriceParamInfo[] params = new PriceParamInfo[count];
        boolean setParam2Null = false;
        TransferOrderBillEntryInfo toeInfo = null;
        CompanyOrgUnitInfo couInfo = toInfo.getIssueCompanyOrgUnit();
        if (currencyInfo == null || supplySou == null || requireSou == null || couInfo == null || couInfo.getBaseCurrency() == null) {
            return;
        }
        ExchangeRateInfo exchangeRateInfo = this.getExchangeRate(ctx, couInfo, (IObjectPK)new ObjectUuidPK(currencyInfo.getId()), (IObjectPK)new ObjectUuidPK(couInfo.getBaseCurrency().getId()));
        for (int i = 0; i < count; ++i) {
            setParam2Null = false;
            toeInfo = toInfo.getEntry().get(i);
            StorageOrgUnitInfo issueSou = toeInfo.getIssueStorageOrgUnit();
            StorageOrgUnitInfo receiveSou = toeInfo.getReceiveStorageOrgUnit();
            MeasureUnitInfo baseUnit = toeInfo.getBaseUnit();
            MeasureUnitInfo unit = toeInfo.getUnit();
            BigDecimal qty = toeInfo.getQty();
            MaterialInfo mi = toeInfo.getMaterial();
            AsstAttrValueInfo asstAttrInfo = toeInfo.getAssistProperty();
            if (issueSou == null || receiveSou == null || mi == null || qty == null || qty.compareTo(ZERO) == 0 || unit == null || baseUnit == null) {
                setParam2Null = true;
            }
            if (setParam2Null) continue;
            SupplyRelationInfo srInfo = fetchData.getSupplyRelation(supplySou.getId().toString(), requireSou.getId().toString(), issueSou.getId().toString(), receiveSou.getId().toString());
            toeInfo.setSupplyRelation(srInfo);
            TransferRuleInfo trInfo = fetchData.getTransferRule(bizType, supplySou.getId().toString(), requireSou.getId().toString(), issueSou.getId().toString(), receiveSou.getId().toString());
            if (srInfo == null || trInfo == null) continue;
            SaleOrgUnitInfo issueLouInfo = trInfo.getIssueSaleOrgUnit();
            SaleOrgUnitInfo supplyLouInfo = null;
            SaleOrgUnitInfo requireLouInfo = null;
            if (!"d8e80652-0117-1000-e000-04c5c0a812202407435C".equals(bizType)) {
                if ("LyS5ouN3YEPgQAB/AQBJsCQHQ1w=".equals(bizType)) {
                    supplyLouInfo = ((TransferRule3Info)trInfo).getSupplySaleOrgUnit();
                } else if ("LyS5ouN4YEPgQAB/AQBJsCQHQ1w=".equals(bizType)) {
                    supplyLouInfo = ((TransferRule4Info)trInfo).getSupplySaleOrgUnit();
                    requireLouInfo = ((TransferRule4Info)trInfo).getRequireSaleOrgUnit();
                }
            }
            toeInfo.setIssueSaleOrgUnit(issueLouInfo);
            toeInfo.setSupplySaleOrgUnit(supplyLouInfo);
            toeInfo.setRequireSaleOrgUnit(requireLouInfo);
            boolean isPresent = toeInfo.isIsPresent();
            if (isPresent) continue;
            PriceParamInfo priceParamInfo = new PriceParamInfo();
            priceParamInfo.setCompanyOrgUnit(toInfo.getReceiptCompanyOrgUnit());
            priceParamInfo.setStorageOrgUnit(toInfo.getIssueStorageOrgUnit());
            priceParamInfo.setIssueCompanyOrgUnitInfo(toeInfo.getIssueCompanyOrgUnit());
            priceParamInfo.setMateial(mi);
            priceParamInfo.setCurrencyInfo(currencyInfo);
            priceParamInfo.setAssistAttirute(asstAttrInfo);
            if (mi != null) {
                pricePrecision = mi.getPricePrecision();
            }
            priceParamInfo.setPricePrecision(pricePrecision);
            priceParamInfo.setSupplyRelation(srInfo);
            priceParamInfo.setQty(qty);
            priceParamInfo.setUnit(unit);
            priceParamInfo.setBaseUnit(baseUnit);
            BizTypeInfo bizTypeInfo = new BizTypeInfo();
            bizTypeInfo.setId(BOSUuid.read((String)bizType));
            priceParamInfo.setBizTypeInfo(bizTypeInfo);
            if (!"d8e80652-0117-1000-e000-04c5c0a812202407435C".equals(bizType)) {
                if ("LyS5ouN3YEPgQAB/AQBJsCQHQ1w=".equals(bizType)) {
                    priceParamInfo.setBizRole(BizRoleTypeEnum.SupplySide);
                } else if ("LyS5ouN4YEPgQAB/AQBJsCQHQ1w=".equals(bizType)) {
                    priceParamInfo.setBizRole(BizRoleTypeEnum.SupplySide);
                }
            }
            priceParamInfo.setIssueSaleOrgUnitInfo(issueLouInfo);
            priceParamInfo.setSupplySaleOrgUnitInfo(supplyLouInfo);
            priceParamInfo.setRequireSaleOrgUnitInfo(requireLouInfo);
            priceParamInfo.setIssueStorageOrgUnitInfo(issueSou);
            priceParamInfo.setIssueWarehsInfo(toeInfo.getIssueWarehouse());
            priceParamInfo.setExchangeRageInfo(exchangeRateInfo);
            CompanyOrgUnitInfo issueCou = toeInfo.getIssueCompanyOrgUnit();
            if (issueSou == null || issueCou == null) {
                priceParamInfo.setCalType(null);
                priceParamInfo.setMoveAverage(false);
            } else {
                priceParamInfo.setMoveAverage(this.isMoveAverage(mi.getId().toString(), issueCou.getId().toString(), fetchData, ctx));
                priceParamInfo.setCalType(fetchData.getParamValue(issueCou.getId().toString(), "SCM_CAL_002"));
            }
            priceParamInfo.setTransferOrderBillTaxRate(toeInfo.getTaxRate());
            params[i] = priceParamInfo;
        }
        try {
            MultiSidesTransferPriceFacadeFactory.getLocalInstance(ctx).getPriceCollection(params);
        }
        catch (Exception e) {
            Logger.error((Throwable)e);
        }
    }

    public ExchangeRateInfo getExchangeRate(Context ctx, CompanyOrgUnitInfo companyOrgUnitInfo, IObjectPK sourceCurrPK, IObjectPK destCurrPK) throws EASBizException, BOSException {
        if (destCurrPK == null) {
            destCurrPK = sourceCurrPK;
        }
        ExchangeTableInfo exchangeTableInfo = companyOrgUnitInfo.getBaseExchangeTable();
        ObjectUuidPK excTablepk = null;
        if (exchangeTableInfo == null) {
            return null;
        }
        excTablepk = new ObjectUuidPK(exchangeTableInfo.getId());
        ExchangeRateInfo exchangeRateInfo = null;
        exchangeRateInfo = SCMBillCommonFacadeFactory.getLocalInstance((Context)ctx).getCurrentExchangeRate((IObjectPK)excTablepk, sourceCurrPK, destCurrPK);
        return exchangeRateInfo;
    }

    private boolean isMoveAverage(String materialId, String companyId, SCMFetchData fetchData, Context ctx) throws BOSException {
        MaterialCompanyInfoInfo matCouInfo = fetchData.getMaterialCompany(ctx, materialId, companyId);
        return matCouInfo == null ? false : AccountType.MOVE_ADD_AVERAGE.equals((Object)matCouInfo.getAccountType());
    }

    protected SCMFetchDataCondition buildCondition(RequestContext request, Context ctx) throws Exception {
        MultiOrgsFetchDataCondition condition = new MultiOrgsFetchDataCondition();
        condition = this.getNormalCondtion();
        this.setConditionContents(condition, request, ctx);
        return condition;
    }

    protected void setConditionContents(MultiOrgsFetchDataCondition condition, RequestContext request, Context ctx) throws Exception {
        TransferOrderBillInfo toInfo = (TransferOrderBillInfo)request.getValue();
        if (toInfo == null || toInfo.getIssueCompanyOrgUnit() == null) {
            return;
        }
        TransferOrderBillEntryCollection entryColl = toInfo.getEntry();
        int arryLength = 0;
        for (int i = 0; i < entryColl.size(); ++i) {
            MaterialInfo material = entryColl.get(i).getMaterial();
            if (material == null) continue;
            ++arryLength;
        }
        String[] materialPKs = new String[arryLength];
        String[] unitPKs = new String[arryLength];
        String[] baseUnitPKs = new String[arryLength];
        String[] asstUnitPKs = new String[arryLength];
        String[] warehsPKs = new String[arryLength];
        String[] recWhPks = new String[arryLength];
        String[] lots = new String[arryLength];
        String[] locationPks = new String[arryLength];
        String[] recLocPks = new String[arryLength];
        String[] issueSouPks = new String[arryLength];
        String[] recSouPks = new String[arryLength];
        String[] issueCouPks = new String[arryLength];
        TransferOrderBillEntryInfo entryInfo = null;
        int cursor = 0;
        for (int i = 0; i < entryColl.size(); ++i) {
            LocationInfo location;
            WarehouseInfo warehs;
            MeasureUnitInfo asstUnit;
            MeasureUnitInfo baseUnit;
            entryInfo = entryColl.get(i);
            MaterialInfo material = entryInfo.getMaterial();
            if (material == null) continue;
            if (material != null) {
                materialPKs[cursor] = material.getId().toString();
            } else if (entryColl.size() == 1) {
                materialPKs = null;
            }
            MeasureUnitInfo unit = entryInfo.getUnit();
            if (unit != null) {
                unitPKs[cursor] = unit.getId().toString();
            }
            if ((baseUnit = entryInfo.getBaseUnit()) != null) {
                baseUnitPKs[cursor] = baseUnit.getId().toString();
            }
            if ((asstUnit = entryInfo.getAssistUnit()) != null && asstUnit.toString() != null && asstUnit.toString().length() > 0) {
                asstUnitPKs[cursor] = asstUnit.getId().toString();
            }
            if ((warehs = entryInfo.getIssueWarehouse()) != null) {
                warehsPKs[cursor] = warehs.getId().toString();
            }
            if ((warehs = entryInfo.getReceiptWarehouse()) != null) {
                recWhPks[cursor] = warehs.getId().toString();
            }
            if ((location = entryInfo.getIssueLocation()) != null) {
                locationPks[cursor] = location.getId().toString();
            }
            if ((location = entryInfo.getReceiptLocation()) != null) {
                recLocPks[cursor] = location.getId().toString();
            }
            if (entryInfo.getIssueStorageOrgUnit() != null) {
                issueSouPks[cursor] = entryInfo.getIssueStorageOrgUnit().getId().toString();
            }
            if (entryInfo.getIssueCompanyOrgUnit() != null) {
                issueCouPks[cursor] = entryInfo.getIssueCompanyOrgUnit().getId().toString();
            }
            if (entryInfo.getReceiveStorageOrgUnit() != null) {
                recSouPks[cursor] = entryInfo.getReceiveStorageOrgUnit().getId().toString();
            }
            lots[cursor] = entryInfo.getLot();
            ++cursor;
        }
        condition.setCou(toInfo.getIssueCompanyOrgUnit());
        condition.setMaterialPKs(materialPKs);
        condition.setUnitPKs(unitPKs);
        condition.setBaseUnitPKs(baseUnitPKs);
        condition.setAsstUnitPKs(asstUnitPKs);
        condition.setWarehousePKs(warehsPKs);
        condition.setLocationPks(locationPks);
        condition.setLots(lots);
        condition.setIssueCouIds(issueCouPks);
        condition.setIssueSouIds(issueSouPks);
        condition.setReceiveSouIds(recSouPks);
        condition.setReceiveLocIds(recLocPks);
        condition.setReceiveWhIds(recWhPks);
        condition.setBizTypeId(toInfo.getBizType() == null ? null : toInfo.getBizType().getId().toString());
        condition.setRequireCou(toInfo.getReceiptCompanyOrgUnit());
        condition.setRequireSou(toInfo.getReceiptStorageOrgUnit());
        condition.setSou(toInfo.getIssueStorageOrgUnit());
        this.initFetchPara.put("Condition", condition);
    }

    protected MultiOrgsFetchDataCondition getNormalCondtion() {
        MultiOrgsFetchDataCondition condition = new MultiOrgsFetchDataCondition();
        condition.setFetchMaterial(true);
        condition.setFetchID(true);
        condition.setFetchNumber(true);
        condition.setFetchName(true);
        condition.setFetchBaseUnit(true);
        condition.setFetchAssistUnit(true);
        condition.setFetchAsstAttrType(true);
        condition.setFetchPricePrecision(true);
        condition.setFetchModel(true);
        condition.setFetchSou(true);
        condition.setFetchIsLotNumber(true);
        condition.setFetchIsSequenceNo(true);
        condition.setFetchIsPeriodValid(true);
        condition.setFetchIsNegative(true);
        condition.setFetchInventoryUnit(true);
        condition.setFetchIssuePriorityMode(true);
        condition.setFetchCompany(true);
        condition.setFetchAccountType(true);
        condition.setFetchStandardCost(true);
        condition.setFetchCompanyStatus(true);
        condition.setFetchUnitPrecision(true);
        condition.setFetchBaseUnitPrecision(true);
        condition.setFetchAsstUnitPrecision(true);
        condition.setFetchDefaultWarehouse(true);
        condition.setFetchDefaultLocation(true);
        condition.setFetchDurability(true);
        condition.setFetchTransferRule(true);
        condition.setFetchSupplyRelation(true);
        return condition;
    }

    @Override
    protected void _handleActionUnClose(RequestContext request, ResponseContext response, Context context) throws Exception {
    }

    @Override
    protected void _handleActionViewVersion(RequestContext request, ResponseContext response, Context context) throws Exception {
    }

    public void handleActionQuickAddLine1(RequestContext request, ResponseContext response, Context context) throws Exception {
        TransferOrderBillInfo toBillInfo = (TransferOrderBillInfo)request.getValue();
        InventoryInfo[] invtInfos = (InventoryInfo[])request.get("invtInfos");
        if (toBillInfo != null && invtInfos != null) {
            StorageOrgUnitInfo supplySou = toBillInfo.getIssueStorageOrgUnit();
            StorageOrgUnitInfo requireSou = toBillInfo.getReceiptStorageOrgUnit();
            CompanyOrgUnitInfo supplyCouInfo = toBillInfo.getIssueCompanyOrgUnit();
            CurrencyInfo currencyInfo = toBillInfo.getCurrency();
            ExchangeRateInfo exchangeRateInfo = (ExchangeRateInfo)request.get("exchangeRateInfo");
            StorageOrgUnitInfo issueSou = supplySou;
            StorageOrgUnitInfo receiveSou = requireSou;
            SCMFetchDataCondition condition = this.buildCondition(invtInfos);
            this.initFetchPara.put("Condition", condition);
            SCMFetchData fetchData = SCMFetchDataFacadeFactory.getLocalInstance((Context)context).fetchData(condition.toEntiryView(), this.initFetchPara);
            if (supplySou == null || requireSou == null || currencyInfo == null) {
                return;
            }
            String bizType = toBillInfo.getBizType() == null ? "d8e80652-0117-1000-e000-04c5c0a812202407435C" : toBillInfo.getBizType().getId().toString();
            for (InventoryInfo invtInfo : invtInfos) {
                MaterialInfo mi = invtInfo.getMaterial();
                if (mi == null) {
                    return;
                }
                BigDecimal qty = invtInfo.getCurStoreQty();
                if (qty == null || qty.compareTo(ZERO) == 0) {
                    return;
                }
                MeasureUnitInfo unit = invtInfo.getUnit();
                if (unit == null) {
                    return;
                }
                MeasureUnitInfo baseUnit = invtInfo.getBaseUnit();
                if (baseUnit == null) {
                    return;
                }
                AsstAttrValueInfo asstAttrInfo = invtInfo.getAssistProperty();
                SupplyRelationInfo srInfo = this.getSupplyRelation(context, supplySou.getId().toString(), requireSou.getId().toString(), issueSou.getId().toString(), receiveSou.getId().toString());
                TransferRuleInfo trInfo = this.getTransferRule(context, bizType, supplySou.getId().toString(), requireSou.getId().toString(), issueSou.getId().toString(), receiveSou.getId().toString());
                if (trInfo == null) {
                    return;
                }
                SaleOrgUnitInfo issueLouInfo = trInfo.getIssueSaleOrgUnit();
                SaleOrgUnitInfo supplyLouInfo = null;
                SaleOrgUnitInfo requireLouInfo = null;
                if (!"d8e80652-0117-1000-e000-04c5c0a812202407435C".equals(bizType)) {
                    if ("LyS5ouN3YEPgQAB/AQBJsCQHQ1w=".equals(bizType)) {
                        supplyLouInfo = ((TransferRule3Info)trInfo).getSupplySaleOrgUnit();
                    } else if ("LyS5ouN4YEPgQAB/AQBJsCQHQ1w=".equals(bizType)) {
                        supplyLouInfo = ((TransferRule4Info)trInfo).getSupplySaleOrgUnit();
                        requireLouInfo = ((TransferRule4Info)trInfo).getRequireSaleOrgUnit();
                    }
                }
                PriceParamInfo priceParamInfo = new PriceParamInfo();
                priceParamInfo.setCompanyOrgUnit(supplyCouInfo);
                priceParamInfo.setStorageOrgUnit(supplySou);
                priceParamInfo.setIssueCompanyOrgUnitInfo(supplyCouInfo);
                priceParamInfo.setMateial(mi);
                priceParamInfo.setCurrencyInfo(currencyInfo);
                priceParamInfo.setAssistAttirute(asstAttrInfo);
                priceParamInfo.setPricePrecision(mi.getPricePrecision());
                priceParamInfo.setSupplyRelation(srInfo);
                priceParamInfo.setQty(qty);
                priceParamInfo.setUnit(unit);
                priceParamInfo.setBaseUnit(baseUnit);
                BizTypeInfo bizTypeInfo = new BizTypeInfo();
                bizTypeInfo.setId(BOSUuid.read((String)bizType));
                priceParamInfo.setBizTypeInfo(bizTypeInfo);
                if ("d8e80652-0117-1000-e000-04c5c0a812202407435C".equals(bizType)) {
                    priceParamInfo.setBizRole(BizRoleTypeEnum.IssueSide);
                } else if ("LyS5ouN3YEPgQAB/AQBJsCQHQ1w=".equals(bizType)) {
                    priceParamInfo.setBizRole(BizRoleTypeEnum.SupplySide);
                } else if ("LyS5ouN4YEPgQAB/AQBJsCQHQ1w=".equals(bizType)) {
                    priceParamInfo.setBizRole(BizRoleTypeEnum.SupplySide);
                }
                priceParamInfo.setIssueSaleOrgUnitInfo(issueLouInfo);
                priceParamInfo.setSupplySaleOrgUnitInfo(supplyLouInfo);
                priceParamInfo.setRequireSaleOrgUnitInfo(requireLouInfo);
                priceParamInfo.setIssueStorageOrgUnitInfo(issueSou);
                priceParamInfo.setIssueWarehsInfo(invtInfo.getWarehouse());
                priceParamInfo.setExchangeRageInfo(exchangeRateInfo);
                CompanyOrgUnitInfo issueCou = supplyCouInfo;
                if (issueSou == null || issueCou == null) {
                    priceParamInfo.setCalType(null);
                    priceParamInfo.setMoveAverage(false);
                } else {
                    priceParamInfo.setMoveAverage(this.isMoveAverage(mi.getId().toString(), issueCou.getId().toString(), fetchData, context));
                    priceParamInfo.setCalType(fetchData.getParamValue(issueCou.getId().toString(), "SCM_CAL_002"));
                }
                MultiSidesTransferPriceFacadeFactory.getLocalInstance(context).getPrice(priceParamInfo);
            }
        }
    }

    public SupplyRelationInfo getSupplyRelation(Context ctx, String supplySouId, String reqSouId, String issueSouId, String recSouId) throws EASBizException, BOSException {
        FilterInfo filter = new FilterInfo();
        filter.appendFilterItem("supplyStorageOrgUnit", (Object)supplySouId);
        filter.appendFilterItem("requireStorageOrgUnit", (Object)reqSouId);
        filter.appendFilterItem("issueStorageOrgUnit", (Object)issueSouId);
        filter.appendFilterItem("receiveStorageOrgUnit", (Object)recSouId);
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filter);
        view.getSelector().addObjectCollection((IObjectCollection)this.getSupplyRelationSelector());
        ISupplyRelation isr = SupplyRelationFactory.getLocalInstance(ctx);
        SupplyRelationCollection col = isr.getSupplyRelationCollection(view);
        if (col != null && col.size() > 0) {
            return col.get(0);
        }
        return null;
    }

    private SelectorItemCollection getSupplyRelationSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("supplyStorageOrgUnit.id");
        sic.add("supplyStorageOrgUnit.name");
        sic.add("supplyStorageOrgUnit.number");
        sic.add("requireStorageOrgUnit.id");
        sic.add("requireStorageOrgUnit.name");
        sic.add("requireStorageOrgUnit.number");
        sic.add("issueStorageOrgUnit.id");
        sic.add("issueStorageOrgUnit.name");
        sic.add("issueStorageOrgUnit.number");
        sic.add("receiveStorageOrgUnit.id");
        sic.add("receiveStorageOrgUnit.name");
        sic.add("receiveStorageOrgUnit.number");
        sic.add("supplyCompanyOrgUnit.id");
        sic.add("supplyCompanyOrgUnit.name");
        sic.add("supplyCompanyOrgUnit.number");
        sic.add("requireCompanyOrgUnit.id");
        sic.add("requireCompanyOrgUnit.name");
        sic.add("requireCompanyOrgUnit.number");
        sic.add("issueCompanyOrgUnit.id");
        sic.add("issueCompanyOrgUnit.name");
        sic.add("issueCompanyOrgUnit.number");
        sic.add("receiveCompanyOrgUnit.id");
        sic.add("receiveCompanyOrgUnit.name");
        sic.add("receiveCompanyOrgUnit.number");
        return sic;
    }

    private ITransferRule getTransferRuleByType(Context ctx, String bizTypeId) throws BOSException {
        if ("d8e80652-0117-1000-e000-04c5c0a812202407435C".equals(bizTypeId)) {
            return TransferRule2Factory.getLocalInstance(ctx);
        }
        if ("LyS5ouN3YEPgQAB/AQBJsCQHQ1w=".equals(bizTypeId)) {
            return TransferRule3Factory.getLocalInstance(ctx);
        }
        if ("LyS5ouN4YEPgQAB/AQBJsCQHQ1w=".equals(bizTypeId)) {
            return TransferRule4Factory.getLocalInstance(ctx);
        }
        return null;
    }

    public TransferRuleInfo getTransferRule(Context ctx, String bizTypeId, String supplySouId, String reqSouId, String issueSouId, String recSouId) throws EASBizException, BOSException {
        if (bizTypeId == null || supplySouId == null) {
            return null;
        }
        FilterInfo filter = new FilterInfo();
        filter.appendFilterItem("bizType", (Object)bizTypeId);
        filter.appendFilterItem("status", (Object)new Integer(1));
        filter.appendFilterItem("supplyRelation.supplyStorageOrgUnit", (Object)supplySouId);
        filter.appendFilterItem("supplyRelation.requireStorageOrgUnit", (Object)reqSouId);
        filter.appendFilterItem("supplyRelation.issueStorageOrgUnit", (Object)issueSouId);
        filter.appendFilterItem("supplyRelation.receiveStorageOrgUnit", (Object)recSouId);
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filter);
        view.getSelector().addObjectCollection((IObjectCollection)this.getTransferRuleSelector(bizTypeId));
        TransferRuleCollection col = this.getTransferRuleByType(ctx, bizTypeId).getTransferRuleCollection(view);
        if (col != null && col.size() > 0) {
            return col.get(0);
        }
        return null;
    }

    private SelectorItemCollection getTransferRuleSelector(String bizTypeId) {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("supplyRelation.supplyStorageOrgUnit.id");
        sic.add("supplyRelation.supplyStorageOrgUnit.name");
        sic.add("supplyRelation.supplyStorageOrgUnit.number");
        sic.add("supplyRelation.requireStorageOrgUnit.id");
        sic.add("supplyRelation.requireStorageOrgUnit.name");
        sic.add("supplyRelation.requireStorageOrgUnit.number");
        sic.add("supplyRelation.issueStorageOrgUnit.id");
        sic.add("supplyRelation.issueStorageOrgUnit.name");
        sic.add("supplyRelation.issueStorageOrgUnit.number");
        sic.add("supplyRelation.receiveStorageOrgUnit.id");
        sic.add("supplyRelation.receiveStorageOrgUnit.name");
        sic.add("supplyRelation.receiveStorageOrgUnit.number");
        sic.add("supplyRelation.id");
        sic.add("issueSaleOrgUnit.id");
        sic.add("issueSaleOrgUnit.name");
        sic.add("issueSaleOrgUnit.number");
        sic.add("bizType.id");
        sic.add("bizType.name");
        sic.add("bizType.number");
        if ("LyS5ouN3YEPgQAB/AQBJsCQHQ1w=".equals(bizTypeId) || "LyS5ouN4YEPgQAB/AQBJsCQHQ1w=".equals(bizTypeId)) {
            sic.add("supplySaleOrgUnit.id");
            sic.add("supplySaleOrgUnit.name");
            sic.add("supplySaleOrgUnit.number");
            if ("LyS5ouN4YEPgQAB/AQBJsCQHQ1w=".equals(bizTypeId)) {
                sic.add("requireSaleOrgUnit.id");
                sic.add("requireSaleOrgUnit.name");
                sic.add("requireSaleOrgUnit.number");
            }
        }
        return sic;
    }

    protected SCMFetchDataCondition buildCondition(InventoryInfo[] invs) {
        SCMFetchDataCondition condition = new SCMFetchDataCondition();
        if (this.isFetchData()) {
            condition.setFetchMaterial(true);
            condition.setFetchID(true);
            condition.setFetchNumber(true);
            condition.setFetchName(true);
            condition.setFetchBaseUnit(true);
            condition.setFetchAssistUnit(true);
            condition.setFetchAsstAttrType(true);
            condition.setFetchModel(true);
            condition.setFetchPricePrecision(true);
            condition.setFetchSou(true);
            condition.setFetchIsLotNumber(true);
            condition.setFetchIsSequenceNo(true);
            condition.setFetchIsPeriodValid(true);
            condition.setFetchIsNegative(true);
            condition.setFetchInventoryUnit(true);
            condition.setFetchIssuePriorityMode(true);
            condition.setFetchCompany(true);
            condition.setFetchAccountType(true);
            condition.setFetchStandardCost(true);
            condition.setFetchCompanyStatus(true);
            condition.setFetchStocker(true);
            condition.setFetchUnitPrecision(true);
            condition.setFetchBaseUnitPrecision(true);
            condition.setFetchAsstUnitPrecision(true);
            condition.setFetchDefaultLocation(true);
            this.setConditionContents(condition, invs);
        }
        return condition;
    }

    protected boolean isFetchData() {
        return true;
    }

    protected void setConditionContents(SCMFetchDataCondition condition, InventoryInfo[] invs) {
        int arryLength = invs.length;
        String[] materialPKs = new String[arryLength];
        String[] unitPKs = new String[arryLength];
        String[] baseUnitPKs = new String[arryLength];
        String[] asstUnitPKs = new String[arryLength];
        String[] warehousePKs = new String[arryLength];
        int cursor = 0;
        for (int i = 0; i < arryLength; ++i) {
            WarehouseInfo warehouse;
            MeasureUnitInfo asstUnit;
            MeasureUnitInfo baseUnit;
            MaterialInfo material = invs[i].getMaterial();
            if (material == null) continue;
            materialPKs[cursor] = material.getId().toString();
            MeasureUnitInfo unit = invs[i].getUnit();
            if (unit != null) {
                unitPKs[cursor] = unit.getId().toString();
            }
            if ((baseUnit = invs[i].getBaseUnit()) != null) {
                baseUnitPKs[cursor] = baseUnit.getId().toString();
            }
            if ((asstUnit = invs[i].getAssistUnit()) != null) {
                asstUnitPKs[cursor] = asstUnit.getId().toString();
            }
            if ((warehouse = invs[i].getWarehouse()) != null) {
                warehousePKs[cursor] = warehouse.getId().toString();
            }
            ++cursor;
        }
        condition.setMaterialPKs(materialPKs);
        condition.setUnitPKs(unitPKs);
        condition.setBaseUnitPKs(baseUnitPKs);
        condition.setAsstUnitPKs(asstUnitPKs);
        condition.setWarehousePKs(warehousePKs);
        condition.setSou(invs[0].getStorageOrgUnit());
        condition.setCou(invs[0].getCompanyOrgUnit());
    }

    public void handleRemove(RequestContext request, ResponseContext response, Context context) throws Exception {
        super.handleRemove(request, response, context);
        this.initFetchData(request, response, context);
    }

    @Override
    protected void _handleActionCalculateDynQty(RequestContext request, ResponseContext response, Context context) throws Exception {
    }
}

