/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv.app.autocreate.plugin;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.OrgUnitRelationCollection;
import com.kingdee.eas.basedata.org.OrgUnitRelationFactory;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.scm.im.inv.PurInWarehsBillInfo;
import com.kingdee.eas.scm.im.inv.PurInWarehsEntryCollection;
import com.kingdee.eas.scm.im.inv.PurInWarehsEntryInfo;
import com.kingdee.eas.scm.im.inv.SaleIssueBillInfo;
import com.kingdee.eas.scm.im.inv.app.autocreate.plugin.AutoCreateInvBillPlugInHandler;
import com.kingdee.eas.scm.im.inv.app.autocreate.plugin.AutoCreatePIToPIPlugInHandler;
import com.kingdee.eas.scm.im.inv.app.autocreate.plugin.AutoCreatePIToSIPlugInHandler;
import com.kingdee.eas.scm.im.inv.app.autocreate.plugin.AutoCreateVirtualBillPlugInHandler;
import com.kingdee.eas.scm.im.inv.util.AccountViewUtil;
import com.kingdee.eas.scm.sm.pur.PurInnerDealPriceCollection;
import com.kingdee.eas.scm.sm.pur.PurInnerDealPriceFactory;
import com.kingdee.eas.scm.sm.pur.PurInnerDealPriceInfo;
import com.kingdee.util.StringUtils;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class AutoCreateBillPIPlugInHandler
extends AutoCreateVirtualBillPlugInHandler {
    private Map<String, String> numberMap = new HashMap<String, String>();
    private int maxNumber = 65;

    @Override
    public void execute(Context ctx, IObjectValue model, String destBosType, String botpName) throws BOSException, EASBizException {
        if (model == null || StringUtils.isEmpty((String)destBosType) || StringUtils.isEmpty((String)botpName)) {
            return;
        }
        String coreBosType = this.getCoreBillBosType(model);
        if (StringUtils.isEmpty((String)coreBosType)) {
            return;
        }
        if ("3171BFAD".equals(coreBosType)) {
            if (model.get("VirtualBillNumber") != null) {
                this.numberMap = (Map)model.get("VirtualBillNumber");
            }
            this.createBillByPurInnerPrice(ctx, model, destBosType, botpName);
            if ("783061E3".equals(destBosType)) {
                this.createInvVirtualBill(ctx, model, destBosType, botpName, null);
            }
            model.put("VirtualBillNumber", this.numberMap);
        } else {
            this.createInvVirtualBill(ctx, model, destBosType, botpName, null);
        }
    }

    private void createBillByPurInnerPrice(Context ctx, IObjectValue model, String destBosType, String botpName) throws BOSException, EASBizException {
        Map<String, PurInnerDealPriceCollection> map = this.cachePurInnerDealPricesByStorage(ctx, model, destBosType);
        if (map == null || map.size() == 0) {
            return;
        }
        this.groupCreateBill(ctx, model, botpName, destBosType, map);
    }

    private void groupCreateBill(Context ctx, IObjectValue model, String botpName, String destBosType, Map<String, PurInnerDealPriceCollection> map) throws EASBizException, BOSException {
        if (model == null || StringUtils.isEmpty((String)botpName) || StringUtils.isEmpty((String)destBosType) || map == null || map.size() == 0) {
            return;
        }
        Map<String, PurInWarehsEntryCollection> entryMap = this.cacheEntryInfoByCoreEntryId(model);
        if (entryMap == null || entryMap.size() == 0) {
            return;
        }
        PurInWarehsBillInfo info = (PurInWarehsBillInfo)model;
        PurInWarehsEntryCollection entryCol = null;
        PurInnerDealPriceCollection coll = null;
        PurInnerDealPriceInfo priceInfo = null;
        PurInWarehsBillInfo cloneInfo = null;
        String[] key = null;
        for (Map.Entry<String, PurInnerDealPriceCollection> entry : map.entrySet()) {
            key = entry.getKey().split("&&");
            if (!destBosType.equals(key[1])) continue;
            coll = entry.getValue();
            entryCol = new PurInWarehsEntryCollection();
            int size = coll.size();
            for (int i = 0; i < size; ++i) {
                priceInfo = coll.get(i);
                if (!entryMap.containsKey(priceInfo.getPurOrderEntry().getId().toString())) continue;
                entryCol.addCollection(entryMap.get(priceInfo.getPurOrderEntry().getId().toString()));
            }
            if (entryCol.size() <= 0) continue;
            cloneInfo = (PurInWarehsBillInfo)info.clone();
            cloneInfo.getEntry().clear();
            PurInWarehsEntryCollection entrys = info.getEntry();
            for (int i = 0; i < entrys.size(); ++i) {
                if (!entrys.get(i).isIsPresent()) continue;
                entryCol.add(entrys.get(i));
            }
            cloneInfo.getEntry().addCollection(entryCol);
            this.createInvVirtualBill(ctx, (IObjectValue)cloneInfo, destBosType, botpName, coll);
        }
    }

    private Map<String, PurInWarehsEntryCollection> cacheEntryInfoByCoreEntryId(IObjectValue model) {
        if (model != null && model instanceof PurInWarehsBillInfo) {
            PurInWarehsBillInfo info = (PurInWarehsBillInfo)model;
            PurInWarehsEntryInfo entryInfo = null;
            PurInWarehsEntryCollection entryCol = null;
            HashMap<String, PurInWarehsEntryCollection> map = new HashMap<String, PurInWarehsEntryCollection>();
            int size = info.getEntry().size();
            for (int i = 0; i < size; ++i) {
                entryInfo = info.getEntry().get(i);
                if (StringUtils.isEmpty((String)entryInfo.getPurOrderEntry())) continue;
                entryCol = map.containsKey(entryInfo.getPurOrderEntry()) ? (PurInWarehsEntryCollection)((Object)map.get(entryInfo.getPurOrderEntry())) : new PurInWarehsEntryCollection();
                entryCol.add(entryInfo);
                map.put(entryInfo.getPurOrderEntry(), entryCol);
            }
            return map;
        }
        return null;
    }

    private String getCoreBillBosType(IObjectValue model) {
        PurInWarehsEntryInfo entryInfo;
        PurInWarehsBillInfo info;
        String bosType = "";
        if (model != null && model instanceof PurInWarehsBillInfo && (info = (PurInWarehsBillInfo)model).getEntry() != null && info.getEntry().get(0) != null && !StringUtils.isEmpty((String)(entryInfo = info.getEntry().get(0)).getPurOrder())) {
            bosType = BOSUuid.getBOSObjectType((String)entryInfo.getPurOrder(), (boolean)true).toString();
        }
        return bosType;
    }

    private Set<String> getCoreBillEntryIds(IObjectValue model) {
        if (model != null && model instanceof PurInWarehsBillInfo) {
            PurInWarehsBillInfo info = (PurInWarehsBillInfo)model;
            PurInWarehsEntryInfo entryInfo = null;
            HashSet<String> idSet = new HashSet<String>();
            int size = info.getEntry().size();
            for (int i = 0; i < size; ++i) {
                entryInfo = info.getEntry().get(i);
                if (StringUtils.isEmpty((String)entryInfo.getPurOrderEntry())) continue;
                idSet.add(entryInfo.getPurOrderEntry());
            }
            return idSet;
        }
        return null;
    }

    private Map<String, PurInnerDealPriceCollection> cachePurInnerDealPricesByStorage(Context ctx, IObjectValue model, String destBosType) throws BOSException {
        PurInnerDealPriceCollection coll = null;
        if (model == null || StringUtils.isEmpty((String)destBosType)) {
            return null;
        }
        if (model.get("PurInnerPriceColl") != null) {
            coll = (PurInnerDealPriceCollection)model.get("PurInnerPriceColl");
        } else {
            Set<String> coreEntryIdSet = this.getCoreBillEntryIds(model);
            if (coreEntryIdSet == null || coreEntryIdSet.size() == 0) {
                return null;
            }
            coll = this.getPurInnerDealPrices(ctx, coreEntryIdSet);
            if (coll != null && coll.size() > 0) {
                model.put("PurInnerPriceColl", (Object)coll);
            }
        }
        if (coll == null || coll.size() == 0) {
            return null;
        }
        this.setStorageOrgUnitByCompany(ctx, coll);
        String recCompanyOrgId = "";
        String supStorageOrgId = "";
        String recStorageOrgID = "";
        String key = "&&" + destBosType;
        PurInnerDealPriceCollection dealPriceColl = null;
        PurInnerDealPriceInfo dealPriceInfo = null;
        HashMap<String, PurInnerDealPriceCollection> map = new HashMap<String, PurInnerDealPriceCollection>();
        int size = coll.size();
        for (int i = 0; i < size; ++i) {
            dealPriceInfo = coll.get(i);
            if (dealPriceInfo == null || dealPriceInfo.getPurOrderEntry() == null || dealPriceInfo.getPurOrderEntry().getCompanyOrgUnit() == null || dealPriceInfo.getRecCompanyOrg() == null || dealPriceInfo.getSupCompanyOrg() == null) continue;
            if (dealPriceInfo.getSupStorageOrg() != null) {
                supStorageOrgId = dealPriceInfo.getSupStorageOrg().getId().toString();
            }
            recCompanyOrgId = dealPriceInfo.getRecCompanyOrg().getId().toString();
            if (dealPriceInfo.getRecStorageOrg() != null) {
                recStorageOrgID = dealPriceInfo.getRecStorageOrg().getId().toString();
            }
            if ("783061E3".equals(destBosType) && !recCompanyOrgId.equals(dealPriceInfo.getPurOrderEntry().getCompanyOrgUnit().getId().toString()) && !StringUtils.isEmpty((String)recStorageOrgID)) {
                dealPriceColl = map.containsKey(recStorageOrgID + key) ? (PurInnerDealPriceCollection)map.get(recStorageOrgID + key) : new PurInnerDealPriceCollection();
                dealPriceColl.add(dealPriceInfo);
                map.put(recStorageOrgID + key, dealPriceColl);
            }
            if (!"CC3E933B".equals(destBosType) || StringUtils.isEmpty((String)supStorageOrgId)) continue;
            dealPriceColl = map.containsKey(supStorageOrgId + key) ? (PurInnerDealPriceCollection)map.get(supStorageOrgId + key) : new PurInnerDealPriceCollection();
            dealPriceColl.add(dealPriceInfo);
            map.put(supStorageOrgId + key, dealPriceColl);
        }
        return map;
    }

    private void setStorageOrgUnitByCompany(Context ctx, PurInnerDealPriceCollection coll) throws BOSException {
        int i;
        if (coll == null || coll.size() == 0) {
            return;
        }
        PurInnerDealPriceInfo priceInfo = null;
        StorageOrgUnitInfo storageOrg = null;
        HashSet<String> set = new HashSet<String>();
        int size = coll.size();
        for (int i2 = 0; i2 < size; ++i2) {
            priceInfo = coll.get(i2);
            if (priceInfo.getSupCompanyOrg() != null && priceInfo.getSupStorageOrg() == null) {
                set.add(priceInfo.getSupCompanyOrg().getId().toString());
            }
            if (priceInfo.getRecCompanyOrg() == null || priceInfo.getRecStorageOrg() != null) continue;
            set.add(priceInfo.getRecCompanyOrg().getId().toString());
        }
        OrgUnitRelationCollection couOrgColl = this.getOrgUnitRelationColl(ctx, set, 4, 1);
        if (couOrgColl == null || couOrgColl.size() == 0) {
            return;
        }
        HashMap<String, String> storageOrgMap = new HashMap<String, String>();
        int size2 = couOrgColl.size();
        for (i = 0; i < size2; ++i) {
            if (couOrgColl.get(i) == null || couOrgColl.get(i).getFromUnit() == null || couOrgColl.get(i).getToUnit() == null || storageOrgMap.containsKey(couOrgColl.get(i).getToUnit().getId().toString())) continue;
            storageOrgMap.put(couOrgColl.get(i).getToUnit().getId().toString(), couOrgColl.get(i).getFromUnit().getId().toString());
        }
        if (storageOrgMap.size() == 0) {
            return;
        }
        size2 = coll.size();
        for (i = 0; i < size2; ++i) {
            priceInfo = coll.get(i);
            if (priceInfo.getSupCompanyOrg() != null && priceInfo.getSupStorageOrg() == null && storageOrgMap.containsKey(priceInfo.getSupCompanyOrg().getId().toString())) {
                storageOrg = new StorageOrgUnitInfo();
                storageOrg.setId(BOSUuid.read((String)((String)storageOrgMap.get(priceInfo.getSupCompanyOrg().getId().toString()))));
                priceInfo.setSupStorageOrg(storageOrg);
            }
            if (priceInfo.getRecCompanyOrg() == null || priceInfo.getRecStorageOrg() != null || !storageOrgMap.containsKey(priceInfo.getRecCompanyOrg().getId().toString())) continue;
            storageOrg = new StorageOrgUnitInfo();
            storageOrg.setId(BOSUuid.read((String)((String)storageOrgMap.get(priceInfo.getRecCompanyOrg().getId().toString()))));
            priceInfo.setRecStorageOrg(storageOrg);
        }
    }

    private OrgUnitRelationCollection getOrgUnitRelationColl(Context ctx, Set<String> set, int fromType, int toType) throws BOSException {
        if (set == null || set.size() == 0) {
            return null;
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("toUnit.id", set, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("typeRelation.fromType", (Object)new Integer(fromType), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("typeRelation.toType", (Object)new Integer(toType), CompareType.EQUALS));
        filter.setMaskString("#0 and #1 and #2");
        view.setFilter(filter);
        SorterItemCollection sortColl = new SorterItemCollection();
        SorterItemInfo sortItem = new SorterItemInfo("toUnit.id");
        sortItem.setSortType(SortType.ASCEND);
        sortColl.add(sortItem);
        SorterItemInfo sortItem1 = new SorterItemInfo("fromUnit.number");
        sortItem1.setSortType(SortType.ASCEND);
        sortColl.add(sortItem1);
        view.setSorter(sortColl);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("fromUnit.id"));
        sic.add(new SelectorItemInfo("fromUnit.name"));
        sic.add(new SelectorItemInfo("fromUnit.number"));
        sic.add(new SelectorItemInfo("fromUnit.longNumber"));
        sic.add(new SelectorItemInfo("toUnit.id"));
        sic.add(new SelectorItemInfo("toUnit.name"));
        sic.add(new SelectorItemInfo("toUnit.number"));
        sic.add(new SelectorItemInfo("toUnit.longNumber"));
        sic.add(new SelectorItemInfo("isDefault"));
        view.setSelector(sic);
        OrgUnitRelationCollection orgColl = OrgUnitRelationFactory.getLocalInstance((Context)ctx).getOrgUnitRelationCollection(view);
        return orgColl;
    }

    private PurInnerDealPriceCollection getPurInnerDealPrices(Context ctx, Set<String> coreEntryIdSet) throws BOSException {
        if (coreEntryIdSet == null || coreEntryIdSet.size() == 0) {
            return null;
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("purOrderEntry.id", coreEntryIdSet, CompareType.INCLUDE));
        view.setFilter(filter);
        view.setSelector(this.getPurInnerDealPriceSelector());
        return PurInnerDealPriceFactory.getLocalInstance((Context)ctx).getPurInnerDealPriceCollection(view);
    }

    private SelectorItemCollection getPurInnerDealPriceSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("price"));
        sic.add(new SelectorItemInfo("discountMode"));
        sic.add(new SelectorItemInfo("discount"));
        sic.add(new SelectorItemInfo("taxRate"));
        sic.add(new SelectorItemInfo("taxPrice"));
        sic.add(new SelectorItemInfo("exchangeRate"));
        sic.add(new SelectorItemInfo("purOrder.id"));
        sic.add(new SelectorItemInfo("purOrderEntry.id"));
        sic.add(new SelectorItemInfo("purOrderEntry.companyOrgUnit.id"));
        sic.add(new SelectorItemInfo("unit.id"));
        sic.add(new SelectorItemInfo("baseUnit.id"));
        sic.add(new SelectorItemInfo("supCompanyOrg.id"));
        sic.add(new SelectorItemInfo("supProfitCenter.id"));
        sic.add(new SelectorItemInfo("supStorageOrg.id"));
        sic.add(new SelectorItemInfo("supWareHouse.id"));
        sic.add(new SelectorItemInfo("recCompanyOrg.id"));
        sic.add(new SelectorItemInfo("recProfitCenter.id"));
        sic.add(new SelectorItemInfo("recStorageOrg.id"));
        sic.add(new SelectorItemInfo("recWareHouse.id"));
        sic.add(new SelectorItemInfo("currency.id"));
        sic.add(new SelectorItemInfo("currency.name"));
        sic.add(new SelectorItemInfo("currency.number"));
        sic.add(new SelectorItemInfo("currency.precision"));
        sic.add(new SelectorItemInfo("saleOrgUnit.id"));
        return sic;
    }

    private void createInvVirtualBill(Context ctx, IObjectValue model, String destBosType, String botpName, PurInnerDealPriceCollection innerPriceCol) throws BOSException, EASBizException {
        AutoCreateInvBillPlugInHandler pluginHandler = null;
        PurInWarehsBillInfo info = null;
        SaleIssueBillInfo saleInfo = null;
        if (model == null || StringUtils.isEmpty((String)botpName) || StringUtils.isEmpty((String)destBosType)) {
            return;
        }
        IObjectCollection infos = this.createBillByBotp(ctx, model, botpName);
        if (infos == null || infos.size() == 0) {
            return;
        }
        if (innerPriceCol != null && innerPriceCol.size() > 0) {
            int size = infos.size();
            for (int i = 0; i < size; ++i) {
                int j;
                int n;
                infos.getObject(i).put("PurInnerDealPrice", (Object)innerPriceCol);
                if ("783061E3".equals(destBosType)) {
                    info = (PurInWarehsBillInfo)infos.getObject(i);
                    info.setStorageOrgUnit(innerPriceCol.get(0).getRecStorageOrg());
                    n = info.getEntry().size();
                    for (j = 0; j < n; ++j) {
                        info.getEntry().get(j).setStorageOrgUnit(info.getStorageOrgUnit());
                    }
                    if (this.numberMap.containsKey(info.getStorageOrgUnit().getId().toString())) {
                        info.setNumber(info.getNumber() + this.numberMap.get(info.getStorageOrgUnit().getId().toString()));
                    } else {
                        if (this.numberMap.size() > 0) {
                            ++this.maxNumber;
                        }
                        this.numberMap.put(info.getStorageOrgUnit().getId().toString(), (char)this.maxNumber + "");
                        info.setNumber(info.getNumber() + (char)this.maxNumber);
                    }
                    info.setAdminOrgUnit(null);
                    continue;
                }
                saleInfo = (SaleIssueBillInfo)infos.getObject(i);
                saleInfo.setStorageOrgUnit(innerPriceCol.get(0).getSupStorageOrg());
                n = saleInfo.getEntry().size();
                for (j = 0; j < n; ++j) {
                    saleInfo.getEntry().get(j).setStorageOrgUnit(saleInfo.getStorageOrgUnit());
                }
                if (this.numberMap.containsKey(saleInfo.getStorageOrgUnit().getId().toString())) {
                    saleInfo.setNumber(saleInfo.getNumber() + this.numberMap.get(saleInfo.getStorageOrgUnit().getId().toString()));
                    continue;
                }
                if (this.numberMap.size() > 0) {
                    ++this.maxNumber;
                }
                this.numberMap.put(saleInfo.getStorageOrgUnit().getId().toString(), (char)this.maxNumber + "");
                saleInfo.setNumber(saleInfo.getNumber() + (char)this.maxNumber);
            }
        } else {
            String coreBosType = this.getCoreBillBosType(model);
            if (!StringUtils.isEmpty((String)coreBosType) && "3171BFAD".equals(coreBosType) && "783061E3".equals(destBosType)) {
                int size = infos.size();
                for (int i = 0; i < size; ++i) {
                    info = (PurInWarehsBillInfo)infos.getObject(0);
                    if (this.numberMap.size() > 0) {
                        ++this.maxNumber;
                    }
                    this.numberMap.put(info.getStorageOrgUnit().getId().toString(), (char)this.maxNumber + "");
                    info.setNumber(info.getNumber() + (char)this.maxNumber);
                }
            }
        }
        pluginHandler = "783061E3".equals(destBosType) ? new AutoCreatePIToPIPlugInHandler() : new AutoCreatePIToSIPlugInHandler();
        pluginHandler.execute(ctx, model, infos);
        AccountViewUtil.updateAccountView(ctx, infos);
    }
}

