/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv.app.autocreate.plugin;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.scm.common.BizTypeInfo;
import com.kingdee.eas.basedata.scm.common.util.SCMBaseCommonUtil;
import com.kingdee.eas.basedata.scm.im.inv.InvUpdateTypeFactory;
import com.kingdee.eas.basedata.scm.im.inv.InvUpdateTypeInfo;
import com.kingdee.eas.basedata.scm.im.inv.StoreStateInfo;
import com.kingdee.eas.basedata.scm.im.inv.StoreTypeInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.dynbusiness.util.DBUtil;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.framework.batchaction.BatchActionEnum;
import com.kingdee.eas.scm.cal.CalculateFacadeFactory;
import com.kingdee.eas.scm.cal.ICalculateFacade;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.common.BizActionEnum;
import com.kingdee.eas.scm.common.SCMBillBaseInfo;
import com.kingdee.eas.scm.common.app.SCMServerUtils;
import com.kingdee.eas.scm.framework.bizflow.app.BizFlowServerHelper;
import com.kingdee.eas.scm.framework.bizflow.app.plugin.AutoCreatePlugInAdapter;
import com.kingdee.eas.scm.im.inv.AbstractInvBillBaseEntryInfo;
import com.kingdee.eas.scm.im.inv.IInventoryUpdate;
import com.kingdee.eas.scm.im.inv.InvBillBaseEntryInfo;
import com.kingdee.eas.scm.im.inv.InvBillBaseInfo;
import com.kingdee.eas.scm.im.inv.InvBizException;
import com.kingdee.eas.scm.im.inv.InvCommonUtils;
import com.kingdee.eas.scm.im.inv.InventoryUpdateFactory;
import com.kingdee.eas.scm.im.inv.MaterialReqBillInfo;
import com.kingdee.eas.scm.im.inv.MoveInWarehsBillInfo;
import com.kingdee.eas.scm.im.inv.MoveIssueBillInfo;
import com.kingdee.eas.scm.im.inv.app.InvServerUtils;
import com.kingdee.eas.scm.util.collection.CollectionUtil;
import com.kingdee.eas.util.app.DbUtil;
import java.sql.Timestamp;
import java.util.Date;

public class AutoCreateInvBillPlugInHandler
extends AutoCreatePlugInAdapter {
    public void execute(Context ctx, IObjectValue model, IObjectCollection objColl) throws BOSException, EASBizException {
        this.processDefaultValue(ctx, model, objColl);
        this.processBillCheck(ctx, model, objColl);
        this.processOtherBiz(ctx, model, objColl);
    }

    public void processDefaultValue(Context ctx, IObjectValue model, IObjectCollection objColl) throws BOSException, EASBizException {
        InvBillBaseInfo info = null;
        int size = objColl.size();
        for (int i = 0; i < size; ++i) {
            if (objColl.getObject(i) == null || !(objColl.getObject(i) instanceof InvBillBaseInfo)) continue;
            info = (InvBillBaseInfo)objColl.getObject(i);
            info.setAuditTime(new Timestamp(new Date().getTime()));
            info.setBaseStatus(BillBaseStatusEnum.AUDITED);
            info.setIsReversed(false);
            CompanyOrgUnitInfo company = InvServerUtils.getCompanyInfoForStorage(ctx, info.getStorageOrgUnit());
            PeriodInfo period = PeriodUtils.getPeriodInfo((Context)ctx, (Date)info.getBizDate(), (CompanyOrgUnitInfo)company);
            if (period != null) {
                info.setYear(period.getPeriodYear());
                info.setPeriod(period.getPeriodNumber());
            }
            info.setMonth(model.getInt("month"));
            info.setDay(model.getInt("day"));
            info.put("isSysBill", Boolean.TRUE);
            if (model.get("entry") != null) {
                InvBillBaseEntryInfo entry = (InvBillBaseEntryInfo)((IObjectCollection)model.get("entry")).getObject(0);
                info.put("VT_StorageOrgUnitID", entry.getStorageOrgUnit().getId().toString());
                info.put("VT_CompanyOrgUnitID", entry.getCompanyOrgUnit().getId().toString());
            }
            info.setFiVouchered(false);
            if (info.getStorageOrgUnit().getCU() == null) continue;
            info.setCU(info.getStorageOrgUnit().getCU());
        }
    }

    public void processBillCheck(Context ctx, IObjectValue model, IObjectCollection objColl) throws BOSException, EASBizException {
        String billTypeID = null;
        InvBillBaseInfo info = null;
        InvBillBaseEntryInfo entry = null;
        EntityViewInfo view = null;
        InvUpdateTypeInfo invUpdateType = null;
        AbstractInvBillBaseEntryInfo srcEntry = null;
        int size = objColl.size();
        for (int i = 0; i < size; ++i) {
            if (objColl.getObject(i) == null || !(objColl.getObject(i) instanceof InvBillBaseInfo)) continue;
            info = (InvBillBaseInfo)objColl.getObject(i);
            if (info != null && info.getTransactionType() == null) {
                throw new InvBizException(InvBizException.TRANSACTION_CHECK_ERROR);
            }
            if (null != info.getBillType()) {
                billTypeID = info.getBillType().getId().toString();
            }
            IObjectCollection entries = info.getEntries();
            CoreBaseCollection coll = InvCommonUtils.getSourceBillCollection(ctx, entries);
            if (CollectionUtil.isEmpty((IObjectCollection)entries)) continue;
            int count = entries.size();
            for (int index = 0; index < count; ++index) {
                entry = (InvBillBaseEntryInfo)entries.getObject(index);
                view = InvCommonUtils.buildInvUpdateTypeEntityView(ctx, info, index, false, coll);
                invUpdateType = InvCommonUtils.getDefaultInvUpdateTypeInfo(ctx, view);
                if (invUpdateType == null) {
                    if (model.get("entry") != null && !CollectionUtil.isEmpty((IObjectCollection)((IObjectCollection)model.get("entry")))) {
                        IObjectCollection col = (IObjectCollection)model.get("entry");
                        for (int mm = 0; mm < col.size(); ++mm) {
                            if (!col.getObject(mm).get("id").toString().equals(entry.getSourceBillEntryId())) continue;
                            srcEntry = (InvBillBaseEntryInfo)col.getObject(mm);
                            break;
                        }
                    }
                    if (srcEntry.getInvUpdateType() == null) continue;
                    InvUpdateTypeInfo srcInvUpdateType = srcEntry.getInvUpdateType();
                    SelectorItemCollection selector = new SelectorItemCollection();
                    selector.add(new SelectorItemInfo("id"));
                    selector.add(new SelectorItemInfo("number"));
                    selector.add(new SelectorItemInfo("name"));
                    selector.add(new SelectorItemInfo("existingQty"));
                    selector.add(new SelectorItemInfo("existingQtyPre"));
                    selector.add(new SelectorItemInfo("isNotUpdateInv"));
                    selector.add(new SelectorItemInfo("scheduled"));
                    selector.add(new SelectorItemInfo("status"));
                    selector.add(new SelectorItemInfo("storeType.id"));
                    selector.add(new SelectorItemInfo("storeType.number"));
                    selector.add(new SelectorItemInfo("storeType.name"));
                    selector.add(new SelectorItemInfo("storeType.storeFlag"));
                    selector.add(new SelectorItemInfo("storeType.isForwardAmt"));
                    selector.add(new SelectorItemInfo("storeState.id"));
                    selector.add(new SelectorItemInfo("storeState.number"));
                    selector.add(new SelectorItemInfo("storeState.name"));
                    selector.add(new SelectorItemInfo("storeTypePre.id"));
                    selector.add(new SelectorItemInfo("storeTypePre.number"));
                    selector.add(new SelectorItemInfo("storeTypePre.name"));
                    selector.add(new SelectorItemInfo("storeTypePre.storeFlag"));
                    selector.add(new SelectorItemInfo("storeTypePre.isForwardAmt"));
                    selector.add(new SelectorItemInfo("storeStatePre.id"));
                    selector.add(new SelectorItemInfo("storeStatePre.number"));
                    selector.add(new SelectorItemInfo("storeStatePre.name"));
                    srcInvUpdateType = InvUpdateTypeFactory.getLocalInstance((Context)ctx).getInvUpdateTypeInfo((IObjectPK)new ObjectUuidPK(srcInvUpdateType.getId()), selector);
                    StoreTypeInfo storeType = srcInvUpdateType.getStoreType();
                    StoreStateInfo storeState = srcInvUpdateType.getStoreState();
                    StoreTypeInfo storeTypePre = srcInvUpdateType.getStoreTypePre();
                    StoreStateInfo storeStatePre = srcInvUpdateType.getStoreStatePre();
                    String storeTypeName = "";
                    String storeStateName = "";
                    if (storeType != null && storeState != null) {
                        storeTypeName = storeType.getName();
                        storeStateName = storeState.getName();
                    } else if (storeTypePre != null && storeStatePre != null) {
                        storeTypeName = storeTypePre.getName();
                        storeStateName = storeStatePre.getName();
                    }
                    if (SCMBaseCommonUtil.isInWarehsBill((String)billTypeID)) {
                        throw new InvBizException(InvBizException.IN_INVUPDATETYPE_ISNOT_EXIST, new String[]{storeTypeName, storeStateName});
                    }
                    if (!SCMBaseCommonUtil.isOutWarehsBill((String)billTypeID)) continue;
                    throw new InvBizException(InvBizException.ISSUE_INVUPDATETYPE_ISNOT_EXIST, new String[]{storeTypeName, storeStateName});
                }
                entry.setInvUpdateType(invUpdateType);
            }
        }
    }

    public void processOtherBiz(Context ctx, IObjectValue model, IObjectCollection objColl) throws BOSException, EASBizException {
        InvBillBaseInfo info = null;
        this.traceUpAndDown(ctx, model, objColl);
        IInventoryUpdate iInventoryUpdate = InventoryUpdateFactory.getLocalInstance((Context)ctx);
        int size = objColl.size();
        for (int i = 0; i < size; ++i) {
            if (objColl.getObject(i) == null || !(objColl.getObject(i) instanceof InvBillBaseInfo)) continue;
            info = (InvBillBaseInfo)objColl.getObject(i);
            if (info.getTransactionType() != null) {
                iInventoryUpdate.updateInventory(info.getId().toString(), BizActionEnum.AUDIT);
            }
            this.calculateBill(ctx, info);
            this.checkMatCompanyInfo(ctx, info);
            BizFlowServerHelper.doProcessing((Context)ctx, (IObjectValue)info, (BatchActionEnum)BatchActionEnum.SAVE);
            objColl.getObject(i).put("HasBeenCreate", (Object)true);
            BizFlowServerHelper.doProcessing((Context)ctx, (IObjectValue)info, (BatchActionEnum)BatchActionEnum.AUDIT);
        }
    }

    public void traceUpAndDown(Context ctx, IObjectValue model, IObjectCollection objColl) throws BOSException {
        String bosType = "";
        String destBillId = "";
        IObjectValue objValue = null;
        if (model == null || objColl == null || objColl.size() == 0) {
            return;
        }
        String srcBillId = model.get("id").toString();
        String srcBosType = model.getBOSType().toString();
        StringBuilder sql = new StringBuilder();
        int size = objColl.size();
        for (int i = 0; i < size; ++i) {
            sql.append("INSERT INTO t_bot_relation (FID,FSrcEntityID,FDestEntityID,FSrcObjectID,FDestObjectID,FOperatorID,FisEffected,FType) ");
            sql.append(" VALUES ( ");
            objValue = objColl.getObject(i);
            destBillId = objValue.get("id").toString();
            bosType = objValue.getBOSType().toString();
            sql.append("'").append(BOSUuid.create((BOSObjectType)new BOSObjectType("59302EC6")).toString()).append("',");
            sql.append("'").append(srcBosType).append("',");
            sql.append("'").append(bosType).append("',");
            sql.append("'").append(srcBillId).append("',");
            sql.append("'").append(destBillId).append("',");
            sql.append("'unknown',");
            sql.append("1,");
            sql.append("0) \r\n");
        }
        if (sql.length() > 0) {
            DbUtil.execute((Context)ctx, (String)sql.toString());
        }
    }

    public void checkMatCompanyInfo(Context ctx, InvBillBaseInfo info) throws BOSException, EASBizException {
        InvServerUtils.checkMatCompanyInfo(ctx, info, InvBizException.MATERIAL_COMPANY_NULL_VIRTUAL);
        if (info.isIsInitBill()) {
            SCMServerUtils.checkInitBizDate((Context)ctx, (SCMBillBaseInfo)info, (CompanyOrgUnitInfo)this.getCompanyOrgUnit(info), (boolean)true);
        } else {
            SCMServerUtils.checkBizDate((Context)ctx, (IObjectValue)info, (CompanyOrgUnitInfo)this.getCompanyOrgUnit(info), (boolean)true);
        }
    }

    protected CompanyOrgUnitInfo getCompanyOrgUnit(InvBillBaseInfo billInfo) throws BOSException, EASBizException {
        IObjectCollection iObjectCollection = (IObjectCollection)billInfo.get("entry");
        if (iObjectCollection != null && iObjectCollection.size() > 0) {
            InvBillBaseEntryInfo aInvBillBaseEntryInfo = (InvBillBaseEntryInfo)iObjectCollection.getObject(0);
            CompanyOrgUnitInfo aCompanyOrgUnitInfo = (CompanyOrgUnitInfo)aInvBillBaseEntryInfo.get("companyOrgUnit");
            return aCompanyOrgUnitInfo;
        }
        return null;
    }

    protected void calculateBill(Context ctx, InvBillBaseInfo aInvBillBaseInfo) throws BOSException, EASBizException {
        ICalculateFacade icf = CalculateFacadeFactory.getLocalInstance((Context)ctx);
        icf.calculate((CoreBillBaseInfo)aInvBillBaseInfo);
    }

    protected void writeBackActualCost(IObjectValue model, Context ctx) throws BOSException, EASBizException {
        if (model instanceof MoveIssueBillInfo) {
            MoveIssueBillInfo info = (MoveIssueBillInfo)model;
            BizTypeInfo bizTypeInfo = info.getBizType();
            String materilaReqID = info.getSourceBillId();
            if (bizTypeInfo.getNumber().equals("349")) {
                CompanyOrgUnitInfo comp = InvServerUtils.getCompanyInfoForStorage(ctx, info.getStorageOrgUnit());
                if (comp == null) {
                    return;
                }
                String companyId = comp.getId().toString();
                StringBuffer updateIssue = new StringBuffer();
                updateIssue.append(" update T_IM_MaterialReqBillEntry as t10 ");
                updateIssue.append(" set (FActualCost,FUnitActualCost) = ( ");
                updateIssue.append(" select t.FActualCost,t.FUnitActualCost from ( ");
                updateIssue.append(" \tselect t2.fid as fid, sum(isnull(t1.FActualCost,0)) as FActualCost,");
                updateIssue.append(" \tround(decimal(sum(isnull(t1.FActualCost,0)),21,8)/decimal(sum(t1.fqty),21,8),8) as FUnitActualCost");
                updateIssue.append(" \tfrom T_IM_MoveIssueBillentry as t1 ");
                updateIssue.append(" \tinner join T_IM_MaterialReqBillEntry as t2 on t2.Fid = t1.FSourceBillEntryID and t1.FSourceBIllID = '" + materilaReqID + "' ");
                updateIssue.append(" \tinner join t_bd_materialcompanyinfo as mci on mci.fmaterialid = t2.fmaterialid ");
                updateIssue.append(" \tand mci.fcompanyid ='" + companyId + "' and mci.fstatus = 1 and mci.FAccountType = 1 ");
                updateIssue.append(" \tgroup by t2.Fid ");
                updateIssue.append(" ) as t where t10.fid = t.fid )");
                StringBuffer sb = new StringBuffer();
                sb.append(" update T_IM_MoveInWarehsBillEntry as t10 ");
                sb.append(" set (FActualCost,FUnitActualCost) = ( ");
                sb.append(" select t.FActualCost,t.FUnitActualCost from ( ");
                sb.append(" \tselect t2.FID as fid, ");
                sb.append(" \tsum(isnull(t1.FActualCost,0)) as FActualCost, ");
                sb.append(" \tround(decimal(sum(isnull(t1.FActualCost,0)),21,8)/decimal(sum(t1.fqty),21,8),8) as FUnitActualCost");
                sb.append(" \tfrom T_IM_MoveIssueBillentry as t1 ");
                sb.append(" \tinner join T_IM_MoveInWarehsBillEntry as t2 on t2.FSourceBillEntryID = t1.FSourceBillEntryID and t2.FSourceBIllID = '" + materilaReqID + "' ");
                sb.append(" \tinner join t_bd_materialcompanyinfo as mci on mci.fmaterialid = t2.fmaterialid ");
                sb.append(" \tand mci.fcompanyid ='" + companyId + "' and mci.fstatus = 1 and mci.FAccountType = 1 ");
                sb.append(" \tgroup by t2.FID ");
                sb.append(" ) as t where t10.fid = t.fid) ");
                DBUtil.executeBatch((Context)ctx, (String[])new String[]{updateIssue.toString(), sb.toString()});
            }
        }
    }

    protected void writeBack4MoveIssue(IObjectValue model, Context ctx) throws BOSException, EASBizException {
        CompanyOrgUnitInfo comp;
        InvBillBaseInfo info;
        String[] sqls = new String[1];
        StringBuffer sb = new StringBuffer();
        String companyId = null;
        if (model instanceof MoveIssueBillInfo) {
            info = (MoveIssueBillInfo)model;
            comp = InvServerUtils.getCompanyInfoForStorage(ctx, info.getStorageOrgUnit());
            if (comp == null) {
                return;
            }
            companyId = comp.getId().toString();
            sb.append(" update T_IM_MoveIssueBillEntry t10 set (FUnitStandardCost,fstandardCost) =  (");
            sb.append(" select company.fstandardcost,TO_DECIMAL(company.fstandardcost*Entry.fqty,17,4)  from ");
            sb.append(" T_IM_MoveIssueBill bill inner join T_IM_MoveIssueBillEntry entry on bill.fid = entry.fparentid ");
            sb.append(" inner join t_bd_materialcompanyinfo company on company.fmaterialid = entry.fmaterialid ");
            sb.append(" and company.fcompanyid ='" + companyId + "' and company.fstatus = 1 and company.fstandardcost is not null ");
            sb.append("  and company.faccounttype = 2 and bill.fid = '" + info.getId().toString() + "' where entry.fid = t10.fid  )");
            sqls[0] = sb.toString();
            DBUtil.executeBatch((Context)ctx, (String[])sqls);
        }
        if (model instanceof MoveInWarehsBillInfo) {
            info = (MoveInWarehsBillInfo)model;
            comp = InvServerUtils.getCompanyInfoForStorage(ctx, info.getStorageOrgUnit());
            if (comp == null) {
                return;
            }
            companyId = comp.getId().toString();
            sb.setLength(0);
            sb.append(" update T_IM_MoveInWarehsBillEntry as t10 set (FUnitStandardCost,fstandardCost) =  (");
            sb.append(" select company.fstandardcost,TO_DECIMAL(company.fstandardcost*Entry.fqty,17,4) ");
            sb.append(" from  T_IM_MoveInWarehsBill as bill ");
            sb.append(" inner join T_IM_MoveInWarehsBillEntry as entry on bill.fid = entry.fparentid ");
            sb.append(" inner join t_bd_materialcompanyinfo as company on company.fmaterialid = entry.fmaterialid ");
            sb.append(" and company.fcompanyid ='" + companyId + "' and company.fstatus = 1 and company.fstandardcost is not null ");
            sb.append(" and company.faccounttype = 2 and bill.fid = '" + info.getId().toString() + "' ");
            sb.append(" where entry.fid = t10.fid )");
            sqls[0] = sb.toString();
            DBUtil.executeBatch((Context)ctx, (String[])sqls);
        }
    }

    protected void writeBack4JumpStorage(IObjectValue model, Context ctx) throws BOSException, EASBizException {
        MaterialReqBillInfo info = (MaterialReqBillInfo)model;
        BizTypeInfo bizTypeInfo = info.getBizType();
        String materilaReqID = info.getId().toString();
        if (bizTypeInfo.getNumber().equals("348")) {
            StringBuffer updateIssue = new StringBuffer();
            updateIssue.append(" update T_IM_MaterialReqBillEntry as t10 ");
            updateIssue.append(" set (FUnitActualCost,FActualCost)  ");
            updateIssue.append(" = ( ");
            updateIssue.append(" select t2.Fsettleprice,TO_DECIMAL(t2.Fsettleprice*t2.fqty,17,4)");
            updateIssue.append(" from T_IM_MaterialReqBillEntry as t2 where t2.FParentID = '" + materilaReqID + "' ");
            updateIssue.append("  and t10.fid = t2.fid  ) ");
            StringBuffer updateMoveIn = new StringBuffer();
            updateMoveIn.append(" update T_IM_MoveInWarehsBillEntry as t10 ");
            updateMoveIn.append(" set (FActualCost,FUnitActualCost) = ( ");
            updateMoveIn.append(" select t1.FActualCost,t1.FUnitActualCost");
            updateMoveIn.append("  from T_IM_MaterialReqBillEntry as t1 inner join  T_IM_MoveInWarehsBillEntry as t2 ");
            updateMoveIn.append("  on t2.FSourceBillEntryID = t1.FID ");
            updateMoveIn.append("  and t1.FParentID  = '" + materilaReqID + "' ");
            updateMoveIn.append("  where t10.fid = t2.fid  )");
            DBUtil.executeBatch((Context)ctx, (String[])new String[]{updateIssue.toString(), updateMoveIn.toString()});
        }
    }
}

