/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv.app.autocreate.plugin;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ExchangeRateInfo;
import com.kingdee.eas.basedata.master.cssp.CustomerFactory;
import com.kingdee.eas.basedata.master.cssp.CustomerInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.basedata.scm.common.BizTypeInfo;
import com.kingdee.eas.basedata.scm.im.inv.InvException;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.dynbusiness.util.BusinessProcessUtil;
import com.kingdee.eas.dynbusiness.util.DBUtil;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBillBase;
import com.kingdee.eas.framework.batchaction.BatchActionEnum;
import com.kingdee.eas.scm.common.BizActionEnum;
import com.kingdee.eas.scm.common.app.SCMServerUtils;
import com.kingdee.eas.scm.framework.bizflow.app.BizFlowServerHelper;
import com.kingdee.eas.scm.im.inv.IInventoryUpdate;
import com.kingdee.eas.scm.im.inv.InvBillBaseInfo;
import com.kingdee.eas.scm.im.inv.InvBizException;
import com.kingdee.eas.scm.im.inv.InventoryUpdateFactory;
import com.kingdee.eas.scm.im.inv.MaterialReqBillInfo;
import com.kingdee.eas.scm.im.inv.MaterialReqBillPriceInfoEntryCollection;
import com.kingdee.eas.scm.im.inv.MaterialReqBillPriceInfoEntryInfo;
import com.kingdee.eas.scm.im.inv.SaleIssueBillFactory;
import com.kingdee.eas.scm.im.inv.SaleIssueBillInfo;
import com.kingdee.eas.scm.im.inv.SaleIssueEntryCollection;
import com.kingdee.eas.scm.im.inv.SaleIssueEntryInfo;
import com.kingdee.eas.scm.im.inv.app.InvServerUtils;
import com.kingdee.eas.scm.im.inv.app.SaleIssueAlgorithmForInfo;
import com.kingdee.eas.scm.im.inv.app.autocreate.plugin.AutoCreateInvBillPlugInHandler;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;

public class AutoCreateMRToSIPlugInHandler
extends AutoCreateInvBillPlugInHandler {
    @Override
    public void execute(Context ctx, IObjectValue model, IObjectCollection objColl) throws BOSException, EASBizException {
        super.execute(ctx, model, objColl);
    }

    @Override
    public void processDefaultValue(Context ctx, IObjectValue model, IObjectCollection objColl) throws BOSException, EASBizException {
        InvBillBaseInfo info = null;
        super.processDefaultValue(ctx, model, objColl);
        int size = objColl.size();
        for (int i = 0; i < size; ++i) {
            info = (InvBillBaseInfo)objColl.getObject(i);
            this.setEntryValue(info, model, ctx);
            SaleIssueBillFactory.getLocalInstance(ctx).matchLotInfo(info);
        }
    }

    @Override
    public void processBillCheck(Context ctx, IObjectValue model, IObjectCollection objColl) throws BOSException, EASBizException {
        super.processBillCheck(ctx, model, objColl);
        ICoreBillBase iCoreBillBase = (ICoreBillBase)BusinessProcessUtil.getLocBizInteface((Context)ctx, (BOSObjectType)objColl.getObject(0).getBOSType());
        int size = objColl.size();
        for (int i = 0; i < size; ++i) {
            iCoreBillBase.addnew((CoreBaseInfo)objColl.getObject(i));
        }
    }

    @Override
    public void processOtherBiz(Context ctx, IObjectValue model, IObjectCollection objColl) throws BOSException, EASBizException {
        int i;
        String bizType = "";
        String transTypeID = null;
        InvBillBaseInfo info = null;
        this.traceUpAndDown(ctx, model, objColl);
        IInventoryUpdate iInventoryUpdate = InventoryUpdateFactory.getLocalInstance((Context)ctx);
        int size = objColl.size();
        for (i = 0; i < size; ++i) {
            info = (InvBillBaseInfo)objColl.getObject(i);
            if (info.getTransactionType() != null) {
                transTypeID = info.getTransactionType().getId().toString();
                iInventoryUpdate.updateInventory(BizActionEnum.AUDIT, info.getId().toString(), transTypeID);
            }
            this.calculateBill(ctx, info);
        }
        if (model instanceof MaterialReqBillInfo) {
            MaterialReqBillInfo tempInfo = (MaterialReqBillInfo)model;
            bizType = tempInfo.getBizType().getId().toString();
        }
        if (!StringUtils.isEmpty((String)bizType) && bizType.equals("nhvcdx82RzuTw48FSlV79CQHQ1w=")) {
            this.writeBack4JumpCompany(model, ctx);
        }
        size = objColl.size();
        for (i = 0; i < size; ++i) {
            BizFlowServerHelper.doProcessing((Context)ctx, (IObjectValue)objColl.getObject(i), (BatchActionEnum)BatchActionEnum.SAVE);
            objColl.getObject(i).put("HasBeenCreate", (Object)true);
            BizFlowServerHelper.doProcessing((Context)ctx, (IObjectValue)objColl.getObject(i), (BatchActionEnum)BatchActionEnum.AUDIT);
        }
    }

    private void setEntryValue(InvBillBaseInfo info, IObjectValue model, Context ctx) throws EASBizException, BOSException {
        BigDecimal zero = new BigDecimal("0.00");
        SaleIssueBillInfo saleIssueInfo = (SaleIssueBillInfo)info;
        saleIssueInfo.setExchangeRate(this.getExchangeRate(ctx, model));
        SaleIssueEntryCollection saleIssueEntrys = saleIssueInfo.getEntry();
        SaleIssueEntryInfo saleIssueEntry = null;
        MaterialReqBillPriceInfoEntryInfo priceInfo = null;
        CustomerInfo innerBalanceCustomer = null;
        int count = saleIssueEntrys.size();
        if (saleIssueInfo.getCustomer() == null) {
            String couID = saleIssueInfo.getDescription();
            saleIssueInfo.setDescription(null);
            if (couID != null && couID.length() > 1) {
                innerBalanceCustomer = CustomerFactory.getLocalInstance((Context)ctx).getInterCustomerCollection(couID, null).get(0);
            }
            if (innerBalanceCustomer == null && info.getBizType() != null && "nhvcdx82RzuTw48FSlV79CQHQ1w=".equals(info.getBizType().getId().toString())) {
                throw new InvBizException(InvBizException.HAS_NO_INNER_CUSTOMER);
            }
            saleIssueInfo.setCustomer(innerBalanceCustomer);
        } else {
            innerBalanceCustomer = saleIssueInfo.getCustomer();
        }
        BigDecimal price = zero;
        BigDecimal realPrice = zero;
        BigDecimal realTaxPrice = zero;
        BigDecimal taxPrice = zero;
        for (int i = 0; i < count; ++i) {
            saleIssueEntry = saleIssueEntrys.get(i);
            saleIssueEntry.setBalanceCustomer(innerBalanceCustomer);
            saleIssueEntry.setOrderCustomer(innerBalanceCustomer);
            saleIssueEntry.setPaymentCustomer(innerBalanceCustomer);
            priceInfo = this.getEntryByID(model, saleIssueEntry.getSourceBillEntryId());
            if (priceInfo == null) continue;
            price = priceInfo.getPrice() == null ? zero : priceInfo.getPrice();
            realPrice = priceInfo.getRealPrice() == null ? zero : priceInfo.getRealPrice();
            realTaxPrice = priceInfo.getRealTaxPrice() == null ? zero : priceInfo.getRealTaxPrice();
            taxPrice = priceInfo.getTaxPrice() == null ? zero : priceInfo.getTaxPrice();
            saleIssueEntry.setSalePrice(price);
            saleIssueEntry.setLocalPrice(price);
            saleIssueEntry.setDiscountType(priceInfo.getDiscountType());
            saleIssueEntry.setActualPrice(realPrice);
            saleIssueEntry.setPrice(realTaxPrice);
            saleIssueEntry.setDiscount(priceInfo.getDiscount());
            saleIssueEntry.setTaxPrice(taxPrice);
            saleIssueEntry.setTaxRate(priceInfo.getTaxRate());
            if (saleIssueEntry.getActualCost() == null) {
                saleIssueEntry.setActualCost(zero);
            }
            if (saleIssueEntry.getUnitActualCost() == null) {
                saleIssueEntry.setUnitActualCost(zero);
            }
            if (saleIssueEntry.getAmount() == null) {
                saleIssueEntry.setAmount(zero);
            }
            if (saleIssueEntry.getNonTaxAmount() != null) continue;
            saleIssueEntry.setNonTaxAmount(zero);
        }
        try {
            new SaleIssueAlgorithmForInfo(saleIssueInfo, ctx).revalue();
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
    }

    private BigDecimal getExchangeRate(Context ctx, IObjectValue model) throws EASBizException, BOSException {
        CompanyOrgUnitInfo CompanyInfo;
        MaterialReqBillInfo materialReqBillInfo = (MaterialReqBillInfo)model;
        StorageOrgUnitInfo supplyStoreOrgUnit = materialReqBillInfo.getSupplyStoreOrgUnit();
        StorageOrgUnitInfo StoreOrgUnit = materialReqBillInfo.getStorageOrgUnit();
        CompanyOrgUnitInfo supplyCompanyInfo = InvServerUtils.getCompanyInfoForStorage(ctx, supplyStoreOrgUnit);
        CurrencyInfo supplyCurrencyInfo = null;
        CurrencyInfo currencyInfo = null;
        if (supplyCompanyInfo != null) {
            supplyCurrencyInfo = supplyCompanyInfo.getBaseCurrency();
        }
        if ((CompanyInfo = InvServerUtils.getCompanyInfoForStorage(ctx, StoreOrgUnit)) != null) {
            currencyInfo = CompanyInfo.getBaseCurrency();
        }
        if (supplyCurrencyInfo != null && currencyInfo != null && supplyCurrencyInfo.getId() != null && currencyInfo.getId() != null) {
            if (supplyCurrencyInfo.getId().equals((Object)currencyInfo.getId())) {
                return new BigDecimal("1.00");
            }
            ObjectUuidPK sourceCurrPK = null;
            ObjectUuidPK destCurrPK = null;
            sourceCurrPK = new ObjectUuidPK(currencyInfo.getId());
            ExchangeRateInfo tempexrateinfo = SCMServerUtils.getExchangeRate((Context)ctx, (CompanyOrgUnitInfo)supplyCompanyInfo, (IObjectPK)sourceCurrPK, (IObjectPK)(destCurrPK = new ObjectUuidPK(supplyCurrencyInfo.getId())));
            if (tempexrateinfo != null) {
                return tempexrateinfo.getConvertRate();
            }
            throw new InvException(InvException.SALEISSUENOTFOUNDEXCHANGERATE);
        }
        return new BigDecimal("0.00");
    }

    private MaterialReqBillPriceInfoEntryInfo getEntryByID(IObjectValue model, String materialReqEntryID) {
        MaterialReqBillInfo materialReqBillInfo = (MaterialReqBillInfo)model;
        MaterialReqBillPriceInfoEntryInfo priceInfo = null;
        MaterialReqBillPriceInfoEntryCollection priceInfos = materialReqBillInfo.getPriceInfo();
        int count = priceInfos.size();
        for (int i = 0; i < count; ++i) {
            MaterialReqBillPriceInfoEntryInfo entry = priceInfos.get(i);
            String id = entry.getMaterialReqEntryID();
            if (id == null || !id.equals(materialReqEntryID)) continue;
            priceInfo = entry;
            break;
        }
        return priceInfo;
    }

    private void writeBack4JumpCompany(IObjectValue model, Context ctx) throws BOSException, EASBizException {
        MaterialReqBillInfo info = (MaterialReqBillInfo)model;
        BizTypeInfo bizTypeInfo = info.getBizType();
        String materilaReqID = info.getId().toString();
        if (bizTypeInfo.getId().toString().equals("nhvcdx82RzuTw48FSlV79CQHQ1w=")) {
            StringBuffer updateIssue = new StringBuffer();
            updateIssue.append(" update T_IM_MaterialReqBillEntry as t10 ");
            updateIssue.append(" set (FUnitActualCost,FActualCost)  ");
            updateIssue.append(" = ( ");
            updateIssue.append(" select TO_DECIMAL(isnull(t1.FRealPrice,0),21,8),TO_DECIMAL(isnull(t1.FRealPrice,0) * isnull(t2.fqty,0),17,4)");
            updateIssue.append(" from T_IM_MaterialReqBillPriceInfo as t1 inner join  T_IM_MaterialReqBillEntry as t2 ");
            updateIssue.append("  on t2.Fid = t1.FMaterialReqEntryID ");
            updateIssue.append("  and t2.FParentID = '" + materilaReqID + "' ");
            updateIssue.append("  where t10.fid = t2.fid  ) ");
            StringBuffer updateMoveIn = new StringBuffer();
            updateMoveIn.append(" update T_IM_MaterialReqBillEntry as t10 ");
            updateMoveIn.append(" set (FActualCost) = ( ");
            updateMoveIn.append(" select TO_DECIMAL(isnull(t2.FActualCost,0),17,4) ");
            updateMoveIn.append("  from T_IM_MaterialReqBillEntry as t1 inner join  T_IM_PurinwarehsEntry as t2 ");
            updateMoveIn.append("   on t2.FSourceBillEntryID = t1.FID ");
            updateMoveIn.append("  and t1.FParentID  = '" + materilaReqID + "' ");
            updateMoveIn.append("  where t10.fid = t1.fid  )");
            DBUtil.executeBatch((Context)ctx, (String[])new String[]{updateIssue.toString(), updateMoveIn.toString()});
        }
    }
}

