/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv.app.autocreate.plugin;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.material.AccountType;
import com.kingdee.eas.basedata.master.material.MaterialCompanyInfoCollection;
import com.kingdee.eas.basedata.master.material.MaterialCompanyInfoFactory;
import com.kingdee.eas.basedata.master.material.MaterialCompanyInfoInfo;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitCollection;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitFactory;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.dynbusiness.util.BusinessProcessUtil;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBillBase;
import com.kingdee.eas.scm.im.inv.InvBillBaseEntryInfo;
import com.kingdee.eas.scm.im.inv.SaleIssueBillInfo;
import com.kingdee.eas.scm.im.inv.SaleIssueEntryCollection;
import com.kingdee.eas.scm.im.inv.SaleIssueEntryInfo;
import com.kingdee.eas.scm.im.inv.app.autocreate.plugin.AutoCreateInvBillPlugInHandler;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class AutoCreateSIToSIPlugInHandler
extends AutoCreateInvBillPlugInHandler {
    @Override
    public void execute(Context ctx, IObjectValue model, IObjectCollection objColl) throws BOSException, EASBizException {
        super.execute(ctx, model, objColl);
    }

    @Override
    public void processDefaultValue(Context ctx, IObjectValue model, IObjectCollection objColl) throws BOSException, EASBizException {
        super.processDefaultValue(ctx, model, objColl);
        this.calVirtualSaleIssueBillCost(ctx, objColl);
        ICoreBillBase iCoreBillBase = (ICoreBillBase)BusinessProcessUtil.getLocBizInteface((Context)ctx, (BOSObjectType)objColl.getObject(0).getBOSType());
        iCoreBillBase.handleAfterTransform("SAVE", objColl);
    }

    @Override
    public void processBillCheck(Context ctx, IObjectValue model, IObjectCollection objColl) throws BOSException, EASBizException {
        super.processBillCheck(ctx, model, objColl);
        ICoreBillBase iCoreBillBase = (ICoreBillBase)BusinessProcessUtil.getLocBizInteface((Context)ctx, (BOSObjectType)objColl.getObject(0).getBOSType());
        int size = objColl.size();
        for (int i = 0; i < size; ++i) {
            iCoreBillBase.addnew((CoreBaseInfo)objColl.getObject(i));
        }
    }

    @Override
    public void processOtherBiz(Context ctx, IObjectValue model, IObjectCollection objColl) throws BOSException, EASBizException {
        super.processOtherBiz(ctx, model, objColl);
    }

    private void calVirtualSaleIssueBillCost(Context ctx, IObjectCollection infos) throws BOSException {
        if (null == infos || infos.size() == 0) {
            return;
        }
        HashSet<String> materialIdSet = new HashSet<String>();
        HashSet<String> couIdSet = new HashSet<String>();
        HashSet<String> unitIdSet = new HashSet<String>();
        for (int i = 0; i < infos.size(); ++i) {
            SaleIssueBillInfo info = (SaleIssueBillInfo)infos.getObject(i);
            SaleIssueEntryCollection entryCol = info.getEntry();
            if (null == entryCol || entryCol.size() == 0) continue;
            SaleIssueEntryInfo entry = null;
            int len = entryCol.size();
            for (int j = 0; j < len; ++j) {
                entry = entryCol.get(j);
                if (null != entry.getUnit()) {
                    unitIdSet.add(entry.getUnit().getId().toString());
                }
                if (null == entry.getMaterial() || null == entry.getCompanyOrgUnit()) continue;
                materialIdSet.add(entry.getMaterial().getId().toString());
                couIdSet.add(entry.getCompanyOrgUnit().getId().toString());
            }
        }
        Map materialCompanyMap = this.getMaterialCompanyInfo(ctx, materialIdSet, couIdSet);
        Map mmuMap = this.getMultiMeasureUnit(ctx, materialIdSet, unitIdSet);
        this.calEntryCost(infos, materialCompanyMap, mmuMap);
    }

    private Map getMaterialCompanyInfo(Context ctx, Set materialIdSet, Set couIdSet) throws BOSException {
        if (null == materialIdSet || null == couIdSet || materialIdSet.size() == 0 || couIdSet.size() == 0) {
            return new HashMap();
        }
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("mateial.id"));
        selector.add(new SelectorItemInfo("company.id"));
        selector.add(new SelectorItemInfo("accountType"));
        selector.add(new SelectorItemInfo("standardCost"));
        selector.add(new SelectorItemInfo("calculateType"));
        entityViewInfo.setSelector(selector);
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("mateial.id", (Object)materialIdSet, CompareType.INCLUDE));
        filterInfo.getFilterItems().add(new FilterItemInfo("company.id", (Object)couIdSet, CompareType.INCLUDE));
        entityViewInfo.setFilter(filterInfo);
        MaterialCompanyInfoCollection col = MaterialCompanyInfoFactory.getLocalInstance((Context)ctx).getMaterialCompanyInfoCollection(entityViewInfo);
        if (null == col || col.size() == 0) {
            return new HashMap();
        }
        HashMap<String, MaterialCompanyInfoInfo> ret = new HashMap<String, MaterialCompanyInfoInfo>();
        MaterialCompanyInfoInfo mci = null;
        int size = col.size();
        for (int i = 0; i < size; ++i) {
            mci = col.get(i);
            String materialId = mci.getMateial().getId().toString();
            String couId = mci.getCompany().getId().toString();
            ret.put(materialId + couId, mci);
        }
        return ret;
    }

    private Map getMultiMeasureUnit(Context ctx, Set materialIdSet, Set unitIdSet) throws BOSException {
        if (null == unitIdSet || unitIdSet.size() == 0 || null == materialIdSet || materialIdSet.size() == 0) {
            return new HashMap();
        }
        EntityViewInfo entity = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("measureUnit.id", (Object)unitIdSet, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("material.id", (Object)materialIdSet, CompareType.INCLUDE));
        entity.setFilter(filter);
        MultiMeasureUnitCollection col = MultiMeasureUnitFactory.getLocalInstance((Context)ctx).getMultiMeasureUnitCollection(entity);
        if (null == col || col.size() == 0) {
            return new HashMap();
        }
        HashMap<String, MultiMeasureUnitInfo> map = new HashMap<String, MultiMeasureUnitInfo>();
        int size = col.size();
        for (int i = 0; i < size; ++i) {
            MultiMeasureUnitInfo mmu = col.get(i);
            String key = mmu.getMaterial().getId().toString() + mmu.getMeasureUnit().getId().toString();
            map.put(key, mmu);
        }
        return map;
    }

    private void calEntryCost(IObjectCollection objectCollection, Map materialCompanyMap, Map mmuMap) {
        if (null == objectCollection || objectCollection.size() == 0 || null == materialCompanyMap || materialCompanyMap.size() == 0 || null == mmuMap) {
            return;
        }
        BigDecimal convsRate = new BigDecimal("1.0");
        int localAmtPrecision = 2;
        int size = objectCollection.size();
        for (int i = 0; i < size; ++i) {
            SaleIssueBillInfo saleIssueBillInfo = (SaleIssueBillInfo)objectCollection.getObject(i);
            SaleIssueEntryCollection entryCol = saleIssueBillInfo.getEntry();
            if (null == entryCol || entryCol.size() == 0) continue;
            int len = entryCol.size();
            for (int j = 0; j < len; ++j) {
                MultiMeasureUnitInfo mmu;
                String tKey;
                MaterialCompanyInfoInfo mciInfo;
                SaleIssueEntryInfo saleIssueEntryInfo = entryCol.get(j);
                MaterialInfo materialInfo = saleIssueEntryInfo.getMaterial();
                CompanyOrgUnitInfo companyOrgUnit = saleIssueEntryInfo.getCompanyOrgUnit();
                MeasureUnitInfo unit = saleIssueEntryInfo.getUnit();
                if (null == materialInfo || null == companyOrgUnit || (mciInfo = (MaterialCompanyInfoInfo)materialCompanyMap.get(tKey = materialInfo.getId().toString() + companyOrgUnit.getId().toString())) == null) continue;
                convsRate = null;
                if (null != unit && null != (mmu = (MultiMeasureUnitInfo)mmuMap.get(tKey = materialInfo.getId().toString() + unit.getId().toString()))) {
                    convsRate = mmu.getBaseConvsRate();
                }
                this.calEntryUnitStandardCost(saleIssueEntryInfo, mciInfo, convsRate);
                this.calEntryStandardCostByUnitCost(saleIssueEntryInfo, localAmtPrecision);
                if (AccountType.STANDARDCOST.equals((Object)mciInfo.getAccountType())) {
                    saleIssueEntryInfo.setUnitActualCost(saleIssueEntryInfo.getUnitStandardCost());
                }
                this.calEntryActualCostByUnitCost(saleIssueEntryInfo, localAmtPrecision);
            }
        }
    }

    private void calEntryActualCostByUnitCost(InvBillBaseEntryInfo entryInfo, int amtPrecision) {
        if (entryInfo == null) {
            return;
        }
        BigDecimal unitActualCost = entryInfo.getUnitActualCost() == null ? SysConstant.BIGZERO : entryInfo.getUnitActualCost();
        BigDecimal qty = entryInfo.getQty() == null ? SysConstant.BIGZERO : entryInfo.getQty();
        BigDecimal actualCost = unitActualCost.multiply(qty);
        actualCost = actualCost.setScale(amtPrecision, 4);
        entryInfo.setActualCost(actualCost);
    }

    private void calEntryUnitStandardCost(InvBillBaseEntryInfo entryInfo, MaterialCompanyInfoInfo mciInfo, BigDecimal convsRate) {
        if (null == entryInfo || null == mciInfo) {
            return;
        }
        BigDecimal unitStandardCost = mciInfo.getStandardCost();
        BigDecimal bigDecimal = unitStandardCost = unitStandardCost != null ? unitStandardCost : SysConstant.BIGZERO;
        if (null != convsRate) {
            unitStandardCost = unitStandardCost.multiply(convsRate);
        }
        entryInfo.setUnitStandardCost(unitStandardCost);
    }

    private void calEntryStandardCostByUnitCost(InvBillBaseEntryInfo entryInfo, int amtPrecision) {
        if (entryInfo == null) {
            return;
        }
        BigDecimal unitStandardCost = entryInfo.getUnitStandardCost();
        BigDecimal qty = entryInfo.getQty() == null ? SysConstant.BIGZERO : entryInfo.getQty();
        BigDecimal standardCost = unitStandardCost.multiply(qty);
        standardCost = standardCost.setScale(amtPrecision, 4);
        entryInfo.setStandardCost(standardCost);
    }
}

