/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv.app.dataloader;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.master.material.MaterialInventoryCollection;
import com.kingdee.eas.basedata.master.material.MaterialInventoryFactory;
import com.kingdee.eas.basedata.master.material.MaterialInventoryInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.scm.common.SCMBillBaseInfo;
import com.kingdee.eas.scm.common.SCMBillEntryBaseInfo;
import com.kingdee.eas.scm.framework.dataloader.DataTypeEnum;
import com.kingdee.eas.scm.framework.dataloader.IDataCache;
import com.kingdee.eas.scm.framework.dataloader.app.AbstractServerDataLoader;
import com.kingdee.eas.scm.im.inv.InvBillBaseInfo;
import com.kingdee.eas.scm.im.inv.MaterialRequestBillEntryInfo;
import com.kingdee.eas.scm.im.inv.MaterialRequestBillInfo;
import com.kingdee.eas.scm.im.inv.StockReqInfo;
import com.kingdee.eas.scm.im.inv.StockTransferBillInfo;
import com.kingdee.eas.scm.im.inv.TransferOrderBillEntryInfo;
import com.kingdee.eas.scm.im.inv.TransferOrderBillInfo;
import com.kingdee.eas.scm.sd.sale.SaleOrderEntryInfo;
import com.kingdee.eas.scm.sd.sale.SaleOrderInfo;
import java.util.HashMap;
import java.util.HashSet;

public class MaterialInventoryDataLoader
extends AbstractServerDataLoader {
    public MaterialInventoryDataLoader(Context ctx) {
        super(ctx);
    }

    public boolean supports(Class<?> clazz) {
        return InvBillBaseInfo.class.isAssignableFrom(clazz) || StockTransferBillInfo.class.isAssignableFrom(clazz) || TransferOrderBillInfo.class.isAssignableFrom(clazz) || StockReqInfo.class.isAssignableFrom(clazz) || SaleOrderInfo.class.isAssignableFrom(clazz);
    }

    public void load(IObjectCollection objectCol, IDataCache dataCache) throws BOSException, EASBizException {
        MaterialInventoryInfo info;
        StorageOrgUnitInfo sou;
        SCMBillEntryBaseInfo entryInfo;
        IObjectCollection entryCol;
        SCMBillBaseInfo invBillInfo;
        assert (objectCol != null);
        assert (dataCache != null);
        HashSet<String> materialIdSet = new HashSet<String>();
        HashSet<String> storageOrgUnitIdSet = new HashSet<String>();
        int len = objectCol.size();
        for (int index = 0; index < len; ++index) {
            invBillInfo = (SCMBillBaseInfo)objectCol.getObject(index);
            if (invBillInfo == null || invBillInfo.getEntries() == null || invBillInfo.getEntries().size() == 0) continue;
            entryCol = invBillInfo.getEntries();
            int size = entryCol.size();
            for (int i = 0; i < size; ++i) {
                entryInfo = (SCMBillEntryBaseInfo)entryCol.getObject(i);
                sou = this.getStorageOrgUnitInfo(invBillInfo, entryInfo);
                if (entryInfo.getMaterial() == null || sou == null) continue;
                materialIdSet.add(entryInfo.getMaterial().getId().toString());
                storageOrgUnitIdSet.add(sou.getId().toString());
                if (!(entryInfo instanceof TransferOrderBillEntryInfo)) continue;
                if (((TransferOrderBillEntryInfo)entryInfo).getIssueStorageOrgUnit() != null) {
                    storageOrgUnitIdSet.add(((TransferOrderBillEntryInfo)entryInfo).getIssueStorageOrgUnit().getId().toString());
                }
                if (((TransferOrderBillEntryInfo)entryInfo).getReceiveStorageOrgUnit() == null) continue;
                storageOrgUnitIdSet.add(((TransferOrderBillEntryInfo)entryInfo).getReceiveStorageOrgUnit().getId().toString());
            }
        }
        if (materialIdSet.size() == 0 || storageOrgUnitIdSet.size() == 0) {
            return;
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("material.id", materialIdSet, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("orgUnit.id", storageOrgUnitIdSet, CompareType.INCLUDE));
        view.setFilter(filter);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("id");
        selector.add("*");
        view.setSelector(selector);
        MaterialInventoryCollection matInventoryCol = MaterialInventoryFactory.getLocalInstance((Context)this.getCtx()).getMaterialInventoryCollection(view);
        HashMap<String, MaterialInventoryInfo> tMap = new HashMap<String, MaterialInventoryInfo>();
        int size = matInventoryCol.size();
        for (int i = 0; i < size; ++i) {
            info = matInventoryCol.get(i);
            String key = info.getMaterial().getId().toString() + info.getOrgUnit().getId().toString();
            tMap.put(key, info);
        }
        int len2 = objectCol.size();
        for (int index = 0; index < len2; ++index) {
            invBillInfo = (SCMBillBaseInfo)objectCol.getObject(index);
            if (invBillInfo == null || invBillInfo.getEntries() == null || invBillInfo.getEntries().size() == 0) continue;
            entryCol = invBillInfo.getEntries();
            int size2 = entryCol.size();
            for (int i = 0; i < size2; ++i) {
                entryInfo = (SCMBillEntryBaseInfo)entryCol.getObject(i);
                sou = this.getStorageOrgUnitInfo(invBillInfo, entryInfo);
                if (entryInfo.getMaterial() == null || sou == null) continue;
                String key = entryInfo.getMaterial().getId().toString() + sou.getId().toString();
                info = (MaterialInventoryInfo)tMap.get(key);
                dataCache.put(key, (Object)info, DataTypeEnum.MATERIAL_INVENTORY);
                if (!(entryInfo instanceof TransferOrderBillEntryInfo) || ((TransferOrderBillEntryInfo)entryInfo).getIssueStorageOrgUnit() == null || ((TransferOrderBillEntryInfo)entryInfo).getReceiveStorageOrgUnit() == null) continue;
                String issueOrg = ((TransferOrderBillEntryInfo)entryInfo).getIssueStorageOrgUnit().getId().toString();
                String recvOrg = ((TransferOrderBillEntryInfo)entryInfo).getReceiveStorageOrgUnit().getId().toString();
                key = entryInfo.getMaterial().getId().toString() + issueOrg;
                if (!dataCache.contain(key, DataTypeEnum.MATERIAL_INVENTORY)) {
                    info = (MaterialInventoryInfo)tMap.get(key);
                    dataCache.put(key, (Object)info, DataTypeEnum.MATERIAL_INVENTORY);
                }
                if (dataCache.contain(key = entryInfo.getMaterial().getId().toString() + recvOrg, DataTypeEnum.MATERIAL_INVENTORY)) continue;
                info = (MaterialInventoryInfo)tMap.get(key);
                dataCache.put(key, (Object)info, DataTypeEnum.MATERIAL_INVENTORY);
            }
        }
    }

    private StorageOrgUnitInfo getStorageOrgUnitInfo(SCMBillBaseInfo info, SCMBillEntryBaseInfo entry) {
        if (info instanceof MaterialRequestBillInfo) {
            return ((MaterialRequestBillEntryInfo)entry).getReceiveStorage();
        }
        if (info instanceof StockTransferBillInfo) {
            return ((StockTransferBillInfo)info).getIssueStorageOrgUnit();
        }
        if (info instanceof TransferOrderBillInfo) {
            return ((TransferOrderBillInfo)info).getReceiptStorageOrgUnit();
        }
        if (info instanceof StockReqInfo) {
            return ((StockReqInfo)info).getReqStorage();
        }
        if (info instanceof InvBillBaseInfo) {
            return ((InvBillBaseInfo)info).getStorageOrgUnit();
        }
        if (info instanceof SaleOrderInfo) {
            return ((SaleOrderEntryInfo)entry).getStorageOrgUnit();
        }
        return null;
    }
}

