/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv.app.dataloader;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.scm.common.TransactionTypeCollection;
import com.kingdee.eas.basedata.scm.common.TransactionTypeFactory;
import com.kingdee.eas.basedata.scm.common.TransactionTypeInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.scm.framework.dataloader.DataTypeEnum;
import com.kingdee.eas.scm.framework.dataloader.IDataCache;
import com.kingdee.eas.scm.framework.dataloader.app.AbstractServerDataLoader;
import com.kingdee.eas.scm.im.inv.InvBillBaseInfo;
import com.kingdee.eas.scm.util.SCMSelectorFactory;
import java.util.HashSet;

public class TransactionTypeDataLoader
extends AbstractServerDataLoader {
    public TransactionTypeDataLoader(Context ctx) {
        super(ctx);
    }

    public boolean supports(Class<?> clazz) {
        return InvBillBaseInfo.class.isAssignableFrom(clazz);
    }

    public void load(IObjectCollection objectCol, IDataCache dataCache) throws BOSException, EASBizException {
        assert (objectCol != null && objectCol.size() > 0);
        assert (dataCache != null);
        HashSet<String> idSet = new HashSet<String>();
        int size = objectCol.size();
        for (int i = 0; i < size; ++i) {
            InvBillBaseInfo invBillInfo = (InvBillBaseInfo)objectCol.getObject(i);
            if (null == invBillInfo || invBillInfo.getTransactionType() == null) continue;
            idSet.add(invBillInfo.getTransactionType().getId().toString());
        }
        if (idSet.size() == 0) {
            return;
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
        view.setFilter(filter);
        view.setSelector(SCMSelectorFactory.getTransactionTypeSelector((boolean)false));
        TransactionTypeCollection tCol = TransactionTypeFactory.getLocalInstance((Context)this.getCtx()).getTransactionTypeCollection(view);
        int size2 = tCol.size();
        for (int i = 0; i < size2; ++i) {
            TransactionTypeInfo info = tCol.get(i);
            dataCache.put(info.getId().toString(), (Object)info, DataTypeEnum.TRANSACTIONTYPE);
        }
    }
}

