/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv.app.dataloader.matassemble;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.master.material.MaterialPlanCollection;
import com.kingdee.eas.basedata.master.material.MaterialPlanFactory;
import com.kingdee.eas.basedata.master.material.MaterialPlanInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.scm.common.SCMBillEntryBaseInfo;
import com.kingdee.eas.scm.framework.dataloader.DataTypeEnum;
import com.kingdee.eas.scm.framework.dataloader.IDataCache;
import com.kingdee.eas.scm.framework.dataloader.app.AbstractServerDataLoader;
import com.kingdee.eas.scm.im.inv.InvBillBaseInfo;
import com.kingdee.eas.scm.im.inv.MatAssembleBillInfo;
import com.kingdee.eas.scm.im.inv.MatDisassembleBillInfo;
import java.util.HashMap;
import java.util.HashSet;

public class MaterialPlanDataLoader
extends AbstractServerDataLoader {
    public MaterialPlanDataLoader(Context ctx) {
        super(ctx);
    }

    public boolean supports(Class<?> clazz) {
        return MatAssembleBillInfo.class.isAssignableFrom(clazz) || MatDisassembleBillInfo.class.isAssignableFrom(clazz);
    }

    public void load(IObjectCollection objectCol, IDataCache dataCache) throws BOSException, EASBizException {
        assert (objectCol != null);
        assert (dataCache != null);
        HashSet<String> materialIdSet = new HashSet<String>();
        HashSet<String> storageOrgUnitIdSet = new HashSet<String>();
        int len = objectCol.size();
        for (int index = 0; index < len; ++index) {
            InvBillBaseInfo invBillInfo = (InvBillBaseInfo)objectCol.getObject(index);
            if (invBillInfo == null || invBillInfo.get(this.getEntryName(invBillInfo)) == null || ((IObjectCollection)invBillInfo.get(this.getEntryName(invBillInfo))).size() == 0) continue;
            IObjectCollection entryCol = (IObjectCollection)invBillInfo.get(this.getEntryName(invBillInfo));
            StorageOrgUnitInfo sou = invBillInfo.getStorageOrgUnit();
            storageOrgUnitIdSet.add(sou.getId().toString());
            int size = entryCol.size();
            for (int i = 0; i < size; ++i) {
                SCMBillEntryBaseInfo entryInfo = (SCMBillEntryBaseInfo)entryCol.getObject(i);
                if (entryInfo.getMaterial() == null || sou == null) continue;
                materialIdSet.add(entryInfo.getMaterial().getId().toString());
                IObjectCollection entry1Col = (IObjectCollection)entryInfo.get(this.getEntry1Name(invBillInfo));
                for (int j = 0; j < entry1Col.size(); ++j) {
                    SCMBillEntryBaseInfo entry1Info = (SCMBillEntryBaseInfo)entry1Col.getObject(j);
                    if (entry1Info.getMaterial() == null) continue;
                    materialIdSet.add(entry1Info.getMaterial().getId().toString());
                }
            }
        }
        if (materialIdSet.size() == 0 || storageOrgUnitIdSet.size() == 0) {
            return;
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("material.id", materialIdSet, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("orgUnit.id", storageOrgUnitIdSet, CompareType.INCLUDE));
        view.setFilter(filter);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("id");
        selector.add("status");
        selector.add("manufactureStrategy.id");
        selector.add("isolatedRule");
        view.setSelector(selector);
        MaterialPlanCollection materialPlanCol = MaterialPlanFactory.getLocalInstance((Context)this.getCtx()).getMaterialPlanCollection(view);
        HashMap<String, MaterialPlanInfo> tMap = new HashMap<String, MaterialPlanInfo>();
        int size = materialPlanCol.size();
        for (int i = 0; i < size; ++i) {
            MaterialPlanInfo info = materialPlanCol.get(i);
            String key = info.getMaterial().getId().toString() + info.getOrgUnit().getId().toString();
            tMap.put(key, info);
            dataCache.put(key, (Object)info, DataTypeEnum.MATERIAL_PLAN);
        }
    }

    protected String getEntryName(InvBillBaseInfo invBillInfo) {
        if (invBillInfo instanceof MatAssembleBillInfo) {
            return "entry";
        }
        return "entries";
    }

    protected String getEntry1Name(InvBillBaseInfo invBillInfo) {
        if (invBillInfo instanceof MatAssembleBillInfo) {
            return "entry1";
        }
        return "entries";
    }
}

