/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv.app.invupdate;

import com.kingdee.bos.BOSException;
import com.kingdee.eas.scm.im.inv.app.invupdate.XmlParamItem;
import com.kingdee.eas.scm.im.inv.app.writeback.IInvCheckingItem;
import com.kingdee.eas.scm.im.inv.app.writeback.IInvReWriteOrder;
import com.kingdee.eas.scm.im.inv.app.writeback.IWriteBackProcessor;
import com.kingdee.eas.scm.im.inv.app.writeback.InvCheckingChain;
import com.kingdee.eas.scm.im.inv.app.writeback.WriteBackProcessor;
import com.kingdee.util.ConfigurationItem;
import com.kingdee.util.XMLConfiguration;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class IMBussinessProcessorFactory {
    private static final String XmlPath = "InvUpdateConfigue.xml";
    private static IMBussinessProcessorFactory processBuilder = null;
    private static Map updateMap = new HashMap();
    private static Map writeBackMap = new HashMap();
    private static Logger logger = Logger.getLogger(IMBussinessProcessorFactory.class);

    private IMBussinessProcessorFactory() {
    }

    private static synchronized void staticInitial() {
        if (processBuilder == null) {
            try {
                processBuilder = new IMBussinessProcessorFactory();
                processBuilder.buildProcessor();
            }
            catch (Throwable e) {
                processBuilder = null;
                logger.error((Object)"******\u89e3\u6790\u5931\u8d25\u4e86********", e);
            }
        }
    }

    public static String getUpdateProcessor(String billTypeNo) {
        IMBussinessProcessorFactory.staticInitial();
        return (String)updateMap.get(billTypeNo);
    }

    public static IWriteBackProcessor getWriteBackProcessor(String billTypeNo) {
        IMBussinessProcessorFactory.staticInitial();
        return (IWriteBackProcessor)writeBackMap.get(billTypeNo);
    }

    private void buildProcessor() throws BOSException {
        HashMap xmlParams = this.getXmlParams();
        HashMap itemhs = new HashMap();
        Set keyset = xmlParams.keySet();
        Iterator it = keyset.iterator();
        String className = "";
        try {
            while (it.hasNext()) {
                String key = (String)it.next();
                XmlParamItem item = (XmlParamItem)xmlParams.get(key);
                itemhs = (HashMap)item.getCheckingChain();
                InvCheckingChain invCheckingChain = new InvCheckingChain();
                if (itemhs != null) {
                    Iterator it2 = itemhs.keySet().iterator();
                    while (it2.hasNext()) {
                        className = (String)itemhs.get(it2.next());
                        if (className == null) continue;
                        invCheckingChain.addInvCheckingItem((IInvCheckingItem)Class.forName(className).newInstance());
                    }
                }
                IInvReWriteOrder invReWriteProcessor = null;
                itemhs = (HashMap)item.getRewriteInfo();
                if (itemhs != null) {
                    className = (String)itemhs.get("rewriteclass");
                    className.toCharArray();
                    if (className != null) {
                        invReWriteProcessor = (IInvReWriteOrder)Class.forName(className).newInstance();
                    }
                }
                writeBackMap.put(key, new WriteBackProcessor(invCheckingChain, invReWriteProcessor));
                itemhs = (HashMap)item.getInvUpdateInfo();
                if (itemhs == null || (className = (String)itemhs.get("updateclass")) == null) continue;
                updateMap.put(key, className);
            }
        }
        catch (InstantiationException e) {
            throw new BOSException((Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new BOSException((Throwable)e);
        }
        catch (ClassNotFoundException e) {
            throw new BOSException((Throwable)e);
        }
    }

    private HashMap getXmlParams() {
        XMLConfiguration config = XMLConfiguration.getInstance((URL)this.getClass().getResource(XmlPath));
        HashMap<String, XmlParamItem> xmlParams = new HashMap<String, XmlParamItem>();
        List list = config.getConfigItemList();
        for (ConfigurationItem billItem : list) {
            List list2 = billItem.getChildren("processor");
            XmlParamItem xmlParaItem = new XmlParamItem();
            if (list2.size() > 0) {
                ConfigurationItem processorItem = (ConfigurationItem)list2.get(0);
                List list3 = processorItem.getAllChildren();
                for (ConfigurationItem citem : list3) {
                    if (citem.getName().equals("checkingchain")) {
                        xmlParaItem.setCheckingChain(citem.getProperties());
                        continue;
                    }
                    if (citem.getName().equals("update")) {
                        xmlParaItem.setInvUpdateInfo(citem.getProperties());
                        continue;
                    }
                    if (!citem.getName().equals("rewriter")) continue;
                    xmlParaItem.setRewriteInfo(citem.getProperties());
                }
            }
            xmlParams.put(billItem.getName(), xmlParaItem);
        }
        return xmlParams;
    }
}

