/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv.app.invupdate.engin;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.basedata.scm.common.UseStatusEnum;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.scm.framework.balance.BalanceFieldModelCollection;
import com.kingdee.eas.scm.framework.balance.BalanceFieldModelInfo;
import com.kingdee.eas.scm.framework.balance.BalanceModelException;
import com.kingdee.eas.scm.framework.balance.BalanceModelFactory;
import com.kingdee.eas.scm.framework.balance.BalanceModelInfo;
import com.kingdee.eas.scm.framework.balance.BizDataTypeEnum;
import com.kingdee.eas.scm.framework.balance.DataTypeEnum;
import com.kingdee.eas.scm.framework.balance.OperationTypeEnum;
import com.kingdee.eas.scm.framework.balance.app.engine.BalanceEnginUtil;
import com.kingdee.eas.scm.framework.balance.app.engine.InvokeTime;
import com.kingdee.eas.scm.framework.balance.app.engine.RealTimeBalanceCalculator;
import com.kingdee.eas.scm.util.app.db.KsqlUtil;
import com.kingdee.eas.scm.util.collection.CollectionUtil;
import com.kingdee.eas.scm.util.string.StringUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class InventoryCheck4VMICalculator
extends RealTimeBalanceCalculator {
    private boolean isEnough = false;
    private String entryTable = null;
    private Map<String, Set<String>> supplierMap = new HashMap<String, Set<String>>();

    public boolean isEnough() {
        return this.isEnough;
    }

    public Map<String, Set<String>> getSupplierMap() {
        return this.supplierMap;
    }

    private InventoryCheck4VMICalculator(Context ctx, BalanceModelInfo balanceModelInfo, String entryTable) throws EASBizException, BOSException {
        super(ctx, balanceModelInfo);
        this.entryTable = entryTable;
    }

    public static InventoryCheck4VMICalculator getInstance(Context ctx, String entryTable) throws EASBizException, BOSException {
        InventoryCheck4VMICalculator invCheckCalculator = null;
        BalanceModelInfo balanceModelInfo = BalanceModelFactory.getLocalInstance((Context)ctx).getBalanceModelInfo((IObjectPK)new ObjectUuidPK("SOYjDrxMRamtGGENYUm98SPUYjI="), BalanceEnginUtil.getBalanceModelSelector());
        if (!UseStatusEnum.ACTIVE.equals((Object)balanceModelInfo.getState())) {
            throw new BalanceModelException(BalanceModelException.BALANCEMODELISNOTACTIVE);
        }
        invCheckCalculator = new InventoryCheck4VMICalculator(ctx, balanceModelInfo, entryTable);
        return invCheckCalculator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void calculateStep() throws BOSException, EASBizException {
        this.takeBillData();
        if (this.isTempTableNull()) {
            return;
        }
        this.invokePlugInHandler(InvokeTime.AfterDetailData);
        this.groupDetailDataToFinalTable();
        this.insertNewRecord();
        this.updateBalanceIdToTempTable();
        this.calculateBalance();
        this.deleteExistingQtySQL();
        String sql = "select 1 from " + this.finalTempTable;
        IRowSet rs = KsqlUtil.executeQuery((Context)this.ctx, (String)sql);
        try {
            if (rs.size() <= 0) {
                this.isEnough = true;
                return;
            }
        }
        finally {
            SQLUtils.cleanup((ResultSet)rs);
        }
        this.OPType = OperationTypeEnum.Reverse;
        this.calculateBalance();
        this.updateFinalTempTable();
        this.matchSupplierIdByEnoughInv();
        StringBuffer sb = new StringBuffer();
        sb.append("select 1 from ").append(this.finalTempTable).append(" tmp ").append("\r\n");
        sb.append("left join ").append(this.balanceModelInfo.getTabName()).append(" bal ").append("\r\n");
        sb.append("on tmp.FID = bal.FID").append("\r\n");
        sb.append("where bal.FID is null ");
        IRowSet rowSet = KsqlUtil.executeQuery((Context)this.ctx, (String)sb.toString());
        try {
            if (rowSet.size() > 0) {
                this.isEnough = false;
                return;
            }
        }
        finally {
            SQLUtils.cleanup((ResultSet)rowSet);
        }
        this.handleSupplierIDMap();
    }

    private void updateFinalTempTable() throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("update ").append(this.finalTempTable).append(" set FStoreTypeID = '").append("181875d5-0105-1000-e000-0114c0a812fd97D461A6").append("'");
        KsqlUtil.execute((Context)this.ctx, (String)sql.toString());
        sql.setLength(0);
        sql.append("update ").append(this.finalTempTable).append(" set FID = ").append("newbosid('").append(this.balBosType).append("')");
        KsqlUtil.execute((Context)this.ctx, (String)sql.toString());
        sql.setLength(0);
        sql.append("update ").append(this.finalTempTable).append(" as final set (FSupplierID) = ").append("\r\n");
        sql.append("(select matReqE.FSupplierID from ").append(this.finalTempTable).append(" tmp ").append("\r\n");
        sql.append("inner join ").append(this.entryTable).append(" entry on entry.FID = tmp.FBillEntryID").append("\r\n");
        sql.append("inner join T_IM_MATERIALREQBILLENTRY").append(" matReqE on matReqE.FID = entry.FSourceBillEntryID and matReqE.FSupplierID is not null").append("\r\n");
        sql.append("where final.FID = tmp.FID)").append("\r\n");
        KsqlUtil.execute((Context)this.ctx, (String)sql.toString());
    }

    private void deleteExistingQtySQL() throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("delete from ").append(this.finalTempTable).append(" where fid not in ");
        sql.append("(select tmp.fid ");
        sql.append("FROM ").append(this.finalTempTable).append(" tmp ");
        sql.append("INNER JOIN T_BD_MaterialInventory mi ON tmp.FMaterialID = mi.FMaterialID AND tmp.FStorageOrgUnitID = mi.FOrgUnit ");
        sql.append("WHERE ISNULL(mi.FIsNegative, 0) = 0 AND (tmp.FCurStoreQty < 0 OR tmp.FBaseQty < 0))");
        KsqlUtil.execute((Context)this.ctx, (String)sql.toString());
    }

    private void matchSupplierIdByEnoughInv() throws BOSException {
        StringBuffer sql = new StringBuffer();
        ArrayList<String> idList = new ArrayList<String>();
        HashMap map = new HashMap();
        ArrayList<String> colList = new ArrayList<String>();
        sql.append("select * from ").append(this.balanceModelInfo.getTabName());
        sql.append(" where FStoreTypeID = '").append("181875d5-0105-1000-e000-0114c0a812fd97D461A6").append("'");
        sql.append(" and FStoreStatusID = '").append("181875d5-0105-1000-e000-012ec0a812fd62A73FA5").append("'");
        IRowSet rs = KsqlUtil.executeQuery((Context)this.ctx, (String)sql.toString());
        try {
            BalanceFieldModelCollection coll = this.balanceModelInfo.getEntry();
            BalanceFieldModelInfo fieldInfo = null;
            for (int i = 1; i < coll.size(); ++i) {
                fieldInfo = coll.get(i);
                if (!BizDataTypeEnum.Dim.equals((Object)fieldInfo.getBizDataType()) && !BizDataTypeEnum.Organization.equals((Object)fieldInfo.getBizDataType()) && !BizDataTypeEnum.Year.equals((Object)fieldInfo.getBizDataType()) && !BizDataTypeEnum.Month.equals((Object)fieldInfo.getBizDataType()) && !BizDataTypeEnum.Period.equals((Object)fieldInfo.getBizDataType()) || "FSupplierID".equals(fieldInfo.getFieldName())) continue;
                colList.add(fieldInfo.getFieldName());
            }
            while (rs.next()) {
                String key = "";
                for (int i = 0; i < colList.size(); ++i) {
                    key = key + rs.getObject((String)colList.get(i)) + ",";
                }
                if (map.containsKey(key)) {
                    BigDecimal baseQty = (BigDecimal)((List)map.get(key)).get(0);
                    if (rs.getBigDecimal("FBaseQty").compareTo(baseQty) <= 0) continue;
                    ArrayList<Object> newlist = new ArrayList<Object>();
                    newlist.add(rs.getBigDecimal("FBaseQty"));
                    newlist.add(rs.getString("FID"));
                    map.put(key, newlist);
                    continue;
                }
                ArrayList<Object> newlist = new ArrayList<Object>();
                newlist.add(rs.getBigDecimal("FBaseQty"));
                newlist.add(rs.getString("FID"));
                map.put(key, newlist);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((ResultSet)rs);
        }
        Set entrySet = map.entrySet();
        for (Map.Entry entry : entrySet) {
            String id = (String)((List)entry.getValue()).get(1);
            idList.add(id);
        }
        if (idList.size() > 0) {
            sql.setLength(0);
            sql.append("update ").append(this.finalTempTable).append(" as tmp set (FID) = ").append("\r\n");
            sql.append("(select bal.FID from ").append(this.balanceModelInfo.getTabName()).append(" bal ").append("\r\n");
            sql.append("where ").append(this.getMatchCondition(this.balanceModelInfo, "tmp", "bal", false)).append("\r\n");
            sql.append(" and bal.FID in (").append(CollectionUtil.convertList2String(idList)).append(")").append("\r\n");
            sql.append(")").append("\r\n");
            sql.append("where tmp.FSupplierID = '").append("EgkAAABc3Xo3xn38").append("'");
            KsqlUtil.execute((Context)this.ctx, (String)sql.toString());
        }
        sql.setLength(0);
        sql.append("update ").append(this.finalTempTable).append(" as tmp set (FID) = ").append("\r\n");
        sql.append("(select bal.FID from ").append(this.balanceModelInfo.getTabName()).append(" bal ").append("\r\n");
        sql.append("where ").append(this.getMatchCondition(this.balanceModelInfo, "tmp", "bal", false)).append("\r\n");
        sql.append(" and bal.FSupplierID = tmp.FSupplierID ").append("\r\n");
        sql.append(")").append("\r\n");
        sql.append("where tmp.FSupplierID <> '").append("EgkAAABc3Xo3xn38").append("'");
        KsqlUtil.execute((Context)this.ctx, (String)sql.toString());
    }

    private String getMatchCondition(BalanceModelInfo balanceModelInfo, String tmpTablePrefix, String balTablePrefix, boolean isDetail) {
        int i;
        StringBuffer sSQL = new StringBuffer();
        BalanceFieldModelCollection coll = balanceModelInfo.getEntry();
        BalanceFieldModelInfo fieldInfo = null;
        for (i = 1; i < coll.size(); ++i) {
            fieldInfo = coll.get(i);
            if (!BizDataTypeEnum.Dim.equals((Object)fieldInfo.getBizDataType()) && !BizDataTypeEnum.Organization.equals((Object)fieldInfo.getBizDataType()) || "FSupplierID".equals(fieldInfo.getFieldName()) || isDetail && "FStoreTypeID".equals(fieldInfo.getFieldName())) continue;
            if (sSQL.length() > 0) {
                sSQL.append("\r\n").append(" AND ");
            }
            sSQL.append(this.getJoinFieldName(fieldInfo, tmpTablePrefix));
            sSQL.append(" = ");
            sSQL.append(this.getJoinFieldName(fieldInfo, balTablePrefix));
        }
        if (!isDetail) {
            for (i = 1; i < coll.size(); ++i) {
                fieldInfo = coll.get(i);
                if (!BizDataTypeEnum.HappenData.equals((Object)fieldInfo.getBizDataType())) continue;
                if (sSQL.length() > 0) {
                    sSQL.append("\r\n").append(" AND ");
                }
                sSQL.append(balTablePrefix).append(".").append(fieldInfo.getFieldName());
                sSQL.append(" >= ");
                sSQL.append(tmpTablePrefix).append(".").append(fieldInfo.getFieldName());
            }
        }
        return sSQL.toString();
    }

    private String getJoinFieldName(BalanceFieldModelInfo fieldInfo, String prefix) {
        StringBuffer fieldStr = new StringBuffer();
        if (fieldInfo.isIsNullable() && StringUtil.isEmpty((String)fieldInfo.getDefaultValue())) {
            fieldStr.append("ISNULL").append("(");
            fieldStr.append(prefix).append(".").append(fieldInfo.getFieldName());
            if (DataTypeEnum.String.equals((Object)fieldInfo.getDataType()) || DataTypeEnum.BOSUuid.equals((Object)fieldInfo.getDataType())) {
                fieldStr.append(", '").append("$#X@$").append("')");
            } else if (DataTypeEnum.Date.equals((Object)fieldInfo.getDataType())) {
                fieldStr.append(", ").append("{ts'1900-01-01'}").append(")");
            } else if (DataTypeEnum.Integer.equals((Object)fieldInfo.getDataType()) || DataTypeEnum.Boolean.equals((Object)fieldInfo.getDataType()) || DataTypeEnum.Amount.equals((Object)fieldInfo.getDataType()) || DataTypeEnum.Qty.equals((Object)fieldInfo.getDataType()) || DataTypeEnum.Price.equals((Object)fieldInfo.getDataType())) {
                fieldStr.append(", 0)");
            } else if (DataTypeEnum.Enum.equals((Object)fieldInfo.getDataType())) {
                fieldStr.append(", -999)");
            }
        } else {
            fieldStr.append(prefix).append(".").append(fieldInfo.getFieldName());
        }
        return fieldStr.toString();
    }

    private void handleSupplierIDMap() throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("update ").append(this.detailTempTable).append(" as detail set (FSupplierID) = ").append("\r\n");
        sql.append("(select bal.FSupplierID from ").append(this.finalTempTable).append(" final ").append("\r\n");
        sql.append("inner join ").append(this.balanceModelInfo.getTabName()).append(" bal ").append(" on bal.FID = final.FID").append("\r\n");
        sql.append("where ").append(this.getMatchCondition(this.balanceModelInfo, "detail", "final", true)).append("\r\n");
        sql.append(")");
        KsqlUtil.execute((Context)this.ctx, (String)sql.toString());
        sql.setLength(0);
        sql.append("select FBillEntryID,FSupplierID from ").append(this.detailTempTable);
        IRowSet rs = KsqlUtil.executeQuery((Context)this.ctx, (String)sql.toString());
        try {
            while (rs.next()) {
                String entryID = rs.getString("FBillEntryID");
                String supplierID = rs.getString("FSupplierID");
                if ("EgkAAABc3Xo3xn38".equals(supplierID)) continue;
                if (this.supplierMap.containsKey(supplierID)) {
                    this.supplierMap.get(supplierID).add(entryID);
                    continue;
                }
                HashSet<String> idSet = new HashSet<String>();
                idSet.add(entryID);
                this.supplierMap.put(supplierID, idSet);
            }
            if (this.supplierMap.size() > 0) {
                this.isEnough = true;
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((ResultSet)rs);
        }
    }
}

