/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv.app.invupdate.engin;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.scm.common.UseStatusEnum;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.scm.framework.balance.BalanceDataModelInfo;
import com.kingdee.eas.scm.framework.balance.BalanceModelException;
import com.kingdee.eas.scm.framework.balance.BalanceModelFactory;
import com.kingdee.eas.scm.framework.balance.BalanceModelInfo;
import com.kingdee.eas.scm.framework.balance.app.engine.BalanceEnginUtil;
import com.kingdee.eas.scm.framework.balance.app.engine.IRenovator;
import com.kingdee.eas.scm.framework.balance.app.engine.ISQLBuilder;
import com.kingdee.eas.scm.framework.balance.app.engine.InsertNewRecordHelper;
import com.kingdee.eas.scm.framework.balance.app.engine.InvokeTime;
import com.kingdee.eas.scm.framework.balance.app.engine.RealTimeBalanceCalculator;
import com.kingdee.eas.scm.framework.balance.app.plugin.HandlerParameter;
import com.kingdee.eas.scm.im.inv.app.invupdate.engin.InventoryRenovatorSQLBuilder;
import com.kingdee.eas.scm.util.app.db.KsqlUtil;
import java.util.Map;
import java.util.Set;

public class InventoryRenovator
extends RealTimeBalanceCalculator
implements IRenovator {
    private static final String FIELD_STORAGE = "FStorageOrgUnitID";
    private static final String FIELD_WAREHOUSE = "FWarehouseID";
    private static final String FIELD_MATERIAL = "FMaterialID";
    private Map params;

    private InventoryRenovator(Context ctx, BalanceModelInfo balanceModelInfo) throws EASBizException, BOSException {
        super(ctx, balanceModelInfo);
    }

    public static IRenovator getInstance(Context ctx) throws EASBizException, BOSException {
        InventoryRenovator renovator = null;
        BalanceModelInfo balanceModelInfo = BalanceModelFactory.getLocalInstance((Context)ctx).getBalanceModelInfo((IObjectPK)new ObjectUuidPK("SOYjDrxMRamtGGENYUm98SPUYjI="), BalanceEnginUtil.getBalanceModelSelector());
        if (!UseStatusEnum.ACTIVE.equals((Object)balanceModelInfo.getState())) {
            throw new BalanceModelException(BalanceModelException.BALANCEMODELISNOTACTIVE);
        }
        renovator = new InventoryRenovator(ctx, balanceModelInfo);
        return renovator;
    }

    protected FilterInfo getBalanceDataModelFilter() {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("balanceModel", (Object)this.balanceModelInfo.getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("state", (Object)UseStatusEnum.ACTIVE));
        this.logger.debug("\u53d6\u6570\u914d\u7f6e\u6a21\u578b\u8fc7\u6ee4\u6761\u4ef6\uff1a" + filter.toSql());
        return filter;
    }

    protected ISQLBuilder createSQLBuilder(BalanceDataModelInfo dataModelInfo) {
        return new InventoryRenovatorSQLBuilder(this.ctx, this.balanceModelInfo, dataModelInfo, this.params);
    }

    protected void calculateStep() throws BOSException, EASBizException {
        this.timer.reset();
        this.takeBillData();
        this.logger.info("\u5355\u636e\u53d6\u6570\u5b8c\u6210\uff0c \u82b1\u8d39\uff1a" + this.timer.msValue());
        this.timer.reset();
        this.invokePlugInHandler(InvokeTime.AfterDetailData);
        this.logger.info("\u63d2\u4ef6\u5904\u7406\u660e\u7ec6\u6570\u636e\u5b8c\u6210\uff0c \u82b1\u8d39\uff1a" + this.timer.msValue());
        this.timer.reset();
        this.groupDetailDataToFinalTable();
        this.logger.info("\u6309\u7ef4\u5ea6\u5206\u7ec4\u6c47\u603b\u6570\u636e\u5b8c\u6210\uff0c \u82b1\u8d39\uff1a" + this.timer.msValue());
        try {
            this.updateBalanceIdToTempTable();
            this.logger.info("\u66f4\u65b0\u4f59\u989d\u8868ID\u5230\u4e34\u65f6\u8868\u5b8c\u6210\uff0c \u82b1\u8d39\uff1a" + this.timer.msValue());
        }
        catch (BOSException e) {
            this.logger.error("\u66f4\u65b0\u65b0ID\u5230\u4e34\u65f6\u8868\u4e2d\u51fa\u73b0\u9519\u8bef\uff0c\u5373\u65f6\u5e93\u5b58\u4e2d\u5b58\u5728\u76f8\u540c\u7ef4\u5ea6\u7684\u91cd\u590d\u8bb0\u5f55\uff0c\u9700\u8981\u5408\u5e76\u5904\u7406\uff01");
            this.updateGroupBalanceIdToTempTable();
        }
        this.timer.reset();
        this.deleteOldBalanceRecord();
        this.logger.info("\u5220\u9664\u65e7\u8bb0\u5f55\u5b8c\u6210\uff0c \u82b1\u8d39\uff1a" + this.timer.msValue());
        this.timer.reset();
        this.insertNewRecordToBalance();
        this.logger.info("\u63d2\u5165\u6700\u7ec8\u6570\u636e\u5230\u4e34\u65f6\u8868\u5b8c\u6210\uff0c \u82b1\u8d39\uff1a" + this.timer.msValue());
        this.timer.reset();
        this.deleteReservationRecord();
        this.logger.info("\u5220\u9664\u9884\u7559\u8bb0\u5f55\u8868\u4e2d\u4e0d\u5b58\u5728\u7684\u5373\u65f6\u5e93\u5b58\u8bb0\u5f55\u5b8c\u6210\uff0c \u82b1\u8d39\uff1a" + this.timer.msValue());
        this.logger.endLog();
    }

    private void updateGroupBalanceIdToTempTable() throws BOSException {
        StringBuffer sql = new StringBuffer();
        String balanceDimStr = BalanceEnginUtil.getBalanceDimFieldStr((BalanceModelInfo)this.balanceModelInfo, null);
        sql.append("update ").append(this.finalTempTable).append(" as tmp set (FID) = ").append("\r\n");
        sql.append("(select bal.FID from (");
        sql.append("select max(FID) as FID,").append(balanceDimStr).append("\r\n");
        sql.append("from ").append(this.balanceModelInfo.getTabName()).append("\r\n");
        sql.append("where ").append(this.getBalanceFilter()).append("\r\n");
        sql.append("group by ").append(balanceDimStr).append(") bal").append("\r\n");
        sql.append("where ").append(InsertNewRecordHelper.getMatchCondition((BalanceModelInfo)this.balanceModelInfo, (String)"tmp", (String)"bal")).append(")");
        this.logger.error("\u66f4\u65b0\u5408\u5e76\u540e\u7684ID\u5230\u4e34\u65f6\u8868\u4e2dSQL: " + sql.toString());
        KsqlUtil.execute((Context)this.ctx, (String)sql.toString());
    }

    protected void lockBalanceRows() throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("update ").append(this.balanceModelInfo.getTabName()).append(" set FID = FID where ");
        sql.append(this.getBalanceFilter());
        this.logger.debugSQL("\u5bf9\u6570\u636e\u8868\u52a0\u884c\u9501SQL: ", sql.toString());
        KsqlUtil.execute((Context)this.ctx, (String)sql.toString());
    }

    protected void deleteOldBalanceRecord() throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("Delete from ").append(this.balanceModelInfo.getTabName()).append(" where ");
        sql.append(this.getBalanceFilter());
        this.logger.debugSQL("\u5bf9\u6570\u636e\u8868\u52a0\u884c\u9501SQL: ", sql.toString());
        KsqlUtil.execute((Context)this.ctx, (String)sql.toString());
    }

    protected void insertNewRecordToBalance() throws BOSException {
        StringBuffer insertSQL = new StringBuffer();
        insertSQL.append(this.getInsertSQL(this.balanceModelInfo.getTabName())).append("\r\n");
        insertSQL.append("SELECT ");
        insertSQL.append(" newbosid('88888888'),");
        insertSQL.append(BalanceEnginUtil.getBalanceModelFieldStr((BalanceModelInfo)this.balanceModelInfo, null)).append("\r\n");
        insertSQL.append("FROM ").append(this.finalTempTable).append("\r\n");
        KsqlUtil.execute((Context)this.ctx, (String)insertSQL.toString());
    }

    protected String getInsertSQL(String tableName) {
        StringBuffer insertSQL = new StringBuffer();
        insertSQL.append("Insert Into ").append(tableName).append("(");
        if ("T_IM_Inventory".equals(tableName)) {
            insertSQL.append("FUniqueKey,");
        }
        insertSQL.append(BalanceEnginUtil.getBalanceModelFieldStr((BalanceModelInfo)this.balanceModelInfo, null));
        insertSQL.append(")");
        return insertSQL.toString();
    }

    protected void deleteReservationRecord() throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("Delete from T_IM_Reservation where not exists(");
        sql.append("  select 1 from T_IM_Inventory inv where T_IM_Reservation.FInventoryID = inv.FID");
        sql.append(") and FInventoryID is not null");
        KsqlUtil.execute((Context)this.ctx, (String)sql.toString());
    }

    private String getBalanceFilter() {
        Set material;
        FilterInfo filter = new FilterInfo();
        String storageId = (String)this.params.get("StorageID");
        filter.getFilterItems().add(new FilterItemInfo(FIELD_STORAGE, (Object)storageId));
        Set warehouse = (Set)this.params.get("WarehouseIDs");
        if (warehouse != null && warehouse.size() > 0) {
            filter.getFilterItems().add(new FilterItemInfo(FIELD_WAREHOUSE, (Object)warehouse, CompareType.INCLUDE));
        }
        if ((material = (Set)this.params.get("MaterialIDs")) != null && material.size() > 0) {
            filter.getFilterItems().add(new FilterItemInfo(FIELD_MATERIAL, (Object)material, CompareType.INCLUDE));
        }
        return filter.toString();
    }

    protected HandlerParameter getHandlerParameter() {
        HandlerParameter params = super.getHandlerParameter();
        params.setReCalulate(true);
        return params;
    }

    public void refresh(Map params) throws BOSException, EASBizException {
        this.params = params;
        super.init();
        try {
            this.calculateStep();
        }
        finally {
            this.releaseTempTable();
        }
    }

    protected Boolean isUseThreadPool4TakeBill() {
        return true;
    }
}

