/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv.app.invupdate.plugin;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ContextUtils;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.base.param.IParamControl;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.basedata.scm.im.inv.LocationFactory;
import com.kingdee.eas.basedata.scm.im.inv.LocationInfo;
import com.kingdee.eas.basedata.scm.im.inv.WarehouseFactory;
import com.kingdee.eas.basedata.scm.im.inv.WarehouseInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.scm.framework.balance.app.log.IBalanceLogger;
import com.kingdee.eas.scm.framework.balance.app.plugin.BalancePlugInAdapter;
import com.kingdee.eas.scm.framework.balance.app.plugin.HandlerParameter;
import com.kingdee.eas.scm.im.inv.InvUpdateException;
import com.kingdee.eas.scm.im.inv.app.InvAppUtils;
import com.kingdee.eas.scm.util.app.db.KsqlUtil;
import com.kingdee.eas.scm.util.filehandle.ResourceUtil;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.LocaleUtils;
import com.kingdee.util.LowTimer;
import com.kingdee.util.NumericExceptionSubItem;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.Locale;

public class InvRealTimeBalancePlugInHandler
extends BalancePlugInAdapter {
    private LowTimer timer = new LowTimer();

    public void handleAfterDetailData(Context ctx, String detailTempTable, HandlerParameter params) throws BOSException, EASBizException {
        IBalanceLogger logger = params.getLogger();
        if (params.isReCalulate()) {
            this.timer.reset();
            this.updateTempData(ctx, detailTempTable);
            logger.info("\u66f4\u65b0\u4e34\u65f6\u8868\u6570\u636e\u5b8c\u6210\uff0c\u82b1\u8d39\uff1a" + this.timer.msValue());
            this.timer.reset();
            this.updateUnitAndQty(ctx, detailTempTable);
            logger.info("\u66f4\u65b0\u8ba1\u91cf\u5355\u4f4d\u548c\u6570\u91cf\u4e3a\u57fa\u672c\u8ba1\u91cf\u5355\u4f4d\u548c\u57fa\u672c\u6570\u91cf\uff0c\u82b1\u8d39\uff1a" + this.timer.msValue());
        } else {
            if ("FC910EF3".equals(params.getBillBosType())) {
                this.timer.reset();
                this.checkARBillUpdateInv(ctx, detailTempTable);
                logger.info("\u5e94\u6536\u5355\u66f4\u65b0\u5e93\u5b58\u5904\u7406\uff0c\u82b1\u8d39\uff1a" + this.timer.msValue());
            }
            this.timer.reset();
            this.updateTempData(ctx, detailTempTable);
            logger.info("\u66f4\u65b0\u4e34\u65f6\u8868\u6570\u636e\u5b8c\u6210\uff0c\u82b1\u8d39\uff1a" + this.timer.msValue());
            this.timer.reset();
            this.updateNull2DefaultValue(ctx, detailTempTable);
            logger.info("\u66f4\u65b0\u4e3a\u7a7a\u7684\u7ef4\u5ea6\u4e3a\u9ed8\u8ba4\u503c\u5b8c\u6210\uff0c\u82b1\u8d39\uff1a" + this.timer.msValue());
            this.timer.reset();
            this.checkCountingFrozen(ctx, detailTempTable);
            logger.info("\u68c0\u67e5\u662f\u5426\u5728\u76d8\u70b9\u5b8c\u6210\uff0c\u82b1\u8d39\uff1a" + this.timer.msValue());
            this.timer.reset();
            this.checkDataValid(ctx, detailTempTable);
            logger.info("\u6821\u9a8c\u6570\u636e\u5408\u6cd5\u6027\u5b8c\u6210\uff0c\u82b1\u8d39\uff1a" + this.timer.msValue());
            this.timer.reset();
            this.updateUnitAndQty(ctx, detailTempTable);
            logger.info("\u66f4\u65b0\u8ba1\u91cf\u5355\u4f4d\u548c\u6570\u91cf\u4e3a\u57fa\u672c\u8ba1\u91cf\u5355\u4f4d\u548c\u57fa\u672c\u6570\u91cf\uff0c\u82b1\u8d39\uff1a" + this.timer.msValue());
        }
    }

    public void handleAfterFinalReadyData(Context ctx, String finalTempTable, HandlerParameter params) throws BOSException, EASBizException {
        if (params.isReCalulate()) {
            return;
        }
        StringBuffer errorInfo = new StringBuffer("\n");
        String sql = this.getCheckExistingQtySQL(finalTempTable);
        IRowSet rs = KsqlUtil.executeQuery((Context)ctx, (String)sql.toString());
        boolean paramFlag = this.isCheckAssistQty(ctx, finalTempTable);
        try {
            boolean isNagetived = false;
            String shortQtyTitle = "";
            String qtyStr = "";
            String unitName = "";
            String wareHouseId = null;
            String locationId = null;
            WarehouseInfo warehouseInfo = null;
            LocationInfo locationInfo = null;
            while (rs.next()) {
                int entrySeq = rs.getInt("entrySeq");
                String materialNumber = rs.getString("materialNumber");
                String materialName = rs.getString("materialName");
                wareHouseId = rs.getString("warehouseId");
                locationId = rs.getString("locationId");
                BigDecimal baseQty = rs.getBigDecimal("FBaseQty");
                BigDecimal assistQty = rs.getBigDecimal("FCurStoreAssistQty");
                int aunitPrecision = rs.getInt("assistUnitPrecesion");
                int baseUnitPrecision = rs.getInt("baseUnitPrecision");
                warehouseInfo = WarehouseFactory.getLocalInstance((Context)ctx).getWarehouseInfo((IObjectPK)new ObjectUuidPK(wareHouseId));
                if (null != locationId && !"EgkAAABc3XMgX/hq".equals(locationId)) {
                    locationInfo = LocationFactory.getLocalInstance((Context)ctx).getLocationInfo((IObjectPK)new ObjectUuidPK(locationId));
                }
                isNagetived = false;
                if (baseQty.signum() == -1) {
                    unitName = rs.getString("baseUnitName");
                    baseQty = baseQty.setScale(baseUnitPrecision, 4).abs();
                    shortQtyTitle = ResourceUtil.getMessage((Context)ctx, (String)"com.kingdee.eas.scm.im.inv.WarehsManageResource", (String)"BaseQty", null);
                    qtyStr = InvAppUtils.getDecimalFormatString(ctx, baseQty, baseQty.scale());
                    isNagetived = true;
                } else if (paramFlag && assistQty.signum() == -1) {
                    unitName = rs.getString("assitUnitName");
                    assistQty = assistQty.setScale(aunitPrecision, 4).abs();
                    shortQtyTitle = ResourceUtil.getMessage((Context)ctx, (String)"com.kingdee.eas.scm.im.inv.WarehsManageResource", (String)"CurStoreAssistQty", null);
                    qtyStr = InvAppUtils.getDecimalFormatString(ctx, assistQty, assistQty.scale());
                    isNagetived = true;
                }
                if (!isNagetived) continue;
                String msg = MessageFormat.format(ResourceBase.getString((String)"com.kingdee.eas.scm.im.inv.WarehsManageResource", (String)"ShortQtyMessage", (Locale)ctx.getLocale()), entrySeq, materialName, materialNumber, shortQtyTitle, qtyStr, unitName, warehouseInfo.getNumber() + " ( " + warehouseInfo.getName() + ")", locationInfo != null ? EASResource.getString((String)"com.kingdee.eas.basedata.scm.im.inv.BDScmImInvResource", (String)"Location") + ":" + locationInfo.getNumber() + " ( " + locationInfo.getName() + ") ," : "");
                errorInfo.append(msg).append("\n");
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        if (errorInfo.length() > 1) {
            throw new InvUpdateException(InvUpdateException.IM_ONHAND_NOT_ENOUGH, new String[]{errorInfo.toString()});
        }
    }

    private String getCheckExistingQtySQL(String finalTempTable) {
        String localeString = LocaleUtils.getLocaleString((Locale)ContextUtils.getLocaleFromEnv());
        String matName = "material.FName_" + localeString;
        String unitName = "unitMu.FName_" + localeString;
        String assistUnitName = "assitUnitMu.FName_" + localeString;
        String baseUnitName = "baseUnitMu.FName_" + localeString;
        StringBuffer sql = new StringBuffer();
        sql.append("select tmp.FCurStoreQty - ISNULL(res.FReservationQty, 0) as FCurStoreQty,");
        sql.append("tmp.FBaseQty - ISNULL(res.FReservationBaseQty, 0) as FBaseQty,");
        sql.append("tmp.FCurStoreAssistQty - ISNULL(res.FReservationAssistQty, 0) as FCurStoreAssistQty,");
        sql.append("tmp.FEntrySeq as entrySeq,");
        sql.append("material.FNumber as materialNumber,");
        sql.append(matName).append(" as materialName,");
        sql.append(unitName).append(" as unitName,");
        sql.append(assistUnitName).append(" as assitUnitName,");
        sql.append(baseUnitName).append(" as baseUnitName,");
        sql.append("ummu.FQtyPrecision as unitPrecision,");
        sql.append("ammu.FQtyPrecision as assistUnitPrecesion,");
        sql.append("bmmu.FQtyPrecision as baseUnitPrecision,");
        sql.append("tmp.FWAREHOUSEID as warehouseId, ");
        sql.append("tmp.FLOCATIONID as locationId ");
        sql.append("FROM ").append(finalTempTable).append(" tmp ");
        sql.append("INNER JOIN T_BD_Material material on material.FID = tmp.FMaterialID ");
        sql.append("LEFT JOIN T_BD_MaterialInventory mi ON tmp.FMaterialID = mi.FMaterialID AND tmp.FStorageOrgUnitID = mi.FOrgUnit ");
        sql.append("LEFT JOIN T_BD_MeasureUnit unitMu on tmp.FUnitID = unitMu.FId ");
        sql.append("LEFT JOIN T_BD_MultiMeasureUnit ummu ON tmp.FMaterialID = ummu.FMaterialID AND tmp.FUnitID = ummu.FMEASUREUNITID ");
        sql.append("LEFT JOIN T_BD_MeasureUnit baseUnitMu on tmp.FBaseUnitID = baseUnitMu.FId ");
        sql.append("LEFT JOIN T_BD_MultiMeasureUnit bmmu ON tmp.FMaterialID = bmmu.FMaterialID AND tmp.FBaseUnitID = bmmu.FMEASUREUNITID ");
        sql.append("INNER JOIN T_DB_WAREHOUSE WH ON WH.FID = tmp.FWarehouseID ");
        sql.append("INNER JOIN T_IM_Inventory inv on tmp.FId = inv.FId ");
        sql.append("LEFT JOIN T_BD_MeasureUnit assitUnitMu on tmp.FAssistUnitID = assitUnitMu.FId ");
        sql.append("LEFT JOIN T_BD_MultiMeasureUnit ammu ON tmp.FMaterialID = ammu.FMaterialID AND tmp.FAssistUnitID = ammu.FMEASUREUNITID ");
        sql.append("LEFT JOIN (");
        sql.append("  Select FInventoryID, sum(FReservationQty) as FReservationQty, sum(FReservationBaseQty) as FReservationBaseQty,sum(FReservationAssistQty) as FReservationAssistQty ");
        sql.append("  from T_IM_Reservation where FInventoryID IN (select FID from ").append(finalTempTable).append(") group by FInventoryID");
        sql.append(") res on res.FInventoryID = tmp.FID ");
        sql.append("WHERE ISNULL(mi.FIsNegative, 0) = 0 and ISNULL(WH.FIsNegative, 0) = 0 ");
        sql.append("AND (tmp.FBaseQty < ISNULL(res.FReservationBaseQty, 0) OR tmp.FCurStoreAssistQty < ISNULL(res.FReservationAssistQty, 0)) ");
        sql.append("and tmp.FBaseQty < inv.FBaseQty ");
        sql.append("ORDER BY tmp.FEntrySeq");
        return sql.toString();
    }

    private void checkARBillUpdateInv(Context ctx, String detailTempTable) throws EASBizException, BOSException {
        if (this.isUpdateByARBILL(ctx, detailTempTable)) {
            return;
        }
        String sSQL = "truncate table " + detailTempTable;
        KsqlUtil.execute((Context)ctx, (String)sSQL);
    }

    private boolean isUpdateByARBILL(Context ctx, String detailTempTable) throws EASBizException, BOSException {
        IRowSet rs;
        block4: {
            boolean bl;
            rs = null;
            try {
                StringBuffer sql = new StringBuffer();
                sql.append("select top 1 FCompanyOrgUnitID from ").append(detailTempTable);
                rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
                String companyOrgUnitId = "";
                if (!rs.next()) break block4;
                companyOrgUnitId = rs.getString(1);
                IParamControl ipc = ParamControlFactory.getLocalInstance((Context)ctx);
                String isUpdateByARBILL = ipc.getParamValue((IObjectPK)new ObjectUuidPK(companyOrgUnitId), "CONSIGNSALES");
                if (isUpdateByARBILL == null) break block4;
                bl = isUpdateByARBILL.trim().equals("true");
            }
            catch (SQLException ex) {
                try {
                    throw new BOSException((Throwable)ex);
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(rs);
                    throw throwable;
                }
            }
            SQLUtils.cleanup((ResultSet)rs);
            return bl;
        }
        SQLUtils.cleanup((ResultSet)rs);
        return false;
    }

    private void updateTempData(Context ctx, String detailTempTable) throws BOSException {
        int customerValue = 3;
        int toCustomerValue = 4;
        int supplierValue = 2;
        int toSupplierValue = 5;
        String[] sqls = new String[4];
        StringBuffer sql = new StringBuffer();
        sql.append("update ").append(detailTempTable).append(" set FCustomerId = '").append("EgkAAABc3Xu/DAQO").append("' where exists ");
        sql.append("(select fid from T_IM_StoreType where FId = ").append(detailTempTable);
        sql.append(".FStoreTypeId and FStoreFlag not in (");
        sql.append(customerValue).append(",").append(toCustomerValue).append("));");
        sqls[0] = sql.toString();
        sql.setLength(0);
        sql.append("update ").append(detailTempTable).append(" set FSupplierId = '").append("EgkAAABc3Xo3xn38").append("' where exists ");
        sql.append("(select fid from T_IM_StoreType where FId = ").append(detailTempTable);
        sql.append(".FStoreTypeId and FStoreFlag not in (");
        sql.append(supplierValue).append(",").append(toSupplierValue).append("));");
        sqls[1] = sql.toString();
        sql.setLength(0);
        sql.append("update ").append(detailTempTable).append(" set FProjectID = '").append("EgkAAABc3Xza3gXu").append("' where exists ");
        sql.append("(select 1 from T_BD_MaterialInventory where FMaterialID = ").append(detailTempTable).append(".FMaterialID ");
        sql.append("and FOrgUnit = ").append(detailTempTable).append(".FStorageOrgUnitID and FIsProjectNumber = 0);");
        sqls[2] = sql.toString();
        sql.setLength(0);
        sql.append("update ").append(detailTempTable).append(" set FTrackNumberID = '").append("EgkAAABc3X0Ibpg9").append("' where exists ");
        sql.append("(select 1 from T_BD_MaterialInventory where FMaterialID = ").append(detailTempTable).append(".FMaterialID ");
        sql.append("and FOrgUnit = ").append(detailTempTable).append(".FStorageOrgUnitID and FIsTrackingNumber = 0);");
        sqls[3] = sql.toString();
        KsqlUtil.execute((Context)ctx, (String[])sqls);
    }

    private void updateNull2DefaultValue(Context ctx, String detailTempTable) throws BOSException {
        String[] sqls = new String[8];
        StringBuffer sql = new StringBuffer();
        sql.append("update ").append(detailTempTable).append(" set FCustomerId = '").append("EgkAAABc3Xu/DAQO").append("' where FCustomerId IS NULL");
        sqls[0] = sql.toString();
        sql.setLength(0);
        sql.append("update ").append(detailTempTable).append(" set FSupplierId = '").append("EgkAAABc3Xo3xn38").append("' where FSupplierId IS NULL");
        sqls[1] = sql.toString();
        sql.setLength(0);
        sql.append("update ").append(detailTempTable).append(" set FProjectID = '").append("EgkAAABc3Xza3gXu").append("' where FProjectID IS NULL");
        sqls[2] = sql.toString();
        sql.setLength(0);
        sql.append("update ").append(detailTempTable).append(" set FTrackNumberID = '").append("EgkAAABc3X0Ibpg9").append("' where FTrackNumberID IS NULL");
        sqls[3] = sql.toString();
        sql.setLength(0);
        sql.append("update ").append(detailTempTable).append(" set FLocationID = '").append("EgkAAABc3XMgX/hq").append("' where FLocationID IS NULL");
        sqls[4] = sql.toString();
        sql.setLength(0);
        sql.append("update ").append(detailTempTable).append(" set FLot = '").append("YNi0IQEOEADgBT3mfwAAAcznrtQ=").append("' where FLot IS NULL");
        sqls[5] = sql.toString();
        sql.setLength(0);
        sql.append("update ").append(detailTempTable).append(" set FAssistPropertyID = '").append("EgkAAAA5EWALxvQu").append("' where FAssistPropertyID IS NULL");
        sqls[6] = sql.toString();
        sql.setLength(0);
        sql.append("update ").append(detailTempTable).append(" set FAssistUnitID = '").append("EgkAAAA5EWFbglxX").append("' where FAssistUnitID IS NULL");
        sqls[7] = sql.toString();
        KsqlUtil.execute((Context)ctx, (String[])sqls);
    }

    private void checkCountingFrozen(Context ctx, String tmpTable) throws BOSException, InvUpdateException {
        StringBuffer sqlBuff = new StringBuffer();
        sqlBuff.append("SELECT TOP 1 1 FROM (");
        sqlBuff.append(" SELECT TEMP.FStorageOrgUnitID, TEMP.FWarehouseID, TEMP.FMaterialID ");
        sqlBuff.append(" FROM ").append(tmpTable).append(" AS TEMP");
        sqlBuff.append(" INNER JOIN T_IM_COUNTINGTEMP AS COUNTING ");
        sqlBuff.append("  ON TEMP.FStorageOrgUnitID = COUNTING.FStorageOrgUnitID ");
        sqlBuff.append(" AND TEMP.FWarehouseID = COUNTING.FWarehouseID ");
        sqlBuff.append(" AND TEMP.FMaterialID = COUNTING.FMaterialID ");
        sqlBuff.append(" UNION ALL ");
        sqlBuff.append(" SELECT TEMP.FStorageOrgUnitID, TEMP.FWarehouseID, TEMP.FMaterialID ");
        sqlBuff.append(" FROM ").append(tmpTable).append(" AS TEMP");
        sqlBuff.append(" INNER JOIN T_IM_COUNTINGTEMP AS COUNTING ");
        sqlBuff.append("  ON TEMP.FStorageOrgUnitID = COUNTING.FStorageOrgUnitID ");
        sqlBuff.append(" AND TEMP.FCustomerID = COUNTING.FCUSTOMERID ");
        sqlBuff.append(" AND TEMP.FMaterialID = COUNTING.FMaterialID ");
        sqlBuff.append(" UNION ALL ");
        sqlBuff.append(" SELECT TEMP.FStorageOrgUnitID, TEMP.FWarehouseID, TEMP.FMaterialID ");
        sqlBuff.append(" FROM ").append(tmpTable).append(" AS TEMP");
        sqlBuff.append(" INNER JOIN T_IM_COUNTINGTEMP AS COUNTING ");
        sqlBuff.append("  ON TEMP.FStorageOrgUnitID = COUNTING.FStorageOrgUnitID ");
        sqlBuff.append(" AND TEMP.FSupplierID = COUNTING.FSupplierID ");
        sqlBuff.append(" AND TEMP.FMaterialID = COUNTING.FMaterialID ");
        sqlBuff.append(") TMP");
        IRowSet result = DbUtil.executeQuery((Context)ctx, (String)sqlBuff.toString());
        try {
            if (result.next()) {
                throw new InvUpdateException(InvUpdateException.COUNTING_CANNOT_INVUPDATE);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((ResultSet)result);
        }
    }

    private void checkDataValid(Context ctx, String tmpTable) throws BOSException, EASBizException {
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)this.getCheckNecessaryInfoSql(tmpTable));
        try {
            if (rs.next()) {
                throw new InvUpdateException(this.getExceptionSubItem4NecessaryInfo()[rs.getInt("ExcepType")]);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((ResultSet)rs);
        }
    }

    private String getCheckNecessaryInfoSql(String tableName) {
        int customerValue = 3;
        int toCustomerValue = 4;
        int supplierValue = 2;
        int toSupplierValue = 5;
        StringBuffer sql = new StringBuffer();
        sql.append("select 2 AS ExcepType from ").append(tableName).append(" tmp ");
        sql.append("left join T_IM_StoreType st on tmp.FStoreTypeId = st.FId ");
        sql.append("where st.FStoreFlag in(").append(customerValue).append(",").append(toCustomerValue).append(") ");
        sql.append("and FCustomerId is null ");
        sql.append("union all ");
        sql.append("select 3 AS ExcepType from ").append(tableName).append(" tmp ");
        sql.append("left join T_IM_StoreType st on tmp.FStoreTypeId = st.FId ");
        sql.append("where st.FStoreFlag in(").append(supplierValue).append(",").append(toSupplierValue).append(") ");
        sql.append("and FSupplierId is null ");
        return sql.toString();
    }

    private NumericExceptionSubItem[] getExceptionSubItem4NecessaryInfo() {
        return new NumericExceptionSubItem[]{InvUpdateException.WAREHOUSE_HAS_NOT_LOCATION, InvUpdateException.WAREHOUSE_HAS_ERROR_LOCATION, InvUpdateException.EFFECT_QTY_BUT_OUT_CUSTOMER_IS_NULL, InvUpdateException.EFFECT_QTY_BUT_OUT_SUPPLIER_IS_NULL};
    }

    private void updateUnitAndQty(Context ctx, String detailTempTable) throws EASBizException, BOSException {
        boolean isBaseUnitUpdate = this.isBaseUnitUpdate(ctx, detailTempTable);
        if (isBaseUnitUpdate) {
            StringBuffer sSQL = new StringBuffer();
            sSQL.append("update ").append(detailTempTable).append(" set FUnitID = FBaseUnitID, FCurStoreQty = FBaseQty");
            sSQL.append(" where FCurStoreQty <> 0 and FBaseQty <> 0");
            DbUtil.execute((Context)ctx, (String)sSQL.toString());
        }
    }

    private boolean isBaseUnitUpdate(Context ctx, String detailTempTable) throws BOSException, EASBizException {
        IRowSet rs;
        block4: {
            boolean bl;
            StringBuffer sSQL = new StringBuffer();
            sSQL.append("Select top 1 FStorageOrgUnitID from ").append(detailTempTable);
            rs = null;
            try {
                IParamControl ipc;
                String isBaseUpdate;
                rs = DbUtil.executeQuery((Context)ctx, (String)sSQL.toString());
                if (!rs.next() || (isBaseUpdate = (ipc = ParamControlFactory.getLocalInstance((Context)ctx)).getParamValue((IObjectPK)new ObjectUuidPK(rs.getString(1)), "INM004")) == null) break block4;
                bl = isBaseUpdate.trim().equals("true");
            }
            catch (SQLException ex) {
                try {
                    throw new BOSException((Throwable)ex);
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(rs);
                    throw throwable;
                }
            }
            SQLUtils.cleanup((ResultSet)rs);
            return bl;
        }
        SQLUtils.cleanup((ResultSet)rs);
        return false;
    }

    public Boolean isCheckAssistQty(Context ctx, String finalTempTable) throws BOSException, EASBizException {
        String flag = "";
        Boolean paramFlag = true;
        StringBuffer sb = new StringBuffer();
        sb.append(" select FVALUE_L2 from T_BAS_ParamItem ParamItem inner join T_BAS_Param  Param on ParamItem.FkeyId = Param.fid ");
        sb.append(" inner join ").append(finalTempTable).append(" tmp on tmp.fstorageOrgUnitId = ParamItem.forgunitid  ");
        sb.append(" where Param.fnumber =  'INM180'");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
        try {
            if (rs.next()) {
                flag = rs.getString("FVALUE_L2");
                Boolean bl = paramFlag = Boolean.valueOf(Boolean.parseBoolean(flag));
                return bl;
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((ResultSet)rs);
        }
        return paramFlag;
    }
}

