/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv.app.writeback;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.scm.common.util.SCMUtils;
import com.kingdee.eas.scm.im.inv.InvUpdateException;
import com.kingdee.eas.scm.im.inv.app.InvAppUtils;
import com.kingdee.eas.scm.im.inv.app.writeback.IInvCheckingItem;
import com.kingdee.eas.scm.im.inv.app.writeback.WriteBackParamInfo;
import com.kingdee.util.LocaleUtils;
import com.kingdee.util.NumericExceptionSubItem;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Set;

public abstract class AbstractCheckingItem
implements IInvCheckingItem {
    protected AbstractCheckingItem() {
    }

    @Override
    public boolean available(String trasTypeNumber) {
        return true;
    }

    protected abstract String getInvCheckingItemName();

    @Override
    public void check(Context ctx, WriteBackParamInfo invUpdPara) throws BOSException, EASBizException {
        this.doCheck(ctx, invUpdPara);
    }

    protected abstract void doCheck(Context var1, WriteBackParamInfo var2) throws BOSException, EASBizException;

    protected String getLocName(Context ctx) throws BOSException {
        return "FName_" + LocaleUtils.getLocaleString((Locale)ctx.getLocale());
    }

    protected void reversedCheck(Context ctx, WriteBackParamInfo invUpdPara) throws InvUpdateException, BOSException, EASBizException {
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        StringBuffer sqlBuff = new StringBuffer();
        String billEntryTable = invUpdPara.getBillEntryTable();
        String tempTableName = invUpdPara.getTempTableName();
        HashMap<String, BigDecimal> hs = new HashMap<String, BigDecimal>();
        int errors = 0;
        BigDecimal validQty = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            sqlBuff = new StringBuffer();
            sqlBuff.append("SELECT A.FBaseQty as SRCQty,A.FReverseBaseQty as REVQty,B.FBaseQty as DESTQty,");
            sqlBuff.append("B.FSourceBillEntryId as FSourceBillEntryId ");
            sqlBuff.append("FROM " + billEntryTable + " A INNER JOIN ");
            sqlBuff.append(" " + tempTableName + " B ");
            sqlBuff.append("ON A.FID = B.FSourceBillEntryId ");
            stmt = conn.prepareStatement(sqlBuff.toString());
            rs = stmt.executeQuery();
            while (rs.next()) {
                validQty = rs.getBigDecimal("SRCQty").setScale(8, 4).abs().subtract(rs.getBigDecimal("REVQty").setScale(8, 4).abs()).subtract(rs.getBigDecimal("DESTQty").setScale(8, 4).abs());
                if (validQty.signum() != -1) continue;
                hs.put(rs.getString("FSourceBillEntryId"), validQty);
                if (++errors < 5) continue;
            }
            if (errors > 0) {
                this.showQtyRefCheckError(ctx, tempTableName, hs, InvUpdateException.REVERSE_QTY_NOMATCH_SOURCE);
            }
        }
        catch (SQLException ex) {
            try {
                throw new BOSException((Throwable)ex);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, stmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)conn);
    }

    protected void showQtyRefCheckError(Context ctx, String tempTable, HashMap errorHs, NumericExceptionSubItem numException) throws InvUpdateException, BOSException {
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        Set keyset = errorHs.keySet();
        StringBuffer errorStr = new StringBuffer();
        String sql = "";
        String sqlin = "";
        Object[] errorArr = new String[1];
        String locName = this.getLocName(ctx);
        String fsourcebillentryid2 = "";
        HashMap<String, String> hsSeq = new HashMap<String, String>();
        HashMap<String, List<String>> hsContent = new HashMap<String, List<String>>();
        HashMap<String, String> hsMsg = new HashMap<String, String>();
        List<String> content = null;
        try {
            try {
                conn = EJBFactory.getConnection((Context)ctx);
                Iterator it = keyset.iterator();
                boolean isfirst = true;
                while (it.hasNext()) {
                    sqlin = sqlin + ",'" + (String)it.next() + "'";
                }
                sqlin = sqlin.substring(1);
                sql = "select  d.fseq as fseq,d.fsourcebillentryid as fsourcebillentryid,a." + locName + " as fmaterialname,c." + locName + " as funitname ,b.FBaseConvsRate as FBaseConvsRate,b.FQtyPrecision as FQtyPrecision from t_bd_material a,t_bd_multimeasureunit b,t_bd_measureunit c," + tempTable + " d where a.fid = d.fmaterialid and b.fmaterialid = d.fmaterialid and b.fmeasureunitid = d.funitid and c.fid = d.funitid and d.fsourcebillentryid in (" + sqlin + ") order by d.fseq ";
                stmt = conn.prepareStatement(sql);
                rs = stmt.executeQuery();
                while (rs.next()) {
                    fsourcebillentryid2 = rs.getString("fsourcebillentryid");
                    if (hsSeq.containsKey(fsourcebillentryid2)) {
                        String fseq = (String)hsSeq.get(fsourcebillentryid2);
                        fseq = fseq + "," + String.valueOf(rs.getInt("fseq"));
                        hsSeq.put(fsourcebillentryid2, fseq);
                        continue;
                    }
                    hsSeq.put(fsourcebillentryid2, String.valueOf(rs.getInt("fseq")));
                    content = new ArrayList<String>();
                    content.add(0, rs.getString("fmaterialname"));
                    BigDecimal qty = (BigDecimal)errorHs.get(fsourcebillentryid2);
                    qty = qty.abs().divide(rs.getBigDecimal("FBaseConvsRate"), rs.getInt("FQtyPrecision"), 4);
                    String qtyStr = InvAppUtils.getDecimalFormatString(ctx, qty, qty.scale());
                    content.add(1, qtyStr);
                    content.add(2, rs.getString("funitname"));
                    if (qty.signum() == 0 && isfirst) {
                        String measureUnitTransError = SCMUtils.getResource((String)"com.kingdee.eas.scm.im.inv.WarehsManageResource", (String)"MeasureUnitTransError", (Context)ctx);
                        hsMsg.put(fsourcebillentryid2, measureUnitTransError);
                        isfirst = false;
                    }
                    hsContent.put(fsourcebillentryid2, content);
                }
                String errorMsg = SCMUtils.getResource((String)"com.kingdee.eas.scm.im.inv.WarehsManageResource", (String)"QtyCheckError", (Context)ctx);
                for (String fsourcebillentryid2 : keyset) {
                    errorStr.append("\n");
                    if (hsSeq.get(fsourcebillentryid2) != null && hsContent.get(fsourcebillentryid2) != null && hsContent.get(fsourcebillentryid2) instanceof List) {
                        content = new ArrayList();
                        content = (List)hsContent.get(fsourcebillentryid2);
                        errorStr.append(MessageFormat.format(errorMsg, (String)hsSeq.get(fsourcebillentryid2), content.get(0), content.get(1), content.get(2)));
                    }
                    if (hsMsg.get(fsourcebillentryid2) == null) continue;
                    errorStr.append("\n").append(hsMsg.get(fsourcebillentryid2));
                }
                errorArr[0] = errorStr.toString();
                throw new InvUpdateException(numException, errorArr);
            }
            catch (SQLException ex) {
                throw new BOSException("Sql execute exception : " + sql, (Throwable)ex);
            }
        }
        catch (Throwable throwable) {
            SQLUtils.cleanup(rs, stmt, (Connection)conn);
            throw throwable;
        }
    }

    protected void showQtyRefCheckError2(Context ctx, String tempTable, HashMap errorHs, NumericExceptionSubItem numException) throws InvUpdateException, BOSException {
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        Set keyset = errorHs.keySet();
        StringBuffer errorStr = new StringBuffer();
        String sql = "";
        String sqlin = "";
        Object[] errorArr = new String[1];
        String locName = this.getLocName(ctx);
        String fcorebillentryid = "";
        LinkedHashMap<String, String> hsSeq = new LinkedHashMap<String, String>();
        HashMap<String, List<String>> hsContent = new HashMap<String, List<String>>();
        HashMap<String, String> hsMsg = new HashMap<String, String>();
        List<String> content = null;
        try {
            try {
                conn = EJBFactory.getConnection((Context)ctx);
                Iterator it = keyset.iterator();
                while (it.hasNext()) {
                    sqlin = sqlin + ",'" + (String)it.next() + "'";
                }
                sqlin = sqlin.substring(1);
                sql = "select  d.fseq as fseq,d.fcorebillentryid as fcorebillentryid,a." + locName + " as fmaterialname,c." + locName + " as funitname ,b.FBaseConvsRate as FBaseConvsRate,b.FQtyPrecision as FQtyPrecision from t_bd_material a,t_bd_multimeasureunit b,t_bd_measureunit c," + tempTable + " d where a.fid = d.fmaterialid and b.fmaterialid = d.fmaterialid and b.fmeasureunitid = d.funitid and c.fid = d.funitid and d.fcorebillentryid in (" + sqlin + ") order by d.fseq ";
                stmt = conn.prepareStatement(sql);
                rs = stmt.executeQuery();
                boolean isfirst = true;
                while (rs.next()) {
                    fcorebillentryid = rs.getString("fcorebillentryid");
                    if (hsSeq.containsKey(fcorebillentryid)) {
                        String fseq = (String)hsSeq.get(fcorebillentryid);
                        fseq = fseq + "," + String.valueOf(rs.getInt("fseq"));
                        hsSeq.put(fcorebillentryid, fseq);
                        continue;
                    }
                    hsSeq.put(fcorebillentryid, String.valueOf(rs.getInt("fseq")));
                    content = new ArrayList<String>();
                    content.add(0, rs.getString("fmaterialname"));
                    BigDecimal qty = (BigDecimal)errorHs.get(fcorebillentryid);
                    qty = qty.abs().divide(rs.getBigDecimal("FBaseConvsRate"), rs.getInt("FQtyPrecision"), 4);
                    String qtyStr = InvAppUtils.getDecimalFormatString(ctx, qty, qty.scale());
                    content.add(1, qtyStr);
                    content.add(2, rs.getString("funitname"));
                    if (qty.signum() == 0 && isfirst) {
                        String measureUnitTransError = SCMUtils.getResource((String)"com.kingdee.eas.scm.im.inv.WarehsManageResource", (String)"MeasureUnitTransError", (Context)ctx);
                        hsMsg.put(fcorebillentryid, measureUnitTransError);
                        isfirst = false;
                    }
                    hsContent.put(fcorebillentryid, content);
                }
                keyset = hsSeq.keySet();
                it = keyset.iterator();
                String errorMsg = SCMUtils.getResource((String)"com.kingdee.eas.scm.im.inv.WarehsManageResource", (String)"QtyCheckError", (Context)ctx);
                while (it.hasNext()) {
                    fcorebillentryid = (String)it.next();
                    errorStr.append("\n");
                    if (hsSeq.get(fcorebillentryid) != null && hsContent.get(fcorebillentryid) != null && hsContent.get(fcorebillentryid) instanceof List) {
                        content = new ArrayList();
                        content = (List)hsContent.get(fcorebillentryid);
                        errorStr.append(MessageFormat.format(errorMsg, (String)hsSeq.get(fcorebillentryid), content.get(0), content.get(1), content.get(2)));
                    }
                    if (hsMsg.get(fcorebillentryid) == null) continue;
                    errorStr.append("\n").append(hsMsg.get(fcorebillentryid));
                }
                errorArr[0] = errorStr.toString();
                throw new InvUpdateException(numException, errorArr);
            }
            catch (SQLException ex) {
                throw new BOSException("Sql execute exception : " + sql, (Throwable)ex);
            }
        }
        catch (Throwable throwable) {
            SQLUtils.cleanup(rs, stmt, (Connection)conn);
            throw throwable;
        }
    }
}

