/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv.app.writeback;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.event.util.DBUtils;
import com.kingdee.bos.framework.DynamicObjectFactory;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.scm.common.BillTypeFactory;
import com.kingdee.eas.basedata.scm.common.BillTypeInfo;
import com.kingdee.eas.basedata.scm.common.TransactionTypeInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.scm.common.BizActionEnum;
import com.kingdee.eas.scm.common.SCMBillBaseInfo;
import com.kingdee.eas.scm.common.SCMBillEntryBaseInfo;
import com.kingdee.eas.scm.common.util.KsqlUtil;
import com.kingdee.eas.scm.im.inv.InvCommonUtils;
import com.kingdee.eas.scm.im.inv.app.InvAppUtils;
import com.kingdee.eas.scm.im.inv.app.invupdate.IMBussinessProcessorFactory;
import com.kingdee.eas.scm.im.inv.app.invupdate.TableGeneratorHelper;
import com.kingdee.eas.scm.im.inv.app.writeback.WriteBackParamInfo;
import com.kingdee.eas.scm.im.inv.app.writeback.WriteBackProcessor;
import com.kingdee.eas.scm.util.string.StringUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.enterprisedt.util.debug.Logger;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.ResultSet;
import java.sql.SQLException;

public class WriteBaceFactory {
    private static Logger logger = Logger.getLogger(WriteBaceFactory.class);

    public static WriteBackProcessor getWriteBackProcessor(String billTypeNO) {
        WriteBackProcessor writeBackProcessor = (WriteBackProcessor)IMBussinessProcessorFactory.getWriteBackProcessor(billTypeNO);
        return writeBackProcessor;
    }

    public static WriteBackParamInfo getWriteBackParamInfo(Context ctx, BizActionEnum bizAction, String billID, String transTypeID) throws BOSException, EASBizException {
        String billTableName;
        WriteBackParamInfo updateParam;
        block21: {
            TransactionTypeInfo transType;
            block20: {
                IRowSet rs;
                block19: {
                    transType = InvAppUtils.getTransType(ctx, transTypeID);
                    updateParam = new WriteBackParamInfo();
                    updateParam.setBizAction(bizAction);
                    updateParam.setBillID(billID);
                    updateParam.setTransType(transType);
                    billTableName = InvCommonUtils.getBillTableName(transType);
                    String billEntryName = InvCommonUtils.getBillEntryTableName(transType);
                    updateParam.setBillTable(billTableName);
                    updateParam.setBillEntryTable(billEntryName);
                    if (transType.getBillType().getNumber() != null) break block20;
                    logger.error("**************\u83b7\u5f97\u5355\u8f66\u7c7b\u578b\u7f16\u7801\u4e3a\u7a7a");
                    rs = null;
                    try {
                        StringBuffer sql = new StringBuffer();
                        sql.append("select bt.fnumber as fnumber from t_scm_transactiontype tt ");
                        sql.append("left join t_scm_billtype bt on bt.fid = tt.fbilltypeid ");
                        sql.append("where tt.fid = ?");
                        rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new String[]{transTypeID});
                        if (!rs.next()) break block19;
                        logger.error("**************\u4ece\u6570\u636e\u5e93\u83b7\u5f97\u4e86\u5355\u636e\u7c7b\u578b\u7f16\u7801\uff1a" + rs.getString("fnumber"));
                        updateParam.setBillTypeNo(rs.getString("fnumber"));
                    }
                    catch (SQLException e) {
                        try {
                            throw new BOSException((Throwable)e);
                        }
                        catch (Throwable throwable) {
                            DBUtils.cleanup(rs, null, null);
                            throw throwable;
                        }
                    }
                }
                DBUtils.cleanup((ResultSet)rs, null, null);
                break block21;
            }
            logger.error("**************\u76f4\u63a5\u5f97\u5230\u4e86\u5355\u636e\u7c7b\u578b\u7f16\u7801\uff1a" + transType.getBillType().getNumber());
            updateParam.setBillTypeNo(transType.getBillType().getNumber());
        }
        BOSObjectType type = BOSUuid.read((String)billID).getType();
        IObjectValue bill = DynamicObjectFactory.getLocalInstance((Context)ctx).getValue(type, (IObjectPK)new ObjectUuidPK(billID));
        String srcBillTypeId = null;
        String coreBillTypeId = null;
        String bizTypeId = "";
        BillTypeInfo srcBillTypeInfo = null;
        BillTypeInfo coreBillTypeInfo = null;
        if (bill instanceof SCMBillBaseInfo) {
            SCMBillEntryBaseInfo scmBillEntry;
            SCMBillBaseInfo scmBill = (SCMBillBaseInfo)bill;
            if (scmBill.getBizType() != null) {
                bizTypeId = scmBill.getBizType().getId().toString();
            }
            if (scmBill.getSourceBillType() != null) {
                srcBillTypeId = scmBill.getSourceBillType().getId().toString();
                srcBillTypeInfo = BillTypeFactory.getLocalInstance((Context)ctx).getBillTypeInfo((IObjectPK)new ObjectUuidPK(srcBillTypeId));
            }
            if (scmBill.getEntries() != null && scmBill.getEntries().size() > 0 && !StringUtil.isEmpty((String)(coreBillTypeId = (scmBillEntry = (SCMBillEntryBaseInfo)scmBill.getEntries().getObject(0)).getCoreBillTypeId()))) {
                coreBillTypeInfo = BillTypeFactory.getLocalInstance((Context)ctx).getBillTypeInfo((IObjectPK)new ObjectUuidPK(coreBillTypeId));
            }
        }
        if (srcBillTypeInfo != null) {
            updateParam.setSourceBillType(srcBillTypeInfo.getNumber());
        } else {
            updateParam.setSourceBillType("");
        }
        if (coreBillTypeInfo != null) {
            updateParam.setCoreBillType(coreBillTypeInfo.getNumber());
        } else {
            updateParam.setCoreBillType("");
        }
        updateParam.setBizType(bizTypeId);
        boolean isReversed = false;
        boolean isInitBill = false;
        IRowSet rs = null;
        StringBuffer sql = new StringBuffer();
        try {
            if ("T_AR_Otherbill".equalsIgnoreCase(billTableName)) {
                sql.append("SELECT FIsReversed,0,FBizDate FROM ").append(billTableName).append(" WHERE FID = ?");
            } else {
                sql.append("SELECT FIsReversed,FIsInitBill,FBizDate FROM ").append(billTableName).append(" WHERE FID = ?");
            }
            rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new String[]{billID});
            if (rs.next()) {
                if (rs.getInt(1) != 0) {
                    isReversed = true;
                }
                if (rs.getInt(2) != 0) {
                    isInitBill = true;
                }
                updateParam.setBizDate(rs.getDate(3));
            }
        }
        catch (SQLException ex) {
            throw new BOSException((Throwable)ex);
        }
        updateParam.setReversed(isReversed);
        updateParam.setInitBill(isInitBill);
        return updateParam;
    }

    public static void initData(Context ctx, WriteBackParamInfo wbParam) throws BOSException {
        long start = System.currentTimeMillis();
        String tempTableName = KsqlUtil.createTempTable((Context)ctx, (String)WriteBaceFactory.getCreateSql());
        wbParam.setTempTableName(tempTableName);
        logger.info("=========Inventory Update, create temp table spend (ms) " + (System.currentTimeMillis() - start));
        start = System.currentTimeMillis();
        StringBuffer sql = new StringBuffer();
        sql.append(WriteBaceFactory.getInsertSql(tempTableName));
        sql.append(WriteBaceFactory.getSelectSQL(wbParam.getBillTypeNo(), wbParam.getBillTable(), wbParam.getBillEntryTable()));
        DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])new Object[]{wbParam.getBillID()});
        logger.info("=========Inventory Update, insert data to temp table spend (ms) " + (System.currentTimeMillis() - start));
    }

    public static String getCreateSql() {
        TableGeneratorHelper.CreateTableParam params = new TableGeneratorHelper.CreateTableParam("T_TMP_WriteBackTable");
        String[] vc44NotNulls = new String[]{"FBillID", "FBillEntryID", "FCompanyOrgUnitID", "FStorageOrgUnitID", "FUnitID", "FBaseUnitID"};
        String[] vc44AllowNulls = new String[]{"FSourceBillId", "FSourceBillEntryId", "FSourceBillTypeID", "FBizTypeID", "FCoreBillId", "FCoreBillEntryId", "FMaterialID", "FAssistUnitID"};
        String[] vc80NotNulls = new String[]{"FBillNumber"};
        String[] vc80AllowNulls = new String[]{"FNoNumMaterialName"};
        String[] intNotNullDefaultZeros = new String[]{"FSeq", "FBaseStatus", "FIsReversed", "FIsPresent", "FIsReturn", "FQtyPrecision"};
        String[] qtyNotNullDefaultZeros = new String[]{"FQty", "FAssistQty", "FBaseQty", "FReverseQty", "FReturnsQty"};
        String[] amtNotNullDefaultZeros = new String[]{"FStandardCost", "FActualCost"};
        String[] dateTimeNotNulls = new String[]{"FBizDate"};
        String[] otherFields = new String[]{"FYear INT DEFAULT 2999 NOT NULL", "FPeriod INT DEFAULT 1 NOT NULL", "FBaseConvsRate NUMERIC(28,10) DEFAULT 0"};
        params.setAmtNotNullDefaultZeros(amtNotNullDefaultZeros);
        params.setDateTimeNotNulls(dateTimeNotNulls);
        params.setIntNotNullDefaultZeros(intNotNullDefaultZeros);
        params.setOtherFields(otherFields);
        params.setQtyNotNullDefaultZeros(qtyNotNullDefaultZeros);
        params.setVc44AllowNulls(vc44AllowNulls);
        params.setVc44NotNullDefaultZeros(vc44NotNulls);
        params.setVc80NotNulls(vc80NotNulls);
        params.setVc80AllowNulls(vc80AllowNulls);
        return TableGeneratorHelper.getCreateTableSql(params);
    }

    private static String getInsertSql(String tableName) {
        StringBuffer sql = new StringBuffer();
        sql.append("INSERT INTO ").append(tableName);
        sql.append("(FBillID,FBillEntryID,FBillNumber,FBizDate,FBizTypeID,FBaseStatus,FIsReversed,FYear,FPeriod,");
        sql.append("FSeq,FCompanyOrgUnitID,FStorageOrgUnitID,FMaterialID,FNoNumMaterialName,FSourceBillId,FSourceBillEntryId,FSourceBillTypeID,");
        sql.append("FCoreBillID,FCoreBillEntryID,FUnitID,FQty,FAssistUnitID,FAssistQty,FBaseUnitID,FBaseQty,FReverseQty,");
        sql.append("FReturnsQty,FIsPresent,FStandardCost,FActualCost,FIsReturn)").append("\r\n");
        return sql.toString();
    }

    private static String getSelectSQL(String billTypeNO, String billTable, String entryTable) {
        StringBuffer sql = new StringBuffer();
        sql.append("Select bill.FID,entry.FID,bill.FNumber,bill.FBizDate,bill.FBizTypeID,bill.FBaseStatus,ISNULL(bill.FIsReversed, 0),bill.FYear,");
        sql.append("bill.FPeriod,entry.FSeq,entry.FCompanyOrgUnitID,entry.FStorageOrgUnitID,entry.FMaterialID,");
        if ("T_IM_PurReceivalEntry".equalsIgnoreCase(entryTable) && "T_IM_PurReceivalBill".equalsIgnoreCase(billTable)) {
            sql.append("case when(entry.FMaterialID is null) then entry.FNoNumMaterialName else null end,");
        } else {
            sql.append("null,");
        }
        sql.append("entry.FSourceBillId,entry.FSourceBillEntryId,entry.FSourceBillTypeID,").append(WriteBaceFactory.getCoreBillField(billTypeNO)).append(",entry.FUnitID,");
        sql.append("ABS(entry.FQty),entry.FAssistUnitID,ISNULL(ABS(entry.FAssistQty),0),entry.FBaseUnitID,ABS(entry.FBaseQty),ISNULL(entry.FReverseQty,0),");
        sql.append("entry.FReturnsQty,ISNULL(entry.FIsPresent, 0),ABS(entry.FStandardCost),ABS(entry.FActualCost),(case when entry.FBaseQty > 0 then 1 else -1 end)").append("\r\n");
        sql.append("from ").append(billTable).append(" bill ").append("\r\n");
        sql.append("inner join ").append(entryTable).append(" entry on entry.FParentID = bill.FID").append("\r\n");
        sql.append("where bill.FID = ?");
        return sql.toString();
    }

    private static String getCoreBillField(String billTypeNO) {
        String coreBillField = "";
        coreBillField = "103".equals(billTypeNO) ? "entry.FPurOrderID,entry.FPurOrderEntryID" : ("102".equals(billTypeNO) ? "entry.FSaleOrderID,entry.FSaleOrderEntryID" : ("107".equals(billTypeNO) || "106".equals(billTypeNO) ? "FStockTransferBillID,FStockTransBillEntryID" : ("101".equals(billTypeNO) ? "case when entry.FPurOrderID is null then entry.FCoreBillID else entry.FPurOrderID end as FCoreBillId,case when entry.FPurOrderID is null then entry.FCoreBillentryID else entry.FPurOrderEntryID end as FCoreBillEntryId" : ("104".equals(billTypeNO) ? "entry.FCOREBILLID,entry.FCOREBILLENTRYID" : "null as FCoreBillId, null as FCoreBillEntryId"))));
        return coreBillField;
    }

    public static void main(String[] args) {
        System.out.println(WriteBaceFactory.getCreateSql());
        System.out.println(WriteBaceFactory.getInsertSql("T_TMP_WriteBackTable"));
        System.out.println(WriteBaceFactory.getSelectSQL("101", "T_IM_PurReceivalBill", "T_IM_PurReceivalEntry"));
    }
}

