/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv.bizCenter.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.scm.im.inv.bizCenter.WHManStateEnum;
import com.kingdee.eas.scm.im.inv.bizCenter.WarehouseManAssignCollection;
import com.kingdee.eas.scm.im.inv.bizCenter.WarehouseManAssignFactory;
import com.kingdee.eas.scm.im.inv.bizCenter.WarehouseManBizException;
import com.kingdee.eas.scm.im.inv.bizCenter.WarehouseManCollection;
import com.kingdee.eas.scm.im.inv.bizCenter.WarehouseManFactory;
import com.kingdee.eas.scm.im.inv.bizCenter.WarehouseManInfo;
import com.kingdee.eas.scm.im.inv.bizCenter.app.AbstractWarehouseManControllerBean;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class WarehouseManControllerBean
extends AbstractWarehouseManControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.scm.im.inv.bizCenter.app.WarehouseManControllerBean");

    @Override
    protected void _audit(Context ctx, IObjectPK[] pks) throws BOSException, EASBizException {
        IObjectPK pk = null;
        String idStr = "";
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < pks.length; ++i) {
            pk = pks[i];
            idStr = idStr + "'" + pk.toString() + "',";
        }
        idStr = idStr.substring(0, idStr.length() - 1);
        String cuId = ((CtrlUnitInfo)ctx.get((Object)OrgType.ControlUnit)).getId().toString();
        sb.append("update T_SCM_WarehouseMan set FStatus = 2 where FID in (").append(idStr).append(")");
        sb.append(" and FStatus=1 and FControlunitid = '").append(cuId).append("'");
        DbUtil.execute((Context)ctx, (String)sb.toString());
    }

    @Override
    protected void _unAudit(Context ctx, IObjectPK[] pks) throws BOSException, EASBizException {
        IObjectPK pk = null;
        String idStr = "";
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < pks.length; ++i) {
            pk = pks[i];
            idStr = idStr + "'" + pk.toString() + "',";
        }
        idStr = idStr.substring(0, idStr.length() - 1);
        String cuId = ((CtrlUnitInfo)ctx.get((Object)OrgType.ControlUnit)).getId().toString();
        sb.append("update T_SCM_WarehouseMan set FStatus = 1 where FID in (").append(idStr).append(")");
        sb.append(" and FStatus=2 and FControlunitid= '").append(cuId).append("'");
        DbUtil.execute((Context)ctx, (String)sb.toString());
    }

    @Override
    public void delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("whman.id", (Object)pk.toString(), CompareType.EQUALS));
        view.setFilter(filter);
        WarehouseManAssignCollection coll = WarehouseManAssignFactory.getLocalInstance(ctx).getWarehouseManAssignCollection(view);
        if (coll.size() > 0) {
            throw new WarehouseManBizException(WarehouseManBizException.REFERENCE_NOT_DELETED);
        }
        super.delete(ctx, pk);
    }

    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        WarehouseManInfo info = (WarehouseManInfo)model;
        StringBuffer sb = new StringBuffer();
        sb.append("select fid from T_SCM_WarehouseMan where FPersonID ='").append(info.getPerson().getId().toString()).append("'");
        sb.append(" and FControlUnitID='").append(info.getCU().getId().toString()).append("'");
        sb.append(" and fid<>'").append(info.getId().toString()).append("'");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
        try {
            if (rs.next()) {
                throw new WarehouseManBizException(WarehouseManBizException.WAREHOUSEMAN_HAS_EXIST);
            }
        }
        catch (SQLException e) {
            throw new BOSException(e.getMessage());
        }
        info.setStatus(WHManStateEnum.SAVED);
        info.setName(info.getPerson().getName());
        info.setNumber(info.getPerson().getNumber());
        return super._save(ctx, (IObjectValue)info);
    }

    @Override
    protected Map _handleBillByOprtState(Context ctx, String id, String oprtState) throws BOSException, EASBizException {
        HashMap<String, WarehouseManInfo> map = new HashMap<String, WarehouseManInfo>();
        if (id == null) {
            return this.createBill(ctx);
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)id, CompareType.EQUALS));
        view.setFilter(filter);
        WarehouseManCollection coll = WarehouseManFactory.getLocalInstance(ctx).getWarehouseManCollection(view);
        map.put("bill", coll.get(0));
        return map;
    }

    private Map createBill(Context ctx) throws BOSException, EASBizException {
        HashMap<String, WarehouseManInfo> map = new HashMap<String, WarehouseManInfo>();
        WarehouseManInfo billInfo = new WarehouseManInfo();
        CtrlUnitInfo cu = (CtrlUnitInfo)ctx.get((Object)OrgType.ControlUnit);
        PermissionFactory.getRemoteInstance().checkFunctionPermission(ctx.getCaller(), (IObjectPK)new ObjectUuidPK(cu.getId().toString()), "warehouseman_addnew");
        billInfo.setStatus(WHManStateEnum.NEW);
        billInfo.setCU(cu);
        map.put("bill", billInfo);
        return map;
    }

    private List checkDataForAudit(Context ctx, String str) throws BOSException, EASBizException {
        StringBuffer sb = new StringBuffer();
        sb.append("select w.fid,p.fnumber from T_SCM_WarehouseMan w");
        sb.append(" Left join T_bd_person p on w.fpersonid = p.fid");
        sb.append(" where w.fid in (").append(str).append(")");
        sb.append(" and w.FStatus<>1");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
        ArrayList<String> list = new ArrayList<String>();
        try {
            while (rs.next()) {
                String id = rs.getString(1);
                String number = rs.getString(2);
                list.add(number);
            }
        }
        catch (SQLException e) {
            throw new BOSException(e.getMessage());
        }
        return list;
    }

    protected FilterInfo getFilterForDefaultCU(Context ctx, IObjectValue model) {
        return null;
    }
}

