/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv.invconfig.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.scm.common.UseStatusEnum;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.scm.common.ISCMBillCommonFacade;
import com.kingdee.eas.scm.common.SCMBillCommonFacadeFactory;
import com.kingdee.eas.scm.im.inv.invconfig.BillInventoryConfigCollection;
import com.kingdee.eas.scm.im.inv.invconfig.BillInventoryConfigInfo;
import com.kingdee.eas.scm.im.inv.invconfig.BillInventoryException;
import com.kingdee.eas.scm.im.inv.invconfig.app.AbstractBillInventoryConfigControllerBean;
import com.kingdee.eas.util.app.ContextUtil;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;

public class BillInventoryConfigControllerBean
extends AbstractBillInventoryConfigControllerBean {
    private static final long serialVersionUID = 1L;

    @Override
    protected ArrayList _setStatus(Context ctx, Set pks, UseStatusEnum status) throws BOSException, EASBizException {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)pks, CompareType.INCLUDE));
        viewInfo.setFilter(filter);
        ArrayList<BillInventoryException> errors = new ArrayList<BillInventoryException>();
        BillInventoryConfigCollection configColl = this.getBillInventoryConfigCollection(ctx, viewInfo);
        if (status.equals((Object)UseStatusEnum.ACTIVE)) {
            HashSet<String> bosTypeSet = new HashSet<String>();
            BillInventoryConfigCollection newConfigColl = this.getNoDuplicateColl(configColl, bosTypeSet);
            boolean isExistDuplicate = newConfigColl.size() != configColl.size();
            Set<String> activedBosTypeSet = this.getActivedBosTypeSet(ctx, bosTypeSet);
            configColl.clear();
            BillInventoryConfigInfo configInfo = null;
            int size = newConfigColl.size();
            for (int i = 0; i < size; ++i) {
                configInfo = newConfigColl.get(i);
                if (activedBosTypeSet.contains(configInfo.getBosType())) {
                    isExistDuplicate = true;
                    continue;
                }
                configColl.add(configInfo);
            }
            if (isExistDuplicate) {
                errors.add(new BillInventoryException(BillInventoryException.ACTIVE_DUPICATE));
            }
        }
        UserInfo user = ContextUtil.getCurrentUserInfo((Context)ctx);
        ISCMBillCommonFacade iSCMBillCommonFacade = SCMBillCommonFacadeFactory.getLocalInstance((Context)ctx);
        Timestamp date = iSCMBillCommonFacade.getServerDate();
        int size = configColl.size();
        for (int i = 0; i < size; ++i) {
            configColl.get(i).setStatus(status);
            configColl.get(i).setLastUpdateTime(date);
            configColl.get(i).setLastUpdateUser(user);
        }
        this._updateBatchData(ctx, (IObjectCollection)configColl);
        return errors;
    }

    private Set<String> getActivedBosTypeSet(Context ctx, Set<String> bosTypeSet) throws BOSException {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("bosType", bosTypeSet, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("status", (Object)1, CompareType.EQUALS));
        viewInfo.setFilter(filter);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("bosType");
        viewInfo.setSelector(sic);
        BillInventoryConfigCollection configColl = this.getBillInventoryConfigCollection(ctx, viewInfo);
        HashSet<String> activedBosTypeSet = new HashSet<String>();
        int size = configColl.size();
        for (int i = 0; i < size; ++i) {
            activedBosTypeSet.add(configColl.get(i).getBosType());
        }
        return activedBosTypeSet;
    }

    private BillInventoryConfigCollection getNoDuplicateColl(BillInventoryConfigCollection configColl, Set<String> bosTypeSet) {
        BillInventoryConfigCollection newConfigColl = new BillInventoryConfigCollection();
        if (configColl.size() == 1) {
            bosTypeSet.add(configColl.get(0).getBosType());
            newConfigColl.addObjectCollection((IObjectCollection)configColl);
            return newConfigColl;
        }
        configColl.sort("bosType");
        String bosType = null;
        int size = configColl.size();
        for (int i = 0; i < size; ++i) {
            bosType = configColl.get(i).getBosType();
            if (this.isDuplicate(configColl, bosType, i)) continue;
            newConfigColl.add(configColl.get(i));
            bosTypeSet.add(bosType);
        }
        return newConfigColl;
    }

    private boolean isDuplicate(BillInventoryConfigCollection configColl, String bosType, int index) {
        int i;
        for (i = index - 1; i > 0; --i) {
            if (!configColl.get(i).getBosType().equals(bosType)) continue;
            return true;
        }
        for (i = index + 1; i < configColl.size(); ++i) {
            if (!configColl.get(i).getBosType().equals(bosType)) continue;
            return true;
        }
        return false;
    }
}

