/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv.invconfig.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.SQLExecutor;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.MeasureUnitFactory;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.material.AsstAttrValueFactory;
import com.kingdee.eas.basedata.master.material.AsstAttrValueInfo;
import com.kingdee.eas.basedata.master.material.IssuePriorityEnum;
import com.kingdee.eas.basedata.master.material.MaterialFactory;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.MaterialInventoryCollection;
import com.kingdee.eas.basedata.master.material.MaterialInventoryFactory;
import com.kingdee.eas.basedata.master.material.MaterialInventoryInfo;
import com.kingdee.eas.basedata.scm.im.inv.LocationFactory;
import com.kingdee.eas.basedata.scm.im.inv.LocationInfo;
import com.kingdee.eas.basedata.scm.im.inv.WarehouseFactory;
import com.kingdee.eas.basedata.scm.im.inv.WarehouseInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.mm.basedata.TrackNumberFactory;
import com.kingdee.eas.mm.basedata.TrackNumberInfo;
import com.kingdee.eas.mm.project.ProjectFactory;
import com.kingdee.eas.mm.project.ProjectInfo;
import com.kingdee.eas.scm.common.SCMBillCommonFacadeFactory;
import com.kingdee.eas.scm.common.util.StringUtil;
import com.kingdee.eas.scm.im.inv.CalculateLotException;
import com.kingdee.eas.scm.im.inv.app.InvAppUtils;
import com.kingdee.eas.scm.im.inv.invconfig.app.AbstractCalculateLotFacadeControllerBean;
import com.kingdee.eas.scm.util.datetime.DateTimeUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class CalculateLotFacadeControllerBean
extends AbstractCalculateLotFacadeControllerBean {
    private static final long serialVersionUID = 1L;
    private boolean checkLocation = false;
    private Set<String> defaultKey = null;
    private List<String> keyList = null;
    private boolean isUpdateByBaseUnit = false;
    private Context ctx = null;
    private String permissionSQL = null;
    private String permissionJoinSQL = null;
    private Map permissionMap = new HashMap();
    private Map iObjectMap = new HashMap();
    private Map materialInvMap = new HashMap();

    @Override
    protected Map _getInventoryColl(Context ctx, Map keyDataMap, Map conditions) throws BOSException, EASBizException {
        this.ctx = ctx;
        this.keyList = (List)conditions.get("keyList");
        this.isUpdateByBaseUnit = (Boolean)conditions.get("isUpdateByBaseUnit");
        HashMap returnMap = new HashMap();
        Iterator it = keyDataMap.keySet().iterator();
        Map keyMap = null;
        String materialID = null;
        String souID = null;
        this.initDefaultKey();
        List invList = null;
        String key = null;
        HashMap<String, Object> dataMap = null;
        boolean isNegative = false;
        boolean isBotp = false;
        if (conditions.get("isBOTP") != null && (Boolean)conditions.get("isBOTP") == Boolean.TRUE) {
            isBotp = true;
        }
        HashSet<String> materialIDSet = new HashSet<String>();
        while (it.hasNext()) {
            key = (String)it.next();
            keyMap = (Map)keyDataMap.get(key);
            materialID = (String)keyMap.get("FMaterialID");
            souID = (String)keyMap.get("FStorageOrgUnitID");
            materialIDSet.add(materialID);
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("material", materialIDSet, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("orgUnit", (Object)souID, CompareType.EQUALS));
        view.setFilter(filter);
        SelectorItemCollection sics = new SelectorItemCollection();
        sics.add(new SelectorItemInfo("id"));
        sics.add(new SelectorItemInfo("material.id"));
        sics.add(new SelectorItemInfo("issuePriorityMode"));
        sics.add(new SelectorItemInfo("isNegative"));
        view.setSelector(sics);
        MaterialInventoryCollection materialInvCol = MaterialInventoryFactory.getLocalInstance((Context)ctx).getMaterialInventoryCollection(view);
        MaterialInventoryInfo materialInv = null;
        int size = materialInvCol.size();
        for (int i = 0; i < size; ++i) {
            materialInv = materialInvCol.get(i);
            this.materialInvMap.put(materialInv.getMaterial().getId().toString(), materialInv);
        }
        boolean isNegativeAndBotp = false;
        it = keyDataMap.keySet().iterator();
        try {
            while (it.hasNext()) {
                key = (String)it.next();
                keyMap = (Map)keyDataMap.get(key);
                materialID = (String)keyMap.get("FMaterialID");
                materialInv = (MaterialInventoryInfo)this.materialInvMap.get(materialID);
                IssuePriorityEnum issuePriority = materialInv.getIssuePriorityMode();
                isNegative = materialInv.isIsNegative();
                invList = this.getInventoryColl(keyMap, issuePriority, isNegative, isBotp);
                isNegativeAndBotp = isNegative && isBotp;
                dataMap = new HashMap<String, Object>();
                dataMap.put("invList", invList);
                dataMap.put("isNegativeAndBotp", isNegativeAndBotp);
                BigDecimal qty = (BigDecimal)keyMap.get("totalQty");
                this.checkEnough(ctx, isNegative, qty, dataMap, keyMap, isBotp);
                returnMap.put(key, dataMap);
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return returnMap;
    }

    private void checkEnough(Context ctx, boolean isNegative, BigDecimal qty, Map dataMap, Map keyMap, boolean isBotp) throws EASBizException, BOSException {
        String qtyField = this.isUpdateByBaseUnit ? "FBaseQty" : "FCurStoreQty";
        Map data = null;
        BigDecimal qtySum = BigDecimal.ZERO;
        dataMap.put("isMatch", Boolean.TRUE);
        List invList = (List)dataMap.get("invList");
        for (int i = 0; i < invList.size(); ++i) {
            data = (Map)invList.get(i);
            qtySum = qtySum.add((BigDecimal)data.get(qtyField) == null ? BigDecimal.ZERO : (BigDecimal)data.get(qtyField));
        }
        if (qty == null) {
            qty = new BigDecimal("0.00");
        }
        if (qtySum.compareTo(qty) < 0) {
            int precision = qty.scale();
            BigDecimal qtyDiff = qty.subtract(qtySum).setScale(precision, RoundingMode.HALF_UP);
            String qtyDiffStr = InvAppUtils.getDecimalFormatString(ctx, qtyDiff, qtyDiff.scale());
            String msg = this.getErrorMsg(ctx, keyMap);
            dataMap.put("isMatch", Boolean.FALSE);
            if (!isNegative || !isBotp) {
                if (this.isUpdateByBaseUnit) {
                    CalculateLotException ex = new CalculateLotException(CalculateLotException.NOTENOUGH, new Object[]{msg, qtyDiffStr});
                    dataMap.put("errorMsg", ex.getMessage());
                } else {
                    CalculateLotException ex = new CalculateLotException(CalculateLotException.NOTENOUGH2, new Object[]{msg, qtyDiffStr});
                    dataMap.put("errorMsg", ex.getMessage());
                }
            }
        }
    }

    private String getErrorMsg(Context ctx, Map keyMap) throws EASBizException, BOSException {
        String locationID;
        String warehouseID;
        String funitID;
        String unitID;
        String trackNumberID;
        String projectID;
        String asstAttrID;
        StringBuilder msg = new StringBuilder();
        String materialID = (String)keyMap.get("FMaterialID");
        if (materialID != null) {
            MaterialInfo material = MaterialFactory.getLocalInstance((Context)ctx).getMaterialInfo((IObjectPK)new ObjectUuidPK(materialID));
            msg.append(material.getNumber());
            msg.append(" ");
            msg.append(material.getName());
        }
        if ((asstAttrID = (String)keyMap.get("FAssistPropertyID")) != null) {
            AsstAttrValueInfo asstAttr = AsstAttrValueFactory.getLocalInstance((Context)ctx).getAsstAttrValueInfo((IObjectPK)new ObjectUuidPK(asstAttrID));
            msg.append(" ").append(asstAttr.getName());
        }
        if ((projectID = (String)keyMap.get("FProjectID")) != null) {
            ProjectInfo project = ProjectFactory.getLocalInstance((Context)ctx).getProjectInfo((IObjectPK)new ObjectUuidPK(projectID));
            msg.append(" ").append(project.getNumber());
        }
        if ((trackNumberID = (String)keyMap.get("FTrackNumberID")) != null) {
            TrackNumberInfo trackNumber = TrackNumberFactory.getLocalInstance((Context)ctx).getTrackNumberInfo((IObjectPK)new ObjectUuidPK(trackNumberID));
            msg.append(" ").append(trackNumber.getNumber());
        }
        if ((unitID = (String)keyMap.get(funitID = this.isUpdateByBaseUnit ? "FBaseUnitID" : "FUnitID")) != null) {
            MeasureUnitInfo unit = MeasureUnitFactory.getLocalInstance((Context)ctx).getMeasureUnitInfo((IObjectPK)new ObjectUuidPK(unitID));
            msg.append(" ").append(unit.getName());
        }
        if ((warehouseID = (String)keyMap.get("FWarehouseID")) != null) {
            WarehouseInfo warehouse = WarehouseFactory.getLocalInstance((Context)ctx).getWarehouseInfo((IObjectPK)new ObjectUuidPK(warehouseID));
            msg.append(" ").append(warehouse.getName());
        }
        if ((locationID = (String)keyMap.get("FLocationID")) != null) {
            LocationInfo location = LocationFactory.getLocalInstance((Context)ctx).getLocationInfo((IObjectPK)new ObjectUuidPK(locationID));
            msg.append(" ").append(location.getName());
        }
        return msg.toString();
    }

    private List getInventoryColl(Map data, IssuePriorityEnum issuePriority, boolean isNegative, boolean isBotp) throws Exception {
        List invList = this.getInventoryColl(data, issuePriority, false);
        if (invList.size() == 0 && isNegative && isBotp) {
            invList = this.getInventoryColl(data, issuePriority, true);
        }
        return invList;
    }

    private List getInventoryColl(Map data, IssuePriorityEnum issuePriority, boolean isNegative) throws Exception {
        StringBuilder sql = new StringBuilder();
        StringBuilder selectSQL = this.getDefaultSelectSQL();
        String invField = null;
        for (int i = 0; i < this.keyList.size(); ++i) {
            invField = this.keyList.get(i);
            if (this.defaultKey.contains(invField)) continue;
            selectSQL.append(", INVENTORY.").append(invField).append(" as ").append(invField);
        }
        this.initPermissionSQL(data.get("FStorageOrgUnitID").toString());
        sql.append((CharSequence)selectSQL).append((CharSequence)this.getDefaultFromSQL());
        if (!StringUtil.isEmpty((String)this.permissionJoinSQL)) {
            sql.append(this.permissionJoinSQL);
        }
        sql.append((CharSequence)this.getDefaultWhereSQL(this.keyList, data, isNegative));
        if (!StringUtil.isEmpty((String)this.permissionSQL)) {
            sql.append(" and ").append(this.permissionSQL);
        }
        sql.append((CharSequence)this.getDefaultOrderBySQL(issuePriority));
        IRowSet rs = new SQLExecutor(this.ctx, sql.toString()).executeSQL();
        List<Map<String, Object>> invList = this.getInventory(rs);
        return invList;
    }

    private List<Map<String, Object>> getInventory(IRowSet rs) throws Exception {
        ArrayList<Map<String, Object>> invList = new ArrayList<Map<String, Object>>();
        HashMap<String, Object> dataMap = null;
        String invField = null;
        Object value = null;
        HashMap<String, Object> cacheMap = new HashMap<String, Object>();
        Object newValue = null;
        while (rs.next()) {
            dataMap = new HashMap<String, Object>();
            for (int i = 0; i < this.keyList.size(); ++i) {
                invField = this.keyList.get(i);
                if ("FBaseUnitID".equals(invField) || "FUnitID".equals(invField)) continue;
                value = rs.getObject(invField);
                if (value != null && cacheMap.containsKey(value.toString())) {
                    dataMap.put(invField, cacheMap.get(value.toString()));
                    continue;
                }
                newValue = this.getFinalValue(invField, value);
                dataMap.put(invField, newValue);
                if (value == null) continue;
                cacheMap.put(value.toString(), newValue);
            }
            dataMap.put("FCurStoreQty", rs.getBigDecimal("FCurStoreQty"));
            dataMap.put("FBaseQty", rs.getBigDecimal("FBaseQty"));
            dataMap.put("FLot", rs.getString("FLot"));
            dataMap.put("FExp", rs.getString("FExp"));
            dataMap.put("FMfg", rs.getString("FMfg"));
            invList.add(dataMap);
        }
        return invList;
    }

    private Object getFinalValue(String invField, Object value) throws EASBizException, BOSException {
        Object obj = value;
        if (invField.toLowerCase(Locale.ENGLISH).endsWith("id") && value != null) {
            ICoreBase coreBase;
            BOSObjectType bosObjectType = BOSUuid.read((String)value.toString()).getType();
            if (this.iObjectMap.get(bosObjectType.toString()) == null) {
                coreBase = (ICoreBase)BOSObjectFactory.createBOSObject((Context)this.ctx, (BOSObjectType)bosObjectType);
                this.iObjectMap.put(bosObjectType.toString(), coreBase);
            }
            coreBase = (ICoreBase)this.iObjectMap.get(bosObjectType.toString());
            obj = coreBase.getValue((IObjectPK)new ObjectUuidPK(value.toString()));
        }
        return obj;
    }

    private void initDefaultKey() {
        String[] fields = new String[]{"FID", "FCompanyOrgUnitID", "FStorageOrgUnitID", "FWarehouseID", "FLocationID", "FSupplierID", "FCustomerID", "FMaterialID", "FLot", "FProjectID", "FTrackNumberID", "FUnitID", "FCurStoreQty", "FAssistUnitID", "FCurStoreAssistQty", "FBaseQty", "FAmount", "FBaseUnitID", "FExp", "FAssistPropertyID", "FLockQty", "FLockBaseQty", "FLockAssistQty"};
        this.defaultKey = new HashSet<String>(Arrays.asList(fields));
    }

    private StringBuilder getDefaultSelectSQL() {
        StringBuilder sql = new StringBuilder();
        sql.append("select INVENTORY.FStorageOrgUnitID as FStorageOrgUnitID, ");
        sql.append("INVENTORY.FMaterialID as FMaterialID, ");
        sql.append("case when INVENTORY.FAssistPropertyID = '").append("EgkAAAA5EWALxvQu").append("' then null else INVENTORY.FAssistPropertyID end as FAssistPropertyID, ");
        sql.append("case when INVENTORY.FWarehouseID = '").append("EgkAAABc3XG76fiu").append("' then null else INVENTORY.FWarehouseID end as FWarehouseID, ");
        sql.append("case when INVENTORY.FLocationID = '").append("EgkAAABc3XMgX/hq").append("' then null else INVENTORY.FLocationID end as FLocationID, ");
        sql.append("case when INVENTORY.FCustomerID = '").append("EgkAAABc3Xu/DAQO").append("' then null else INVENTORY.FCustomerID end as FCustomerID, ");
        sql.append("case when INVENTORY.FSupplierID = '").append("EgkAAABc3Xo3xn38").append("' then null else INVENTORY.FSupplierID end as FSupplierID, ");
        sql.append("case when INVENTORY.FLot = '").append("YNi0IQEOEADgBT3mfwAAAcznrtQ=").append("' then null else INVENTORY.FLot end as FLot, ");
        sql.append(" INVENTORY.FCurStoreQty ");
        sql.append(" - ");
        sql.append(" ISNULL(DECIMAL((RESERVATION.FReservationBaseQty / MULTIUNIT.FBaseConvsRate), 21, 8), 0) ");
        sql.append(" as FCurStoreQty ");
        sql.append(", INVENTORY.FBaseQty - ISNULL(RESERVATION.FReservationBaseQty, 0) as FBaseQty, ");
        sql.append("dom.FMfg as FMfg, ");
        sql.append("dom.FExp as FExp ");
        sql.append(", case when INVENTORY.FProjectID = '").append("EgkAAABc3Xza3gXu").append("' then null else INVENTORY.FProjectID end as FProjectID ");
        sql.append(", case when INVENTORY.FTrackNumberID = '").append("EgkAAABc3X0Ibpg9").append("' then null else INVENTORY.FTrackNumberID end as FTrackNumberID ");
        return sql;
    }

    private StringBuilder getDefaultFromSQL() {
        StringBuilder sql = new StringBuilder();
        sql.append(" from T_IM_Inventory INVENTORY left outer join T_IM_DateOfMinDurability dom ");
        sql.append(" on INVENTORY.FLot = dom.FLot and INVENTORY.FStorageOrgUnitID = dom.FStorageOrgUnitID and INVENTORY.FMaterialID = dom.FMaterialID \r\n");
        sql.append(" LEFT OUTER JOIN T_BD_material AS material ON material.FID = INVENTORY.FMaterialID \r\n");
        sql.append(" LEFT OUTER JOIN T_BD_MultiMeasureUnit AS MULTIUNIT ON INVENTORY.FMaterialID = MULTIUNIT.FMaterialID AND INVENTORY.FUnitID = MULTIUNIT.FMeasureUnitID \r\n");
        sql.append(" LEFT OUTER JOIN T_DB_WAREHOUSE AS WAREHOUSE ON INVENTORY.FWarehouseID = WAREHOUSE.FID \r\n");
        if (this.checkLocation) {
            sql.append(" LEFT OUTER JOIN T_DB_LOCATION AS LOCATION ON LOCATION.FID = INVENTORY.FLOCATIONID \r\n");
        }
        sql.append((CharSequence)this.getReservationSQL());
        return sql;
    }

    private StringBuilder getReservationSQL() {
        StringBuilder sql = new StringBuilder();
        sql.append(" LEFT OUTER JOIN (");
        sql.append(" SELECT FInventoryID, ");
        sql.append(" ISNULL(SUM(FReservationQty), 0) AS FReservationQty, ").append(" ISNULL(SUM(FReservationBaseQty), 0) AS FReservationBaseQty, ").append(" ISNULL(SUM(FReservationAssistQty), 0) AS FReservationAssistQty ");
        sql.append(" FROM T_IM_Reservation ");
        sql.append(" GROUP BY FInventoryID) AS RESERVATION ");
        sql.append(" ON RESERVATION.FInventoryID = INVENTORY.FID \r\n");
        return sql;
    }

    private StringBuilder getDefaultWhereSQL(List<String> keyList, Map<String, Object> dataMap, boolean isNegative) {
        StringBuilder sql = new StringBuilder();
        sql.append(" where INVENTORY.FLot is not null and INVENTORY.Flot <> '").append("YNi0IQEOEADgBT3mfwAAAcznrtQ=").append("' ");
        if (!isNegative) {
            sql.append(" and (INVENTORY.FBaseQty - ISNULL(RESERVATION.FReservationBaseQty, 0)) > 0 ");
            sql.append(" and FCurStoreQty > 0 ");
        }
        String invField = null;
        Object obj = null;
        for (int i = 0; i < keyList.size(); ++i) {
            invField = keyList.get(i);
            obj = dataMap.get(invField);
            if (obj == null) continue;
            if (obj instanceof IObjectValue) {
                obj = ((IObjectValue)obj).get("id").toString();
            } else if (obj instanceof Boolean) {
                obj = (Boolean)obj != false ? "1" : "0";
            } else {
                if (obj instanceof Date) {
                    obj = "to_date('" + DateTimeUtil.getFmtDate((Date)((Date)obj)) + "') ";
                    sql.append(" and INVENTORY.").append(invField).append(" = ").append(obj.toString()).append(" ");
                    continue;
                }
                obj = obj.toString();
            }
            sql.append(" and INVENTORY.").append(invField).append(" = '").append(obj.toString()).append("' ");
        }
        return sql;
    }

    private StringBuilder getDefaultOrderBySQL(IssuePriorityEnum issuePriority) {
        StringBuilder sql = new StringBuilder();
        if (issuePriority != null) {
            switch (issuePriority.getValue()) {
                case 1: {
                    sql.append(" order by dom.FLot asc");
                    break;
                }
                case 2: {
                    sql.append(" order by dom.FInWarehouseDate,INVENTORY.FLot asc ");
                    break;
                }
                case 3: {
                    sql.append(" order by dom.FInWarehouseDate desc,INVENTORY.FLot asc");
                    break;
                }
                case 4: {
                    sql.append(" order by dom.FExp,dom.FInWarehouseDate,INVENTORY.FLot asc");
                    break;
                }
                default: {
                    sql.append(" order by dom.FInWarehouseDate ,INVENTORY.FLot asc ");
                    break;
                }
            }
        } else {
            sql.append(" order by dom.FInWarehouseDate ,INVENTORY.FLot asc ");
        }
        return sql;
    }

    private void initPermissionSQL(String souId) throws BOSException {
        Map permMap;
        if (souId == null || souId.equals("")) {
            return;
        }
        HashSet<String> ids = new HashSet<String>();
        ids.add(souId);
        if (this.permissionMap.get(souId) == null) {
            permMap = SCMBillCommonFacadeFactory.getLocalInstance((Context)this.ctx).getPermissionEntityViewMap(ids, null);
            this.permissionMap.put(souId, permMap);
        }
        permMap = (Map)this.permissionMap.get(souId);
        this.permissionSQL = (String)permMap.get("PERM_WHERE");
        this.permissionJoinSQL = (String)permMap.get("PERM_JOIN");
        this.checkLocation = "true".equals(permMap.get("checkLocation"));
    }
}

