/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv.vmi.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.service.job.core.IJobHandler;
import com.kingdee.bos.service.job.core.Job;
import com.kingdee.bos.service.job.core.JobLog;
import com.kingdee.eas.basedata.common.perf.JobParam;
import com.kingdee.eas.basedata.common.perf.PerfSepCfgFactory;
import com.kingdee.eas.basedata.common.perf.PerfSepCfgInfo;
import com.kingdee.eas.basedata.common.perf.app.PerfSepServerUtils;
import com.kingdee.eas.basedata.common.perf.app.util.MessageInfo;
import com.kingdee.eas.basedata.common.perf.app.util.MessageUtil;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.scm.common.BillTypeInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.scm.common.security.util.SCMSqlUtil;
import com.kingdee.eas.scm.im.inv.IPurInWarehsBill;
import com.kingdee.eas.scm.im.inv.PurInWarehsBillFactory;
import com.kingdee.eas.scm.im.inv.vmi.VMISettleOptFacadeFactory;
import com.kingdee.eas.scm.im.inv.vmi.info.ReturnInfo;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class VMISettleJobHandler
implements IJobHandler {
    private static final long serialVersionUID = 1L;
    private static final String res = "com.kingdee.eas.basedata.common.perf.PerfResource";

    public Object execute(Job job) throws Exception {
        CompanyOrgUnitInfo company = null;
        Context ctx = null;
        MessageInfo info = null;
        ReturnInfo resultInfo = null;
        ctx = job.getContext();
        try {
            JobParam jobParam = (JobParam)job.getParameters();
            Map bizParam = (Map)jobParam.getBizParam();
            Locale locale = null;
            company = (CompanyOrgUnitInfo)bizParam.get("companyOrg");
            ctx.setLocale(jobParam.getLocale());
            String userId = ctx.getCaller().toString();
            info = new MessageInfo();
            info.setUserID(userId);
            info.setbizAction(job.getTitle());
            info.setOrgNumber(company.getName(locale) + "(" + company.getNumber() + ")");
            boolean isSendMsg = true;
            String jobNum = jobParam.getJobNumber();
            String oql = " where number = '" + jobNum + "'";
            PerfSepCfgInfo pfInfo = PerfSepCfgFactory.getLocalInstance((Context)ctx).getPerfSepCfgInfo(oql);
            if (pfInfo != null) {
                isSendMsg = pfInfo.isIsSendMsg();
            }
            info.setSendMsg(isSendMsg);
            List settleList = (List)bizParam.get("settleList");
            Map params = (Map)bizParam.get("params");
            BillTypeInfo billType = (BillTypeInfo)bizParam.get("billType");
            resultInfo = VMISettleOptFacadeFactory.getLocalInstance(ctx).settle(settleList, billType, params);
            JobLog log = new JobLog(JobLog.Type.Info, job.getTitle() + this.getResource("SUCCESS", jobParam.getLocale()));
            job.saveMessage(log);
            info.setSuccessed(true);
            MessageUtil.sendMsg((Context)ctx, (MessageInfo)info);
        }
        catch (Exception e) {
            info.setExecption(e.getMessage());
            info.setSuccessed(false);
            MessageUtil.sendMsg((Context)ctx, info);
            throw e;
        }
        finally {
            PerfSepServerUtils.updateTaskState((Job)job);
        }
        return resultInfo;
    }

    private String getResource(String resName, Locale locale) {
        return ResourceBase.getString((String)res, (String)resName, (Locale)locale);
    }

    private static boolean hasCFField(Context ctx) throws BOSException {
        String tempsql = "select 1 from ksql_usercolumns  where KSQL_COL_TABNAME = 'T_BD_SUPPLIER'";
        tempsql = tempsql + " and KSQL_COL_NAME = 'CFIsSrm'";
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)tempsql.toString());
            if (rs.next()) {
                return true;
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void syncVirtualPurInwareHs(Context ctx, ReturnInfo resultInfo) throws BOSException, SQLException, EASBizException {
        if (!VMISettleJobHandler.hasCFField(ctx)) {
            return;
        }
        List<IObjectPK> groupIdList = resultInfo.getPkList();
        if (groupIdList == null || groupIdList.size() == 0) {
            return;
        }
        String tmpTable = null;
        try {
            StringBuffer idStr = new StringBuffer();
            if (groupIdList.size() > 1000) {
                String[] idArr = new String[groupIdList.size()];
                for (int i = 0; i < groupIdList.size(); ++i) {
                    idArr[i] = groupIdList.get(i).toString();
                }
                tmpTable = SCMSqlUtil.convertIdArrToTempTab((Context)ctx, (String[])idArr);
            } else {
                for (int i = 0; i < groupIdList.size(); ++i) {
                    if (i > 0) {
                        idStr.append(",");
                    }
                    idStr.append("'").append(groupIdList.get(i).toString()).append("'");
                }
            }
            StringBuffer sql = new StringBuffer();
            sql.append("select vr.fbillid from T_IM_VMISettleRecord vr ");
            sql.append("left join T_BD_SUPPLIER s on s.fid = vr.FSUPPLIERID ");
            sql.append("where vr.fbillTypeId = '50957179-0105-1000-e000-015fc0a812fd463ED552' and vr.fparentid in ( ");
            if (idStr.length() > 0) {
                sql.append(idStr).append(")");
            } else {
                sql.append("select fid from ").append(tmpTable).append(") ");
            }
            sql.append("and s.CFIsSrm = 1 ");
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            int i = 0;
            ArrayList<ObjectUuidPK> pks = new ArrayList<ObjectUuidPK>();
            IPurInWarehsBill iPurIn = PurInWarehsBillFactory.getLocalInstance(ctx);
            while (rs.next()) {
                pks.add(new ObjectUuidPK(rs.getString("fbillid")));
                if (++i % 1000 != 0) continue;
                iPurIn.synPurInrehsBill4VMI(pks);
                pks = new ArrayList();
            }
            if (pks.size() > 0) {
                iPurIn.synPurInrehsBill4VMI(pks);
            }
            if (tmpTable == null) return;
        }
        catch (Throwable throwable) {
            if (tmpTable == null) throw throwable;
            SCMSqlUtil.releasTempTable((Context)ctx, tmpTable);
            throw throwable;
        }
        SCMSqlUtil.releasTempTable((Context)ctx, (String)tmpTable);
    }
}

