/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv.vmi.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.service.ServiceStateManager;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.btp.BTPManagerFactory;
import com.kingdee.eas.base.btp.IBTPManager;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.base.netctrl.IMutexServiceControl;
import com.kingdee.eas.base.netctrl.MutexServiceControlFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.master.cssp.SupplierInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.scm.common.BillTypeInfo;
import com.kingdee.eas.basedata.scm.common.TransactionTypeInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.BillBaseException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.CoreBillBaseCollection;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.framework.report.util.RptRowSet;
import com.kingdee.eas.scm.cal.util.DBUtil;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.common.PurchaseTypeEnum;
import com.kingdee.eas.scm.common.SCMBillException;
import com.kingdee.eas.scm.common.util.StringUtil;
import com.kingdee.eas.scm.im.inv.IInvBillBase;
import com.kingdee.eas.scm.im.inv.InvBillBaseCollection;
import com.kingdee.eas.scm.im.inv.InvBillBaseEntryInfo;
import com.kingdee.eas.scm.im.inv.InvBillBaseInfo;
import com.kingdee.eas.scm.im.inv.MaterialReqBillFactory;
import com.kingdee.eas.scm.im.inv.MaterialReqBillInfo;
import com.kingdee.eas.scm.im.inv.OtherIssueBillFactory;
import com.kingdee.eas.scm.im.inv.PurInWarehsBillFactory;
import com.kingdee.eas.scm.im.inv.SaleIssueBillCollection;
import com.kingdee.eas.scm.im.inv.SaleIssueBillFactory;
import com.kingdee.eas.scm.im.inv.SaleIssueBillInfo;
import com.kingdee.eas.scm.im.inv.SaleIssueEntryCollection;
import com.kingdee.eas.scm.im.inv.SaleIssueEntryFactory;
import com.kingdee.eas.scm.im.inv.SaleIssueEntryInfo;
import com.kingdee.eas.scm.im.inv.app.InvAppUtils;
import com.kingdee.eas.scm.im.inv.app.InvServerUtils;
import com.kingdee.eas.scm.im.inv.vmi.CreateTypeEnum;
import com.kingdee.eas.scm.im.inv.vmi.FieldDefInfo;
import com.kingdee.eas.scm.im.inv.vmi.FieldEntryDefInfo;
import com.kingdee.eas.scm.im.inv.vmi.RecordTypeEnum;
import com.kingdee.eas.scm.im.inv.vmi.VMISettleException;
import com.kingdee.eas.scm.im.inv.vmi.VMISettleGroupCollection;
import com.kingdee.eas.scm.im.inv.vmi.VMISettleGroupFactory;
import com.kingdee.eas.scm.im.inv.vmi.VMISettleGroupInfo;
import com.kingdee.eas.scm.im.inv.vmi.VMISettleRecordInfo;
import com.kingdee.eas.scm.im.inv.vmi.app.AbstractVMISettleOptFacadeControllerBean;
import com.kingdee.eas.scm.im.inv.vmi.app.calculate.SettleCalculateFactory;
import com.kingdee.eas.scm.im.inv.vmi.app.helper.VMISettleSQLBuilder;
import com.kingdee.eas.scm.im.inv.vmi.app.helper.VMISettleTableBuilder;
import com.kingdee.eas.scm.im.inv.vmi.app.service.FetchPriceVMIService;
import com.kingdee.eas.scm.im.inv.vmi.app.service.FetchPurOrg4VMIService;
import com.kingdee.eas.scm.im.inv.vmi.app.service.VirtualBillVMIService;
import com.kingdee.eas.scm.im.inv.vmi.info.ReturnInfo;
import com.kingdee.eas.scm.im.inv.vmi.util.ORMappingUtil;
import com.kingdee.eas.scm.im.inv.vmi.util.VMISettleUtil;
import com.kingdee.eas.scm.util.SCMSelectorFactory;
import com.kingdee.eas.scm.util.app.db.KsqlUtil;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.LowTimer;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.sql.RowSet;
import org.apache.log4j.Logger;

public class VMISettleOptFacadeControllerBean
extends AbstractVMISettleOptFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.scm.im.inv.vmi.app.VMISettleOptFacadeControllerBean");
    private VMISettleTableBuilder tableBuilder = null;
    private VMISettleSQLBuilder sqlBuilder = null;
    private FetchPurOrg4VMIService fetchPurOrgService = null;
    private VirtualBillVMIService helper = null;

    protected RptParams _createTempTable(Context ctx, RptParams params) throws BOSException, EASBizException {
        this._init(ctx, params);
        this.dropPoolTempTable(ctx, params.getString("detailTableName"));
        String detailTableName = DBUtil.createTempTable((Context)ctx, (String)this.sqlBuilder.getCreateTempTableSQL(false));
        String tempTableName = DBUtil.createTempTable((Context)ctx, (String)this.sqlBuilder.getCreateTempTableSQL(true));
        String purOrgTempTableName = DBUtil.createTempTable((Context)ctx, (String)this.fetchPurOrgService.getCreateTempTableSql());
        this.insertDetailData(ctx, detailTableName, params);
        this.insertTotalData(ctx, detailTableName, tempTableName, params);
        this.updateRelatedData(ctx, purOrgTempTableName, tempTableName, detailTableName, params);
        RptParams result = new RptParams();
        result.setObject("header", (Object)this.tableBuilder.createTableHeader(true));
        result.setString("tempTable", tempTableName);
        result.setString("detailTableName", detailTableName);
        String countSql = "select count(1) cc from " + tempTableName;
        RptRowSet rs = this.executeQuery(countSql, null, ctx);
        rs.next();
        int count = rs.getInt(0);
        result.setInt("totalCount", count);
        result.setObject("fieldDefInfo", params.getObject("fieldDefInfo"));
        return result;
    }

    public void updateRelatedData(Context ctx, String purOrgTempTableName, String tempTableName, String detailTableName, RptParams params) throws EASBizException, BOSException {
        this.updatePurOrgData(ctx, purOrgTempTableName, tempTableName);
    }

    public void fetchBatchPrice(Context ctx, String tempTableName, RptParams params) throws BOSException, EASBizException {
        FetchPriceVMIService fetchPriceVMIService = new FetchPriceVMIService();
        HashMap<String, Object> fetchPriceMap = new HashMap<String, Object>();
        fetchPriceMap.put("tempTableName", tempTableName);
        fetchPriceMap.put("sqlBuilder", this.sqlBuilder);
        fetchPriceMap.put("settleDate", params.getObject("settleDate"));
        fetchPriceVMIService.fetchBatchPrice(ctx, fetchPriceMap);
    }

    public void updateCurrencyData(Context ctx, String tempTable) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("update ").append(tempTable).append(" tmp set ");
        sql.append(" (").append("fixed_currency").append(",").append("fixed_currencyName").append(")= ");
        sql.append(" (select cur.fid, cur.fname_").append(ctx.getLocale().toString()).append("\n");
        sql.append(" from  t_Org_Company org \n");
        sql.append(" inner join T_BD_Currency cur on org.FBaseCurrencyId = cur.fid");
        sql.append(" where tmp.fcompanyOrgUnit_id = org.fid )");
        DbUtil.execute((Context)ctx, (String)sql.toString());
    }

    public void updatePurOrgData(Context ctx, String purOrgTempTableName, String tempTableName) throws EASBizException, BOSException {
        this.insertPurOrgData(ctx, purOrgTempTableName, tempTableName);
        this.fetchPurOrgService.updatePurOrgUseCategory(ctx, purOrgTempTableName);
        this.updateTotalPurOrgData(ctx, purOrgTempTableName, tempTableName);
    }

    private void insertTotalData(Context ctx, String detailTableName, String tempTableName, RptParams params) throws BOSException, EASBizException {
        String totalSql = this.sqlBuilder.getTotalInsertSql(detailTableName, tempTableName);
        DbUtil.execute((Context)ctx, (String)totalSql);
    }

    private void insertDetailData(Context ctx, String detailTableName, RptParams params) throws BOSException, EASBizException {
        String detailSql = this.sqlBuilder.getDetailInsertSql(detailTableName, params);
        if (this.getExtendFilter(params) != null) {
            detailSql = detailSql + this.getExtendFilter(params);
        }
        DbUtil.execute((Context)ctx, (String)detailSql);
    }

    private void insertPurOrgData(Context ctx, String purOrgTempTableName, String tempTableName) throws BOSException, EASBizException {
        StringBuffer purOrgSql = new StringBuffer();
        purOrgSql.append(" insert into ").append(purOrgTempTableName);
        purOrgSql.append(" (FID,FMaterialID,FSupplierID,FStorageOrgUnitID ) ");
        purOrgSql.append(" select newbosid('88888888'),fmaterial_id,fsupplier_id,fstorageOrgUnit_id");
        purOrgSql.append(" from ").append(tempTableName);
        purOrgSql.append(" group by fmaterial_id,fsupplier_id,fstorageOrgUnit_id");
        DbUtil.execute((Context)ctx, (String)purOrgSql.toString());
    }

    private void updateTotalPurOrgData(Context ctx, String purOrgTempTableName, String tempTableName) {
        StringBuffer updateSql = new StringBuffer();
        updateSql.append(" update ").append(tempTableName).append(" as tmp");
        updateSql.append(" set (").append("fixed_purchaseOrgUnit").append(",").append("fixed_purchaseOrgUnitName").append(")= ");
        updateSql.append(" (select org.fid,").append("org.fname_").append(ctx.getLocale().toString()).append(" from ").append(purOrgTempTableName).append(" as purTemp");
        updateSql.append("  inner join T_ORG_Purchase org on purTemp.FPurOrgUnitID = org.fid");
        updateSql.append("  where purTemp.FMaterialID = tmp.fmaterial_id ");
        updateSql.append("  and purTemp.FSupplierID = tmp.fsupplier_id ");
        updateSql.append("  and purTemp.FStorageOrgUnitID = tmp.fstorageOrgUnit_id");
        updateSql.append(" )");
        try {
            DbUtil.execute((Context)ctx, (String)updateSql.toString());
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
    }

    protected RptParams _init(Context ctx, RptParams params) throws BOSException, EASBizException {
        BillTypeInfo billType = (BillTypeInfo)params.getObject("billType");
        FieldDefInfo fieldDefInfo = (FieldDefInfo)params.getObject("fieldDefInfo");
        if (fieldDefInfo == null) {
            fieldDefInfo = VMISettleUtil.loadFieldDefInfo(ctx, billType.getBosType());
            params.setObject("fieldDefInfo", (Object)fieldDefInfo);
        }
        this.sqlBuilder = new VMISettleSQLBuilder(ctx, fieldDefInfo);
        this.tableBuilder = new VMISettleTableBuilder(ctx, this.sqlBuilder, params);
        this.fetchPurOrgService = new FetchPurOrg4VMIService();
        return params;
    }

    protected RptParams _query(Context ctx, RptParams params, int from, int len) throws BOSException, EASBizException {
        this._init(ctx, params);
        String tempTableName = params.getString("tempTable");
        StringBuffer sqlBuffer = new StringBuffer();
        sqlBuffer.append("SELECT '' as tmpField, '' AS SELECTED,").append(this.sqlBuilder.getQuerySelectSql(true));
        sqlBuffer.append("\n FROM ").append(tempTableName);
        BillTypeInfo billType = (BillTypeInfo)params.getObject("billType");
        if ("CC3E933B".equals(billType.getBosType())) {
            sqlBuffer.append(" order by FSUPPLIER_NUMBER,fmaterial_number,fnumber,fentry_seq ");
        } else {
            sqlBuffer.append(" order by fmaterial_number asc,FSUPPLIER_NUMBER,FIXED_ID ");
        }
        LowTimer t = new LowTimer();
        RptRowSet rs = this.executeQuery(sqlBuffer.toString(), null, from, len, ctx);
        logger.debug((Object)("VMI\u7ed3\u7b97\u6570\u636e\u67e5\u8be2\u5171\u8017\u65f6(ms):" + t.msValue()));
        RptParams pp = new RptParams();
        pp.setObject("rowset", (Object)rs);
        return pp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected ReturnInfo _settle(Context ctx, List settleList, BillTypeInfo billType, Map params) throws BOSException, EASBizException {
        ReturnInfo resultInfo = null;
        IObjectPK logPK = null;
        int total = 0;
        CompanyOrgUnitInfo companyOrgUnit = (CompanyOrgUnitInfo)params.get("companyOrgUnit");
        Set supplierIdSet = VMISettleUtil.getSelectIds(params.get("supplier"));
        RptParams param = (RptParams)params.get("param");
        IMutexServiceControl iMutexServiceControl = MutexServiceControlFactory.getLocalInstance((Context)ctx);
        ArrayList<String> requestLockList = new ArrayList<String>();
        ArrayList thisLockList = new ArrayList();
        ArrayList otherLockList = new ArrayList();
        try {
            boolean isClose;
            logPK = LogUtil.beginLog((Context)ctx, (String)this.getResource(ctx, "vmiSettle_settle"), (BOSObjectType)BOSObjectType.create((String)this.getFacadeBosType()), null, null, (String)"vmiSettle_settle", (String)companyOrgUnit.getId().toString());
            String id = companyOrgUnit.getId().toString() + billType.getId().toString();
            if (supplierIdSet != null && supplierIdSet.size() > 0) {
                Iterator suppliers = supplierIdSet.iterator();
                String idStr = null;
                while (suppliers.hasNext()) {
                    idStr = id + (String)suppliers.next();
                    requestLockList.add(idStr);
                }
            } else {
                requestLockList.add(id);
            }
            this.requestLocks(ctx, requestLockList, thisLockList, otherLockList);
            IObjectValue bean = (IObjectValue)settleList.get(0);
            if (bean != null && bean.getDate("settleDate") != null && companyOrgUnit != null && (isClose = this.isCloseAccount(ctx, bean.getDate("settleDate"), companyOrgUnit, null))) {
                throw new SCMBillException(SCMBillException.CURRENT_PERIOD_COLSED, (Object[])new String[]{companyOrgUnit.getName()});
            }
            total = settleList.size();
            FieldDefInfo fieldDefInfo = (FieldDefInfo)params.get("fieldDefInfo");
            String sql = this.getDetailSelectSql(ctx, fieldDefInfo, param);
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
            this.lockBill(ctx, settleList, (RowSet)rs, fieldDefInfo, billType);
            sql = this.getTotalSelectSql(ctx, fieldDefInfo, param);
            rs = DbUtil.executeQuery((Context)ctx, (String)sql);
            int errorCount = this.checkSettleBill(ctx, settleList, (RowSet)rs, fieldDefInfo, billType);
            int sucessCount = total - errorCount;
            resultInfo = SettleCalculateFactory.getSettleCalculate(ctx, billType).settle(settleList, params);
            resultInfo.setEorraCount(errorCount);
            resultInfo.setSuccessCount(sucessCount);
        }
        finally {
            if (thisLockList.size() > 0) {
                iMutexServiceControl.batchReleaseObjIDForUpdate(thisLockList);
            }
        }
        if (resultInfo.isSuccess()) {
            LogUtil.afterLog((Context)ctx, (IObjectPK)logPK);
        }
        return resultInfo;
    }

    protected int checkSettleBill(Context ctx, List settleList, RowSet rs, FieldDefInfo fieldDefInfo, BillTypeInfo billTypeInfo) throws BOSException {
        BigDecimal unVmiSettleBaseQty = null;
        IObjectValue objectValue = null;
        Object value = null;
        FieldEntryDefInfo entryInfo = null;
        Boolean flag = false;
        int errorCount = 0;
        for (int i = settleList.size() - 1; i >= 0; --i) {
            objectValue = (IObjectValue)settleList.get(i);
            try {
                while (rs.next()) {
                    flag = true;
                    for (int j = 0; j < fieldDefInfo.getEntry().size(); ++j) {
                        entryInfo = fieldDefInfo.getEntry().get(j);
                        if (!entryInfo.isIsMerge()) continue;
                        String FieldTransferName = entryInfo.getFieldTransferName();
                        Object fieldValue = rs.getObject(FieldTransferName);
                        value = ORMappingUtil.getPropertyValue(objectValue, entryInfo);
                        if (!(value == null && fieldValue != null || !(value instanceof BigDecimal) && value != null && !value.equals(fieldValue)) && (!(value instanceof BigDecimal) || !(fieldValue instanceof BigDecimal) || ((BigDecimal)value).compareTo((BigDecimal)fieldValue) == 0)) continue;
                        flag = false;
                        break;
                    }
                    if (!flag.booleanValue()) continue;
                    unVmiSettleBaseQty = rs.getBigDecimal("unVmiSettleBaseQty");
                    if (unVmiSettleBaseQty.abs().compareTo(((BigDecimal)objectValue.get("fixed_currentvmisettleqty")).abs()) < 0) {
                        settleList.remove(i);
                        ++errorCount;
                        break;
                    }
                    objectValue.put("fixed_unvmisettlebaseqty", (Object)unVmiSettleBaseQty);
                    break;
                }
                if (!flag.booleanValue()) {
                    settleList.remove(i);
                    ++errorCount;
                }
                rs.beforeFirst();
                continue;
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
        }
        return errorCount;
    }

    public String getDetailSelectSql(Context ctx, FieldDefInfo fieldDefInfo, RptParams params) {
        this.sqlBuilder = new VMISettleSQLBuilder(ctx, fieldDefInfo);
        StringBuffer sql = new StringBuffer();
        sql.append("select ").append(this.getSelectSql(fieldDefInfo, false));
        sql.append("\n");
        sql.append(fieldDefInfo.getQuery().getFromSQL());
        sql.append("\n");
        sql.append(this.sqlBuilder.getWhereSql(params));
        return sql.toString();
    }

    public String getGroupBySql(FieldDefInfo config) {
        StringBuffer groupBySql = new StringBuffer();
        FieldEntryDefInfo entryInfo = null;
        int size = config.getEntry().size();
        for (int i = 0; i < size; ++i) {
            entryInfo = config.getEntry().get(i);
            if (!entryInfo.isIsMerge()) continue;
            groupBySql.append(entryInfo.getFieldTableName()).append(",");
        }
        return groupBySql.substring(0, groupBySql.length() - 1);
    }

    public String getSelectSql(FieldDefInfo config, Boolean isTotal) {
        StringBuffer selectSql = new StringBuffer();
        FieldEntryDefInfo entryInfo = null;
        int size = config.getEntry().size();
        for (int i = 0; i < size; ++i) {
            entryInfo = config.getEntry().get(i);
            if (!entryInfo.isIsMerge() && isTotal.booleanValue()) continue;
            selectSql.append(entryInfo.getFieldTableName()).append(" as ").append(entryInfo.getFieldTransferName()).append(",");
        }
        if (isTotal.booleanValue()) {
            selectSql.append("sum(entry.funVmiSettleBaseQty) as unVmiSettleBaseQty ").append(",");
        } else {
            selectSql.append(" entry.funVmiSettleBaseQty as ").append("fixed_unVmiSettleBaseQty").append(" ,");
            selectSql.append(" entry.funVmiSettleBaseQty as ").append("fixed_currentVmiSettleQty").append(" ,");
        }
        return selectSql.substring(0, selectSql.length() - 1);
    }

    public String getTotalSelectSql(Context ctx, FieldDefInfo fieldDefInfo, RptParams params) {
        this.sqlBuilder = new VMISettleSQLBuilder(ctx, fieldDefInfo);
        StringBuffer sql = new StringBuffer();
        sql.append("select ").append(this.getSelectSql(fieldDefInfo, true));
        sql.append("\n");
        sql.append(fieldDefInfo.getQuery().getFromSQL());
        sql.append("\n");
        sql.append(this.sqlBuilder.getWhereSql(params));
        sql.append(" group by ").append(this.getGroupBySql(fieldDefInfo));
        return sql.toString();
    }

    public void insertTempTable(Context ctx, String tempTableName, String fieldName, Set<String> ids) throws BOSException {
        if (ids == null || ids.size() == 0) {
            return;
        }
        ArrayList<Object[]> list = new ArrayList<Object[]>();
        String id2 = null;
        Object[] idArr = null;
        for (String id2 : ids) {
            idArr = new Object[]{id2};
            list.add(idArr);
        }
        StringBuffer insertBaseSql = new StringBuffer();
        insertBaseSql.append("insert into ").append(tempTableName).append("(").append(fieldName).append(") ").append("values(?)");
        DbUtil.executeBatch((Context)ctx, (String)insertBaseSql.toString(), list);
    }

    protected void lockBill(Context ctx, List settleList, RowSet rs, FieldDefInfo fieldDefInfo, BillTypeInfo billTypeInfo) throws BOSException {
        String tempTable = null;
        try {
            StringBuffer UPDATE_sql = new StringBuffer();
            HashSet<String> idSet = new HashSet<String>();
            StringBuffer createSql = new StringBuffer();
            String insertSql = null;
            IObjectValue objectValue = null;
            Object value = null;
            FieldEntryDefInfo entryInfo = null;
            Boolean flag = true;
            for (int i = 0; i < settleList.size(); ++i) {
                objectValue = (IObjectValue)settleList.get(i);
                while (rs.next()) {
                    flag = true;
                    for (int j = 0; j < fieldDefInfo.getEntry().size(); ++j) {
                        entryInfo = fieldDefInfo.getEntry().get(j);
                        if (!entryInfo.isIsMerge()) continue;
                        String FieldTransferName = entryInfo.getFieldTransferName();
                        Object fieldValue = rs.getObject(FieldTransferName);
                        value = ORMappingUtil.getPropertyValue(objectValue, entryInfo);
                        if ((value != null || fieldValue == null) && (value == null || value.equals(fieldValue))) continue;
                        flag = false;
                        break;
                    }
                    if (!flag.booleanValue()) continue;
                    idSet.add(rs.getString("fid"));
                }
                rs.beforeFirst();
            }
            if (idSet.size() > 800) {
                createSql.append("create table temptable ( Fid varchar(44) ); ");
                tempTable = KsqlUtil.createTempTableWithNewTx((Context)ctx, (String)createSql.toString());
                this.insertTempTable(ctx, tempTable, "Fid", idSet);
                insertSql = "select Fid from " + tempTable;
            } else if (idSet.size() > 0) {
                insertSql = InvServerUtils.getSqlIdsStrForColl(idSet);
            }
            if (idSet.size() > 0) {
                if ("50957179-0105-1000-e000-0163c0a812fd463ED552".equals(billTypeInfo.getId().toString())) {
                    UPDATE_sql.append(" update T_IM_MaterialReqBill set FID=FID where FID in(");
                } else if ("50957179-0105-1000-e000-0177c0a812fd463ED552".equals(billTypeInfo.getId().toString())) {
                    UPDATE_sql.append(" update T_IM_OtherIssueBill set FID=FID where FID in(");
                } else {
                    UPDATE_sql.append(" update T_IM_SaleIssueBill set FID=FID where FID in(");
                }
                UPDATE_sql.append(insertSql).append(")");
                DbUtil.execute((Context)ctx, (String)UPDATE_sql.toString());
            }
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                KsqlUtil.releaseTempTable((Context)ctx, tempTable);
                throw throwable;
            }
        }
        KsqlUtil.releaseTempTable((Context)ctx, (String)tempTable);
    }

    @Override
    protected Map _unSettle(Context ctx, Set ids) throws BOSException, EASBizException {
        HashMap<String, Serializable> resultMap = new HashMap<String, Serializable>();
        if (ids == null || ids.size() == 0) {
            return resultMap;
        }
        String SEL_SETTLE_RECORD = " Select FBillEntryId, FBillTypeID, sum(FCurrentVmiSettleBaseQty) as curSettleBaseQty from T_IM_VMISettleRecord where FParentId in ({0}) and FRecordType in (0,3) group by FBillEntryId, FBillTypeID ";
        String SEL_SETTLE_VIRTUAL_RECORD = " Select FBillID,FBillTypeID,FCurrentVmiSettleBaseQty from T_IM_VMISettleRecord  where FParentId in ({0}) and FRecordType in (1,2) ";
        String SEL_SETTLE_ERROE = " Select sgroup.fid as FGroupId,sgroup.fnumber as FGroupNumber,record.FbillId as FBillId,record.FbillNumber as FbillNumber  from T_IM_VMISettleRecord record inner join T_IM_VMISettleGroup sgroup on record.fparentid = sgroup.fid  where record.FBillID in ({0}) and FRecordType in (1,2)";
        String UPDATE_SETTLE_QTY = " update {0} set FUnVmiSettleBaseQty=FUnVmiSettleBaseQty+?,FTotalVmiSettleBaseQty=FTotalVmiSettleBaseQty-?  where FID = ?";
        String[] DELETE_SETTLE_RECORD = new String[]{"Delete from T_IM_VMISettleGroup where FID in ({0})", "Delete from T_IM_VMISettleRecord where FParentId in ({0})"};
        String idFitler = VMISettleUtil.getSqlIds(ids);
        Connection conn = null;
        PreparedStatement matReqPM = null;
        PreparedStatement otherIssPM = null;
        String settleRecordSQL = null;
        String settleRecordVirtualSQL = null;
        String settleErrorSQL = null;
        IRowSet settleRecordSet = null;
        IRowSet settleRecordVirtualSet = null;
        IRowSet settleErrorSet = null;
        BigDecimal curSettleBaseQty = null;
        String billId = null;
        String groupId = null;
        String billEntryId = null;
        String billTypeId = null;
        String groupNumber = null;
        String billNumber = null;
        StringBuffer errorMsg = new StringBuffer();
        Map errorMap = null;
        List errorList = null;
        ArrayList errorIdLsit = null;
        HashSet<String> errorGroupIdSet = null;
        HashMap errorIdMap = null;
        int errorCount = 0;
        try {
            settleRecordVirtualSQL = MessageFormat.format(" Select FBillID,FBillTypeID,FCurrentVmiSettleBaseQty from T_IM_VMISettleRecord  where FParentId in ({0}) and FRecordType in (1,2) ", idFitler);
            settleRecordVirtualSet = DBUtil.executeQuery((Context)ctx, (String)settleRecordVirtualSQL);
            errorList = this.deleteVirtualBill(ctx, settleRecordVirtualSet);
            if (errorList != null && errorList.size() > 0) {
                errorCount = errorList.size();
                errorIdLsit = new ArrayList();
                errorIdMap = new HashMap();
                errorGroupIdSet = new HashSet<String>();
                for (int i = 0; i < errorList.size(); ++i) {
                    errorMap = (Map)errorList.get(i);
                    errorIdLsit.add(errorMap.get("billId"));
                    errorIdMap.put(errorMap.get("billId"), errorMap);
                }
                String billIdstr = VMISettleUtil.getSqlIds(errorIdLsit);
                settleErrorSQL = MessageFormat.format(" Select sgroup.fid as FGroupId,sgroup.fnumber as FGroupNumber,record.FbillId as FBillId,record.FbillNumber as FbillNumber  from T_IM_VMISettleRecord record inner join T_IM_VMISettleGroup sgroup on record.fparentid = sgroup.fid  where record.FBillID in ({0}) and FRecordType in (1,2)", billIdstr.toString());
                settleErrorSet = DBUtil.executeQuery((Context)ctx, (String)settleErrorSQL);
                while (settleErrorSet.next()) {
                    groupId = settleErrorSet.getString("FGroupId");
                    errorGroupIdSet.add(groupId);
                    billId = settleErrorSet.getString("FBillId");
                    billNumber = settleErrorSet.getString("FbillNumber");
                    groupNumber = settleErrorSet.getString("FGroupNumber");
                    errorMap = (Map)errorIdMap.get(billId);
                    if ("VOUCHER".equals(errorMap.get("error"))) {
                        errorMsg.append(this.getResource(ctx, "ErrorUnSettleIsVoucherServer", new Object[]{groupNumber, billNumber})).append("\n");
                    } else if (errorMap.get("errorMsg") != null) {
                        errorMsg.append(this.getResource(ctx, "ErrorSettleOtherMsg", new Object[]{groupNumber, billNumber}));
                        errorMsg.append(errorMap.get("errorMsg")).append("\n");
                    }
                    ids.remove(groupId);
                }
            }
            idFitler = VMISettleUtil.getSqlIds(ids);
            String matReqSQL = MessageFormat.format(" update {0} set FUnVmiSettleBaseQty=FUnVmiSettleBaseQty+?,FTotalVmiSettleBaseQty=FTotalVmiSettleBaseQty-?  where FID = ?", "T_IM_MaterialReqBillEntry");
            String otherIssSQL = MessageFormat.format(" update {0} set FUnVmiSettleBaseQty=FUnVmiSettleBaseQty+?,FTotalVmiSettleBaseQty=FTotalVmiSettleBaseQty-?  where FID = ?", "T_IM_OtherIssueBillEntry");
            settleRecordSQL = MessageFormat.format(" Select FBillEntryId, FBillTypeID, sum(FCurrentVmiSettleBaseQty) as curSettleBaseQty from T_IM_VMISettleRecord where FParentId in ({0}) and FRecordType in (0,3) group by FBillEntryId, FBillTypeID ", idFitler);
            settleRecordSet = DBUtil.executeQuery((Context)ctx, (String)settleRecordSQL);
            conn = EJBFactory.getConnection((Context)ctx);
            matReqPM = conn.prepareStatement(matReqSQL);
            otherIssPM = conn.prepareStatement(otherIssSQL);
            while (settleRecordSet.next()) {
                billEntryId = settleRecordSet.getString("FBillEntryId");
                billTypeId = settleRecordSet.getString("FBillTypeID");
                curSettleBaseQty = settleRecordSet.getBigDecimal("curSettleBaseQty");
                if ("50957179-0105-1000-e000-0163c0a812fd463ED552".equals(billTypeId)) {
                    matReqPM.setBigDecimal(1, curSettleBaseQty);
                    matReqPM.setBigDecimal(2, curSettleBaseQty);
                    matReqPM.setString(3, billEntryId);
                    matReqPM.addBatch();
                    continue;
                }
                if (!"50957179-0105-1000-e000-0177c0a812fd463ED552".equals(billTypeId)) continue;
                otherIssPM.setBigDecimal(1, curSettleBaseQty);
                otherIssPM.setBigDecimal(2, curSettleBaseQty);
                otherIssPM.setString(3, billEntryId);
                otherIssPM.addBatch();
            }
            matReqPM.executeBatch();
            otherIssPM.executeBatch();
            String[] delSQL = new String[]{MessageFormat.format(DELETE_SETTLE_RECORD[0], idFitler), MessageFormat.format(DELETE_SETTLE_RECORD[1], idFitler)};
            DBUtil.execute((Context)ctx, (String[])delSQL);
        }
        catch (SQLException ex) {
            try {
                throw new BOSException((Throwable)ex);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(settleRecordSet);
                SQLUtils.cleanup(settleRecordVirtualSet);
                DBUtil.close(conn, (PreparedStatement[])new PreparedStatement[]{matReqPM, otherIssPM}, (ResultSet[])new ResultSet[]{settleRecordSet, settleRecordVirtualSet, settleErrorSet});
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)settleRecordSet);
        SQLUtils.cleanup((ResultSet)settleRecordVirtualSet);
        DBUtil.close((Connection)conn, (PreparedStatement[])new PreparedStatement[]{matReqPM, otherIssPM}, (ResultSet[])new ResultSet[]{settleRecordSet, settleRecordVirtualSet, settleErrorSet});
        resultMap.put("ERROR_LIST", errorGroupIdSet);
        resultMap.put("ERROR_COUNT", Integer.valueOf(errorCount));
        resultMap.put("ERROR_MSG", errorMsg);
        return resultMap;
    }

    private List deleteVirtualBill(Context ctx, IRowSet settleRecordVirtualSet) throws BOSException, EASBizException {
        HashSet<String> purInwaresBlueList = new HashSet<String>();
        HashSet<String> purInwaresRedList = new HashSet<String>();
        HashSet<String> materialReqBlueList = new HashSet<String>();
        HashSet<String> materialReqRedList = new HashSet<String>();
        HashSet<String> otherIssueBlueList = new HashSet<String>();
        HashSet<String> otherIssueRedList = new HashSet<String>();
        HashSet<String> saleIssueBlueList = new HashSet<String>();
        HashSet<String> saleIssueRedList = new HashSet<String>();
        BigDecimal curSettleBaseQty = null;
        String billId = null;
        Object billEntryId = null;
        String billTypeId = null;
        boolean isRedBill = false;
        try {
            while (settleRecordVirtualSet.next()) {
                billId = settleRecordVirtualSet.getString("FBillID");
                billTypeId = settleRecordVirtualSet.getString("FBillTypeID");
                curSettleBaseQty = settleRecordVirtualSet.getBigDecimal("FCurrentVmiSettleBaseQty");
                if (curSettleBaseQty.signum() == -1) {
                    isRedBill = true;
                }
                if ("50957179-0105-1000-e000-0163c0a812fd463ED552".equals(billTypeId)) {
                    if (isRedBill) {
                        materialReqRedList.add(billId);
                        continue;
                    }
                    materialReqBlueList.add(billId);
                    continue;
                }
                if ("50957179-0105-1000-e000-0177c0a812fd463ED552".equals(billTypeId)) {
                    if (isRedBill) {
                        otherIssueRedList.add(billId);
                        continue;
                    }
                    otherIssueBlueList.add(billId);
                    continue;
                }
                if ("50957179-0105-1000-e000-015fc0a812fd463ED552".equals(billTypeId)) {
                    if (isRedBill) {
                        purInwaresRedList.add(billId);
                        continue;
                    }
                    purInwaresBlueList.add(billId);
                    continue;
                }
                if (!"50957179-0105-1000-e000-015bc0a812fd463ED552".equals(billTypeId)) continue;
                if (isRedBill) {
                    saleIssueRedList.add(billId);
                    continue;
                }
                saleIssueBlueList.add(billId);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        this.addSplitBillId(ctx, purInwaresRedList);
        this.addSplitBillId(ctx, purInwaresBlueList);
        this.addSplitBillId(ctx, saleIssueRedList);
        this.addSplitBillId(ctx, saleIssueBlueList);
        ArrayList errorList = new ArrayList();
        errorList.addAll(this.batchUnAuditAndDeleteBill(ctx, otherIssueBlueList, "50957179-0105-1000-e000-0177c0a812fd463ED552", true));
        errorList.addAll(this.batchUnAuditAndDeleteBill(ctx, materialReqBlueList, "50957179-0105-1000-e000-0163c0a812fd463ED552", true));
        errorList.addAll(this.batchUnAuditAndDeleteBill(ctx, purInwaresRedList, "50957179-0105-1000-e000-015fc0a812fd463ED552", true));
        errorList.addAll(this.batchUnAuditAndDeleteBill(ctx, saleIssueBlueList, "50957179-0105-1000-e000-015bc0a812fd463ED552", true));
        errorList.addAll(this.batchUnAuditAndDeleteBill(ctx, otherIssueRedList, "50957179-0105-1000-e000-0177c0a812fd463ED552", true));
        errorList.addAll(this.batchUnAuditAndDeleteBill(ctx, materialReqRedList, "50957179-0105-1000-e000-0163c0a812fd463ED552", true));
        errorList.addAll(this.batchUnAuditAndDeleteBill(ctx, purInwaresBlueList, "50957179-0105-1000-e000-015fc0a812fd463ED552", true));
        errorList.addAll(this.batchUnAuditAndDeleteBill(ctx, saleIssueRedList, "50957179-0105-1000-e000-015bc0a812fd463ED552", true));
        if (errorList.size() == 0) {
            this.batchUnAuditAndDeleteBill(ctx, otherIssueBlueList, "50957179-0105-1000-e000-0177c0a812fd463ED552", false);
            this.batchUnAuditAndDeleteBill(ctx, materialReqBlueList, "50957179-0105-1000-e000-0163c0a812fd463ED552", false);
            this.batchUnAuditAndDeleteBill(ctx, purInwaresRedList, "50957179-0105-1000-e000-015fc0a812fd463ED552", false);
            this.batchUnAuditAndDeleteBill(ctx, saleIssueBlueList, "50957179-0105-1000-e000-015bc0a812fd463ED552", false);
            this.batchUnAuditAndDeleteBill(ctx, otherIssueRedList, "50957179-0105-1000-e000-0177c0a812fd463ED552", false);
            this.batchUnAuditAndDeleteBill(ctx, materialReqRedList, "50957179-0105-1000-e000-0163c0a812fd463ED552", false);
            this.batchUnAuditAndDeleteBill(ctx, purInwaresBlueList, "50957179-0105-1000-e000-015fc0a812fd463ED552", false);
            this.batchUnAuditAndDeleteBill(ctx, saleIssueRedList, "50957179-0105-1000-e000-015bc0a812fd463ED552", false);
        }
        return errorList;
    }

    private void addSplitBillId(Context ctx, Set<String> idSet) throws BOSException {
        if (!idSet.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            sb.append(" SELECT DISTINCT FCHILDID FROM T_IV_RELATIONOFCHILDANDPARENT WHERE FROOTID IN (");
            sb.append(StringUtil.getKeyIdList((Object[])idSet.toArray())).append(")");
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
            try {
                while (rs.next()) {
                    idSet.add(rs.getString("FCHILDID"));
                }
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
        }
    }

    protected List batchUnAuditAndDeleteBill(Context ctx, Set idSet, String billType, boolean isCheck) throws BOSException, EASBizException {
        ArrayList errorList = new ArrayList();
        if (idSet == null || idSet.size() == 0) {
            return errorList;
        }
        IObjectPK objectPK = null;
        CoreBillBaseCollection coll = null;
        EntityViewInfo entityView = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        entityView.setFilter(filterInfo);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("id");
        selector.add("baseStatus");
        selector.add("year");
        selector.add("period");
        selector.add("isSysBill");
        selector.add("isInitBill");
        selector.add("billType.id");
        selector.add("transactionType.id");
        selector.add("transactionType.isCalculate");
        selector.add("entry.material.id");
        selector.add("entry.sourceBillId");
        selector.add("entry.companyOrgUnit.id");
        entityView.setSelector(selector);
        IInvBillBase iInvBillBase = null;
        HashMap<String, String> errorMap = new HashMap<String, String>();
        String tableName = null;
        if ("50957179-0105-1000-e000-0163c0a812fd463ED552".equals(billType)) {
            iInvBillBase = MaterialReqBillFactory.getLocalInstance(ctx);
            tableName = "T_IM_MaterialReqBill";
        } else if ("50957179-0105-1000-e000-0177c0a812fd463ED552".equals(billType)) {
            iInvBillBase = OtherIssueBillFactory.getLocalInstance(ctx);
            tableName = "T_IM_OtherIssueBill";
        } else if ("50957179-0105-1000-e000-015fc0a812fd463ED552".equals(billType)) {
            iInvBillBase = PurInWarehsBillFactory.getLocalInstance(ctx);
            tableName = "T_IM_PurInWarehsBill";
        } else if ("50957179-0105-1000-e000-015bc0a812fd463ED552".equals(billType)) {
            iInvBillBase = SaleIssueBillFactory.getLocalInstance(ctx);
            tableName = "T_IM_SaleIssueBill";
        }
        if (null == iInvBillBase) {
            throw new IllegalArgumentException("billType not supported!");
        }
        if (!isCheck) {
            Iterator ids = idSet.iterator();
            StringBuffer idsStr = new StringBuffer();
            String id = null;
            while (ids.hasNext()) {
                id = (String)ids.next();
                idsStr.append("'" + id + "',");
            }
            idsStr.deleteCharAt(idsStr.length() - 1);
            String updateSql = "update " + tableName + " set FBaseStatus = " + 1 + " where fid in (" + idsStr + ")";
            DbUtil.execute((Context)ctx, (String)updateSql);
        }
        ArrayList<ObjectUuidPK> pkList = new ArrayList<ObjectUuidPK>();
        VirtualBillVMIService helper = new VirtualBillVMIService(ctx);
        coll = iInvBillBase.getCoreBillBaseCollection(entityView);
        for (int i = 0; i < coll.size(); ++i) {
            InvBillBaseInfo info = (InvBillBaseInfo)coll.getObject(i);
            info.setBaseStatus(BillBaseStatusEnum.TEMPORARILYSAVED);
            if (isCheck) {
                if (info.isFiVouchered()) {
                    errorMap = new HashMap();
                    errorMap.put("billId", info.getId().toString());
                    errorMap.put("error", "VOUCHER");
                    errorMap.put("errorMsg", null);
                    errorList.add(errorMap);
                    continue;
                }
                IBTPManager iBTPManager = BTPManagerFactory.getLocalInstance((Context)ctx);
                if (!iBTPManager.ifHaveDestBills(info.getId().toString())) continue;
                errorMap = new HashMap();
                errorMap.put("billId", info.getId().toString());
                errorMap.put("error", null);
                errorMap.put("errorMsg", new BillBaseException(BillBaseException.HASFLOWERBILL).getMessage());
                errorList.add(errorMap);
                continue;
            }
            try {
                info.put("IS_VMI_BIZ", true);
                helper.afterUnPassAudit(objectPK, info);
                info.remove("IS_VMI_BIZ");
            }
            catch (EASBizException e) {
                errorMap = new HashMap();
                errorMap.put("billId", info.getId().toString());
                errorMap.put("error", null);
                String errorMessage = "";
                errorMessage = e.getCause() != null ? e.getCause().getMessage() : e.getMessage();
                errorMap.put("errorMsg", errorMessage);
                errorList.add(errorMap);
                continue;
            }
            pkList.add(new ObjectUuidPK(info.getId()));
        }
        if (pkList.size() > 0) {
            IObjectPK[] paramType = new IObjectPK[]{};
            IObjectPK[] pks = pkList.toArray(paramType);
            ServiceStateManager.getInstance().enableNextCallServices();
            iInvBillBase.deleteBatchData(pks);
        }
        return errorList;
    }

    private IInvBillBase getInterface(Context ctx, String billTypeId) throws BOSException {
        IInvBillBase iInvBillBase = null;
        if ("50957179-0105-1000-e000-0163c0a812fd463ED552".equals(billTypeId)) {
            iInvBillBase = MaterialReqBillFactory.getLocalInstance(ctx);
        } else if ("50957179-0105-1000-e000-0177c0a812fd463ED552".equals(billTypeId)) {
            iInvBillBase = OtherIssueBillFactory.getLocalInstance(ctx);
        } else if ("50957179-0105-1000-e000-015fc0a812fd463ED552".equals(billTypeId)) {
            iInvBillBase = PurInWarehsBillFactory.getLocalInstance(ctx);
        }
        return iInvBillBase;
    }

    @Override
    protected Map _reWriteDetailQty(Context ctx, String bosType, String detailTableName, IObjectValue objectValue, BigDecimal qty) throws BOSException, EASBizException {
        IObjectCollection coll = this.getDetailListByTotalRecord(ctx, detailTableName, bosType, objectValue);
        InvBillBaseInfo info = null;
        InvBillBaseEntryInfo entryInfo = null;
        ArrayList<InvBillBaseEntryInfo> entryList = new ArrayList<InvBillBaseEntryInfo>();
        ArrayList<InvBillBaseEntryInfo> redEntryList = new ArrayList<InvBillBaseEntryInfo>();
        ArrayList<InvBillBaseEntryInfo> blueEntryList = new ArrayList<InvBillBaseEntryInfo>();
        HashMap<String, String> resultMap = new HashMap<String, String>();
        BigDecimal redVmiSettleBaseQty = BigDecimal.ZERO;
        BigDecimal blueVmiSettleBaseQty = BigDecimal.ZERO;
        int size = coll.size();
        for (int i = 0; i < size; ++i) {
            info = (InvBillBaseInfo)coll.getObject(i);
            entryInfo = (InvBillBaseEntryInfo)info.getEntries().getObject(0);
            entryInfo.put("fixed_currentVmiSettleQty", BigDecimal.ZERO);
            entryInfo.put("fixed_unVmiSettleBaseQty", entryInfo.getUnVmiSettleBaseQty());
            if (entryInfo.getUnVmiSettleBaseQty().signum() == -1) {
                redEntryList.add(entryInfo);
                redVmiSettleBaseQty = redVmiSettleBaseQty.add(entryInfo.getUnVmiSettleBaseQty());
            } else {
                blueEntryList.add(entryInfo);
                blueVmiSettleBaseQty = blueVmiSettleBaseQty.add(entryInfo.getUnVmiSettleBaseQty());
            }
            entryList.add(entryInfo);
        }
        if ((redEntryList.size() == 0 || blueEntryList.size() == 0) && BigDecimal.ZERO.compareTo(qty) == 0) {
            resultMap.put("ERROR_MSG", "qtySameDirectionError");
            return resultMap;
        }
        if (redVmiSettleBaseQty.add(blueVmiSettleBaseQty).compareTo(BigDecimal.ZERO) == 0) {
            for (InvBillBaseEntryInfo entry : redEntryList) {
                entry.put("fixed_currentVmiSettleQty", entry.get("fixed_unVmiSettleBaseQty"));
                entry.put("fixed_unVmiSettleBaseQty", BigDecimal.ZERO);
            }
            for (InvBillBaseEntryInfo entry : blueEntryList) {
                entry.put("fixed_currentVmiSettleQty", entry.get("fixed_unVmiSettleBaseQty"));
                entry.put("fixed_unVmiSettleBaseQty", BigDecimal.ZERO);
            }
        } else if (redVmiSettleBaseQty.add(blueVmiSettleBaseQty).compareTo(BigDecimal.ZERO) > 0) {
            for (InvBillBaseEntryInfo entry : redEntryList) {
                entry.put("fixed_currentVmiSettleQty", entry.get("fixed_unVmiSettleBaseQty"));
                entry.put("fixed_unVmiSettleBaseQty", BigDecimal.ZERO);
            }
            BigDecimal totalVmiSettleBaseQty = BigDecimal.ZERO;
            BigDecimal curVmiSettleBaseQty = BigDecimal.ZERO;
            BigDecimal unVmiSettleBaseQty = BigDecimal.ZERO;
            for (InvBillBaseEntryInfo entry : blueEntryList) {
                unVmiSettleBaseQty = (BigDecimal)entry.get("fixed_unVmiSettleBaseQty");
                if ((totalVmiSettleBaseQty = totalVmiSettleBaseQty.add(unVmiSettleBaseQty)).add(redVmiSettleBaseQty).compareTo(BigDecimal.ZERO) > 0) {
                    curVmiSettleBaseQty = unVmiSettleBaseQty.subtract(totalVmiSettleBaseQty.add(redVmiSettleBaseQty));
                    entry.put("fixed_currentVmiSettleQty", ((BigDecimal)entry.get("fixed_currentVmiSettleQty")).add(curVmiSettleBaseQty));
                    entry.put("fixed_unVmiSettleBaseQty", unVmiSettleBaseQty.subtract(curVmiSettleBaseQty));
                    break;
                }
                entry.put("fixed_currentVmiSettleQty", ((BigDecimal)entry.get("fixed_currentVmiSettleQty")).add(unVmiSettleBaseQty));
                entry.put("fixed_unVmiSettleBaseQty", BigDecimal.ZERO);
            }
            if (qty.compareTo(BigDecimal.ZERO) != 0) {
                totalVmiSettleBaseQty = BigDecimal.ZERO;
                for (InvBillBaseEntryInfo entry : blueEntryList) {
                    unVmiSettleBaseQty = (BigDecimal)entry.get("fixed_unVmiSettleBaseQty");
                    if (unVmiSettleBaseQty.compareTo(BigDecimal.ZERO) == 0) continue;
                    if ((totalVmiSettleBaseQty = totalVmiSettleBaseQty.add(unVmiSettleBaseQty)).compareTo(qty) > 0) {
                        curVmiSettleBaseQty = unVmiSettleBaseQty.subtract(totalVmiSettleBaseQty.subtract(qty));
                        entry.put("fixed_currentVmiSettleQty", ((BigDecimal)entry.get("fixed_currentVmiSettleQty")).add(curVmiSettleBaseQty));
                        entry.put("fixed_unVmiSettleBaseQty", unVmiSettleBaseQty.subtract(curVmiSettleBaseQty));
                        break;
                    }
                    entry.put("fixed_currentVmiSettleQty", ((BigDecimal)entry.get("fixed_currentVmiSettleQty")).add(unVmiSettleBaseQty));
                    entry.put("fixed_unVmiSettleBaseQty", BigDecimal.ZERO);
                }
            }
        } else if (redVmiSettleBaseQty.add(blueVmiSettleBaseQty).compareTo(BigDecimal.ZERO) < 0) {
            for (InvBillBaseEntryInfo entry : blueEntryList) {
                entry.put("fixed_currentVmiSettleQty", entry.getUnVmiSettleBaseQty());
                entry.put("fixed_unVmiSettleBaseQty", BigDecimal.ZERO);
            }
            Object totalVmiSettleBaseQty = BigDecimal.ZERO;
            BigDecimal curVmiSettleBaseQty = BigDecimal.ZERO;
            BigDecimal unVmiSettleBaseQty = BigDecimal.ZERO;
            for (InvBillBaseEntryInfo entry : redEntryList) {
                unVmiSettleBaseQty = (BigDecimal)entry.get("fixed_unVmiSettleBaseQty");
                if (((BigDecimal)(totalVmiSettleBaseQty = ((BigDecimal)totalVmiSettleBaseQty).add(unVmiSettleBaseQty))).add(blueVmiSettleBaseQty).compareTo(BigDecimal.ZERO) < 0) {
                    curVmiSettleBaseQty = unVmiSettleBaseQty.subtract(((BigDecimal)totalVmiSettleBaseQty).add(blueVmiSettleBaseQty));
                    entry.put("fixed_currentVmiSettleQty", ((BigDecimal)entry.get("fixed_currentVmiSettleQty")).add(curVmiSettleBaseQty));
                    entry.put("fixed_unVmiSettleBaseQty", unVmiSettleBaseQty.subtract(curVmiSettleBaseQty));
                    break;
                }
                entry.put("fixed_currentVmiSettleQty", ((BigDecimal)entry.get("fixed_currentVmiSettleQty")).add(unVmiSettleBaseQty));
                entry.put("fixed_unVmiSettleBaseQty", BigDecimal.ZERO);
            }
            if (qty.compareTo(BigDecimal.ZERO) != 0) {
                totalVmiSettleBaseQty = BigDecimal.ZERO;
                for (InvBillBaseEntryInfo entry : redEntryList) {
                    unVmiSettleBaseQty = (BigDecimal)entry.get("fixed_unVmiSettleBaseQty");
                    if (unVmiSettleBaseQty.compareTo(BigDecimal.ZERO) == 0) continue;
                    if (((BigDecimal)(totalVmiSettleBaseQty = ((BigDecimal)totalVmiSettleBaseQty).add(unVmiSettleBaseQty))).compareTo(qty) < 0) {
                        curVmiSettleBaseQty = unVmiSettleBaseQty.subtract(((BigDecimal)totalVmiSettleBaseQty).subtract(qty));
                        entry.put("fixed_currentVmiSettleQty", ((BigDecimal)entry.get("fixed_currentVmiSettleQty")).add(curVmiSettleBaseQty));
                        entry.put("fixed_unVmiSettleBaseQty", unVmiSettleBaseQty.subtract(curVmiSettleBaseQty));
                        break;
                    }
                    entry.put("fixed_currentVmiSettleQty", ((BigDecimal)entry.get("fixed_currentVmiSettleQty")).add(unVmiSettleBaseQty));
                    entry.put("fixed_unVmiSettleBaseQty", BigDecimal.ZERO);
                }
            }
        }
        this.updateDetailBill(ctx, detailTableName, entryList);
        return resultMap;
    }

    private void updateDetailBill(Context ctx, String detailTableName, List entryList) throws BOSException, EASBizException {
        String UPDATE_SETTLE_QTY = " update {0} set fixed_currentVmiSettleQty=? ,fixed_unVmiSettleBaseQty=? where fentry_id = ?";
        Connection conn = null;
        PreparedStatement detailPM = null;
        String detailSQL = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            detailSQL = MessageFormat.format(" update {0} set fixed_currentVmiSettleQty=? ,fixed_unVmiSettleBaseQty=? where fentry_id = ?", detailTableName);
            detailPM = conn.prepareStatement(detailSQL);
            InvBillBaseEntryInfo entryInfo = null;
            int size = entryList.size();
            for (int i = 0; i < size; ++i) {
                entryInfo = (InvBillBaseEntryInfo)entryList.get(i);
                detailPM.setBigDecimal(1, (BigDecimal)entryInfo.get("fixed_currentVmiSettleQty"));
                detailPM.setBigDecimal(2, (BigDecimal)entryInfo.get("fixed_unVmiSettleBaseQty"));
                detailPM.setString(3, entryInfo.getId().toString());
                detailPM.addBatch();
            }
            detailPM.executeBatch();
        }
        catch (SQLException ex) {
            try {
                throw new BOSException((Throwable)ex);
            }
            catch (Throwable throwable) {
                DBUtil.close((Connection)conn, (PreparedStatement[])new PreparedStatement[]{detailPM}, (ResultSet[])new ResultSet[0]);
                throw throwable;
            }
        }
        DBUtil.close((Connection)conn, (PreparedStatement[])new PreparedStatement[]{detailPM}, (ResultSet[])new ResultSet[0]);
    }

    private IObjectCollection getDetailListByTotalRecord(Context ctx, String detailTableName, String bosType, IObjectValue objectValue) throws BOSException, EASBizException {
        FieldDefInfo fieldDefInfo = VMISettleUtil.loadFieldDefInfo(ctx, bosType);
        this.sqlBuilder = new VMISettleSQLBuilder(ctx, fieldDefInfo);
        IRowSet rs = null;
        IObjectCollection resultColl = null;
        StringBuffer sb = new StringBuffer();
        sb.append(" select ").append(this.sqlBuilder.getTableSelectSql(false)).append(" from ").append(detailTableName);
        sb.append("\r\n");
        sb.append(" where 1=1 ");
        ArrayList<Object> params = new ArrayList<Object>();
        Object value = null;
        for (int i = 0; i < fieldDefInfo.getEntry().size(); ++i) {
            if (!fieldDefInfo.getEntry().get(i).isIsMerge()) continue;
            value = ORMappingUtil.getPropertyValue(objectValue, fieldDefInfo.getEntry().get(i));
            if (value != null) {
                sb.append(" and ").append(fieldDefInfo.getEntry().get(i).getFieldTransferName()).append(" = ? ");
                params.add(value);
                continue;
            }
            sb.append(" and ").append(fieldDefInfo.getEntry().get(i).getFieldTransferName()).append(" is NULL");
        }
        sb.append(" and fentry_unVmiSettleBaseQty <> 0");
        try {
            rs = DbUtil.executeQuery((Context)ctx, (String)sb.toString(), (Object[])params.toArray());
            resultColl = ORMappingUtil.rowSetToCollection(rs, this.sqlBuilder, false);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return resultColl;
    }

    @Override
    protected void _redBlueSettle(Context ctx, IObjectValue model, String billTypeId) throws BOSException, EASBizException {
        if (!(model instanceof MaterialReqBillInfo) && !(model instanceof SaleIssueBillInfo)) {
            return;
        }
        InvBillBaseInfo info = (InvBillBaseInfo)model;
        if (!this.checkRedBlueSettle(ctx, info, billTypeId)) {
            return;
        }
        InvBillBaseEntryInfo entryInfo = null;
        ArrayList<InvBillBaseEntryInfo> entryList = new ArrayList<InvBillBaseEntryInfo>();
        String sourceBillId = null;
        String saleOrderId = null;
        HashSet<String> sourceBillIdSet = new HashSet<String>();
        HashSet<String> coreBillIdSet = new HashSet<String>();
        boolean isVmiEntry = false;
        int size = info.getEntries().size();
        for (int i = 0; i < size; ++i) {
            entryInfo = (InvBillBaseEntryInfo)info.getEntries().getObject(i);
            sourceBillId = entryInfo.getSourceBillId();
            boolean bl = isVmiEntry = entryInfo.getInvUpdateType() != null && entryInfo.getInvUpdateType().getStoreTypePre() != null && "181875d5-0105-1000-e000-0114c0a812fd97D461A6".equals(entryInfo.getInvUpdateType().getStoreTypePre().getId().toString());
            if (isVmiEntry && !StringUtils.isEmpty((String)sourceBillId) && billTypeId.equals(info.getSourceBillType().getId().toString())) {
                entryList.add(entryInfo);
                sourceBillIdSet.add(sourceBillId);
                continue;
            }
            if (!"50957179-0105-1000-e000-015bc0a812fd463ED552".equals(billTypeId)) continue;
            saleOrderId = ((SaleIssueEntryInfo)entryInfo).getSaleOrder();
            if (!isVmiEntry || StringUtils.isEmpty((String)saleOrderId)) continue;
            entryList.add(entryInfo);
            coreBillIdSet.add(saleOrderId);
        }
        if (!entryList.isEmpty()) {
            HashMap<String, List<InvBillBaseEntryInfo>> blueBillEntryMap = new HashMap<String, List<InvBillBaseEntryInfo>>();
            HashMap<String, InvBillBaseInfo> blueBillMap = new HashMap<String, InvBillBaseInfo>();
            if (!sourceBillIdSet.isEmpty()) {
                this.buildRedBlueSourceBillMap(ctx, billTypeId, entryList, sourceBillIdSet, blueBillEntryMap, blueBillMap);
            }
            if (!coreBillIdSet.isEmpty()) {
                this.buildRedBlueCoreBillMap(ctx, entryList, coreBillIdSet, sourceBillIdSet, blueBillEntryMap, blueBillMap);
            }
            this.doRedBlueVmiSettle(ctx, info, entryList, blueBillEntryMap, blueBillMap);
        }
    }

    private void doRedBlueVmiSettle(Context ctx, InvBillBaseInfo redBill, List<InvBillBaseEntryInfo> entryList, Map<String, List<InvBillBaseEntryInfo>> blueBillEntryMap, Map<String, InvBillBaseInfo> blueBillMap) throws EASBizException, BOSException {
        if (blueBillEntryMap == null || blueBillEntryMap.size() == 0) {
            return;
        }
        BigDecimal currentSettleBaseQty = BigDecimal.ZERO;
        BigDecimal redBilltotalSettleBaseQty = BigDecimal.ZERO;
        int seq = 0;
        int groupNum = 0;
        VMISettleGroupInfo createVmiSettleGroupInfo = this.createVmiSettleGroupInfo(ctx, redBill);
        String updateSQL = this.getUpdateBillSql(redBill);
        ArrayList<Object[]> sqlParam = new ArrayList<Object[]>();
        int size = entryList.size();
        for (int i = 0; i < size; ++i) {
            InvBillBaseEntryInfo redBillentryInfo = entryList.get(i);
            redBilltotalSettleBaseQty = BigDecimal.ZERO;
            if (redBillentryInfo.getUnVmiSettleBaseQty().compareTo(BigDecimal.ZERO) == 0) continue;
            List<InvBillBaseEntryInfo> buleBillEntryList = blueBillEntryMap.get(redBillentryInfo.getId().toString());
            Iterator<InvBillBaseEntryInfo> iterator = buleBillEntryList.iterator();
            while (iterator.hasNext() && redBillentryInfo.getUnVmiSettleBaseQty().compareTo(BigDecimal.ZERO) != 0) {
                InvBillBaseEntryInfo blueBillentryInfo = iterator.next();
                if (blueBillentryInfo == null || blueBillentryInfo.getUnVmiSettleBaseQty().compareTo(BigDecimal.ZERO) == 0) continue;
                currentSettleBaseQty = redBillentryInfo.getUnVmiSettleBaseQty().abs().compareTo(blueBillentryInfo.getUnVmiSettleBaseQty().abs()) >= 0 ? blueBillentryInfo.getUnVmiSettleBaseQty().abs() : redBillentryInfo.getUnVmiSettleBaseQty().abs();
                InvBillBaseInfo blueBill = blueBillMap.get(((InvBillBaseInfo)blueBillentryInfo.get("parent")).getId().toString());
                this.createSettleRecordInfo(ctx, createVmiSettleGroupInfo, redBill, redBillentryInfo, currentSettleBaseQty.abs().negate(), ++seq, groupNum);
                this.createSettleRecordInfo(ctx, createVmiSettleGroupInfo, blueBill, blueBillentryInfo, currentSettleBaseQty.abs(), seq, groupNum);
                sqlParam.add(new Object[]{currentSettleBaseQty.abs(), currentSettleBaseQty.abs(), blueBillentryInfo.getId().toString()});
                redBilltotalSettleBaseQty = redBilltotalSettleBaseQty.add(currentSettleBaseQty);
                redBillentryInfo.setUnVmiSettleBaseQty(redBillentryInfo.getUnVmiSettleBaseQty().subtract(currentSettleBaseQty.abs().negate()));
                redBillentryInfo.setTotalVmiSettleBaseQty(redBillentryInfo.getTotalVmiSettleBaseQty().add(currentSettleBaseQty.abs().negate()));
                blueBillentryInfo.setUnVmiSettleBaseQty(blueBillentryInfo.getUnVmiSettleBaseQty().subtract(currentSettleBaseQty.abs()));
                blueBillentryInfo.setTotalVmiSettleBaseQty(blueBillentryInfo.getTotalVmiSettleBaseQty().add(currentSettleBaseQty.abs()));
                ++groupNum;
            }
            sqlParam.add(new Object[]{redBilltotalSettleBaseQty.negate(), redBilltotalSettleBaseQty.negate(), redBillentryInfo.getId().toString()});
        }
        DbUtil.executeBatch((Context)ctx, (String)updateSQL, sqlParam);
        VMISettleGroupFactory.getLocalInstance(ctx).save((CoreBaseInfo)createVmiSettleGroupInfo);
    }

    private String getUpdateBillSql(InvBillBaseInfo redBill) {
        String detailTableName = "";
        if (redBill instanceof MaterialReqBillInfo) {
            detailTableName = "T_IM_MaterialReqBillEntry";
        } else if (redBill instanceof SaleIssueBillInfo) {
            detailTableName = "T_IM_SALEISSUEENTRY";
        }
        String UPDATE_MAT_REQ_QTY = " update {0} set FUnVmiSettleBaseQty=FUnVmiSettleBaseQty-?,FTotalVmiSettleBaseQty=FTotalVmiSettleBaseQty+?  where FID = ?";
        String updateSQL = MessageFormat.format(UPDATE_MAT_REQ_QTY, detailTableName);
        return updateSQL;
    }

    private VMISettleGroupInfo createVmiSettleGroupInfo(Context ctx, InvBillBaseInfo info) throws EASBizException, BOSException {
        SimpleDateFormat format = new SimpleDateFormat("yyyyMMddHHmmssSSS");
        Date date = new Date();
        VMISettleGroupInfo groupInfo = new VMISettleGroupInfo();
        groupInfo.setId(BOSUuid.create((BOSObjectType)groupInfo.getBOSType()));
        groupInfo.setNumber(format.format(date));
        if (info instanceof MaterialReqBillInfo) {
            groupInfo.setCompanyOrgUnit(((MaterialReqBillInfo)info).getSupplyCompanyOrgUnit());
        } else {
            groupInfo.setCompanyOrgUnit((CompanyOrgUnitInfo)info.getEntries().getObject(0).get("companyOrgUnit"));
        }
        groupInfo.setCreateTime(new Timestamp(System.currentTimeMillis()));
        groupInfo.setSettleDate(date);
        groupInfo.setBizDate(info.getBizDate());
        groupInfo.setCreator(ContextUtil.getCurrentUserInfo((Context)ctx));
        groupInfo.setCU(ContextUtil.getCurrentCtrlUnit((Context)ctx));
        groupInfo.setCreateType(CreateTypeEnum.RedBlueSettle);
        this.setSettleBizPeriod(ctx, groupInfo);
        return groupInfo;
    }

    private void updateMatReqSettleQty(Context ctx, String detailTableName, List entryList, Map srcEntryMap) throws BOSException, EASBizException {
        String UPDATE_MAT_REQ_QTY = " update {0} set FUnVmiSettleBaseQty=FUnVmiSettleBaseQty-?,FTotalVmiSettleBaseQty=FTotalVmiSettleBaseQty+?  where FID = ?";
        Connection conn = null;
        PreparedStatement updatePM = null;
        String updateSQL = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            updateSQL = MessageFormat.format(" update {0} set FUnVmiSettleBaseQty=FUnVmiSettleBaseQty-?,FTotalVmiSettleBaseQty=FTotalVmiSettleBaseQty+?  where FID = ?", detailTableName);
            updatePM = conn.prepareStatement(updateSQL);
            InvBillBaseEntryInfo entryInfo = null;
            InvBillBaseEntryInfo srcEntryInfo = null;
            BigDecimal currentVmiSettleBaseQty = BigDecimal.ZERO;
            int size = entryList.size();
            for (int i = 0; i < size; ++i) {
                entryInfo = (InvBillBaseEntryInfo)entryList.get(i);
                srcEntryInfo = (InvBillBaseEntryInfo)srcEntryMap.get(entryInfo.getSourceBillEntryId());
                currentVmiSettleBaseQty = entryInfo.getBaseQty().add(srcEntryInfo.getUnVmiSettleBaseQty()).compareTo(BigDecimal.ZERO) >= 0 ? entryInfo.getBaseQty() : srcEntryInfo.getUnVmiSettleBaseQty().negate();
                updatePM.setBigDecimal(1, currentVmiSettleBaseQty);
                updatePM.setBigDecimal(2, currentVmiSettleBaseQty);
                updatePM.setString(3, entryInfo.getId().toString());
                updatePM.addBatch();
                updatePM.setBigDecimal(1, currentVmiSettleBaseQty.negate());
                updatePM.setBigDecimal(2, currentVmiSettleBaseQty.negate());
                updatePM.setString(3, srcEntryInfo.getId().toString());
                updatePM.addBatch();
            }
            updatePM.executeBatch();
        }
        catch (SQLException ex) {
            try {
                throw new BOSException((Throwable)ex);
            }
            catch (Throwable throwable) {
                DBUtil.close((Connection)conn, (PreparedStatement[])new PreparedStatement[]{updatePM}, (ResultSet[])new ResultSet[0]);
                throw throwable;
            }
        }
        DBUtil.close((Connection)conn, (PreparedStatement[])new PreparedStatement[]{updatePM}, (ResultSet[])new ResultSet[0]);
    }

    private boolean checkRedBlueSettle(Context ctx, InvBillBaseInfo model, String billTypeId) throws EASBizException, BOSException {
        InvBillBaseInfo info;
        boolean result = false;
        if (model.getSourceBillType() == null) {
            return false;
        }
        if (model instanceof MaterialReqBillInfo) {
            info = (MaterialReqBillInfo)model;
            result = this.checkRedBlueSettle4Matreq(ctx, billTypeId, (MaterialReqBillInfo)info);
        }
        if (model instanceof SaleIssueBillInfo) {
            info = (SaleIssueBillInfo)model;
            result = this.checkRedBlueSettle4SaleIssue(ctx, billTypeId, (SaleIssueBillInfo)info);
        }
        return result;
    }

    private boolean checkRedBlueSettle4SaleIssue(Context ctx, String billTypeId, SaleIssueBillInfo info) throws EASBizException, BOSException {
        TransactionTypeInfo tti = info.getTransactionType();
        if (tti == null) {
            return false;
        }
        if (info.isIsSysBill()) {
            return false;
        }
        if (tti.getRiType() == null) {
            info.setTransactionType(InvAppUtils.getTransType(ctx, tti.getId().toString()));
        }
        if (info.getBillType() == null) {
            info.setBillType(info.getTransactionType().getBillType());
        }
        boolean saleIssueBack = false;
        if ("50957179-0105-1000-e000-015bc0a812fd463ED552".equals(billTypeId) && tti.getRiType().getBizDirection().getValue() == -1) {
            saleIssueBack = true;
        }
        return saleIssueBack && info.getBaseStatus().equals((Object)BillBaseStatusEnum.AUDITED);
    }

    private boolean checkRedBlueSettle4Matreq(Context ctx, String billTypeId, MaterialReqBillInfo info) throws BOSException, EASBizException {
        TransactionTypeInfo tti = info.getTransactionType();
        if (tti == null) {
            return false;
        }
        if (info.isIsSysBill()) {
            return false;
        }
        if (tti.getRiType() == null) {
            info.setTransactionType(InvAppUtils.getTransType(ctx, tti.getId().toString()));
        }
        if (info.getBillType() == null) {
            info.setBillType(info.getTransactionType().getBillType());
        }
        if (PurchaseTypeEnum.SUBCONTRACT.equals((Object)info.getPurchaseType())) {
            return false;
        }
        boolean isMatReqBack = false;
        if ("50957179-0105-1000-e000-0163c0a812fd463ED552".equals(billTypeId) && tti.getRiType().getBizDirection().getValue() == -1) {
            isMatReqBack = true;
        }
        if (!isMatReqBack || !info.getBaseStatus().equals((Object)BillBaseStatusEnum.AUDITED)) {
            return false;
        }
        return billTypeId.equals(info.getSourceBillType().getId().toString());
    }

    protected VMISettleGroupInfo createSettleGroupInfo(Context ctx, InvBillBaseInfo info, InvBillBaseInfo srcInfo, List<InvBillBaseEntryInfo> entryList, Map srcEntryMap) throws EASBizException, BOSException {
        InvBillBaseEntryInfo entryInfo = null;
        InvBillBaseEntryInfo srcEntryInfo = null;
        SimpleDateFormat format = new SimpleDateFormat("yyyyMMddHHmmssSSS");
        Date date = new Date();
        VMISettleGroupInfo groupInfo = new VMISettleGroupInfo();
        groupInfo.setId(BOSUuid.create((BOSObjectType)groupInfo.getBOSType()));
        groupInfo.setNumber(format.format(date));
        if (info instanceof MaterialReqBillInfo) {
            groupInfo.setCompanyOrgUnit(((MaterialReqBillInfo)info).getSupplyCompanyOrgUnit());
        } else {
            groupInfo.setCompanyOrgUnit((CompanyOrgUnitInfo)info.getEntries().getObject(0).get("companyOrgUnit"));
        }
        groupInfo.setCreateTime(new Timestamp(System.currentTimeMillis()));
        groupInfo.setSettleDate(date);
        groupInfo.setBizDate(info.getBizDate());
        groupInfo.setCreator(ContextUtil.getCurrentUserInfo((Context)ctx));
        groupInfo.setCU(ContextUtil.getCurrentCtrlUnit((Context)ctx));
        groupInfo.setCreateType(CreateTypeEnum.RedBlueSettle);
        this.setSettleBizPeriod(ctx, groupInfo);
        int seq = 0;
        int groupNO = 0;
        BigDecimal currentVmiSettleBaseQty = BigDecimal.ZERO;
        int size = entryList.size();
        for (int i = 0; i < size; ++i) {
            entryInfo = entryList.get(i);
            srcEntryInfo = (InvBillBaseEntryInfo)srcEntryMap.get(entryInfo.getSourceBillEntryId());
            currentVmiSettleBaseQty = entryInfo.getBaseQty().add(srcEntryInfo.getUnVmiSettleBaseQty()).compareTo(BigDecimal.ZERO) >= 0 ? entryInfo.getBaseQty() : srcEntryInfo.getUnVmiSettleBaseQty().negate();
            this.createSettleRecordInfo(ctx, groupInfo, info, entryInfo, currentVmiSettleBaseQty, seq++, groupNO);
            this.createSettleRecordInfo(ctx, groupInfo, srcInfo, srcEntryInfo, currentVmiSettleBaseQty.negate(), seq++, groupNO);
            ++groupNO;
        }
        return groupInfo;
    }

    private void setSettleBizPeriod(Context ctx, VMISettleGroupInfo groupInfo) throws BOSException, EASBizException {
        PeriodInfo bizPeriod = PeriodUtils.getPeriodInfo((Context)ctx, (Date)groupInfo.getBizDate(), (CompanyOrgUnitInfo)groupInfo.getCompanyOrgUnit(), (SystemEnum)SystemEnum.INVENTORYMANAGEMENT);
        if (bizPeriod.isIsAdjustPeriod()) {
            bizPeriod = PeriodUtils.getNextPeriodInfo((PeriodInfo)bizPeriod);
        }
    }

    protected VMISettleRecordInfo createSettleRecordInfo(Context ctx, VMISettleGroupInfo groupInfo, InvBillBaseInfo info, InvBillBaseEntryInfo entryInfo, BigDecimal currentVmiSettleBaseQty, int seq, int groupNO) {
        VMISettleRecordInfo recordInfo = new VMISettleRecordInfo();
        recordInfo.setId(BOSUuid.create((BOSObjectType)recordInfo.getBOSType()));
        recordInfo.setGroupNO(groupNO);
        recordInfo.setSeq(seq);
        recordInfo.setBillType(info.getBillType());
        recordInfo.setBizType(info.getBizType());
        recordInfo.setTransactionType(info.getTransactionType());
        recordInfo.setBillID(info.getId().toString());
        recordInfo.setBillEntryID(entryInfo.getId().toString());
        recordInfo.setBillEntrySeq(entryInfo.getSeq());
        recordInfo.setBillNumber(info.getNumber());
        recordInfo.setBillDate(info.getBizDate());
        recordInfo.setCompanyOrgUnit(entryInfo.getCompanyOrgUnit());
        recordInfo.setStorageOrgUnit(entryInfo.getStorageOrgUnit());
        recordInfo.setSupplier((SupplierInfo)entryInfo.get("supplier"));
        recordInfo.setMaterial(entryInfo.getMaterial());
        recordInfo.setLot(entryInfo.getLot());
        recordInfo.setAssistProperty(entryInfo.getAssistProperty());
        recordInfo.setUnit(entryInfo.getUnit());
        recordInfo.setQty(entryInfo.getQty());
        recordInfo.setCurrentVmiSettleBaseQty(currentVmiSettleBaseQty);
        recordInfo.setUnVmiSettleBaseQty(entryInfo.getUnVmiSettleBaseQty().subtract(currentVmiSettleBaseQty));
        recordInfo.setBaseUnit(entryInfo.getBaseUnit());
        recordInfo.setBaseQty(entryInfo.getBaseQty());
        recordInfo.setWarehouse(entryInfo.getWarehouse());
        recordInfo.setLocation(entryInfo.getLocation());
        recordInfo.setProject(entryInfo.getProject());
        recordInfo.setTrackNumber(entryInfo.getTrackNumber());
        recordInfo.setCalculator(ContextUtil.getCurrentUserInfo((Context)ctx));
        recordInfo.setRecordType(RecordTypeEnum.Src);
        groupInfo.getEntry().add(recordInfo);
        return recordInfo;
    }

    @Override
    protected void _redBlueUnSettle(Context ctx, IObjectValue model, String billTypeId) throws BOSException, EASBizException {
        if (!(model instanceof MaterialReqBillInfo) && !(model instanceof SaleIssueBillInfo)) {
            return;
        }
        InvBillBaseInfo info = null;
        ObjectUuidPK pk = new ObjectUuidPK(((InvBillBaseInfo)model).getId());
        info = "50957179-0105-1000-e000-0163c0a812fd463ED552".equals(billTypeId) ? MaterialReqBillFactory.getLocalInstance(ctx).getMaterialReqBillInfo((IObjectPK)pk, SCMSelectorFactory.getMaterialReqBillSelector((boolean)true)) : SaleIssueBillFactory.getLocalInstance(ctx).getSaleIssueBillInfo((IObjectPK)pk, SCMSelectorFactory.getSaleIssueBillSelector((boolean)true));
        if (!this.checkRedBlueUnSettle(ctx, (IObjectValue)info, billTypeId)) {
            return;
        }
        String[] ids = new String[]{info.getId().toString()};
        this.redBlueUnSettle(ctx, ids);
    }

    private void buildRedBlueSourceBillMap(Context ctx, String billTypeId, List<InvBillBaseEntryInfo> entryList, Set<String> sourceBillIdSet, Map<String, List<InvBillBaseEntryInfo>> blueBillEntryMap, Map<String, InvBillBaseInfo> blueBillMap) throws BOSException {
        InvBillBaseCollection soureBillCol;
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", sourceBillIdSet, CompareType.INCLUDE));
        view.setFilter(filter);
        if ("50957179-0105-1000-e000-0163c0a812fd463ED552".equals(billTypeId)) {
            view.setSelector(SCMSelectorFactory.getMaterialReqBillSelector((boolean)true));
            soureBillCol = MaterialReqBillFactory.getLocalInstance(ctx).getInvBillBaseCollection(view);
        } else {
            view.setSelector(SCMSelectorFactory.getSaleIssueBillSelector((boolean)true));
            soureBillCol = SaleIssueBillFactory.getLocalInstance(ctx).getInvBillBaseCollection(view);
        }
        for (InvBillBaseEntryInfo redBillEnttryInfo : entryList) {
            String redBillEntryId = redBillEnttryInfo.getId().toString();
            Iterator iterator = soureBillCol.iterator();
            while (iterator.hasNext()) {
                InvBillBaseInfo blueBillInfo = (InvBillBaseInfo)iterator.next();
                blueBillMap.put(blueBillInfo.getId().toString(), blueBillInfo);
                BOSUuid sourceBillEntryId = BOSUuid.read((String)redBillEnttryInfo.getSourceBillEntryId());
                InvBillBaseEntryInfo blueBillEntryInfo = (InvBillBaseEntryInfo)blueBillInfo.getEntries().getObject((Object)sourceBillEntryId);
                if (blueBillEntryInfo == null) continue;
                if (!blueBillEntryMap.containsKey(redBillEntryId)) {
                    ArrayList bulueBillEntryList = new ArrayList();
                    blueBillEntryMap.put(redBillEntryId, bulueBillEntryList);
                }
                blueBillEntryMap.get(redBillEntryId).add(blueBillEntryInfo);
            }
        }
    }

    private void buildRedBlueCoreBillMap(Context ctx, List<InvBillBaseEntryInfo> entryList, Set<String> coreBillIdSet, Set<String> sourceBillIdSet, Map<String, List<InvBillBaseEntryInfo>> blueBillEntryMap, Map<String, InvBillBaseInfo> blueBillMap) throws BOSException {
        ArrayList bulueBillEntryList;
        String coreBillEntryid;
        SaleIssueBillInfo blueBillInfo;
        SaleIssueEntryInfo blueBillEntryInfo;
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("saleOrder", coreBillIdSet, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("unVmiSettleBaseQty", (Object)0, CompareType.GREATER));
        view.setFilter(filter);
        SelectorItemCollection sics = new SelectorItemCollection();
        sics.add(new SelectorItemInfo("parent.id"));
        view.setSelector(sics);
        SaleIssueEntryCollection saleIssueEntryCollection = SaleIssueEntryFactory.getLocalInstance(ctx).getSaleIssueEntryCollection(view);
        HashSet<String> saleBillIdSet = new HashSet<String>();
        int size = saleIssueEntryCollection.size();
        for (int i = 0; i < size; ++i) {
            blueBillEntryInfo = saleIssueEntryCollection.get(i);
            saleBillIdSet.add(blueBillEntryInfo.getParent().getId().toString());
        }
        if (saleBillIdSet.isEmpty()) {
            return;
        }
        filter = new FilterInfo();
        if (!sourceBillIdSet.isEmpty()) {
            filter.getFilterItems().add(new FilterItemInfo("id", sourceBillIdSet, CompareType.NOTINCLUDE));
        }
        filter.getFilterItems().add(new FilterItemInfo("id", saleBillIdSet, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("baseStatus", (Object)4));
        view.setFilter(filter);
        SorterItemCollection sorterItemCollection = new SorterItemCollection();
        sorterItemCollection.add(new SorterItemInfo("bizDate"));
        view.setSorter(sorterItemCollection);
        view.setSelector(SCMSelectorFactory.getSaleIssueBillSelector((boolean)true));
        SaleIssueBillCollection coreBillColl = SaleIssueBillFactory.getLocalInstance(ctx).getSaleIssueBillCollection(view);
        Iterator iterator = coreBillColl.iterator();
        while (iterator.hasNext()) {
            blueBillInfo = (SaleIssueBillInfo)iterator.next();
            blueBillMap.put(blueBillInfo.getId().toString(), blueBillInfo);
        }
        HashMap coreBillEntryMap = new HashMap();
        Iterator iterator2 = coreBillColl.iterator();
        while (iterator2.hasNext()) {
            blueBillInfo = (SaleIssueBillInfo)iterator2.next();
            int size2 = blueBillInfo.getEntry().size();
            for (int i = 0; i < size2; ++i) {
                blueBillEntryInfo = blueBillInfo.getEntry().get(i);
                coreBillEntryid = blueBillEntryInfo.getSaleOrderEntry();
                if (!coreBillEntryMap.containsKey(coreBillEntryid)) {
                    bulueBillEntryList = new ArrayList();
                    coreBillEntryMap.put(coreBillEntryid, bulueBillEntryList);
                }
                ((List)coreBillEntryMap.get(coreBillEntryid)).add(blueBillEntryInfo);
            }
        }
        for (InvBillBaseEntryInfo redBillEntryInfo : entryList) {
            coreBillEntryid = ((SaleIssueEntryInfo)redBillEntryInfo).getSaleOrderEntry();
            String redBillEntryId = redBillEntryInfo.getId().toString();
            if (!blueBillEntryMap.containsKey(redBillEntryId)) {
                bulueBillEntryList = new ArrayList();
                blueBillEntryMap.put(redBillEntryId, bulueBillEntryList);
            }
            if (!coreBillEntryMap.containsKey(coreBillEntryid)) continue;
            blueBillEntryMap.get(redBillEntryId).addAll((Collection)coreBillEntryMap.get(coreBillEntryid));
        }
    }

    private boolean checkRedBlueUnSettle(Context ctx, IObjectValue model, String billTypeId) throws EASBizException, BOSException {
        InvBillBaseInfo info;
        boolean result = false;
        if (model instanceof MaterialReqBillInfo) {
            info = (MaterialReqBillInfo)model;
            result = this.checkRedBlueUnSettle4MatReq(ctx, billTypeId, (MaterialReqBillInfo)info);
        }
        if (model instanceof SaleIssueBillInfo) {
            info = (SaleIssueBillInfo)model;
            result = this.checkRedBlueUnSettle4SaleIssue(ctx, billTypeId, (SaleIssueBillInfo)info);
        }
        return result;
    }

    private boolean checkRedBlueUnSettle4SaleIssue(Context ctx, String billTypeId, SaleIssueBillInfo info) throws EASBizException, BOSException {
        TransactionTypeInfo tti = info.getTransactionType();
        if (tti == null) {
            return false;
        }
        if (info.isIsSysBill()) {
            return false;
        }
        if (tti.getRiType() == null) {
            info.setTransactionType(InvAppUtils.getTransType(ctx, tti.getId().toString()));
        }
        if (info.getBillType() == null) {
            info.setBillType(info.getTransactionType().getBillType());
        }
        boolean isSaleIssue = false;
        if ("50957179-0105-1000-e000-015bc0a812fd463ED552".equals(billTypeId) && tti.getRiType().getBizDirection().getValue() == -1) {
            isSaleIssue = true;
        }
        return isSaleIssue && !info.getBaseStatus().equals((Object)BillBaseStatusEnum.AUDITED);
    }

    private boolean checkRedBlueUnSettle4MatReq(Context ctx, String billTypeId, MaterialReqBillInfo info) throws BOSException, EASBizException {
        TransactionTypeInfo tti = info.getTransactionType();
        if (tti == null) {
            return false;
        }
        if (info.isIsSysBill()) {
            return false;
        }
        if (PurchaseTypeEnum.SUBCONTRACT.equals((Object)info.getPurchaseType())) {
            return false;
        }
        if (tti.getRiType() == null) {
            info.setTransactionType(InvAppUtils.getTransType(ctx, tti.getId().toString()));
        }
        if (info.getBillType() == null) {
            info.setBillType(info.getTransactionType().getBillType());
        }
        boolean isMatReqBack = false;
        if ("50957179-0105-1000-e000-0163c0a812fd463ED552".equals(billTypeId) && tti.getRiType().getBizDirection().getValue() == -1) {
            isMatReqBack = true;
        }
        return isMatReqBack && !info.getBaseStatus().equals((Object)BillBaseStatusEnum.AUDITED);
    }

    private void redBlueUnSettle(Context ctx, String[] ids) throws BOSException, EASBizException {
        if (ids == null || ids.length == 0) {
            return;
        }
        StringBuffer bf = new StringBuffer();
        bf.append("(");
        int length = ids.length;
        for (int i = 0; i < length; ++i) {
            bf.append("'").append(ids[i]).append("'");
            if (i == length - 1) continue;
            bf.append(",");
        }
        bf.append(")");
        String billId = bf.toString();
        bf.setLength(0);
        bf.append(" select distinct fparentid from T_IM_VMISettleRecord");
        bf.append(" where FBillID in ").append(billId);
        String sql = bf.toString();
        logger.debug((Object)("sql=" + sql));
        bf.setLength(0);
        HashSet<String> newids = new HashSet<String>();
        try {
            IRowSet rs = DBUtil.executeQuery((Context)ctx, (String)sql);
            while (rs.next()) {
                newids.add(rs.getString("fparentid"));
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage());
            throw new BOSException((Throwable)e);
        }
        if (newids.isEmpty()) {
            return;
        }
        this.unSettle(ctx, newids);
    }

    @Override
    protected Map _fetchPrice(Context ctx, Map params) throws BOSException, EASBizException {
        FetchPriceVMIService fetchPriceVMIService = new FetchPriceVMIService();
        Map priceMap = null;
        priceMap = fetchPriceVMIService.fetchPrice(ctx, params);
        return priceMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Map _unSettleNew(Context ctx, Set ids) throws BOSException, EASBizException {
        HashMap<String, Comparable<StringBuffer>> resultMap = new HashMap<String, Comparable<StringBuffer>>();
        if (ids == null || ids.size() == 0) {
            return resultMap;
        }
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)ids, CompareType.INCLUDE));
        viewInfo.setFilter(filter);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("*"));
        selector.add("companyOrgUnit.id");
        selector.add("companyOrgUnit.number");
        selector.add("companyOrgUnit.name");
        selector.add(new SelectorItemInfo("entry.*"));
        viewInfo.setSelector(selector);
        VMISettleGroupCollection groupColl = VMISettleGroupFactory.getLocalInstance(ctx).getVMISettleGroupCollection(viewInfo);
        VMISettleGroupInfo groupInfo = null;
        UserInfo user = ContextUtil.getCurrentUserInfo((Context)ctx);
        CompanyOrgUnitInfo companyOrgUnit = null;
        HashMap<String, PeriodInfo> periodMap = new HashMap<String, PeriodInfo>();
        StringBuffer errorMsg = new StringBuffer();
        String groupNumber = null;
        int errorCount = 0;
        HashMap<String, VMISettleGroupInfo> logMap = new HashMap<String, VMISettleGroupInfo>();
        HashSet<String> logErrorSet = new HashSet<String>();
        HashMap<String, Boolean> couCloseAccountMap = new HashMap<String, Boolean>();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        for (int i = 0; i < groupColl.size(); ++i) {
            int createType;
            Date settleDate;
            String key;
            Boolean isCloseAcount;
            PeriodInfo curPeriod;
            groupInfo = groupColl.get(i);
            logMap.put(groupInfo.getNumber(), groupInfo);
            companyOrgUnit = groupInfo.getCompanyOrgUnit();
            groupNumber = groupInfo.getNumber();
            if (!VMISettleUtil.isAuthoriedForOrg(ctx, companyOrgUnit.getId().toString(), user.getId().toString(), "vmisettle_unsettle")) {
                errorMsg.append(this.getResource(ctx, "NotUnSettleRightServer", new Object[]{groupNumber, companyOrgUnit.getName()})).append("\n");
                ids.remove(groupInfo.getId().toString());
                logErrorSet.add(groupInfo.getId().toString());
                ++errorCount;
            }
            if ((curPeriod = (PeriodInfo)periodMap.get(companyOrgUnit.getId().toString())) == null) {
                curPeriod = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.INVENTORYMANAGEMENT, (CompanyOrgUnitInfo)companyOrgUnit);
                periodMap.put(companyOrgUnit.getId().toString(), curPeriod);
            }
            if ((isCloseAcount = (Boolean)couCloseAccountMap.get(key = sdf.format(settleDate = groupInfo.getSettleDate()) + companyOrgUnit.getId().toString())) == null) {
                isCloseAcount = this.isCloseAccount(ctx, settleDate, companyOrgUnit, curPeriod);
                couCloseAccountMap.put(key, isCloseAcount);
            }
            if (isCloseAcount.booleanValue()) {
                throw new SCMBillException(SCMBillException.CURRENT_PERIOD_COLSED, (Object[])new String[]{companyOrgUnit.getName()});
            }
            if (settleDate.before(curPeriod.getBeginDate())) {
                errorMsg.append(this.getResource(ctx, "ErrorUnSettlePeriodServer", new Object[]{groupNumber, companyOrgUnit.getName()})).append("\n");
                ids.remove(groupInfo.getId().toString());
                logErrorSet.add(groupInfo.getId().toString());
                ++errorCount;
            }
            if ((createType = groupInfo.getCreateType().getValue()) != 2) continue;
            errorMsg.append(this.getResource(ctx, "ErrorUnSettleCreateTypeServer", new Object[]{groupNumber, companyOrgUnit.getName()})).append("\n");
            ids.remove(groupInfo.getId().toString());
            logErrorSet.add(groupInfo.getId().toString());
            ++errorCount;
        }
        Map errorMap = null;
        if (ids.size() > 0) {
            IMutexServiceControl iMutexServiceControl = MutexServiceControlFactory.getLocalInstance((Context)ctx);
            ArrayList requestLockList = new ArrayList();
            ArrayList thisLockList = new ArrayList();
            ArrayList otherLockList = new ArrayList();
            try {
                requestLockList.addAll(ids);
                this.requestLocks(ctx, requestLockList, thisLockList, otherLockList);
                for (String id : ids) {
                    errorMap = this.unSettle(ctx, id);
                    resultMap.put("ERROR_MSG", errorMsg.append(errorMap.get("ERROR_MSG")));
                    resultMap.put("ERROR_COUNT", Integer.valueOf(errorCount + (Integer)errorMap.get("ERROR_COUNT")));
                    Set errorSet = (Set)resultMap.get("ERROR_LIST");
                    if (errorSet == null) continue;
                    logErrorSet.addAll(errorSet);
                }
            }
            finally {
                if (thisLockList.size() > 0) {
                    iMutexServiceControl.batchReleaseObjIDForUpdate(thisLockList);
                }
            }
        } else {
            resultMap.put("ERROR_MSG", errorMsg);
            resultMap.put("ERROR_COUNT", Integer.valueOf(errorCount));
        }
        this.setLog(ctx, logMap, logErrorSet, "vmiSettle_unSettle", this.getResource(ctx, "vmiSettle_unSettle"), this.getFacadeBosType());
        return resultMap;
    }

    @Override
    protected Map _unSettle(Context ctx, String id) throws BOSException, EASBizException {
        HashMap<String, Serializable> resultMap = new HashMap<String, Serializable>();
        HashSet<String> ids = new HashSet<String>();
        if (id == null || id.length() == 0) {
            return resultMap;
        }
        ids.add(id);
        String SEL_SETTLE_RECORD = " Select FBillEntryId, FBillTypeID, sum(FCurrentVmiSettleBaseQty) as curSettleBaseQty from T_IM_VMISettleRecord where FParentId in ({0}) and FRecordType in (0,3) group by FBillEntryId, FBillTypeID ";
        String SEL_SETTLE_VIRTUAL_RECORD = " Select FBillID,FBillTypeID,FCurrentVmiSettleBaseQty from T_IM_VMISettleRecord  where FParentId in ({0}) and FRecordType in (1,2) ";
        String SEL_SETTLE_ERROE = " Select sgroup.fid as FGroupId,sgroup.fnumber as FGroupNumber,record.FbillId as FBillId,record.FbillNumber as FbillNumber  from T_IM_VMISettleRecord record inner join T_IM_VMISettleGroup sgroup on record.fparentid = sgroup.fid  where record.FBillID in ({0}) and FRecordType in (1,2)";
        String[] DELETE_SETTLE_RECORD = new String[]{"Delete from T_IM_VMISettleGroup where FID in ({0})", "Delete from T_IM_VMISettleRecord where FParentId in ({0})"};
        String idFitler = VMISettleUtil.getSqlIds(ids);
        String settleRecordSQL = null;
        String settleRecordVirtualSQL = null;
        String settleErrorSQL = null;
        IRowSet settleRecordSet = null;
        IRowSet settleRecordVirtualSet = null;
        IRowSet settleErrorSet = null;
        BigDecimal curSettleBaseQty = null;
        String billId = null;
        String groupId = null;
        Object billEntryId = null;
        String billTypeId = null;
        String groupNumber = null;
        String billNumber = null;
        StringBuffer errorMsg = new StringBuffer();
        Map errorMap = null;
        List errorList = null;
        ArrayList errorIdLsit = null;
        HashSet<String> errorGroupIdSet = null;
        HashMap errorIdMap = null;
        int errorCount = 0;
        try {
            settleRecordVirtualSQL = MessageFormat.format(" Select FBillID,FBillTypeID,FCurrentVmiSettleBaseQty from T_IM_VMISettleRecord  where FParentId in ({0}) and FRecordType in (1,2) ", idFitler);
            settleRecordVirtualSet = DBUtil.executeQuery((Context)ctx, (String)settleRecordVirtualSQL);
            errorList = this.deleteVirtualBill(ctx, settleRecordVirtualSet);
            if (errorList != null && errorList.size() > 0) {
                errorCount = errorList.size();
                errorIdLsit = new ArrayList();
                errorIdMap = new HashMap();
                errorGroupIdSet = new HashSet<String>();
                for (int i = 0; i < errorList.size(); ++i) {
                    errorMap = (Map)errorList.get(i);
                    errorIdLsit.add(errorMap.get("billId"));
                    errorIdMap.put(errorMap.get("billId"), errorMap);
                }
                String billIdstr = VMISettleUtil.getSqlIds(errorIdLsit);
                settleErrorSQL = MessageFormat.format(" Select sgroup.fid as FGroupId,sgroup.fnumber as FGroupNumber,record.FbillId as FBillId,record.FbillNumber as FbillNumber  from T_IM_VMISettleRecord record inner join T_IM_VMISettleGroup sgroup on record.fparentid = sgroup.fid  where record.FBillID in ({0}) and FRecordType in (1,2)", billIdstr.toString());
                settleErrorSet = DBUtil.executeQuery((Context)ctx, (String)settleErrorSQL);
                while (settleErrorSet.next()) {
                    groupId = settleErrorSet.getString("FGroupId");
                    errorGroupIdSet.add(groupId);
                    billId = settleErrorSet.getString("FBillId");
                    billNumber = settleErrorSet.getString("FbillNumber");
                    groupNumber = settleErrorSet.getString("FGroupNumber");
                    errorMap = (Map)errorIdMap.get(billId);
                    if ("VOUCHER".equals(errorMap.get("error"))) {
                        errorMsg.append(this.getResource(ctx, "ErrorUnSettleIsVoucherServer", new Object[]{groupNumber, billNumber})).append("\n");
                    } else if (errorMap.get("errorMsg") != null) {
                        errorMsg.append(this.getResource(ctx, "ErrorSettleOtherMsg", new Object[]{groupNumber, billNumber}));
                        errorMsg.append(errorMap.get("errorMsg")).append("\n");
                    }
                    ids.remove(groupId);
                }
            }
            String[][] billEntryTable = new String[][]{{"50957179-0105-1000-e000-0163c0a812fd463ED552", "T_IM_MaterialReqBillEntry"}, {"50957179-0105-1000-e000-0177c0a812fd463ED552", "T_IM_OtherIssueBillEntry"}, {"50957179-0105-1000-e000-015bc0a812fd463ED552", "T_IM_SaleIssueEntry"}};
            HashMap paramMap = new HashMap();
            ArrayList<Object[]> paramList = null;
            idFitler = VMISettleUtil.getSqlIds(ids);
            settleRecordSQL = MessageFormat.format(" Select FBillEntryId, FBillTypeID, sum(FCurrentVmiSettleBaseQty) as curSettleBaseQty from T_IM_VMISettleRecord where FParentId in ({0}) and FRecordType in (0,3) group by FBillEntryId, FBillTypeID ", idFitler);
            settleRecordSet = DBUtil.executeQuery((Context)ctx, (String)settleRecordSQL);
            while (settleRecordSet.next()) {
                billTypeId = settleRecordSet.getString("FBillTypeID");
                curSettleBaseQty = settleRecordSet.getBigDecimal("curSettleBaseQty");
                paramList = (ArrayList<Object[]>)paramMap.get(billTypeId);
                if (paramList == null) {
                    paramList = new ArrayList<Object[]>();
                    paramMap.put(billTypeId, paramList);
                }
                Object[] paramArray = new Object[]{curSettleBaseQty, curSettleBaseQty, settleRecordSet.getString("FBillEntryId")};
                paramList.add(paramArray);
            }
            String updateSql = null;
            for (int i = 0; i < billEntryTable.length; ++i) {
                if (paramMap.get(billEntryTable[i][0]) == null) continue;
                updateSql = " update " + billEntryTable[i][1] + " set FUnVmiSettleBaseQty=FUnVmiSettleBaseQty+?,FTotalVmiSettleBaseQty=FTotalVmiSettleBaseQty-?  where FID = ?";
                DbUtil.executeBatch((Context)ctx, (String)updateSql, (List)((List)paramMap.get(billEntryTable[i][0])));
            }
            String[] delSQL = new String[]{MessageFormat.format(DELETE_SETTLE_RECORD[0], idFitler), MessageFormat.format(DELETE_SETTLE_RECORD[1], idFitler)};
            DBUtil.execute((Context)ctx, (String[])delSQL);
        }
        catch (SQLException ex) {
            try {
                throw new BOSException((Throwable)ex);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(settleRecordSet);
                SQLUtils.cleanup(settleRecordVirtualSet);
                SQLUtils.cleanup(settleErrorSet);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)settleRecordSet);
        SQLUtils.cleanup((ResultSet)settleRecordVirtualSet);
        SQLUtils.cleanup((ResultSet)settleErrorSet);
        resultMap.put("ERROR_LIST", errorGroupIdSet);
        resultMap.put("ERROR_COUNT", Integer.valueOf(errorCount));
        resultMap.put("ERROR_MSG", errorMsg);
        return resultMap;
    }

    protected boolean isCloseAccount(Context ctx, Date settleDate, CompanyOrgUnitInfo cou, PeriodInfo curPeriodInfo) throws EASBizException, BOSException {
        boolean isShuted;
        if (cou != null && (isShuted = SystemStatusCtrolUtils.isClose((Context)ctx, (SystemEnum)SystemEnum.INVENTORYMANAGEMENT, (CompanyOrgUnitInfo)cou))) {
            PeriodInfo periodInfo = PeriodUtils.getPeriodInfo((Context)ctx, (Date)settleDate, (CompanyOrgUnitInfo)cou);
            if (curPeriodInfo == null) {
                curPeriodInfo = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.INVENTORYMANAGEMENT, (CompanyOrgUnitInfo)cou);
            }
            if (periodInfo != null && curPeriodInfo != null && periodInfo.getId().toString().equals(curPeriodInfo.getId().toString())) {
                return true;
            }
        }
        return false;
    }

    private String getFacadeBosType() {
        return "C612778A";
    }

    public void setLog(Context ctx, Map map, Set set, String logItemName, String methodName, String bosType) {
        if (map == null || map.size() == 0) {
            return;
        }
        Iterator it = map.keySet().iterator();
        String number = null;
        VMISettleGroupInfo groupInfo = null;
        while (it.hasNext()) {
            number = (String)it.next();
            groupInfo = (VMISettleGroupInfo)map.get(number);
            IObjectPK pk = LogUtil.beginLog((Context)ctx, (String)methodName, (BOSObjectType)BOSObjectType.create((String)bosType), null, (String)number, (String)logItemName);
            if (set.contains(number)) continue;
            LogUtil.afterLog((Context)ctx, (IObjectPK)pk);
        }
    }

    private void requestLocks(Context ctx, List requestLockList, List thisLockList, List otherLockList) throws BOSException, EASBizException {
        String[] requestLockArr = requestLockList.toArray(new String[requestLockList.size()]);
        Map requestLockMap = MutexServiceControlFactory.getLocalInstance((Context)ctx).batchRequestObjIDForUpdate(requestLockList);
        int size = requestLockList.size();
        for (int i = 0; i < size; ++i) {
            String id = (String)requestLockList.get(i);
            if (((Boolean)requestLockMap.get(id)).booleanValue()) {
                thisLockList.add(id);
                continue;
            }
            otherLockList.add(id);
        }
        if (otherLockList.size() > 0) {
            throw new VMISettleException(VMISettleException.BILL_LOCKED);
        }
    }

    private String getResource(Context ctx, String key) {
        return ResourceBase.getString((String)"com.kingdee.eas.scm.im.inv.vmi.VMISettleResource", (String)key, (Locale)ctx.getLocale());
    }

    private String getResource(Context ctx, String key, Object[] params) {
        return ResourceBase.getString((String)"com.kingdee.eas.scm.im.inv.vmi.VMISettleResource", (String)key, (Locale)ctx.getLocale(), (Object[])params);
    }

    protected String getExtendFilter(RptParams params) {
        return null;
    }
}

