/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv.vmi.app.service;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.master.cssp.SupplierInfo;
import com.kingdee.eas.basedata.org.PurchaseOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.scm.cal.util.DBUtil;
import com.kingdee.eas.scm.im.inv.InvBillBaseEntryInfo;
import com.kingdee.eas.scm.im.inv.InvBillBaseInfo;
import com.kingdee.eas.scm.im.inv.vmi.FieldDefInfo;
import com.kingdee.eas.scm.im.inv.vmi.app.helper.VMISettleSQLBuilder;
import com.kingdee.eas.scm.im.inv.vmi.util.ORMappingUtil;
import com.kingdee.eas.scm.sm.pur.PurPriceInfo;
import com.kingdee.eas.scm.sm.pur.PurPriceInfoCollection;
import com.kingdee.eas.scm.sm.pur.PurPriceParam;
import com.kingdee.eas.scm.sm.pur.PurPriceParamCollection;
import com.kingdee.eas.scm.sm.pur.PurServiceFacadeFactory;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class FetchPriceVMIService {
    public void fetchBatchPrice(Context ctx, Map fetchPriceMap) throws BOSException, EASBizException {
        IObjectCollection rsColl;
        String tempTableName = (String)fetchPriceMap.get("tempTableName");
        VMISettleSQLBuilder sqlBuilder = (VMISettleSQLBuilder)fetchPriceMap.get("sqlBuilder");
        Date settleDate = (Date)fetchPriceMap.get("settleDate");
        FieldDefInfo fieldDefInfo = sqlBuilder.getConfig();
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT ").append(sqlBuilder.getQuerySelectSql(true));
        sql.append("\n FROM ").append(tempTableName);
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            rsColl = ORMappingUtil.rowSetToCollection(rs, sqlBuilder, true);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        int redSeq = 0;
        int blueSeq = 0;
        PurPriceParamCollection blueParamCol = new PurPriceParamCollection();
        blueParamCol.setBillTypeId("50957179-0105-1000-e000-015fc0a812fd463ED552");
        blueParamCol.setBizTypeId("LAdiD6Y5Sim6q6bmixITqSQHQ1w=");
        PurPriceParamCollection redParamCol = new PurPriceParamCollection();
        redParamCol.setBillTypeId("50957179-0105-1000-e000-015fc0a812fd463ED552");
        redParamCol.setBizTypeId("3IS1Qaa0R32+3JPxlVZg5iQHQ1w=");
        InvBillBaseInfo info = null;
        InvBillBaseEntryInfo entryInfo = null;
        BigDecimal currentVmiSettleQty = BigDecimal.ZERO;
        PurPriceParam purPriceParam = null;
        ArrayList<InvBillBaseInfo> blueList = new ArrayList<InvBillBaseInfo>();
        ArrayList<InvBillBaseInfo> redList = new ArrayList<InvBillBaseInfo>();
        int size = rsColl.size();
        for (int i = 0; i < size; ++i) {
            info = (InvBillBaseInfo)rsColl.getObject(i);
            entryInfo = (InvBillBaseEntryInfo)info.getEntries().getObject(0);
            this.fillBill(info);
            info.setBizDate(settleDate);
            currentVmiSettleQty = (BigDecimal)info.get("fixed_currentVmiSettleQty");
            if (currentVmiSettleQty.compareTo(BigDecimal.ZERO) > 0) {
                purPriceParam = this.getPurPriceParam(info, entryInfo, blueSeq++);
                purPriceParam.setBizTypeId("LAdiD6Y5Sim6q6bmixITqSQHQ1w=");
                blueParamCol.addPurPriceParam(purPriceParam);
                blueList.add(info);
                continue;
            }
            if (currentVmiSettleQty.compareTo(BigDecimal.ZERO) >= 0) continue;
            purPriceParam = this.getPurPriceParam(info, entryInfo, redSeq++);
            purPriceParam.setBizTypeId("3IS1Qaa0R32+3JPxlVZg5iQHQ1w=");
            redParamCol.addPurPriceParam(purPriceParam);
            redList.add(info);
        }
        this.updatePrice(ctx, tempTableName, blueParamCol, blueList);
        this.updatePrice(ctx, tempTableName, redParamCol, redList);
    }

    public Map fetchPrice(Context ctx, Map fetchPriceMap) throws EASBizException, BOSException {
        int i;
        IObjectCollection infoColl = (IObjectCollection)fetchPriceMap.get("objectCollection");
        int redSeq = 0;
        int blueSeq = 0;
        PurPriceParamCollection blueParamCol = new PurPriceParamCollection();
        blueParamCol.setBillTypeId("50957179-0105-1000-e000-015fc0a812fd463ED552");
        blueParamCol.setBizTypeId("LAdiD6Y5Sim6q6bmixITqSQHQ1w=");
        blueParamCol.setSource("qty");
        PurPriceParamCollection redParamCol = new PurPriceParamCollection();
        redParamCol.setBillTypeId("50957179-0105-1000-e000-015fc0a812fd463ED552");
        redParamCol.setBizTypeId("3IS1Qaa0R32+3JPxlVZg5iQHQ1w=");
        redParamCol.setSource("qty");
        InvBillBaseInfo info = null;
        InvBillBaseEntryInfo entryInfo = null;
        BigDecimal currentVmiSettleQty = BigDecimal.ZERO;
        PurPriceParam purPriceParam = null;
        ArrayList<InvBillBaseInfo> blueList = new ArrayList<InvBillBaseInfo>();
        ArrayList<InvBillBaseInfo> redList = new ArrayList<InvBillBaseInfo>();
        int size = infoColl.size();
        for (int i2 = 0; i2 < size; ++i2) {
            info = (InvBillBaseInfo)infoColl.getObject(i2);
            this.fillBill(info);
            entryInfo = (InvBillBaseEntryInfo)info.getEntries().getObject(0);
            currentVmiSettleQty = (BigDecimal)info.get("fixed_currentVmiSettleQty");
            if (currentVmiSettleQty.compareTo(BigDecimal.ZERO) > 0) {
                purPriceParam = this.getPurPriceParam(info, entryInfo, blueSeq++);
                purPriceParam.setBizTypeId("LAdiD6Y5Sim6q6bmixITqSQHQ1w=");
                blueParamCol.addPurPriceParam(purPriceParam);
                blueList.add(info);
                continue;
            }
            if (currentVmiSettleQty.compareTo(BigDecimal.ZERO) >= 0) continue;
            purPriceParam = this.getPurPriceParam(info, entryInfo, redSeq++);
            purPriceParam.setBizTypeId("3IS1Qaa0R32+3JPxlVZg5iQHQ1w=");
            redParamCol.addPurPriceParam(purPriceParam);
            redList.add(info);
        }
        PurPriceInfoCollection bluePriceColl = PurServiceFacadeFactory.getLocalInstance((Context)ctx).fetchPrice(blueParamCol);
        PurPriceInfoCollection redPriceColl = PurServiceFacadeFactory.getLocalInstance((Context)ctx).fetchPrice(redParamCol);
        Map bluePriceMap = bluePriceColl.getSeq2PriceInfo();
        Map redPriceMap = redPriceColl.getSeq2PriceInfo();
        HashMap<String, PurPriceInfo> priceMap = new HashMap<String, PurPriceInfo>();
        PurPriceInfo purPriceInfo = null;
        int size2 = blueList.size();
        for (i = 0; i < size2; ++i) {
            info = (InvBillBaseInfo)blueList.get(i);
            purPriceInfo = (PurPriceInfo)bluePriceMap.get(i);
            priceMap.put(info.getId().toString(), purPriceInfo);
        }
        size2 = redList.size();
        for (i = 0; i < size2; ++i) {
            info = (InvBillBaseInfo)redList.get(i);
            purPriceInfo = (PurPriceInfo)redPriceMap.get(i);
            priceMap.put(info.getId().toString(), purPriceInfo);
        }
        return priceMap;
    }

    private PurPriceInfoCollection updatePrice(Context ctx, String tempTableName, PurPriceParamCollection paramCol, List list) throws BOSException, EASBizException {
        if (paramCol == null || paramCol.size() == 0) {
            return null;
        }
        String UPDATE_PRICE = this.getUpdatePriceSql();
        PurPriceInfoCollection purPriceColl = PurServiceFacadeFactory.getLocalInstance((Context)ctx).fetchPrice(paramCol);
        Map seq2PriceInfo = purPriceColl.getSeq2PriceInfo();
        PurPriceInfo purPriceInfo = null;
        InvBillBaseInfo info = null;
        Connection conn = null;
        PreparedStatement updatePM = null;
        String updateSQL = null;
        boolean canUpdate = false;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            updateSQL = MessageFormat.format(UPDATE_PRICE, tempTableName);
            updatePM = conn.prepareStatement(updateSQL);
            int size = list.size();
            for (int i = 0; i < size; ++i) {
                info = (InvBillBaseInfo)list.get(i);
                purPriceInfo = (PurPriceInfo)seq2PriceInfo.get(i);
                if (purPriceInfo == null) continue;
                updatePM.setBigDecimal(1, purPriceInfo.getPrice() == null ? BigDecimal.ZERO : purPriceInfo.getPrice());
                updatePM.setInt(2, purPriceInfo.isInTaxPrice() ? 1 : 0);
                updatePM.setBigDecimal(3, purPriceInfo.getTaxRate());
                updatePM.setBigDecimal(4, purPriceInfo.getDiscountRate());
                updatePM.setInt(5, purPriceInfo.getEditCtrl().getValue());
                updatePM.setString(6, (String)info.get("fixed_id"));
                updatePM.addBatch();
                canUpdate = true;
            }
            if (canUpdate) {
                updatePM.executeBatch();
            }
        }
        catch (SQLException ex) {
            try {
                throw new BOSException((Throwable)ex);
            }
            catch (Throwable throwable) {
                DBUtil.close((Connection)conn, (PreparedStatement[])new PreparedStatement[]{updatePM}, (ResultSet[])new ResultSet[0]);
                throw throwable;
            }
        }
        DBUtil.close((Connection)conn, (PreparedStatement[])new PreparedStatement[]{updatePM}, (ResultSet[])new ResultSet[0]);
        return purPriceColl;
    }

    private String getUpdatePriceSql() {
        StringBuffer sql = new StringBuffer();
        sql.append(" update {0} set ");
        sql.append("fixed_vmiSettlePrice").append("=? ,");
        sql.append("fixed_isInTax").append("=? ,");
        sql.append("fixed_taxRate").append("=? ,");
        sql.append("fixed_discountRate").append("=? ,");
        sql.append("fixed_editCtrl").append("=? ");
        sql.append(" where ").append("fixed_id").append("= ?");
        return sql.toString();
    }

    private void fillBill(InvBillBaseInfo bill) throws EASBizException, BOSException {
        InvBillBaseEntryInfo entryInfo = (InvBillBaseEntryInfo)bill.getEntries().getObject(0);
        bill.setStorageOrgUnit(entryInfo.getStorageOrgUnit());
        entryInfo.setUnit(entryInfo.getBaseUnit());
        entryInfo.setQty((BigDecimal)bill.get("fixed_currentVmiSettleQty"));
        entryInfo.setBaseQty((BigDecimal)bill.get("fixed_currentVmiSettleQty"));
        entryInfo.setTotalVmiSettleBaseQty(BigDecimal.ZERO);
        entryInfo.setUnVmiSettleBaseQty((BigDecimal)bill.get("fixed_currentVmiSettleQty"));
    }

    private PurPriceParam getPurPriceParam(InvBillBaseInfo info, InvBillBaseEntryInfo entryInfo, int seq) {
        SupplierInfo supplier = (SupplierInfo)entryInfo.get("supplier");
        CurrencyInfo currencyInfo = (CurrencyInfo)info.get("fixed_currencyName");
        PurchaseOrgUnitInfo purOrgUnitInfo = (PurchaseOrgUnitInfo)info.get("fixed_purchaseOrgUnitName");
        PurPriceParam param = new PurPriceParam();
        param.setBillTypeId("50957179-0105-1000-e000-015fc0a812fd463ED552");
        param.setSeq(seq);
        param.setPurOrgUnitId(purOrgUnitInfo == null ? null : purOrgUnitInfo.getId().toString());
        param.setSupplierId(supplier == null ? null : supplier.getId().toString());
        param.setMaterialId(entryInfo.getMaterial().getId().toString());
        param.setMaterialPurchaseType(0);
        param.setUnitId(entryInfo.getUnit().getId().toString());
        param.setCurrencyId(currencyInfo == null ? null : currencyInfo.getId().toString());
        param.setBizDate(info.getBizDate());
        param.setAssistPropertyId(entryInfo.getAssistProperty() == null ? null : entryInfo.getAssistProperty().getId().toString());
        param.setQty(entryInfo.getQty().abs());
        param.setRecOrgUnitId(info.getStorageOrgUnit().getId().toString());
        if (info.get("fixed_isintax") != null) {
            param.setInTax(((Boolean)info.get("fixed_isintax")).booleanValue());
        }
        return param;
    }
}

