/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv.vmi.app.service;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.basedata.assistant.ConvertModeEnum;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ExchangeRateInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.scm.common.util.CalculateUtils;
import com.kingdee.eas.scm.im.inv.PurInWarehsBillInfo;
import com.kingdee.eas.scm.im.inv.PurInWarehsEntryInfo;
import com.kingdee.eas.scm.im.inv.vmi.util.VMISettleUtil;
import java.math.BigDecimal;

public class PurInwarehsAlgorithm {
    private CompanyOrgUnitInfo cou = null;
    private StorageOrgUnitInfo sou = null;
    private CurrencyInfo baseCurrInfo = null;
    private CurrencyInfo currencyInfo = null;
    private boolean isInTax = false;
    private boolean isPriceInTax = false;
    private ExchangeRateInfo exchangeRateinfo = null;
    private int pricePrecision = 4;
    private Context ctx = null;
    private PurInWarehsBillInfo info = null;

    public PurInwarehsAlgorithm(Context ctx, PurInWarehsBillInfo info) throws BOSException, EASBizException {
        this.info = info;
        this.ctx = ctx;
        this.currencyInfo = info.getCurrency();
        this.isInTax = info.isIsInTax();
        this.isPriceInTax = info.isIsPriceInTax();
        PurInWarehsEntryInfo entryInfo = (PurInWarehsEntryInfo)info.getEntries().getObject(0);
        this.cou = entryInfo.getCompanyOrgUnit();
        this.sou = entryInfo.getStorageOrgUnit();
        this.baseCurrInfo = this.cou.getBaseCurrency();
        this.pricePrecision = entryInfo.getMaterial().getPricePrecision();
        this.exchangeRateinfo = VMISettleUtil.getExchangeRateInfo(ctx, this.cou, this.currencyInfo, this.cou.getBaseCurrency(), info.getBizDate());
        this.initEntry(entryInfo);
    }

    public void initEntry(PurInWarehsEntryInfo entryInfo) throws BOSException, EASBizException {
        if (this.isInTax) {
            this.calDiscountAmountByTaxPrice(entryInfo);
            this.calTaxAmountByTaxPrice(entryInfo, this.isInTax);
            this.calLocalTaxAmount(entryInfo, this.exchangeRateinfo);
            this.calTax(entryInfo, this.isInTax, this.isPriceInTax);
            this.calLocalTax(entryInfo, this.exchangeRateinfo);
            this.calPriceByTaxPrice(entryInfo, this.isPriceInTax);
            this.calAmount(entryInfo, this.isInTax);
            this.calActualTaxPrice(entryInfo);
            this.calActualPrice(entryInfo);
            this.calPurchaseCost(entryInfo, this.isInTax, this.exchangeRateinfo);
            this.calUnitPurchaseCost(entryInfo, this.isInTax, this.exchangeRateinfo);
            entryInfo.setUnitMaterialCost(BigDecimal.ZERO);
            entryInfo.setMaterialCost(BigDecimal.ZERO);
        } else {
            this.calAmount(entryInfo, this.isInTax);
            this.calTax(entryInfo, this.isInTax, this.isPriceInTax);
            this.calLocalTax(entryInfo, this.exchangeRateinfo);
            this.calTaxAmountByTaxPrice(entryInfo, this.isInTax);
            this.calLocalTaxAmount(entryInfo, this.exchangeRateinfo);
            this.calActualPrice(entryInfo);
            this.calActualTaxPrice(entryInfo);
            entryInfo.setDiscountRate(BigDecimal.ZERO);
            entryInfo.setDiscountAmount(BigDecimal.ZERO);
            this.calPurchaseCost(entryInfo, this.isInTax, this.exchangeRateinfo);
            this.calUnitPurchaseCost(entryInfo, this.isInTax, this.exchangeRateinfo);
            entryInfo.setUnitMaterialCost(BigDecimal.ZERO);
            entryInfo.setMaterialCost(BigDecimal.ZERO);
        }
    }

    protected BigDecimal validateNullValue(BigDecimal value) {
        if (value == null) {
            return BigDecimal.ZERO;
        }
        return value;
    }

    public void calDiscountAmountByTaxPrice(PurInWarehsEntryInfo entryInfo) {
        int scale = this.currencyInfo.getPrecision();
        BigDecimal taxPrice = entryInfo.getTaxPrice();
        BigDecimal qty = entryInfo.getQty();
        BigDecimal discountRate = entryInfo.getDiscountRate();
        BigDecimal oneHundred = new BigDecimal("100.0");
        taxPrice = this.validateNullValue(taxPrice);
        qty = this.validateNullValue(qty);
        discountRate = this.validateNullValue(discountRate);
        BigDecimal discountAmount = taxPrice.multiply(qty).multiply(discountRate.divide(oneHundred, 10, 4)).setScale(scale, 4);
        entryInfo.setDiscountAmount(discountAmount);
    }

    public void calPriceByTaxPrice(PurInWarehsEntryInfo entryInfo, boolean isPriceInTax) {
        int scale = this.pricePrecision;
        BigDecimal taxPrice = entryInfo.getTaxPrice();
        BigDecimal taxRate = entryInfo.getTaxRate();
        taxPrice = this.validateNullValue(taxPrice);
        taxRate = this.validateNullValue(taxRate);
        taxPrice = taxPrice.abs();
        BigDecimal price = CalculateUtils.calPrice((BigDecimal)taxPrice, (BigDecimal)taxRate, (int)scale);
        if (isPriceInTax) {
            price = CalculateUtils.calPriceIsPriceInTax((BigDecimal)taxRate, (BigDecimal)taxPrice, (int)scale);
        }
        entryInfo.setPrice(price);
    }

    public void calTaxAmountByTaxPrice(PurInWarehsEntryInfo entryInfo, boolean isInTax) {
        int scale = this.currencyInfo.getPrecision();
        if (isInTax) {
            BigDecimal taxPrice = entryInfo.getTaxPrice();
            BigDecimal qty = entryInfo.getQty();
            BigDecimal discountAmount = entryInfo.getDiscountAmount();
            taxPrice = this.validateNullValue(taxPrice);
            qty = this.validateNullValue(qty);
            discountAmount = this.validateNullValue(discountAmount);
            BigDecimal taxAmount = taxPrice.multiply(qty).subtract(discountAmount);
            taxAmount = taxAmount.setScale(scale, 4);
            entryInfo.setTaxAmount(taxAmount);
        } else {
            BigDecimal amount = entryInfo.getAmount();
            BigDecimal tax = entryInfo.getTax();
            BigDecimal taxAmount = amount.add(tax);
            taxAmount = taxAmount.setScale(scale, 4);
            entryInfo.setTaxAmount(taxAmount);
        }
    }

    public void calTax(PurInWarehsEntryInfo entryInfo, boolean isInTax, boolean isPriceInTax) {
        int scale = this.currencyInfo.getPrecision();
        BigDecimal tax = SysConstant.BIGZERO;
        if (isInTax) {
            BigDecimal one = new BigDecimal("1.0");
            BigDecimal taxAmount = entryInfo.getTaxAmount();
            BigDecimal taxRate = entryInfo.getTaxRate();
            taxAmount = this.validateNullValue(taxAmount);
            taxRate = this.validateNullValue(taxRate);
            BigDecimal oneHundred = new BigDecimal("100.0");
            if (taxAmount != null && taxRate != null) {
                taxRate = taxRate.divide(oneHundred, 10, 4);
                tax = taxAmount.divide(taxRate.add(one), 10, 4).multiply(taxRate);
                if (isPriceInTax) {
                    tax = taxAmount.multiply(taxRate);
                }
                tax = tax.setScale(scale, 4);
            }
        } else {
            BigDecimal amount = entryInfo.getAmount();
            BigDecimal taxRate = entryInfo.getTaxRate();
            amount = this.validateNullValue(amount);
            taxRate = this.validateNullValue(taxRate);
            BigDecimal oneHundred = new BigDecimal("100.0");
            taxRate = taxRate.divide(oneHundred, taxRate.scale() + 4, 4);
            tax = tax.setScale(scale, 4);
        }
        entryInfo.setTax(tax);
    }

    public void calLocalTaxAmount(PurInWarehsEntryInfo entryInfo, ExchangeRateInfo exchangeRateinfo) {
        int scale = this.baseCurrInfo.getPrecision();
        BigDecimal taxAmount = entryInfo.getTaxAmount();
        taxAmount = this.validateNullValue(taxAmount);
        BigDecimal exchangerate = exchangeRateinfo.getConvertRate();
        if (exchangeRateinfo != null && exchangerate.compareTo(BigDecimal.ZERO) != 0) {
            if (exchangeRateinfo.getExchangeAux().getConvertMode() == ConvertModeEnum.DIRECTEXCHANGERATE) {
                entryInfo.setLocalTaxAmount(taxAmount.multiply(exchangerate).setScale(scale, 4));
            } else {
                entryInfo.setLocalTaxAmount(taxAmount.divide(exchangerate, scale, 4));
            }
        }
    }

    public void calAmount(PurInWarehsEntryInfo entryInfo, boolean isInTax) {
        int scale = this.currencyInfo.getPrecision();
        if (isInTax) {
            BigDecimal taxAmount = entryInfo.getTaxAmount();
            BigDecimal tax = entryInfo.getTax();
            taxAmount = this.validateNullValue(taxAmount);
            tax = this.validateNullValue(tax);
            if (taxAmount != null && tax != null) {
                BigDecimal actualTaxPrice = taxAmount.subtract(tax);
                actualTaxPrice = actualTaxPrice.setScale(scale, 4);
                entryInfo.setAmount(actualTaxPrice);
            }
        } else {
            BigDecimal price = entryInfo.getPrice();
            BigDecimal discountRate = entryInfo.getDiscountRate();
            BigDecimal qty = entryInfo.getQty();
            price = this.validateNullValue(price);
            discountRate = this.validateNullValue(discountRate);
            qty = this.validateNullValue(qty);
            BigDecimal one = new BigDecimal("1.0");
            BigDecimal oneHundred = new BigDecimal("100.0");
            BigDecimal amount = qty.multiply(price).multiply(one.subtract(discountRate.divide(oneHundred, 10, 4)));
            amount = amount.setScale(scale, 4);
            entryInfo.setAmount(amount);
        }
    }

    public void calLocalTax(PurInWarehsEntryInfo entryInfo, ExchangeRateInfo exchangeRateinfo) {
        int scale = this.baseCurrInfo.getPrecision();
        BigDecimal tax = entryInfo.getTax();
        BigDecimal exchangerate = exchangeRateinfo.getConvertRate();
        tax = this.validateNullValue(tax);
        exchangerate = this.validateNullValue(exchangerate);
        if (exchangeRateinfo != null && exchangerate.compareTo(BigDecimal.ZERO) != 0) {
            if (exchangeRateinfo.getExchangeAux().getConvertMode() == ConvertModeEnum.DIRECTEXCHANGERATE) {
                entryInfo.setLocalTax(tax.multiply(exchangerate).setScale(scale, 4));
            } else {
                entryInfo.setLocalTax(tax.divide(exchangerate, scale, 4));
            }
        }
    }

    public void calActualTaxPrice(PurInWarehsEntryInfo entryInfo) {
        BigDecimal discountRate = entryInfo.getDiscountRate();
        discountRate = this.validateNullValue(discountRate);
        BigDecimal zero = new BigDecimal("0.0");
        int scale = this.pricePrecision;
        if (discountRate == null || discountRate.compareTo(BigDecimal.ZERO) == 0) {
            BigDecimal taxPrice = entryInfo.getTaxPrice();
            taxPrice = this.validateNullValue(taxPrice);
            entryInfo.setActualTaxPrice(taxPrice);
        } else {
            BigDecimal taxAmount = entryInfo.getTaxAmount();
            BigDecimal qty = entryInfo.getQty();
            taxAmount = this.validateNullValue(taxAmount);
            qty = this.validateNullValue(qty);
            BigDecimal actualTaxPrice = SysConstant.BIGZERO;
            if (taxAmount != null && qty != null && qty.compareTo(zero) != 0) {
                actualTaxPrice = taxAmount.divide(qty, scale, 4);
                entryInfo.setActualTaxPrice(actualTaxPrice);
            }
        }
    }

    public void calActualPrice(PurInWarehsEntryInfo entryInfo) {
        int scale = this.currencyInfo.getPrecision();
        BigDecimal amount = entryInfo.getAmount();
        BigDecimal qty = entryInfo.getQty();
        BigDecimal discountRate = entryInfo.getDiscountRate();
        amount = this.validateNullValue(amount);
        qty = this.validateNullValue(qty);
        if ((discountRate = this.validateNullValue(discountRate)) == null || discountRate.compareTo(BigDecimal.ZERO) == 0) {
            BigDecimal price = entryInfo.getPrice();
            entryInfo.setActualPrice(price);
        } else if (amount != null && qty != null && qty.compareTo(BigDecimal.ZERO) != 0) {
            BigDecimal actualPrice = amount.divide(qty, scale, 4);
            entryInfo.setActualPrice(actualPrice);
        }
    }

    public void calPurchaseCost(PurInWarehsEntryInfo entryInfo, boolean isInTax, ExchangeRateInfo exchangeRateinfo) {
        int scale = this.baseCurrInfo.getPrecision();
        if (isInTax) {
            BigDecimal localTaxAmount = entryInfo.getLocalTaxAmount();
            BigDecimal localTax = entryInfo.getLocalTax();
            localTaxAmount = this.validateNullValue(localTaxAmount);
            localTax = this.validateNullValue(localTax);
            BigDecimal purchaseCost = SysConstant.BIGZERO;
            purchaseCost = localTaxAmount.subtract(localTax);
            purchaseCost = purchaseCost.setScale(scale, 4);
            entryInfo.setPurchaseCost(purchaseCost);
        } else {
            BigDecimal unitPurchaseCost = entryInfo.getUnitPurchaseCost();
            BigDecimal qty = entryInfo.getQty();
            unitPurchaseCost = this.validateNullValue(unitPurchaseCost);
            qty = this.validateNullValue(qty);
            BigDecimal purchaseCost = SysConstant.BIGZERO;
            purchaseCost = unitPurchaseCost.multiply(qty);
            entryInfo.setPurchaseCost(purchaseCost);
        }
    }

    public void calUnitPurchaseCost(PurInWarehsEntryInfo entryInfo, boolean isInTax, ExchangeRateInfo exchangeRateinfo) {
        int scale = this.pricePrecision;
        BigDecimal exchangerate = exchangeRateinfo.getConvertRate();
        if (isInTax) {
            BigDecimal purchaseCost = entryInfo.getPurchaseCost();
            BigDecimal qty = entryInfo.getQty();
            BigDecimal actualPrice = entryInfo.getActualPrice();
            purchaseCost = this.validateNullValue(purchaseCost);
            qty = this.validateNullValue(qty);
            actualPrice = this.validateNullValue(actualPrice);
            BigDecimal unitPurchaseCost = SysConstant.BIGZERO;
            if (exchangerate.compareTo(BigDecimal.ZERO) == 0) {
                entryInfo.setUnitPurchaseCost(actualPrice);
            } else if (purchaseCost != null && qty != null && qty.compareTo(BigDecimal.ZERO) != 0) {
                unitPurchaseCost = purchaseCost.divide(qty, scale, 4);
                entryInfo.setUnitPurchaseCost(unitPurchaseCost);
            }
        } else {
            BigDecimal actualPrice = entryInfo.getActualPrice();
            actualPrice = this.validateNullValue(actualPrice);
            if (exchangeRateinfo != null && exchangerate.compareTo(BigDecimal.ZERO) != 0) {
                if (exchangeRateinfo.getExchangeAux().getConvertMode() == ConvertModeEnum.DIRECTEXCHANGERATE) {
                    entryInfo.setUnitPurchaseCost(actualPrice.multiply(exchangerate).setScale(scale, 4));
                } else {
                    entryInfo.setUnitPurchaseCost(actualPrice.divide(exchangerate, scale, 4));
                }
            } else {
                entryInfo.setUnitPurchaseCost(actualPrice);
            }
        }
    }
}

