/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv.vrule.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.param.NantionalServiceFacadeFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.scm.im.inv.InvUpdateTypeFactory;
import com.kingdee.eas.basedata.scm.im.inv.InvUpdateTypeInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.scm.cal.StandardCostAdjBillInfo;
import com.kingdee.eas.scm.common.SCMBillBaseInfo;
import com.kingdee.eas.scm.common.SCMBillException;
import com.kingdee.eas.scm.framework.validator.bizrule.app.AbstractServerVRule;
import com.kingdee.eas.scm.im.inv.InvBillBaseEntryInfo;
import com.kingdee.eas.scm.im.inv.InvBillBaseInfo;
import com.kingdee.eas.scm.im.inv.PurReceivalBillInfo;
import com.kingdee.eas.scm.im.inv.PurReceivalEntryInfo;
import com.kingdee.eas.scm.util.datetime.DateTimeUtil;
import com.kingdee.eas.util.app.ContextUtil;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.HashMap;

public class CheckBizDateVRule
extends AbstractServerVRule {
    public CheckBizDateVRule(Context ctx) {
        super(ctx);
    }

    public boolean supports(Class<? extends IObjectValue> clazz) {
        return InvBillBaseInfo.class.isAssignableFrom(clazz);
    }

    public void validate(IObjectValue bean) throws BOSException, EASBizException {
        String uuid;
        BOSObjectType bosType;
        InvBillBaseInfo invBillBaseInfo = (InvBillBaseInfo)bean;
        if (invBillBaseInfo.getId() != null && (bosType = BOSUuid.read((String)(uuid = invBillBaseInfo.getId().toString())).getType()) != null && bosType.toString() != null && "BFBCAD51".equals(bosType.toString())) {
            return;
        }
        if (invBillBaseInfo.isIsInitBill()) {
            this.checkInitBizDate((IObjectValue)invBillBaseInfo);
        } else {
            this.checkBizDate((IObjectValue)invBillBaseInfo);
        }
    }

    protected boolean checkInitBizDate(IObjectValue model) throws EASBizException, BOSException {
        SCMBillBaseInfo aSCMBillBaseInfo = (SCMBillBaseInfo)model;
        if (aSCMBillBaseInfo.getBizDate() == null) {
            throw new SCMBillException(SCMBillException.BIZDATEISNULL);
        }
        CompanyOrgUnitInfo aCompanyOrgUnitInfo = this.getCompanyOrgUnit((IObjectValue)aSCMBillBaseInfo);
        if (aCompanyOrgUnitInfo != null && aCompanyOrgUnitInfo.getId() != null) {
            PeriodInfo currentPeriodInfo = SystemStatusCtrolUtils.getCurrentPeriod((Context)this.getCtx(), (SystemEnum)SystemEnum.INVENTORYMANAGEMENT, (CompanyOrgUnitInfo)aCompanyOrgUnitInfo);
            if (currentPeriodInfo == null) {
                throw new SCMBillException(SCMBillException.CURRENTPERIODISNULL);
            }
            if (!aSCMBillBaseInfo.getBizDate().before(currentPeriodInfo.getBeginDate())) {
                Object[] temp = new String[]{DateTimeUtil.getDateFmtString((Context)this.getCtx(), (String)currentPeriodInfo.getBeginDate().toString())};
                throw new SCMBillException(SCMBillException.BIZDATEAFTERPERIOD, temp);
            }
        }
        return true;
    }

    protected boolean checkBizDate(IObjectValue model) throws EASBizException, BOSException {
        return this.checkBizDate(model, this.getCompanyOrgUnit(model), false);
    }

    protected CompanyOrgUnitInfo getCompanyOrgUnit(IObjectValue model) throws BOSException, EASBizException {
        InvBillBaseInfo invBillBaseInfo = (InvBillBaseInfo)model;
        IObjectCollection iObjectCollection = invBillBaseInfo.getEntries();
        if (iObjectCollection != null && iObjectCollection.size() > 0) {
            InvBillBaseEntryInfo aInvBillBaseEntryInfo = (InvBillBaseEntryInfo)iObjectCollection.getObject(0);
            return (CompanyOrgUnitInfo)aInvBillBaseEntryInfo.get("companyOrgUnit");
        }
        return null;
    }

    private boolean checkBizDate(IObjectValue model, CompanyOrgUnitInfo couInfo, boolean isVirtualBill) throws EASBizException, BOSException {
        SCMBillBaseInfo aSCMBillBaseInfo = (SCMBillBaseInfo)model;
        if (aSCMBillBaseInfo.getBizDate() == null) {
            if (isVirtualBill) {
                throw new SCMBillException(SCMBillException.BIZDATEISNULL_VIRTUAL);
            }
            throw new SCMBillException(SCMBillException.BIZDATEISNULL);
        }
        if (couInfo != null && couInfo.getId() != null) {
            PeriodInfo currentPeriodInfo;
            if ("15F2BD83".equals(model.getBOSType().toString())) {
                PurReceivalEntryInfo purReceivalEntryInfo = null;
                InvUpdateTypeInfo invUpdateTypeInfo = null;
                boolean isUpdateInv = false;
                if (model instanceof PurReceivalBillInfo) {
                    for (int i = 0; i < ((PurReceivalBillInfo)model).getEntry().size(); ++i) {
                        purReceivalEntryInfo = ((PurReceivalBillInfo)model).getEntry().get(i);
                        if (purReceivalEntryInfo == null || purReceivalEntryInfo.getInvUpdateType() == null) continue;
                        invUpdateTypeInfo = purReceivalEntryInfo.getInvUpdateType();
                        if (invUpdateTypeInfo.get("invUpdateType") == null) {
                            invUpdateTypeInfo = InvUpdateTypeFactory.getLocalInstance((Context)this.getCtx()).getInvUpdateTypeInfo((IObjectPK)new ObjectUuidPK(invUpdateTypeInfo.getId()));
                        }
                        if (invUpdateTypeInfo.isIsNotUpdateInv()) continue;
                        isUpdateInv = true;
                    }
                    if (!isUpdateInv) {
                        return true;
                    }
                }
            }
            if ((currentPeriodInfo = SystemStatusCtrolUtils.getCurrentPeriod((Context)this.getCtx(), (SystemEnum)SystemEnum.INVENTORYMANAGEMENT, (CompanyOrgUnitInfo)couInfo)) == null) {
                if (isVirtualBill) {
                    throw new SCMBillException(SCMBillException.CURRENTPERIODISNULL_VIRTUAL, new Object[]{couInfo.getName()});
                }
                throw new SCMBillException(SCMBillException.CURRENTPERIODISNULLFORINV);
            }
            if (aSCMBillBaseInfo.getBizDate().before(currentPeriodInfo.getBeginDate())) {
                Calendar beginCalendar = Calendar.getInstance();
                beginCalendar.setTime(currentPeriodInfo.getBeginDate());
                Object[] temp = new String[1];
                StringBuffer sb = new StringBuffer();
                sb.append(beginCalendar.get(1));
                sb.append("-");
                int month = beginCalendar.get(2) + 1;
                if (month < 10) {
                    sb.append("0");
                }
                sb.append(month);
                sb.append("-");
                int date = beginCalendar.get(5);
                if (date < 10) {
                    sb.append("0");
                }
                sb.append(date);
                try {
                    HashMap nationMap = NantionalServiceFacadeFactory.getLocalInstance((Context)this.getCtx()).getNationalConfig(ContextUtil.getCurrentUserInfo((Context)this.getCtx()).getId().toString(), ContextUtil.getCurrentCtrlUnit((Context)this.getCtx()).getId().toString(), this.getCtx().getLocale().toString());
                    DateFormat format = (DateFormat)nationMap.get("dateFormat");
                    SimpleDateFormat dtFormat = new SimpleDateFormat("yyyy-MM-dd");
                    temp[0] = format.format(dtFormat.parse(sb.toString()));
                    if (isVirtualBill) {
                        throw new SCMBillException(SCMBillException.BIZDATEBEFOREPERIOD_VIRTUAL, new Object[]{couInfo.getName(), sb.toString()});
                    }
                    throw new SCMBillException(SCMBillException.BIZDATEBEFOREPERIOD, temp);
                }
                catch (ParseException e) {
                    throw new BOSException((Throwable)e);
                }
            }
            if (aSCMBillBaseInfo instanceof StandardCostAdjBillInfo) {
                aSCMBillBaseInfo.setYear(currentPeriodInfo.getPeriodYear());
                aSCMBillBaseInfo.setPeriod(currentPeriodInfo.getPeriodNumber());
            }
        }
        return true;
    }
}

