/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv.vrule.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.scm.framework.validator.bizrule.app.AbstractServerVRule;
import com.kingdee.eas.scm.im.inv.InvBillBaseEntryInfo;
import com.kingdee.eas.scm.im.inv.InvBillBaseInfo;
import com.kingdee.eas.scm.im.inv.InvBizException;
import com.kingdee.eas.scm.im.inv.ManufactureRecBillEntryCollection;
import com.kingdee.eas.scm.im.inv.ManufactureRecBillInfo;
import com.kingdee.eas.scm.im.inv.MaterialReqBillEntryCollection;
import com.kingdee.eas.scm.im.inv.MaterialReqBillInfo;
import java.math.BigDecimal;

public class CheckCostCenterOrgUnitVRule
extends AbstractServerVRule {
    public CheckCostCenterOrgUnitVRule(Context ctx) {
        super(ctx);
    }

    public boolean supports(Class<? extends IObjectValue> clazz) {
        return InvBillBaseInfo.class.isAssignableFrom(clazz);
    }

    public void validate(IObjectValue bean) throws BOSException, EASBizException {
        InvBillBaseInfo info = (InvBillBaseInfo)bean;
        if (null == info || info.getEntries() == null || info.getEntries().size() == 0) {
            return;
        }
        if (info.getTransactionType() == null || !info.getTransactionType().isIsManuCostCalculate()) {
            return;
        }
        InvBillBaseEntryInfo entry = (InvBillBaseEntryInfo)info.getEntries().getObject(0);
        CompanyOrgUnitInfo cou = entry.getCompanyOrgUnit();
        if (cou == null) {
            return;
        }
        boolean isStartCost = SystemStatusCtrolFactory.getLocalInstance((Context)this.getCtx()).isStart(1001, cou.getId().toString());
        if (!isStartCost) {
            return;
        }
        if (bean instanceof ManufactureRecBillInfo) {
            this.checkManufactureRecCostCenter((ManufactureRecBillInfo)info);
        } else if (bean instanceof MaterialReqBillInfo) {
            this.checkMaterialReqEntryCostCenter((MaterialReqBillInfo)info);
        } else {
            this.checkBillCostCenter(info);
        }
    }

    private void checkBillCostCenter(InvBillBaseInfo info) throws InvBizException {
        if (info.getCostCenterOrgUnit() == null) {
            throw new InvBizException(InvBizException.COSTCENTR_NULL);
        }
    }

    private void checkManufactureRecCostCenter(ManufactureRecBillInfo info) throws InvBizException {
        if (info.getCostCenterOrgUnit() == null) {
            throw new InvBizException(InvBizException.COSTCENTR_NULL);
        }
        ManufactureRecBillEntryCollection entryCol = info.getEntry();
        StringBuilder sb = new StringBuilder();
        int size = entryCol.size();
        for (int i = 0; i < size; ++i) {
            if (entryCol.get(i).getCostCenterOrgUnit() != null) continue;
            sb.append(i + 1).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
            throw new InvBizException(InvBizException.ENTRYCOSTCENTR_NULL, new Object[]{sb.toString()});
        }
    }

    private void checkMaterialReqEntryCostCenter(MaterialReqBillInfo info) throws InvBizException {
        MaterialReqBillEntryCollection entryCol = info.getEntry();
        StringBuilder sb = new StringBuilder();
        int size = entryCol.size();
        for (int i = 0; i < size; ++i) {
            if (entryCol.get(i).getQty().compareTo(BigDecimal.ZERO) == 0 || entryCol.get(i).getCostCenterOrgUnit() != null) continue;
            sb.append(i + 1).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
            throw new InvBizException(InvBizException.ENTRYCOSTCENTR_NULL, new Object[]{sb.toString()});
        }
    }
}

