/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv.vrule.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.eas.basedata.master.material.AccountType;
import com.kingdee.eas.basedata.master.material.MaterialCompanyInfoCollection;
import com.kingdee.eas.basedata.master.material.MaterialCompanyInfoFactory;
import com.kingdee.eas.basedata.master.material.MaterialCompanyInfoInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.scm.common.TransactionTypeInfo;
import com.kingdee.eas.basedata.scm.common.util.SCMBaseCommonUtil;
import com.kingdee.eas.basedata.scm.im.inv.InvUpdateTypeInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.scm.framework.dataloader.DataTypeEnum;
import com.kingdee.eas.scm.framework.validator.bizrule.app.AbstractServerVRule;
import com.kingdee.eas.scm.im.inv.InvBillBaseEntryInfo;
import com.kingdee.eas.scm.im.inv.InvBillBaseInfo;
import com.kingdee.eas.scm.im.inv.InvBizException;
import com.kingdee.eas.scm.util.constant.SCMConstant;
import java.math.BigDecimal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CheckEntryCostFieldVRule
extends AbstractServerVRule {
    private static final Logger logger = LoggerFactory.getLogger(CheckEntryCostFieldVRule.class);

    public CheckEntryCostFieldVRule(Context ctx) {
        super(ctx);
    }

    public boolean supports(Class<? extends IObjectValue> clazz) {
        return InvBillBaseInfo.class.isAssignableFrom(clazz);
    }

    public void validate(IObjectValue bean) throws BOSException, EASBizException {
        if (bean == null) {
            return;
        }
        InvBillBaseInfo info = (InvBillBaseInfo)bean;
        TransactionTypeInfo transactionTypeInfo = info.getTransactionType();
        if (null == transactionTypeInfo) {
            return;
        }
        if (!transactionTypeInfo.isIsCalculate()) {
            return;
        }
        if (info.getBillType() == null) {
            return;
        }
        IObjectCollection entryCol = info.getEntries();
        CompanyOrgUnitInfo cou = null;
        InvUpdateTypeInfo invUpdateType = null;
        int size = entryCol.size();
        for (int i = 0; i < size; ++i) {
            MaterialCompanyInfoInfo materialCompanyInfo;
            InvBillBaseEntryInfo entry = (InvBillBaseEntryInfo)entryCol.getObject(i);
            if (i == 0 && (cou = entry.getCompanyOrgUnit()) == null) break;
            if (entry.isIsPresent() || entry.getMaterial() == null || (materialCompanyInfo = this.getMaterialCompanyInfoInfo(entry.getMaterial().getId().toString(), cou.getId().toString())) == null) continue;
            if (AccountType.MOVE_ADD_AVERAGE.equals((Object)materialCompanyInfo.getAccountType()) && !info.getBizType().getId().toString().equals("mxmcXEczQ52MGxLV1Oyh9SQHQ1w=") && SCMBaseCommonUtil.isInWarehsBill((String)info.getBillType().getId().toString())) {
                invUpdateType = entry.getInvUpdateType();
                if (!invUpdateType.getStoreType().isIsForwardAmt()) {
                    return;
                }
                if (info.getBizType() != null && ("d8e80652-011a-1000-e000-04c5c0a812202407435C".equals(info.getBizType().getId().toString()) || "d8e80652-011b-1000-e000-04c5c0a812202407435C".equals(info.getBizType().getId().toString()))) {
                    return;
                }
                if (!(entry.getUnitActualCost() != null && entry.getUnitActualCost().compareTo(SCMConstant.BIGDECIMAL_ZERO) != 0 || this.isCheckEntryCost(info, entry.getBaseQty()))) {
                    throw new InvBizException(InvBizException.UNITFACTCOSTISNULL, new Object[]{entry.getSeq()});
                }
                if (entry.getActualCost() != null && entry.getActualCost().compareTo(SCMConstant.BIGDECIMAL_ZERO) != 0 || this.isCheckEntryCost(info, entry.getBaseQty())) continue;
                throw new InvBizException(InvBizException.FACTCOSTISNULL, new Object[]{entry.getSeq()});
            }
            if (!AccountType.STANDARDCOST.equals((Object)materialCompanyInfo.getAccountType()) || !SCMBaseCommonUtil.isOutWarehsBill((String)info.getBillType().getId().toString())) continue;
            if (!(entry.getActualCost() != null && entry.getStandardCost() != null || this.isCheckEntryCost(info, entry.getBaseQty()))) {
                throw new InvBizException(InvBizException.COSTNOTEQUAL, new String[]{String.valueOf(entry.getSeq()), String.valueOf(entry.getSeq())});
            }
            if (entry.getActualCost().compareTo(entry.getStandardCost()) == 0) continue;
            throw new InvBizException(InvBizException.COSTNOTEQUAL, new String[]{String.valueOf(entry.getSeq()), String.valueOf(entry.getSeq())});
        }
    }

    protected boolean isCountingBill(InvBillBaseInfo info) {
        boolean isCountingBill = false;
        if (info != null && info.getSourceBillType() != null && info.getSourceBillType().getId() != null && "50957179-0105-1000-e004-4152c0a812fd463ED552".equals(info.getSourceBillType().getId().toString())) {
            isCountingBill = true;
        }
        return isCountingBill;
    }

    private boolean isCheckEntryCost(InvBillBaseInfo info, BigDecimal baseQty) {
        return SCMConstant.BIGDECIMAL_ZERO.compareTo(baseQty) == 0 && this.isCountingBill(info);
    }

    private MaterialCompanyInfoInfo getMaterialCompanyInfoInfo(String materialId, String company) throws BOSException {
        if (this.getDataCache().contain(materialId + company, DataTypeEnum.MATERIAL_COMPANY)) {
            return (MaterialCompanyInfoInfo)this.getDataCache().get(materialId + company, DataTypeEnum.MATERIAL_COMPANY);
        }
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("id");
        selector.add("accountType");
        entityViewInfo.setSelector(selector);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("mateial.id", (Object)materialId));
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)company));
        entityViewInfo.setFilter(filter);
        MaterialCompanyInfoCollection col = MaterialCompanyInfoFactory.getLocalInstance((Context)this.getCtx()).getMaterialCompanyInfoCollection(entityViewInfo);
        if (col.size() > 0) {
            return col.get(0);
        }
        return null;
    }
}

