/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv.vrule.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.eas.basedata.scm.common.BillTypeInfo;
import com.kingdee.eas.basedata.scm.common.BizTypeInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.batchaction.BatchActionEnum;
import com.kingdee.eas.scm.common.SCMBillBaseInfo;
import com.kingdee.eas.scm.common.util.SCMUtils;
import com.kingdee.eas.scm.framework.validator.bizrule.app.AbstractServerVRule;
import com.kingdee.eas.scm.im.inv.InvBizException;
import com.kingdee.eas.scm.im.inv.app.InvServerUtils;

public class CheckFromSpecialBillVRule
extends AbstractServerVRule {
    private BatchActionEnum batchAction;

    public CheckFromSpecialBillVRule(Context ctx) {
        super(ctx);
    }

    public boolean supports(Class<? extends IObjectValue> clazz) {
        return SCMBillBaseInfo.class.isAssignableFrom(clazz);
    }

    public void validate(IObjectValue bean) throws BOSException, EASBizException {
        if (!BatchActionEnum.UNAUDIT.equals((Object)this.batchAction) || null == bean) {
            return;
        }
        if (bean.getBoolean("innerAudit")) {
            return;
        }
        Context ctx = this.getCtx();
        if (bean instanceof SCMBillBaseInfo) {
            this.check4MatAttrChange(ctx, (SCMBillBaseInfo)bean);
            this.check4MatAssembling(ctx, (SCMBillBaseInfo)bean);
            this.check4MatDisAssembling(ctx, (SCMBillBaseInfo)bean);
        }
    }

    protected void check4MatAttrChange(Context ctx, SCMBillBaseInfo value) throws BOSException, EASBizException {
        BizTypeInfo bizType = value.getBizType();
        if (bizType != null && this.isFromMatAttrBizType(bizType.getId().toString())) {
            throw new InvBizException(InvBizException.COMMON, new Object[]{InvServerUtils.getResource(ctx, "CANT_UNAUDIT_ISMATATTRINBILL")});
        }
    }

    protected void check4MatAssembling(Context ctx, SCMBillBaseInfo value) throws BOSException, EASBizException {
        BillTypeInfo sourceBillType = value.getSourceBillType();
        if (sourceBillType != null && "CJeXjSzrKhfgU0ETqMA1nkY+1VI=".equals(sourceBillType.getId().toString())) {
            throw new InvBizException(InvBizException.COMMON, new Object[]{SCMUtils.getResource((String)"com.kingdee.eas.scm.im.inv.WarehsManageResource", (String)"MATASSEMBLEBIZ_CANT_UNAUDIT", (String[])new String[]{""}, (Context)ctx)});
        }
    }

    protected void check4MatDisAssembling(Context ctx, SCMBillBaseInfo value) throws BOSException, EASBizException {
        BillTypeInfo sourceBillType = value.getSourceBillType();
        if (sourceBillType != null && "CJewLHpKKe/gU0ETqMDAp0Y+1VI=".equals(sourceBillType.getId().toString())) {
            throw new InvBizException(InvBizException.COMMON, new Object[]{SCMUtils.getResource((String)"com.kingdee.eas.scm.im.inv.WarehsManageResource", (String)"MATDISASSEMBLEBIZ_CANT_UNAUDIT", (String[])new String[]{""}, (Context)ctx)});
        }
    }

    protected boolean isFromMatAttrBizType(String bizTypeID) {
        return bizTypeID.equals("kXeVPjE9chDgQKjAYj1RYCQHQ1w=") || bizTypeID.equals("kXeVPjF4chDgQKjAYj1RYCQHQ1w=") || bizTypeID.equals("kXeVPjGzchDgQKjAYj1RYCQHQ1w=") || bizTypeID.equals("kXeUoXWkByTgQKjAYj1F6CQHQ1w=") || bizTypeID.equals("kXeUoXXfByTgQKjAYj1F6CQHQ1w=") || bizTypeID.equals("kXeVPjHuchDgQKjAYj1RYCQHQ1w=");
    }

    public BatchActionEnum getBatchAction() {
        return this.batchAction;
    }

    public void setBatchAction(String batchAction) throws BOSException, EASBizException {
        this.batchAction = BatchActionEnum.getBatchActionEnum((Context)this.getCtx(), (String)batchAction);
    }
}

