/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv.vrule.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.bot.BOTRelationFactory;
import com.kingdee.bos.metadata.bot.IBOTRelation;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.btp.BTPManagerFactory;
import com.kingdee.eas.base.btp.IBTPManager;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.scm.common.BillTypeInfo;
import com.kingdee.eas.basedata.scm.im.inv.InvException;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.scm.common.ISCMBillCommonFacade;
import com.kingdee.eas.scm.common.SCMBillCommonFacadeFactory;
import com.kingdee.eas.scm.common.SCMBillException;
import com.kingdee.eas.scm.common.app.SCMServerUtils;
import com.kingdee.eas.scm.framework.validator.bizrule.app.AbstractServerVRule;
import com.kingdee.eas.scm.im.inv.InvBillBaseInfo;
import com.kingdee.eas.scm.im.inv.InvBizException;
import com.kingdee.eas.scm.im.inv.MaterialReqBillEntryInfo;
import com.kingdee.eas.scm.im.inv.MaterialReqBillInfo;
import com.kingdee.eas.scm.im.inv.MoveInWarehsBillInfo;
import com.kingdee.eas.scm.im.inv.MoveIssueBillInfo;
import com.kingdee.eas.scm.im.inv.OtherIssueBillEntryInfo;
import com.kingdee.eas.scm.im.inv.OtherIssueBillInfo;
import com.kingdee.eas.scm.im.inv.PurInWarehsBillInfo;
import com.kingdee.eas.scm.im.inv.PurInWarehsEntryInfo;
import com.kingdee.eas.scm.im.inv.SaleIssueBillInfo;
import com.kingdee.eas.scm.im.inv.SaleIssueEntryCollection;
import com.kingdee.eas.scm.im.inv.SaleIssueEntryInfo;
import com.kingdee.eas.scm.im.inv.app.AutoPurInProcessor;
import com.kingdee.eas.scm.im.inv.app.AutoSaleIssueProcessor;
import com.kingdee.eas.scm.im.inv.vmi.VMISettleException;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Vector;

public class CheckINVUnAuditConditionVRule
extends AbstractServerVRule {
    public CheckINVUnAuditConditionVRule(Context ctx) {
        super(ctx);
    }

    public boolean supports(Class<? extends IObjectValue> clazz) {
        return InvBillBaseInfo.class.isAssignableFrom(clazz);
    }

    public void validate(IObjectValue bean) throws BOSException, EASBizException {
        assert (bean != null);
        InvBillBaseInfo invBillBaseInfo = (InvBillBaseInfo)bean;
        this.checkIsReversed(invBillBaseInfo);
        this.checkIsVouchered(invBillBaseInfo);
        this.checkIsHaveDestBills(invBillBaseInfo);
        this.checkIsHasExpenseApportionBills(invBillBaseInfo);
        this.check4SplitBill(invBillBaseInfo);
        this.checkIsTotalSaleFeeNotZero(invBillBaseInfo);
    }

    private void checkIsHasExpenseApportionBills(InvBillBaseInfo invBillBaseInfo) throws InvBizException, BOSException {
        if (invBillBaseInfo instanceof PurInWarehsBillInfo) {
            PurInWarehsBillInfo piwInfo = (PurInWarehsBillInfo)invBillBaseInfo;
            String purInwarehsBillId = piwInfo.getId().toString();
            if (null == purInwarehsBillId || "".equals(purInwarehsBillId.trim())) {
                return;
            }
            StringBuffer sql = new StringBuffer();
            sql.append("SELECT FID from T_CL_ExpenseApportionEntry where FSourceBillId = '").append(purInwarehsBillId).append("'");
            IRowSet rowSet = DbUtil.executeQuery((Context)this.getCtx(), (String)sql.toString());
            if (rowSet.size() > 0) {
                throw new InvBizException(InvBizException.INWARE_HAS_EXPENSEAPPORTION);
            }
        }
    }

    private void checkIsReversed(InvBillBaseInfo invBillBaseInfo) throws SCMBillException {
        if (invBillBaseInfo.isIsReversed()) {
            throw new SCMBillException(SCMBillException.ISREVERSED_CANNOTUNAUDIT, new Object[]{invBillBaseInfo.getNumber(), ""});
        }
    }

    private void checkIsVouchered(InvBillBaseInfo invBillBaseInfo) throws EASBizException, BOSException {
        if (invBillBaseInfo.isFiVouchered() || invBillBaseInfo.isPcVouchered()) {
            throw new SCMBillException(SCMBillException.CHECKISVOUCHEREDOK, new Object[]{invBillBaseInfo.getNumber(), ""});
        }
    }

    private void checkIsHaveDestBills(InvBillBaseInfo aInvBillBaseInfo) throws EASBizException, BOSException {
        if (aInvBillBaseInfo instanceof SaleIssueBillInfo) {
            SaleIssueBillInfo aSaleIssueBillInfo = (SaleIssueBillInfo)aInvBillBaseInfo;
            if (aSaleIssueBillInfo.isIsSysBill()) {
                throw new InvBizException(InvBizException.VISUALBILLNOTUNAUDIT, new Object[]{aInvBillBaseInfo.getNumber()});
            }
            AutoSaleIssueProcessor.getInstance().autoDelete(this.getCtx(), aInvBillBaseInfo);
            this._checkDestIncVisualBills(this.getCtx(), aInvBillBaseInfo);
        } else if (aInvBillBaseInfo instanceof PurInWarehsBillInfo) {
            PurInWarehsBillInfo piwInfo = (PurInWarehsBillInfo)aInvBillBaseInfo;
            PurInWarehsEntryInfo piwEntryInfo = null;
            if (piwInfo.isIsSysBill()) {
                if (piwInfo.getEntries() != null && piwInfo.getEntries().size() > 0 && (piwEntryInfo = (PurInWarehsEntryInfo)piwInfo.getEntries().getObject(0)).getTotalVmiSettleBaseQty().compareTo(BigDecimal.ZERO) != 0) {
                    throw new VMISettleException(VMISettleException.CHECK_VMI_UNAUDIT, new Object[]{aInvBillBaseInfo.getNumber()});
                }
                throw new InvBizException(InvBizException.VISUALBILLNOTUNAUDIT, new Object[]{aInvBillBaseInfo.getNumber()});
            }
            AutoPurInProcessor.getInstance().autoDelete(this.getCtx(), aInvBillBaseInfo);
            this._checkDestIncVisualBills(this.getCtx(), aInvBillBaseInfo);
        } else if (aInvBillBaseInfo instanceof MaterialReqBillInfo) {
            MaterialReqBillInfo matReqInfo = (MaterialReqBillInfo)aInvBillBaseInfo;
            MaterialReqBillEntryInfo matReqEntryInfo = null;
            if (matReqInfo.isIsSysBill() && matReqInfo.getEntries() != null && matReqInfo.getEntries().size() > 0 && (matReqEntryInfo = (MaterialReqBillEntryInfo)matReqInfo.getEntries().getObject(0)).getTotalVmiSettleBaseQty().compareTo(BigDecimal.ZERO) != 0) {
                throw new VMISettleException(VMISettleException.CHECK_VMI_UNAUDIT, new Object[]{aInvBillBaseInfo.getNumber()});
            }
            this._checkDestIncVisualBills4MaterialReq(this.getCtx(), aInvBillBaseInfo);
        } else {
            String billIdString;
            IBTPManager iBTPManager;
            if (aInvBillBaseInfo instanceof MoveIssueBillInfo) {
                MoveIssueBillInfo misInfo = (MoveIssueBillInfo)aInvBillBaseInfo;
                if (misInfo.isIsSysBill()) {
                    throw new InvBizException(InvBizException.VISUALBILLNOTUNAUDIT, new Object[]{aInvBillBaseInfo.getNumber()});
                }
            } else if (aInvBillBaseInfo instanceof MoveInWarehsBillInfo) {
                MoveInWarehsBillInfo miwInfo = (MoveInWarehsBillInfo)aInvBillBaseInfo;
                if (miwInfo.isIsSysBill()) {
                    throw new InvBizException(InvBizException.VISUALBILLNOTUNAUDIT, new Object[]{aInvBillBaseInfo.getNumber()});
                }
            } else if (aInvBillBaseInfo instanceof OtherIssueBillInfo) {
                OtherIssueBillInfo otherInfo = (OtherIssueBillInfo)aInvBillBaseInfo;
                OtherIssueBillEntryInfo otherEntryInfo = null;
                if (otherInfo.isIsSysBill() && otherInfo.getEntries() != null && otherInfo.getEntries().size() > 0 && (otherEntryInfo = (OtherIssueBillEntryInfo)otherInfo.getEntries().getObject(0)).getTotalVmiSettleBaseQty().compareTo(BigDecimal.ZERO) != 0) {
                    throw new VMISettleException(VMISettleException.CHECK_VMI_UNAUDIT, new Object[]{aInvBillBaseInfo.getNumber()});
                }
            }
            if ((iBTPManager = BTPManagerFactory.getLocalInstance((Context)this.getCtx())).ifHaveDestBills(billIdString = aInvBillBaseInfo.getId().toString())) {
                throw new SCMBillException(SCMBillException.HASDESTBILL_CANNOTUNAUDIT, new Object[]{aInvBillBaseInfo.getNumber()});
            }
        }
    }

    protected void _checkDestIncVisualBills(Context ctx, InvBillBaseInfo aInvBillBaseInfo) throws EASBizException, BOSException {
        String returnValue;
        String billId = aInvBillBaseInfo.getId().toString();
        String purInWarehsBosType = new PurInWarehsBillInfo().getBOSType().toString();
        String saleIssueBosType = new SaleIssueBillInfo().getBOSType().toString();
        IBOTRelation iBOTRelation = BOTRelationFactory.getLocalInstance((Context)ctx);
        ArrayList listDestIDs = iBOTRelation.getDestObjIdByDestType(billId, null);
        Vector<String> vecNoVirtualBill = new Vector<String>(0);
        Vector<String> vecPurInwareBill = new Vector<String>(0);
        Vector<String> vecSaleIssueBill = new Vector<String>(0);
        BOSObjectType destBosType = null;
        for (int i = 0; i < listDestIDs.size(); ++i) {
            String destID = (String)listDestIDs.get(i);
            destBosType = BOSUuid.read((String)destID).getType();
            if (purInWarehsBosType.equals(destBosType.toString())) {
                vecPurInwareBill.add(destID);
                continue;
            }
            if (saleIssueBosType.equals(destBosType.toString())) {
                vecSaleIssueBill.add(destID);
                continue;
            }
            vecNoVirtualBill.add(destID);
        }
        if (vecNoVirtualBill.size() > 0) {
            throw new SCMBillException(SCMBillException.HASDESTBILL_CANNOTUNAUDIT, new Object[]{aInvBillBaseInfo.getNumber(), ""});
        }
        Vector<String> vecPurVisualBill = new Vector(0);
        Vector<String> vecSaleVisualBill = new Vector(0);
        if (vecPurInwareBill.size() > 0) {
            vecPurVisualBill = this.getAndCheckVisualBill(ctx, "pur", vecNoVirtualBill, vecPurInwareBill);
        }
        aInvBillBaseInfo.put("purInWarehsVirtualBill", vecPurVisualBill);
        if (vecPurVisualBill.size() > 0 && null != (returnValue = this.checkIsCLoseVBill(ctx, "pur", vecPurVisualBill))) {
            if ("purDownBillChecked".endsWith(returnValue)) {
                throw new InvException(InvException.PURDOWNBILLCHECKED);
            }
            if ("purDownBillClosed".endsWith(returnValue)) {
                throw new InvException(InvException.PURDOWNBILLCLOSED);
            }
            if ("purDownBillWriteoff".endsWith(returnValue)) {
                throw new InvException(InvException.PURDOWNBILLWRITEOFF);
            }
        }
        if (vecSaleIssueBill.size() > 0) {
            vecSaleVisualBill = this.getAndCheckVisualBill(ctx, "sale", vecNoVirtualBill, vecSaleIssueBill);
        }
        if (vecSaleVisualBill.size() > 0 && null != (returnValue = this.checkIsCLoseVBill(ctx, "sale", vecSaleVisualBill)) && null != returnValue) {
            if ("saleDownBillChecked".endsWith(returnValue)) {
                throw new InvException(InvException.SALEDOWNBILLCHECKED);
            }
            if ("saleDownBillClosed".endsWith(returnValue)) {
                throw new InvException(InvException.SALEDOWNBILLCLOSED);
            }
            if ("saleDownBillWriteoff".endsWith(returnValue)) {
                throw new InvException(InvException.SALEDOWNBILLWRITEOFF);
            }
        }
        aInvBillBaseInfo.put("purSaleIssueVirtualBill", vecSaleVisualBill);
        if (vecNoVirtualBill.size() > 0) {
            throw new SCMBillException(SCMBillException.HASDESTBILL_CANNOTUNAUDIT, new Object[]{aInvBillBaseInfo.getNumber(), ""});
        }
    }

    protected void _checkDestIncVisualBills4MaterialReq(Context ctx, InvBillBaseInfo aInvBillBaseInfo) throws EASBizException, BOSException {
        String billId = aInvBillBaseInfo.getId().toString();
        String purInWarehsBosType = new PurInWarehsBillInfo().getBOSType().toString();
        String saleIssueBosType = new SaleIssueBillInfo().getBOSType().toString();
        String moveIssueBillBosType = new MoveIssueBillInfo().getBOSType().toString();
        String moveInWareBillBosType = new MoveInWarehsBillInfo().getBOSType().toString();
        IBOTRelation iBOTRelation = BOTRelationFactory.getLocalInstance((Context)ctx);
        ArrayList listDestIDs = iBOTRelation.getDestObjIdByDestType(billId, null);
        Vector<String> vecNoVirtualBill = new Vector<String>(0);
        Vector<String> vecPurInwareBill = new Vector<String>(0);
        Vector<String> vecSaleIssueBill = new Vector<String>(0);
        Vector<String> vecMoveInwareBill = new Vector<String>(0);
        Vector<String> vecMoveIssueBill = new Vector<String>(0);
        BOSObjectType destBosType = null;
        for (int i = 0; i < listDestIDs.size(); ++i) {
            String destID = (String)listDestIDs.get(i);
            destBosType = BOSUuid.read((String)destID).getType();
            if (purInWarehsBosType.equals(destBosType.toString())) {
                vecPurInwareBill.add(destID);
                continue;
            }
            if (saleIssueBosType.equals(destBosType.toString())) {
                vecSaleIssueBill.add(destID);
                continue;
            }
            if (moveIssueBillBosType.equals(destBosType.toString())) {
                vecMoveIssueBill.add(destID);
                continue;
            }
            if (moveInWareBillBosType.equals(destBosType.toString())) {
                vecMoveInwareBill.add(destID);
                continue;
            }
            vecNoVirtualBill.add(destID);
        }
        if (vecNoVirtualBill.size() > 0) {
            throw new SCMBillException(SCMBillException.HASDESTBILL_CANNOTUNAUDIT, new Object[]{aInvBillBaseInfo.getNumber(), ""});
        }
        Vector<Object> vecPurVisualBill = new Vector(0);
        Vector<Object> vecSaleVisualBill = new Vector(0);
        Vector<Object> vecMoveInVisualBill = new Vector(0);
        Vector<Object> vecMoveIssueVisualBill = new Vector(0);
        if (vecPurInwareBill.size() > 0) {
            vecPurVisualBill = this.getAndCheckVisualBill(ctx, "pur", vecNoVirtualBill, vecPurInwareBill);
        }
        aInvBillBaseInfo.put("purInWarehsVirtualBill", vecPurVisualBill);
        if (vecSaleIssueBill.size() > 0) {
            vecSaleVisualBill = this.getAndCheckVisualBill(ctx, "sale", vecNoVirtualBill, vecSaleIssueBill);
        }
        aInvBillBaseInfo.put("purSaleIssueVirtualBill", vecSaleVisualBill);
        if (vecMoveInwareBill.size() > 0) {
            vecMoveInVisualBill = this.getAndCheckVisualBill(ctx, "movein", vecNoVirtualBill, vecMoveInwareBill);
        }
        aInvBillBaseInfo.put("purMoveInVirtualBill", vecMoveInVisualBill);
        if (vecMoveIssueBill.size() > 0) {
            vecMoveIssueVisualBill = this.getAndCheckVisualBill(ctx, "moveissue", vecNoVirtualBill, vecMoveIssueBill);
        }
        aInvBillBaseInfo.put("purMoveIssueVirtualBill", vecMoveIssueVisualBill);
        if (vecNoVirtualBill.size() > 0) {
            throw new SCMBillException(SCMBillException.HASDESTBILL_CANNOTUNAUDIT, new Object[]{aInvBillBaseInfo.getNumber(), ""});
        }
        if (vecPurVisualBill != null && vecPurVisualBill.size() > 0) {
            String purInwarehsBillId = (String)vecPurVisualBill.get(0);
            this.checkPurInwareHasExpenseApportionRecord(ctx, purInwarehsBillId);
        }
    }

    private void checkPurInwareHasExpenseApportionRecord(Context ctx, String purInwarehsBillId) throws BOSException, InvBizException {
        if (null == purInwarehsBillId || "".equals(purInwarehsBillId.trim())) {
            return;
        }
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT FID from T_CL_ExpenseApportionEntry where FSourceBillId = '").append(purInwarehsBillId).append("'");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        if (rowSet.size() > 0) {
            throw new InvBizException(InvBizException.VIRTUAL_INWARE_HAS_EXPENSEAPPORTION);
        }
    }

    private String checkIsCLoseVBill(Context ctx, String purOrSale, Vector<String> virtrualBills) throws EASBizException, BOSException {
        String returnValue = null;
        StringBuffer sql = new StringBuffer();
        sql.append("Select A.FbizDate as FbizDate,A.FSTORAGEORGUNITID as FSTORAGEORGUNITID ,B.FWrittenOffQty  as FWrittenOffQty From ");
        if (purOrSale.equals("pur")) {
            sql.append("T_IM_PurInWarehsBill A inner join T_IM_PurInWarehsEntry B on A.FID = B.FParentID ");
        } else if (purOrSale.equals("sale")) {
            sql.append("T_IM_SaleIssueBill A inner join T_IM_SaleIssueEntry B on A.FID = B.FParentID ");
        }
        sql.append("where A.Fid ");
        sql.append(SCMServerUtils.getInID(virtrualBills));
        sql.append(" and b.FISPRESENT =0 ");
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            ISCMBillCommonFacade iSCMBillCommonFacade = SCMBillCommonFacadeFactory.getLocalInstance((Context)ctx);
            CompanyOrgUnitInfo cou = null;
            Date bizDate = null;
            String sou = null;
            BigDecimal writternOffQTY = SysConstant.BIGZERO;
            while (rs.next()) {
                bizDate = rs.getDate("FbizDate");
                sou = rs.getString("FSTORAGEORGUNITID");
                writternOffQTY = rs.getBigDecimal("FWrittenOffQty");
                if (bizDate == null) {
                    throw new SCMBillException(SCMBillException.BIZDATEISNULL);
                }
                cou = iSCMBillCommonFacade.getCompanyInfo(BOSUuid.read((String)sou));
                PeriodInfo periodInfo = PeriodUtils.getPeriodInfo((Context)ctx, (java.util.Date)bizDate, (CompanyOrgUnitInfo)cou);
                PeriodInfo curPeriodInfo = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.INVENTORYMANAGEMENT, (CompanyOrgUnitInfo)cou);
                if (writternOffQTY.compareTo(SysConstant.BIGZERO) > 0 && periodInfo.getPeriodYear() == curPeriodInfo.getPeriodYear() && periodInfo.getPeriodNumber() == curPeriodInfo.getPeriodNumber()) {
                    returnValue = purOrSale.equals("pur") ? "purDownBillWriteoff" : "saleDownBillWriteoff";
                } else if (SystemStatusCtrolUtils.isClose((Context)ctx, (SystemEnum)SystemEnum.INVENTORYMANAGEMENT, (CompanyOrgUnitInfo)cou) && periodInfo.getPeriodYear() == curPeriodInfo.getPeriodYear() && periodInfo.getPeriodNumber() == curPeriodInfo.getPeriodNumber()) {
                    returnValue = purOrSale.equals("pur") ? "purDownBillClosed" : "saleDownBillClosed";
                } else {
                    PeriodInfo currentPeriodInfo;
                    PeriodInfo vBillPeriod = PeriodUtils.getPeriodInfo((Context)ctx, (java.util.Date)bizDate, (CompanyOrgUnitInfo)cou, (SystemEnum)SystemEnum.INVENTORYMANAGEMENT);
                    if (PeriodUtils.PeriodCompare((PeriodInfo)vBillPeriod, (PeriodInfo)(currentPeriodInfo = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.INVENTORYMANAGEMENT, (CompanyOrgUnitInfo)cou))) || periodInfo.getPeriodYear() != curPeriodInfo.getPeriodYear() || periodInfo.getPeriodNumber() != curPeriodInfo.getPeriodNumber()) continue;
                    returnValue = purOrSale.equals("pur") ? "purDownBillChecked" : "saleDownBillChecked";
                }
                break;
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return returnValue;
    }

    protected Vector<String> getAndCheckVisualBill(Context ctx, String purOrSale, Vector<String> vNotVirtrual, Vector<String> vDestBill) throws EASBizException, BOSException {
        Vector<String> vecVisualBill = new Vector<String>(0);
        Connection conn = null;
        Statement stmt = null;
        StringBuffer sql = new StringBuffer();
        sql.append("Select Fid,Fnumber,FIsSysBill From ");
        if (purOrSale.equals("pur")) {
            sql.append("T_IM_PurInWarehsBill ");
        } else if (purOrSale.equals("sale")) {
            sql.append("T_IM_SaleIssueBill ");
        } else if (purOrSale.equals("movein")) {
            sql.append("T_IM_MoveInWarehsBill ");
        } else if (purOrSale.equals("moveissue")) {
            sql.append("T_IM_MoveIssueBill ");
        }
        sql.append("where Fid ");
        sql.append(SCMServerUtils.getInID(vDestBill));
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            stmt = conn.createStatement();
            ResultSet rs = stmt.executeQuery(sql.toString());
            String id = null;
            String number = null;
            int isSysBill = -1;
            while (rs.next()) {
                id = rs.getString("Fid");
                number = rs.getString("Fnumber");
                isSysBill = rs.getInt("FIsSysBill");
                if (isSysBill == 0) {
                    vNotVirtrual.add(id);
                    continue;
                }
                if (isSysBill != 1) continue;
                if (BTPManagerFactory.getLocalInstance((Context)ctx).ifHaveDestBills(id) && !this.isVMIBiz(ctx, purOrSale, id)) {
                    throw new InvBizException(InvBizException.VISUALBILHASDESTBILL, new Object[]{number});
                }
                vecVisualBill.add(id);
            }
        }
        catch (SQLException sqle) {
            try {
                throw new BOSException((Throwable)sqle);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(stmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)stmt, (Connection)conn);
        return vecVisualBill;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isVMIBiz(Context ctx, String purOrSale, String billId) throws EASBizException, BOSException {
        String bosType = null;
        if (purOrSale.equals("sale")) {
            bosType = "CC3E933B";
        } else if (purOrSale.equals("moveissue")) {
            bosType = "71D272F1";
        }
        if (bosType != null) {
            StringBuffer sql = new StringBuffer();
            sql.append("select 1 from t_bot_relation where FSrcEntityID = '").append(bosType).append("'");
            sql.append(" and FSrcObjectID = '").append(billId).append("'");
            sql.append(" and FDestEntityID <> '").append("783061E3").append("'");
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            try {
                if (rs.size() > 0) {
                    boolean bl = false;
                    return bl;
                }
            }
            finally {
                SQLUtils.cleanup((ResultSet)rs);
            }
            sql.setLength(0);
            sql.append("select 1 from t_bot_relation rel ");
            sql.append(" inner join T_IM_PURINWAREHSBILL purin on purin.fid = rel.FDestObjectID");
            sql.append(" where rel.FSrcEntityID = '").append(bosType).append("'");
            sql.append(" and rel.FDestEntityID = '").append("783061E3").append("'");
            sql.append(" and rel.FSrcObjectID = '").append(billId).append("'");
            sql.append(" and purin.FIsSysBill <> 1");
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            try {
                if (rowSet.size() > 0) {
                    boolean bl = false;
                    return bl;
                }
            }
            finally {
                SQLUtils.cleanup((ResultSet)rowSet);
            }
            sql.setLength(0);
            sql.append("select purinwarehs.FNumber as FNumber from t_bot_relation relation inner join T_IM_PURINWAREHSBILL purinwarehs on  purinwarehs.fid = relation.FSrcObjectID ");
            sql.append(" where relation.FSrcEntityID = '").append("783061E3").append("'");
            sql.append(" and relation.FDestObjectID is not null and relation.FSrcObjectID in ");
            sql.append(" (select purin.FID from t_bot_relation rel ");
            sql.append(" inner join T_IM_PURINWAREHSBILL purin on purin.fid = rel.FDestObjectID");
            sql.append(" where rel.FSrcEntityID = '").append(bosType).append("'");
            sql.append(" and rel.FDestEntityID = '").append("783061E3").append("'");
            sql.append(" and rel.FSrcObjectID = '").append(billId).append("'");
            sql.append(" and purin.FIsSysBill = 1)");
            IRowSet iRowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            try {
                if (iRowSet.next()) {
                    String number = iRowSet.getString("FNumber");
                    throw new InvBizException(InvBizException.VISUALBILHASDESTBILL, new Object[]{number});
                }
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
            finally {
                SQLUtils.cleanup((ResultSet)iRowSet);
            }
            return true;
        }
        return false;
    }

    private void check4SplitBill(InvBillBaseInfo info) throws BOSException, InvBizException {
        String billNumber;
        BillTypeInfo billType;
        if (!(info instanceof SaleIssueBillInfo) && !(info instanceof PurInWarehsBillInfo)) {
            return;
        }
        String[] saleBillTypes = new String[]{"510b6503-0105-1000-e000-0113c0a812fd463ED552", "Eg5BUQEVEADgAAABwKgOEEY+1VI=", "50957179-0105-1000-e008-8152c0a812fd463ED552"};
        List<String> billTypeList = Arrays.asList(saleBillTypes);
        if (info instanceof PurInWarehsBillInfo) {
            String[] purBillTypes = new String[]{"510b6503-0105-1000-e000-010bc0a812fd463ED552", "Eg5BUQEVEADgAAABwKgOEEY+1VI=", "50957179-0105-1000-e006-6152c0a812fd463ED552"};
            billTypeList = Arrays.asList(purBillTypes);
        }
        if ((billType = (BillTypeInfo)info.getEntries().getObject(0).getObjectValue("sourceBillType")) == null || !billTypeList.contains(billType.getId().toString())) {
            return;
        }
        String table = "T_IM_SALEISSUEBILL";
        String tableEntry = "T_IM_SALEISSUEENTRY";
        if (info instanceof PurInWarehsBillInfo) {
            table = "T_IM_PURINWAREHSBILL";
            tableEntry = "T_IM_PURINWAREHSENTRY";
        }
        if ((billNumber = info.getNumber()).contains("_C00")) {
            billNumber = billNumber.substring(0, billNumber.lastIndexOf("_C00"));
        }
        StringBuffer sql = new StringBuffer();
        sql.append("select count(en.FID) as num from " + tableEntry + " en ");
        sql.append("inner join " + table + " b on en.FPARENTID = b.FID ");
        sql.append("inner join T_IM_SALEISSUEENTRY en1 on en.FID = en1.FSOURCEBILLENTRYID  ");
        sql.append("inner join T_IM_SALEISSUEBILL b1 on en1.FPARENTID = b1.FID ");
        sql.append("where b1.FISSYSBILL = 1 and B.FNUMBER = ? and en.FQTY != en1.FQTY  ");
        IRowSet rs = DbUtil.executeQuery((Context)this.getCtx(), (String)sql.toString(), (Object[])new Object[]{billNumber});
        try {
            if (rs.next() && rs.getInt("num") > 0) {
                throw new InvBizException(InvBizException.EXIST_SPLIT_SYSBILL);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    private void checkIsTotalSaleFeeNotZero(InvBillBaseInfo invBillBaseInfo) throws EASBizException, BOSException {
        SaleIssueBillInfo saleIssueBillInfo;
        SaleIssueEntryCollection entry;
        if (invBillBaseInfo instanceof SaleIssueBillInfo && null != (entry = (saleIssueBillInfo = (SaleIssueBillInfo)invBillBaseInfo).getEntry()) && entry.size() > 0) {
            for (int i = 0; i < entry.size(); ++i) {
                SaleIssueEntryInfo saleIssueEntryInfo = entry.get(i);
                if (null == saleIssueEntryInfo.getTotalSaleFee() || BigDecimal.ZERO.compareTo(saleIssueEntryInfo.getTotalSaleFee()) == 0) continue;
                throw new InvBizException(InvBizException.SALEISSUEISSHARE, new Object[]{saleIssueBillInfo.getNumber()});
            }
        }
    }
}

