/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv.vrule.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.eas.basedata.master.material.IMaterialInventory;
import com.kingdee.eas.basedata.master.material.MaterialInventoryCollection;
import com.kingdee.eas.basedata.master.material.MaterialInventoryFactory;
import com.kingdee.eas.basedata.master.material.MaterialInventoryInfo;
import com.kingdee.eas.basedata.scm.common.TransactionTypeInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.scm.framework.dataloader.DataTypeEnum;
import com.kingdee.eas.scm.framework.validator.bizrule.app.AbstractServerVRule;
import com.kingdee.eas.scm.im.inv.InvBillBaseEntryInfo;
import com.kingdee.eas.scm.im.inv.InvBillBaseInfo;
import com.kingdee.eas.scm.im.inv.InvBizException;
import com.kingdee.eas.scm.im.inv.MaterialReqBillInfo;
import com.kingdee.eas.scm.im.inv.PurReceivalEntryInfo;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CheckLotAndExpiryDateVRule
extends AbstractServerVRule {
    private static final Logger logger = LoggerFactory.getLogger(CheckLotAndExpiryDateVRule.class);

    public CheckLotAndExpiryDateVRule(Context ctx) {
        super(ctx);
    }

    public boolean supports(Class<? extends IObjectValue> clazz) {
        return InvBillBaseInfo.class.isAssignableFrom(clazz);
    }

    public void validate(IObjectValue bean) throws BOSException, EASBizException {
        InvBillBaseInfo invBillInfo = (InvBillBaseInfo)bean;
        if (invBillInfo == null || invBillInfo.getStorageOrgUnit() == null) {
            return;
        }
        boolean isMaterialReqBill = false;
        if (invBillInfo instanceof MaterialReqBillInfo) {
            isMaterialReqBill = true;
        }
        IObjectCollection entrys = invBillInfo.getEntries();
        ArrayList<InvBillBaseEntryInfo> entryList = new ArrayList<InvBillBaseEntryInfo>();
        boolean isUpdateInv = this.isUpdateInv(invBillInfo);
        if (invBillInfo.getBillType().getId().toString().equals("XlazxwEREADgAAAEwKgSxUY+1VI=")) {
            isUpdateInv = false;
        }
        int len = entrys.size();
        for (int j = 0; j < len; ++j) {
            MaterialInventoryInfo materilInvInfo;
            InvBillBaseEntryInfo entry = (InvBillBaseEntryInfo)entrys.getObject(j);
            if (entry.getMaterial() == null || isMaterialReqBill && (entry.getQty() == null || entry.getQty().compareTo(BigDecimal.ZERO) == 0) || null == (materilInvInfo = this.getMaterialInventoryInfo(entry.getMaterial().getId().toString(), invBillInfo.getStorageOrgUnit().getId().toString()))) continue;
            if (isUpdateInv && materilInvInfo.isIsLotNumber() && StringUtils.isEmpty((String)entry.getLot())) {
                throw new InvBizException(InvBizException.COSTADJUST_LOT_NULL, new String[]{String.valueOf(j + 1)});
            }
            if (!isUpdateInv || !materilInvInfo.isIsPeriodValid()) continue;
            if (entry.getMfg() == null || entry.getExp() == null) {
                throw new InvBizException(InvBizException.MATERIAL_IS_PERIODVALID_NOTNULL, new String[]{String.valueOf(j + 1)});
            }
            entryList.add(entry);
        }
        int count = entryList.size();
        for (int k = 0; k < count; ++k) {
            InvBillBaseEntryInfo billEntry = (InvBillBaseEntryInfo)entryList.get(k);
            for (int z = k; z < entryList.size() - 1; ++z) {
                if (!billEntry.getLot().equals(((InvBillBaseEntryInfo)entryList.get(z)).getLot()) || !billEntry.getMaterial().getId().toString().equals(((InvBillBaseEntryInfo)entryList.get(z)).getMaterial().getId().toString()) || billEntry.getMfg().equals(((InvBillBaseEntryInfo)entryList.get(z)).getMfg()) && billEntry.getExp().equals(((InvBillBaseEntryInfo)entryList.get(z)).getExp())) continue;
                throw new InvBizException(InvBizException.DUPLICATELOTSALL, new String[]{String.valueOf(z + 1)});
            }
        }
    }

    private MaterialInventoryInfo getMaterialInventoryInfo(String materialId, String souId) throws BOSException {
        String key = materialId + souId;
        if (this.getDataCache().contain(key, DataTypeEnum.MATERIAL_INVENTORY)) {
            return (MaterialInventoryInfo)this.getDataCache().get(materialId + souId, DataTypeEnum.MATERIAL_INVENTORY);
        }
        IMaterialInventory iMaterialInventory = MaterialInventoryFactory.getLocalInstance((Context)this.getCtx());
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("material.id", (Object)materialId));
        filter.getFilterItems().add(new FilterItemInfo("OrgUnit.id", (Object)souId));
        view.setFilter(filter);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("id");
        selector.add("isLotNumber");
        selector.add("isPeriodValid");
        view.setSelector(selector);
        MaterialInventoryCollection col = iMaterialInventory.getMaterialInventoryCollection(view);
        if (null != col && col.size() > 0) {
            this.getDataCache().put(key, (Object)col.get(0), DataTypeEnum.MATERIAL_INVENTORY);
            return col.get(0);
        }
        return null;
    }

    private boolean isUpdateInv(InvBillBaseInfo invBillInfo) {
        String billTypeID = invBillInfo.getBillType().getId().toString();
        if (!"50957179-0105-1000-e000-0157c0a812fd463ED552".equals(billTypeID)) {
            return true;
        }
        TransactionTypeInfo tti = invBillInfo.getTransactionType();
        if (tti == null) {
            return true;
        }
        PurReceivalEntryInfo entryInfo = (PurReceivalEntryInfo)invBillInfo.getEntries().getObject(0);
        return !entryInfo.getInvUpdateType().isIsNotUpdateInv();
    }
}

