/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv.vrule.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.eas.basedata.master.material.IMaterialInventory;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.MaterialInventoryCollection;
import com.kingdee.eas.basedata.master.material.MaterialInventoryFactory;
import com.kingdee.eas.basedata.master.material.MaterialInventoryInfo;
import com.kingdee.eas.basedata.master.material.UsedStatusEnum;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.scm.framework.dataloader.DataTypeEnum;
import com.kingdee.eas.scm.framework.validator.bizrule.app.AbstractServerVRule;
import com.kingdee.eas.scm.im.inv.InvBillBaseEntryInfo;
import com.kingdee.eas.scm.im.inv.InvBillBaseInfo;
import com.kingdee.eas.scm.im.inv.InvBizException;
import com.kingdee.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CheckMaterialInventoryVRule
extends AbstractServerVRule {
    private static final Logger logger = LoggerFactory.getLogger(CheckMaterialInventoryVRule.class);

    public CheckMaterialInventoryVRule() {
        this(null);
    }

    public CheckMaterialInventoryVRule(Context ctx) {
        super(ctx);
    }

    public boolean supports(Class<? extends IObjectValue> clazz) {
        return InvBillBaseInfo.class.isAssignableFrom(clazz);
    }

    public void validate(IObjectValue bean) throws BOSException, EASBizException {
        assert (bean != null);
        InvBillBaseInfo invInfo = (InvBillBaseInfo)bean;
        if (invInfo.getStorageOrgUnit() == null) {
            return;
        }
        IObjectCollection col = invInfo.getEntries();
        String souId = invInfo.getStorageOrgUnit().getId().toString();
        StringBuilder errors = new StringBuilder();
        int size = col.size();
        for (int i = 0; i < size; ++i) {
            MaterialInventoryInfo miInfo;
            InvBillBaseEntryInfo entry = (InvBillBaseEntryInfo)col.getObject(i);
            MaterialInfo materialInfo = entry.getMaterial();
            if (materialInfo == null || null != (miInfo = this.getMaterialInventoryInfo(materialInfo.getId().toString(), souId))) continue;
            errors.append(materialInfo.getNumber()).append(",");
        }
        if (errors.length() > 0) {
            errors.setLength(errors.length() - 1);
            throw new InvBizException(InvBizException.MATERIAL_INVENTORY_UNAPPROVE, new Object[]{errors.toString()});
        }
    }

    private MaterialInventoryInfo getMaterialInventoryInfo(String materialId, String souId) throws BOSException {
        assert (!StringUtils.isEmpty((String)souId));
        assert (StringUtils.isEmpty((String)materialId));
        if (this.getDataCache().contain(materialId + souId, DataTypeEnum.MATERIAL_INVENTORY)) {
            return (MaterialInventoryInfo)this.getDataCache().get(materialId + souId, DataTypeEnum.MATERIAL_INVENTORY);
        }
        IMaterialInventory iMaterialInventory = MaterialInventoryFactory.getLocalInstance((Context)this.getCtx());
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("material.id", (Object)materialId));
        filter.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)souId));
        filter.getFilterItems().add(new FilterItemInfo("status", (Object)UsedStatusEnum.APPROVED));
        entityViewInfo.setFilter(filter);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("id");
        selector.add("number");
        selector.add("isSequenceNo");
        entityViewInfo.setSelector(selector);
        MaterialInventoryCollection col = iMaterialInventory.getMaterialInventoryCollection(entityViewInfo);
        MaterialInventoryInfo info = null;
        if (col != null && col.size() > 0) {
            info = col.get(0);
        }
        this.getDataCache().put(materialId + souId, (Object)info, DataTypeEnum.MATERIAL_INVENTORY);
        return info;
    }
}

