/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv.vrule.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.scm.common.TransactionTypeFactory;
import com.kingdee.eas.basedata.scm.common.TransactionTypeInfo;
import com.kingdee.eas.basedata.scm.im.inv.InvUpdateTypeInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.dynbusiness.util.BusinessProcessUtil;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.scm.common.SCMBillException;
import com.kingdee.eas.scm.common.util.SCMUtils;
import com.kingdee.eas.scm.framework.validator.bizrule.app.AbstractServerVRule;
import com.kingdee.eas.scm.im.inv.IInvBillBaseEntry;
import com.kingdee.eas.scm.im.inv.InvBillBaseEntryInfo;
import com.kingdee.eas.scm.im.inv.InvBillBaseInfo;
import com.kingdee.eas.scm.im.inv.InvBizException;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CheckReversedBillVRule
extends AbstractServerVRule {
    private static final Logger logger = LoggerFactory.getLogger(CheckReversedBillVRule.class);

    public CheckReversedBillVRule(Context ctx) {
        super(ctx);
    }

    public boolean supports(Class<? extends IObjectValue> clazz) {
        return InvBillBaseInfo.class.isAssignableFrom(clazz);
    }

    public void validate(IObjectValue bean) throws BOSException, EASBizException {
        CompanyOrgUnitInfo companyOrgUnitInfo;
        InvBillBaseInfo invBillBaseInfo = (InvBillBaseInfo)bean;
        if (invBillBaseInfo == null || !invBillBaseInfo.isIsReversed()) {
            return;
        }
        if (invBillBaseInfo.getSourceBillType() == null) {
            throw new InvBizException(InvBizException.INV_NOSRCBILL);
        }
        String sourceBillId = null;
        IObjectCollection entryCol = invBillBaseInfo.getEntries();
        if (entryCol == null || entryCol.size() == 0) {
            return;
        }
        InvBillBaseEntryInfo entryInfo = (InvBillBaseEntryInfo)entryCol.getObject(0);
        if (entryInfo != null && entryInfo.getSourceBillId() != null) {
            sourceBillId = entryInfo.getSourceBillId();
        }
        if (!StringUtils.isEmpty(sourceBillId) && invBillBaseInfo.getBizDate() != null) {
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("number"));
            sic.add(new SelectorItemInfo("bizDate"));
            InvBillBaseInfo sourceBillInfo = (InvBillBaseInfo)BusinessProcessUtil.getValueByBosType((Context)this.getCtx(), (IObjectPK)new ObjectUuidPK(sourceBillId), (SelectorItemCollection)sic);
            if (sourceBillInfo != null && sourceBillInfo.getBizDate() != null && invBillBaseInfo.getBizDate().getTime() < sourceBillInfo.getBizDate().getTime()) {
                throw new InvBizException(InvBizException.BIZDATEBEFORESOURCEBILL, new Object[]{"[" + sourceBillInfo.getBizDate().toString() + "]"});
            }
        }
        if ((companyOrgUnitInfo = entryInfo.getCompanyOrgUnit()) != null) {
            PeriodInfo currentPeriodInfo = this.getCurrentPeriod(companyOrgUnitInfo);
            if (currentPeriodInfo == null) {
                throw new SCMBillException(SCMBillException.CURRENTPERIODISNULL);
            }
            TransactionTypeInfo transactionType = invBillBaseInfo.getTransactionType();
            InvUpdateTypeInfo invUpdateTypeInfo = TransactionTypeFactory.getLocalInstance((Context)this.getCtx()).getDefaultInvUpdateType(transactionType.getId().toString());
            if (invUpdateTypeInfo != null && invUpdateTypeInfo.isIsNotUpdateInv() && !invBillBaseInfo.isIsInitBill() && invBillBaseInfo.getBizDate().before(currentPeriodInfo.getBeginDate())) {
                throw new InvBizException(InvBizException.BIZDATEBEFORECURRENTPERIOD, new Object[]{"[" + currentPeriodInfo.getBeginDate().toString() + "]"});
            }
        }
        for (int j = 0; j < entryCol.size(); ++j) {
            BigDecimal realCountervail;
            entryInfo = (InvBillBaseEntryInfo)entryCol.getObject(j);
            if (entryInfo.getSourceBillEntryId() == null) continue;
            InvBillBaseEntryInfo sEntry = this.getSourceEntryInfo((IObjectPK)new ObjectUuidPK(entryInfo.getSourceBillEntryId()), entryInfo.getBOSType());
            BigDecimal bigDecimal = realCountervail = sEntry.getReverseQty() == null ? sEntry.getQty().abs() : sEntry.getQty().abs().subtract(sEntry.getReverseQty());
            if (entryInfo.getQty() == null || entryInfo.getQty().compareTo(realCountervail) <= 0) continue;
            String stringNo = SCMUtils.getResource((String)"com.kingdee.eas.scm.im.inv.WarehsManageResource", (String)"No", (Context)this.getCtx());
            String stringRow = SCMUtils.getResource((String)"com.kingdee.eas.scm.im.inv.WarehsManageResource", (String)"Row", (Context)this.getCtx());
            throw new InvBizException(InvBizException.OFFSETQTYGREATERTHANOLD, new String[]{invBillBaseInfo.getNumber() + stringNo + entryInfo.getSeq() + stringRow});
        }
    }

    private InvBillBaseEntryInfo getSourceEntryInfo(IObjectPK sourcePk, BOSObjectType bosType) throws EASBizException, BOSException {
        IInvBillBaseEntry iInvBillBaseEntry = (IInvBillBaseEntry)BOSObjectFactory.createBOSObject((Context)this.getCtx(), (BOSObjectType)bosType);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("id");
        selector.add("qty");
        selector.add("reverseQty");
        return (InvBillBaseEntryInfo)iInvBillBaseEntry.getSCMBillEntryBaseInfo(sourcePk, selector);
    }

    private PeriodInfo getCurrentPeriod(CompanyOrgUnitInfo companyOrgUnitInfo) throws EASBizException, BOSException {
        PeriodInfo period = SystemStatusCtrolUtils.getCurrentPeriod((Context)this.getCtx(), (SystemEnum)SystemEnum.INVENTORYMANAGEMENT, (CompanyOrgUnitInfo)companyOrgUnitInfo);
        return period;
    }
}

