/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv.vrule.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.IStorageOrgUnit;
import com.kingdee.eas.basedata.org.StorageOrgUnitFactory;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.basedata.scm.common.BizTypeInfo;
import com.kingdee.eas.basedata.scm.common.ITransactionType;
import com.kingdee.eas.basedata.scm.common.TransactionTypeFactory;
import com.kingdee.eas.basedata.scm.common.TransactionTypeInfo;
import com.kingdee.eas.basedata.scm.im.inv.ISOAccreditWH;
import com.kingdee.eas.basedata.scm.im.inv.InvUpdateTypeInfo;
import com.kingdee.eas.basedata.scm.im.inv.SOAccreditWHFactory;
import com.kingdee.eas.basedata.scm.im.inv.WarehouseInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.scm.cal.CostAdjuestCreateTypeEnum;
import com.kingdee.eas.scm.framework.dataloader.DataTypeEnum;
import com.kingdee.eas.scm.framework.validator.bizrule.app.AbstractServerVRule;
import com.kingdee.eas.scm.im.inv.InvBillBaseEntryInfo;
import com.kingdee.eas.scm.im.inv.InvBillBaseInfo;
import com.kingdee.eas.scm.im.inv.InvBizException;
import com.kingdee.eas.scm.im.inv.StockTransferBillEntryCollection;
import com.kingdee.eas.scm.im.inv.StockTransferBillEntryInfo;
import com.kingdee.eas.scm.im.inv.StockTransferBillInfo;
import com.kingdee.eas.scm.im.inv.TransferOrderBillEntryCollection;
import com.kingdee.eas.scm.im.inv.TransferOrderBillEntryInfo;
import com.kingdee.eas.scm.im.inv.TransferOrderBillInfo;
import java.util.HashSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CheckStorageAndWarehouseIsStartedVRule
extends AbstractServerVRule {
    private static final Logger logger = LoggerFactory.getLogger(CheckStorageAndWarehouseIsStartedVRule.class);

    public CheckStorageAndWarehouseIsStartedVRule(Context ctx) {
        super(ctx);
    }

    public boolean supports(Class<? extends IObjectValue> clazz) {
        return InvBillBaseInfo.class.isAssignableFrom(clazz) || StockTransferBillInfo.class.isAssignableFrom(clazz) || TransferOrderBillInfo.class.isAssignableFrom(clazz);
    }

    public void validate(IObjectValue bean) throws BOSException, EASBizException {
        if (bean instanceof InvBillBaseInfo) {
            this.checkIsStarted((InvBillBaseInfo)bean);
        } else if (bean instanceof StockTransferBillInfo) {
            this.checkIsStarted((StockTransferBillInfo)bean);
        } else if (bean instanceof TransferOrderBillInfo) {
            this.checkIsStarted((TransferOrderBillInfo)bean);
        }
    }

    protected void checkIsStarted(InvBillBaseInfo billInfo) throws BOSException, EASBizException {
        TransactionTypeInfo tti = billInfo.getTransactionType();
        IObjectCollection entrys = billInfo.getEntries();
        boolean isManuAdjustBill = false;
        if (tti == null && billInfo.getBillType() != null && "3a3b5446-0106-1000-e000-01bcc0a812e6463ED552".equals(billInfo.getBillType().getId().toString())) {
            isManuAdjustBill = CostAdjuestCreateTypeEnum.USERINPUT.equals(billInfo.get("createType"));
        }
        if (tti == null && !isManuAdjustBill) {
            return;
        }
        if (billInfo.isIsInitBill()) {
            return;
        }
        StringBuilder msg = new StringBuilder();
        InvUpdateTypeInfo invUpdateTypeInfo = null;
        if (entrys.size() > 0) {
            invUpdateTypeInfo = ((InvBillBaseEntryInfo)entrys.getObject(0)).getInvUpdateType();
        }
        if ((isManuAdjustBill || invUpdateTypeInfo != null && !invUpdateTypeInfo.isIsNotUpdateInv()) && entrys != null && entrys.size() > 0) {
            InvBillBaseEntryInfo aInvBillBaseEntryInfo = (InvBillBaseEntryInfo)entrys.getObject(0);
            String storageOrgUnitID = "";
            if (billInfo.getStorageOrgUnit() != null) {
                storageOrgUnitID = billInfo.getStorageOrgUnit().getId().toString();
                HashSet<BOSUuid> vctSou = new HashSet<BOSUuid>();
                for (int i = 0; i < entrys.size(); ++i) {
                    aInvBillBaseEntryInfo = (InvBillBaseEntryInfo)entrys.getObject(i);
                    if (aInvBillBaseEntryInfo.getWarehouse() == null) continue;
                    vctSou.add(aInvBillBaseEntryInfo.getWarehouse().getId());
                }
                Object[] warehouses = null;
                if (vctSou.size() > 0) {
                    if (tti.getBillType() == null) {
                        ITransactionType itt = TransactionTypeFactory.getLocalInstance((Context)this.getCtx());
                        tti = itt.getTransactionTypeInfo((IObjectPK)new ObjectUuidPK(tti.getId()));
                    }
                    ISOAccreditWH iSOAccreditWH = SOAccreditWHFactory.getLocalInstance((Context)this.getCtx());
                    warehouses = !isManuAdjustBill && "528d806a-0106-1000-e000-0194c0a812e6463ED552".equals(tti.getBillType().getId().toString()) ? iSOAccreditWH.isStarted(storageOrgUnitID, vctSou.toArray(), true) : iSOAccreditWH.isStarted(storageOrgUnitID, vctSou.toArray(), false);
                }
                if (warehouses != null && warehouses.length > 0) {
                    StorageOrgUnitInfo sou = this.getStorageOrgUnitInfo(storageOrgUnitID);
                    for (int i = 0; i < warehouses.length; ++i) {
                        if (warehouses[i] == null) continue;
                        msg.append("\n").append(sou.getName()).append(" - ").append(warehouses[i].toString());
                    }
                }
            }
        }
        if (msg.length() > 0) {
            if (tti != null && "528d806a-0106-1000-e000-0194c0a812e6463ED552".equals(tti.getBillType().getId().toString())) {
                throw new InvBizException(InvBizException.ISSTARTED, new String[]{msg.toString()});
            }
            throw new InvBizException(InvBizException.ISNOTSTARTED, new String[]{msg.toString()});
        }
    }

    private void checkIsStarted(StockTransferBillInfo billInfo) throws BOSException, EASBizException {
        StorageOrgUnitInfo sou;
        StringBuffer msg = new StringBuffer();
        if ("d8e80652-0119-1000-e000-04c5c0a812202407435C".equals(billInfo.getBizType().getId().toString()) && (sou = billInfo.getIssueStorageOrgUnit()) != null) {
            StockTransferBillEntryCollection entrys = billInfo.getEntry();
            StockTransferBillEntryInfo entry = null;
            int entrySize = entrys.size();
            HashSet<String> list = new HashSet<String>();
            Object[] warehouses = null;
            WarehouseInfo ware = null;
            String wareId = null;
            String storageId = sou.getId().toString();
            for (int i = 0; i < entrySize; ++i) {
                entry = entrys.get(i);
                ware = entry.getIssueWarehouse();
                if (ware != null) {
                    wareId = ware.getId().toString();
                    list.add(wareId);
                }
                if ((ware = entry.getReceiptWarehouse()) == null) continue;
                wareId = ware.getId().toString();
                list.add(wareId);
            }
            if (list.size() > 0) {
                warehouses = SOAccreditWHFactory.getLocalInstance((Context)this.getCtx()).isStarted(storageId, list.toArray(), false);
            }
            if (warehouses != null && warehouses.length > 0) {
                int size = warehouses.length;
                for (int i = 0; i < size; ++i) {
                    msg.append("\n");
                    msg.append(sou.getName());
                    msg.append(" - ");
                    msg.append(warehouses[i].toString());
                }
            }
        }
        if (msg.length() > 0) {
            throw new InvBizException(InvBizException.ISNOTSTARTED, new String[]{msg.toString()});
        }
    }

    private void checkIsStarted(TransferOrderBillInfo billInfo) throws BOSException, EASBizException {
        StorageOrgUnitInfo sou;
        StringBuilder msg = new StringBuilder();
        BizTypeInfo bizType = billInfo.getBizType();
        if (bizType.getId().toString().equals("d8e80652-0119-1000-e000-04c5c0a812202407435C") && (sou = billInfo.getIssueStorageOrgUnit()) != null) {
            TransferOrderBillEntryCollection entrys = billInfo.getEntry();
            TransferOrderBillEntryInfo entry = null;
            int entrySize = entrys.size();
            HashSet<String> list = new HashSet<String>();
            Object[] warehouses = null;
            WarehouseInfo ware = null;
            String wareId = null;
            String storageId = sou.getId().toString();
            for (int i = 0; i < entrySize; ++i) {
                entry = entrys.get(i);
                ware = entry.getIssueWarehouse();
                if (ware != null) {
                    wareId = ware.getId().toString();
                    list.add(wareId);
                }
                if ((ware = entry.getReceiptWarehouse()) == null) continue;
                wareId = ware.getId().toString();
                list.add(wareId);
            }
            if (list.size() > 0) {
                warehouses = SOAccreditWHFactory.getLocalInstance((Context)this.getCtx()).isStarted(storageId, list.toArray(), false);
            }
            if (warehouses != null && warehouses.length > 0) {
                int size = warehouses.length;
                for (int i = 0; i < size; ++i) {
                    msg.append("\n");
                    msg.append(sou.getName());
                    msg.append(" - ");
                    msg.append(warehouses[i].toString());
                }
            }
        }
        if (msg.length() > 0) {
            throw new InvBizException(InvBizException.ISNOTSTARTED, new String[]{msg.toString()});
        }
    }

    private StorageOrgUnitInfo getStorageOrgUnitInfo(String souId) throws BOSException, EASBizException {
        if (this.getDataCache().contain(souId, DataTypeEnum.STORAGEORGUNITINFO)) {
            return (StorageOrgUnitInfo)this.getDataCache().get(souId, DataTypeEnum.STORAGEORGUNITINFO);
        }
        IStorageOrgUnit iStorageOrgUnit = StorageOrgUnitFactory.getLocalInstance((Context)this.getCtx());
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("name");
        sic.add("id");
        StorageOrgUnitInfo orgUnitInfo = iStorageOrgUnit.getStorageOrgUnitInfo((IObjectPK)new ObjectStringPK(souId));
        this.getDataCache().put(souId, (Object)orgUnitInfo, DataTypeEnum.STORAGEORGUNITINFO);
        return orgUnitInfo;
    }
}

