/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv.vrule.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.IOrgUnitRelation;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitRelationFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.scm.framework.dataloader.DataTypeEnum;
import com.kingdee.eas.scm.framework.validator.bizrule.app.AbstractServerVRule;
import com.kingdee.eas.scm.im.inv.InvBillBaseInfo;
import com.kingdee.eas.scm.im.inv.InvBizException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CheckStorageDelegateCompanyVRule
extends AbstractServerVRule {
    private static final Logger logger = LoggerFactory.getLogger(CheckStorageDelegateCompanyVRule.class);

    public CheckStorageDelegateCompanyVRule(Context ctx) {
        super(ctx);
    }

    public boolean supports(Class<? extends IObjectValue> clazz) {
        return InvBillBaseInfo.class.isAssignableFrom(clazz);
    }

    public void validate(IObjectValue bean) throws BOSException, EASBizException {
        InvBillBaseInfo invBillBaseInfo = (InvBillBaseInfo)bean;
        if (this.getStorageDelegateCompany(invBillBaseInfo.getStorageOrgUnit().getId().toString()) == null) {
            throw new InvBizException(InvBizException.STORAGEORGNOTHASCOMPANYORG, new String[]{invBillBaseInfo.getNumber()});
        }
    }

    private CompanyOrgUnitInfo getStorageDelegateCompany(String souId) throws BOSException, EASBizException {
        if (this.getDataCache().contain(souId, DataTypeEnum.MAINORGUNIT_2_COMPANY)) {
            return (CompanyOrgUnitInfo)this.getDataCache().get(souId, DataTypeEnum.MAINORGUNIT_2_COMPANY);
        }
        IOrgUnitRelation iOrgUnitRelation = OrgUnitRelationFactory.getLocalInstance((Context)this.getCtx());
        OrgUnitCollection col = iOrgUnitRelation.getToUnit(souId, 4, 1);
        CompanyOrgUnitInfo info = null;
        if (null != col && col.size() > 0) {
            info = (CompanyOrgUnitInfo)col.get(0);
        }
        this.getDataCache().put(souId, info, DataTypeEnum.MAINORGUNIT_2_COMPANY);
        return info;
    }
}

