/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv.vrule.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.swing.StringUtils;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.eas.basedata.master.material.MaterialInventoryCollection;
import com.kingdee.eas.basedata.master.material.MaterialInventoryFactory;
import com.kingdee.eas.basedata.master.material.MaterialInventoryInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.scm.framework.dataloader.DataTypeEnum;
import com.kingdee.eas.scm.framework.validator.bizrule.app.AbstractServerVRule;
import com.kingdee.eas.scm.im.inv.InvBillBaseEntryInfo;
import com.kingdee.eas.scm.im.inv.InvBillBaseInfo;
import com.kingdee.eas.scm.im.inv.InvBizException;
import com.kingdee.eas.scm.im.inv.PurInWarehsBillInfo;
import com.kingdee.eas.scm.im.inv.PurInWarehsEntryInfo;
import com.kingdee.eas.scm.im.inv.PurReceivalBillInfo;
import com.kingdee.eas.scm.im.inv.PurReceivalEntryInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CheckSupplierLotNoVRule
extends AbstractServerVRule {
    private static final Logger logger = LoggerFactory.getLogger(CheckSupplierLotNoVRule.class);

    public CheckSupplierLotNoVRule(Context ctx) {
        super(ctx);
    }

    public boolean supports(Class<? extends IObjectValue> clazz) {
        return PurInWarehsBillInfo.class.isAssignableFrom(clazz) || PurReceivalBillInfo.class.isAssignableFrom(clazz);
    }

    public void validate(IObjectValue bean) throws BOSException, EASBizException {
        InvBillBaseInfo invBillInfo = (InvBillBaseInfo)bean;
        IObjectCollection entrys = invBillInfo.getEntries();
        if (invBillInfo.getStorageOrgUnit() == null) {
            return;
        }
        boolean isPurInwarehsBill = invBillInfo instanceof PurInWarehsBillInfo;
        boolean isPurReceivalBill = invBillInfo instanceof PurReceivalBillInfo;
        String supplierLotNo = null;
        int len = entrys.size();
        for (int j = 0; j < len; ++j) {
            InvBillBaseEntryInfo entry = (InvBillBaseEntryInfo)entrys.getObject(j);
            if (entry.getMaterial() == null) {
                return;
            }
            MaterialInventoryInfo miInfo = this.getMaterialInventoryInfo(entry.getMaterial().getId().toString(), invBillInfo.getStorageOrgUnit().getId().toString());
            if (null == miInfo) {
                if (!logger.isDebugEnabled()) continue;
                logger.debug("\u6ca1\u6709\u83b7\u53d6\u5230\u7269\u6599\u7684\u5e93\u5b58\u5c5e\u6027");
                continue;
            }
            if (miInfo == null || !miInfo.isIsBatchNo()) continue;
            if (isPurInwarehsBill) {
                supplierLotNo = ((PurInWarehsEntryInfo)entry).getSupplierLotNo();
            } else if (isPurReceivalBill) {
                supplierLotNo = ((PurReceivalEntryInfo)entry).getSupplierLotNo();
            }
            if (!StringUtils.isEmpty((String)supplierLotNo)) continue;
            throw new InvBizException(InvBizException.SUPPLIERLOT_CANNOT_NULL, new Object[]{String.valueOf(j + 1)});
        }
    }

    private MaterialInventoryInfo getMaterialInventoryInfo(String materialId, String souId) throws BOSException {
        String key = materialId + souId;
        if (this.getDataCache().contain(key, DataTypeEnum.MATERIAL_INVENTORY)) {
            return (MaterialInventoryInfo)this.getDataCache().get(materialId + souId, DataTypeEnum.MATERIAL_INVENTORY);
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("material.id", (Object)materialId));
        filter.getFilterItems().add(new FilterItemInfo("OrgUnit.id", (Object)souId));
        view.setFilter(filter);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("id");
        selector.add("isBatchNo");
        view.setSelector(selector);
        MaterialInventoryCollection col = MaterialInventoryFactory.getLocalInstance((Context)this.getCtx()).getMaterialInventoryCollection(view);
        if (null != col && col.size() > 0) {
            this.getDataCache().put(key, (Object)col.get(0), DataTypeEnum.MATERIAL_INVENTORY);
            return col.get(0);
        }
        return null;
    }
}

