/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv.vrule.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.basedata.scm.im.inv.LocationInfo;
import com.kingdee.eas.basedata.scm.im.inv.WarehouseInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.scm.common.PurchaseTypeEnum;
import com.kingdee.eas.scm.common.SCMBillBaseInfo;
import com.kingdee.eas.scm.common.util.SCMUtils;
import com.kingdee.eas.scm.framework.validator.bizrule.app.AbstractServerVRule;
import com.kingdee.eas.scm.im.inv.InvBillBaseEntryInfo;
import com.kingdee.eas.scm.im.inv.InvBillBaseInfo;
import com.kingdee.eas.scm.im.inv.MaterialReqBillInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class CheckWarehouseAndLocationVRule
extends AbstractServerVRule {
    private final String res = "com.kingdee.eas.scm.im.inv.DataValidCheckResource";
    private final Context ctx;
    private final String EXT_WAREHOUE = "supplyWarehouse";
    private final String EXT_LOCATION = "supplyLocation";
    private final String IS_HAS_LOCATION_LIST = "isHasLocationList";

    public CheckWarehouseAndLocationVRule(Context ctx) {
        super(ctx);
        this.ctx = ctx;
    }

    public boolean supports(Class<? extends IObjectValue> clazz) {
        return SCMBillBaseInfo.class.isAssignableFrom(clazz);
    }

    public void validate(IObjectValue bean) throws BOSException, EASBizException {
        if (!(bean instanceof InvBillBaseInfo)) {
            return;
        }
        try {
            InvBillBaseInfo info = (InvBillBaseInfo)bean;
            IObjectCollection entrys = (IObjectCollection)info.get("entry");
            if (entrys == null) {
                entrys = (IObjectCollection)info.get("entries");
            }
            StringBuilder errorMsg = new StringBuilder();
            this.checkWarehouse(errorMsg, info.getStorageOrgUnit().getId().toString(), entrys, false);
            this.checkLocation(errorMsg, entrys, false);
            if (bean instanceof MaterialReqBillInfo && ((MaterialReqBillInfo)bean).getPurchaseType().equals((Object)PurchaseTypeEnum.PURCHASE)) {
                this.checkWarehouse(errorMsg, ((StorageOrgUnitInfo)info.get("supplyStoreOrgUnit")).getId().toString(), entrys, true);
                this.checkLocation(errorMsg, entrys, true);
            }
            if (errorMsg.length() > 0) {
                throw new BOSException(errorMsg.toString());
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
    }

    private void checkWarehouse(StringBuilder errorMsg, String souId, IObjectCollection entrys, boolean matReqExt) throws BOSException {
        String entryRes = SCMUtils.getResource((String)"com.kingdee.eas.scm.im.inv.DataValidCheckResource", (String)"ENTRY", (Context)this.ctx);
        String exceptionMsg = SCMUtils.getResource((String)"com.kingdee.eas.scm.im.inv.DataValidCheckResource", (String)"WAREHOUSE_NOT_IN_SOU", (Context)this.ctx);
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT w.FID FROM T_DB_WAREHOUSE w ");
        sql.append("INNER JOIN T_DB_SOAccreditWH wh on w.FID = wh.FWAREHOUSEID ");
        sql.append("where wh.FSTORAGEORGID = '").append(souId).append("'");
        IRowSet rs = DbUtil.executeQuery((Context)this.ctx, (String)sql.toString());
        HashSet<String> warehouseSet = new HashSet<String>();
        try {
            while (rs.next()) {
                warehouseSet.add(rs.getString("FID"));
            }
            for (int i = 0; i < entrys.size(); ++i) {
                InvBillBaseEntryInfo entry = (InvBillBaseEntryInfo)entrys.getObject(i);
                WarehouseInfo warehouse = matReqExt ? (WarehouseInfo)entry.get("supplyWarehouse") : entry.getWarehouse();
                if (warehouse == null || warehouseSet.contains(warehouse.getId().toString())) continue;
                errorMsg.append("\n\r").append(entryRes).append(entry.getSeq()).append(exceptionMsg);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    private void checkLocation(StringBuilder errorMsg, IObjectCollection entrys, boolean matReqExt) throws BOSException {
        try {
            Map<String, List<String>> warehouse2Location = this.getWarehouse2Location(entrys, matReqExt);
            List<String> isHasLocationList = warehouse2Location.get("isHasLocationList");
            String entryRes = SCMUtils.getResource((String)"com.kingdee.eas.scm.im.inv.DataValidCheckResource", (String)"ENTRY", (Context)this.ctx);
            for (int i = 0; i < entrys.size(); ++i) {
                LocationInfo location;
                WarehouseInfo warehouse;
                InvBillBaseEntryInfo entry = (InvBillBaseEntryInfo)entrys.getObject(i);
                if (matReqExt) {
                    warehouse = (WarehouseInfo)entry.get("supplyWarehouse");
                    location = (LocationInfo)entry.get("supplyLocation");
                } else {
                    location = entry.getLocation();
                    warehouse = entry.getWarehouse();
                }
                if (warehouse == null) continue;
                if (!isHasLocationList.contains(warehouse.getId().toString())) {
                    if (location == null) continue;
                    errorMsg.append("\n\r").append(entryRes).append(entry.getSeq());
                    errorMsg.append(SCMUtils.getResource((String)"com.kingdee.eas.scm.im.inv.DataValidCheckResource", (String)"LOCATION_CLEAR", (Context)this.ctx));
                    continue;
                }
                if (location == null) {
                    errorMsg.append("\n\r").append(entryRes).append(entry.getSeq());
                    errorMsg.append(SCMUtils.getResource((String)"com.kingdee.eas.scm.im.inv.DataValidCheckResource", (String)"LOCATION_CAN_NOT_NULL", (Context)this.ctx));
                    continue;
                }
                List<String> currLocationList = warehouse2Location.get(warehouse.getId().toString());
                if (currLocationList == null || currLocationList.contains(location.getId().toString())) continue;
                errorMsg.append("\n\r").append(entryRes).append(entry.getSeq());
                errorMsg.append(SCMUtils.getResource((String)"com.kingdee.eas.scm.im.inv.DataValidCheckResource", (String)"LOCATION_NOT_IN_WH", (Context)this.ctx));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    private Map<String, List<String>> getWarehouse2Location(IObjectCollection entrys, boolean matReqExt) throws BOSException, SQLException {
        HashMap<String, List<String>> warehouse2Location = new HashMap<String, List<String>>();
        HashSet<String> warehouseSet = new HashSet<String>();
        for (int i = 0; i < entrys.size(); ++i) {
            InvBillBaseEntryInfo entry = (InvBillBaseEntryInfo)entrys.getObject(i);
            WarehouseInfo warehouse = matReqExt ? (WarehouseInfo)entry.get("supplyWarehouse") : entry.getWarehouse();
            if (warehouse == null) continue;
            warehouseSet.add(warehouse.getId().toString());
        }
        if (warehouseSet.isEmpty()) {
            return warehouse2Location;
        }
        StringBuilder ids = new StringBuilder();
        for (String s : warehouseSet) {
            ids.append("'").append(s).append("',");
        }
        ids.setLength(ids.length() - 1);
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT l.FID locationId,w.FID warehouseId, w.FHASLOCATION isHasLocation FROM t_db_location l inner join t_db_warehouse w ON L.FWAREHOUSEID = W.FID ");
        sql.append("where w.FHASLOCATION = 1 and l.FSTATE = '1' ");
        sql.append("and w.fid in ").append("(").append((CharSequence)ids).append(")");
        sql.append(" order by w.FID");
        IRowSet rs = DbUtil.executeQuery((Context)this.ctx, (String)sql.toString());
        ArrayList<String> isHasLocationList = new ArrayList<String>();
        while (rs.next()) {
            List<String> locationList;
            String warehouseId = rs.getString("warehouseId");
            String locationId = rs.getString("locationId");
            if (warehouse2Location.containsKey(warehouseId)) {
                locationList = (List)warehouse2Location.get(warehouseId);
                locationList.add(locationId);
            } else {
                locationList = new ArrayList();
                locationList.add(locationId);
                warehouse2Location.put(warehouseId, locationList);
            }
            if (rs.getInt("isHasLocation") != 1) continue;
            isHasLocationList.add(warehouseId);
        }
        warehouse2Location.put("isHasLocationList", isHasLocationList);
        return warehouse2Location;
    }
}

