/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv.vrule.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.scm.cal.util.DBUtil;
import com.kingdee.eas.scm.common.util.SCMUtils;
import com.kingdee.eas.scm.framework.validator.bizrule.app.AbstractServerVRule;
import com.kingdee.eas.scm.im.inv.InvBillBaseEntryInfo;
import com.kingdee.eas.scm.im.inv.InvBillBaseInfo;
import com.kingdee.eas.scm.im.inv.InvBizException;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.LocaleUtils;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CheckWarehouseVRule
extends AbstractServerVRule {
    private static final Logger logger = LoggerFactory.getLogger(CheckWarehouseVRule.class);
    Context ctx;

    public CheckWarehouseVRule(Context ctx) {
        super(ctx);
        this.ctx = ctx;
    }

    public boolean supports(Class<? extends IObjectValue> clazz) {
        return InvBillBaseInfo.class.isAssignableFrom(clazz);
    }

    public void validate(IObjectValue bean) throws BOSException, EASBizException {
        String res = "com.kingdee.eas.scm.common.SCMResource";
        String loc = LocaleUtils.getLocaleString((Locale)this.ctx.getLocale());
        InvBillBaseInfo invBillBaseInfo = (InvBillBaseInfo)bean;
        IObjectCollection entrys = invBillBaseInfo.getEntries();
        StorageOrgUnitInfo sou = invBillBaseInfo.getStorageOrgUnit();
        if (sou == null) {
            throw new InvBizException(InvBizException.STOREORG_IS_NULL);
        }
        StringBuffer warehouseIds = new StringBuffer();
        ArrayList<String> warehouseList = new ArrayList<String>();
        int len = entrys.size();
        for (int j = 0; j < len; ++j) {
            InvBillBaseEntryInfo entry = (InvBillBaseEntryInfo)entrys.getObject(j);
            if (!warehouseList.contains(entry.getWarehouse().getId().toString())) {
                warehouseIds.append("'").append(entry.getWarehouse().getId().toString()).append("',");
            }
            warehouseList.add(entry.getWarehouse().getId().toString());
        }
        if (warehouseIds.length() > 0) {
            HashMap<String, String> exceptionMap = new HashMap<String, String>();
            HashSet<String> exceptionSet = new HashSet<String>();
            warehouseIds.setLength(warehouseIds.length() - 1);
            StringBuffer sql = new StringBuffer();
            sql.append("SELECT WH.FID,WH.FNUMBER,WH.FNAME_").append(loc).append(" FNAME  FROM T_DB_WAREHOUSE WH \n");
            sql.append("LEFT JOIN T_DB_SOACCREDITWH SOA ON SOA.FWAREHOUSEID = WH.FID \n");
            sql.append("AND SOA.FSTORAGEORGID='").append(sou.getId().toString()).append("' \n");
            sql.append("AND SOA.FSTATUS = ").append(1).append(" \n");
            sql.append("WHERE WH.FID IN(").append(warehouseIds).append(") \n");
            sql.append("AND (SOA.FSTORAGEORGID IS NULL \n");
            sql.append("OR WH.FWHSTATE <> '").append("1").append("')");
            IRowSet rs = DBUtil.executeQuery((Context)this.ctx, (String)sql.toString());
            StringBuffer warehouseRelationNotExists = new StringBuffer();
            try {
                while (rs.next()) {
                    exceptionMap.put(rs.getString("FID"), rs.getString("FNAME") + "[" + rs.getString("FNUMBER") + "]");
                    exceptionSet.add(rs.getString("FID"));
                }
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
            for (int i = 0; i < warehouseList.size(); ++i) {
                if (!exceptionSet.contains(warehouseList.get(i))) continue;
                warehouseRelationNotExists.append("\n").append(SCMUtils.getResource((String)res, (String)"EntryFieldCheck_RowNum", (Context)this.ctx)).append(":").append(i + 1).append(" ").append((String)exceptionMap.get(warehouseList.get(i)));
            }
            if (warehouseRelationNotExists.length() > 0) {
                throw new InvBizException(InvBizException.WAREHOUSERELATIONNOTEXISTS, new String[]{warehouseRelationNotExists.toString()});
            }
        }
    }
}

