/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv.vrule.app.matassemble;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.scm.framework.validator.bizrule.app.AbstractServerVRule;
import com.kingdee.eas.scm.im.inv.MatAssembleException;
import com.kingdee.eas.scm.im.inv.MatDisassembleAfterEntryCollection;
import com.kingdee.eas.scm.im.inv.MatDisassembleBeforeEntryCollection;
import com.kingdee.eas.scm.im.inv.MatDisassembleBeforeEntryInfo;
import com.kingdee.eas.scm.im.inv.MatDisassembleBillInfo;
import java.math.BigDecimal;

public class CheckCostRateVRule
extends AbstractServerVRule {
    public CheckCostRateVRule(Context ctx) {
        super(ctx);
    }

    public boolean supports(Class<? extends IObjectValue> clazz) {
        return MatDisassembleBillInfo.class.isAssignableFrom(clazz);
    }

    public void validate(IObjectValue bean) throws BOSException, EASBizException {
        MatDisassembleBillInfo info = (MatDisassembleBillInfo)bean;
        MatDisassembleBeforeEntryCollection entryColl = info.getEntries();
        for (int beforeRow = 0; beforeRow < entryColl.size(); ++beforeRow) {
            MatDisassembleBeforeEntryInfo beforeEntryInfo = entryColl.get(beforeRow);
            MatDisassembleAfterEntryCollection afterEntries = beforeEntryInfo.getEntries();
            BigDecimal afterProcessChargeSum = new BigDecimal("0.00");
            for (int afterRow = 0; afterRow < afterEntries.size(); ++afterRow) {
                if (afterEntries.get(afterRow).getProcessCharge() == null) continue;
                afterProcessChargeSum = afterEntries.get(afterRow).getProcessCharge().add(afterProcessChargeSum);
            }
            if (afterProcessChargeSum.compareTo(beforeEntryInfo.getProcessCharge() == null ? BigDecimal.ZERO : beforeEntryInfo.getProcessCharge()) != 0) {
                throw new MatAssembleException(MatAssembleException.PROCESSCHARGESUM_ISNOTSAME, new String[]{beforeRow + 1 + ""});
            }
            BigDecimal sum = new BigDecimal(0);
            for (int afterRow = 0; afterRow < afterEntries.size(); ++afterRow) {
                if (afterEntries.get(afterRow).getCostRate() == null) continue;
                sum = afterEntries.get(afterRow).getCostRate().add(sum);
            }
            if (sum.compareTo(new BigDecimal(100)) == 0) continue;
            throw new MatAssembleException(MatAssembleException.COSTRATE_NOTEQ_ONE, new String[]{beforeRow + 1 + ""});
        }
    }
}

