/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv.vrule.app.matassemble;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.eas.basedata.master.material.IMaterialInventory;
import com.kingdee.eas.basedata.master.material.MaterialInventoryCollection;
import com.kingdee.eas.basedata.master.material.MaterialInventoryFactory;
import com.kingdee.eas.basedata.master.material.MaterialInventoryInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.scm.framework.dataloader.DataTypeEnum;
import com.kingdee.eas.scm.framework.validator.bizrule.app.AbstractServerVRule;
import com.kingdee.eas.scm.im.inv.InvBillBaseEntryInfo;
import com.kingdee.eas.scm.im.inv.InvBillBaseInfo;
import com.kingdee.eas.scm.im.inv.InvBizException;
import com.kingdee.eas.scm.im.inv.MatAssembleBillInfo;
import com.kingdee.eas.scm.im.inv.MatAssembleException;
import com.kingdee.eas.scm.im.inv.MatDisassembleBillInfo;
import com.kingdee.util.NumericExceptionSubItem;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CheckLotAndExpiryDateVRule
extends AbstractServerVRule {
    private static final Logger logger = LoggerFactory.getLogger(CheckLotAndExpiryDateVRule.class);
    private String entryName;
    private String entry1Name;
    private InvBillBaseInfo invInfo;
    private NumericExceptionSubItem LOT_IS_NULL = MatAssembleException.ASS_LOT_IS_NULL;
    private NumericExceptionSubItem MATERIAL_IS_PERIODVALID_NOTNULL = MatAssembleException.ASS_MATERIAL_IS_PERIODVALID_NOTNULL;

    public CheckLotAndExpiryDateVRule(Context ctx) {
        super(ctx);
    }

    public boolean supports(Class<? extends IObjectValue> clazz) {
        if (MatAssembleBillInfo.class.isAssignableFrom(clazz)) {
            this.entryName = "entry";
            this.entry1Name = "entry1";
            return true;
        }
        if (MatDisassembleBillInfo.class.isAssignableFrom(clazz)) {
            this.entryName = "entries";
            this.entry1Name = "entries";
            this.LOT_IS_NULL = MatAssembleException.DISASS_LOT_IS_NULL;
            this.MATERIAL_IS_PERIODVALID_NOTNULL = MatAssembleException.DISASS_MATERIAL_IS_PERIODVALID_NOTNULL;
            return true;
        }
        return false;
    }

    public void validate(IObjectValue bean) throws BOSException, EASBizException {
        this.invInfo = (InvBillBaseInfo)bean;
        this.validate(bean, 0, false);
    }

    private MaterialInventoryInfo getMaterialInventoryInfo(String materialId, String souId) throws BOSException {
        String key = materialId + souId;
        if (this.getDataCache().contain(key, DataTypeEnum.MATERIAL_INVENTORY)) {
            return (MaterialInventoryInfo)this.getDataCache().get(materialId + souId, DataTypeEnum.MATERIAL_INVENTORY);
        }
        IMaterialInventory iMaterialInventory = MaterialInventoryFactory.getLocalInstance((Context)this.getCtx());
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("material.id", (Object)materialId));
        filter.getFilterItems().add(new FilterItemInfo("OrgUnit.id", (Object)souId));
        view.setFilter(filter);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("id");
        selector.add("isLotNumber");
        selector.add("isPeriodValid");
        view.setSelector(selector);
        MaterialInventoryCollection col = iMaterialInventory.getMaterialInventoryCollection(view);
        if (null != col && col.size() > 0) {
            this.getDataCache().put(key, (Object)col.get(0), DataTypeEnum.MATERIAL_INVENTORY);
            return col.get(0);
        }
        return null;
    }

    private void validate(IObjectValue bean, int parentSeq, boolean isChildEntry) throws BOSException, EASBizException {
        IObjectValue invInfo = bean;
        if (invInfo == null || this.invInfo.getStorageOrgUnit() == null) {
            return;
        }
        String entryName = this.entryName;
        if (isChildEntry) {
            entryName = this.entry1Name;
        }
        IObjectCollection entrys = (IObjectCollection)invInfo.get(entryName);
        ArrayList<InvBillBaseEntryInfo> entryList = new ArrayList<InvBillBaseEntryInfo>();
        int len = entrys.size();
        for (int j = 0; j < len; ++j) {
            MaterialInventoryInfo materilInvInfo;
            InvBillBaseEntryInfo entry = (InvBillBaseEntryInfo)entrys.getObject(j);
            if (entry.getMaterial() == null || null == (materilInvInfo = this.getMaterialInventoryInfo(entry.getMaterial().getId().toString(), this.invInfo.getStorageOrgUnit().getId().toString()))) continue;
            if (materilInvInfo.isIsLotNumber() && StringUtils.isEmpty((String)entry.getLot())) {
                if (!isChildEntry) {
                    throw new InvBizException(InvBizException.COSTADJUST_LOT_NULL, new String[]{String.valueOf(j + 1)});
                }
                throw new MatAssembleException(this.LOT_IS_NULL, new String[]{String.valueOf(parentSeq), String.valueOf(j + 1)});
            }
            if (materilInvInfo.isIsPeriodValid()) {
                if (entry.getMfg() == null || entry.getExp() == null) {
                    if (!isChildEntry) {
                        throw new InvBizException(InvBizException.MATERIAL_IS_PERIODVALID_NOTNULL, new String[]{String.valueOf(j + 1)});
                    }
                    throw new MatAssembleException(this.MATERIAL_IS_PERIODVALID_NOTNULL, new String[]{String.valueOf(parentSeq), String.valueOf(j + 1)});
                }
                entryList.add(entry);
            }
            if (isChildEntry) continue;
            this.validate((IObjectValue)entry, j + 1, true);
        }
        int count = entryList.size();
        for (int k = 0; k < count; ++k) {
            InvBillBaseEntryInfo billEntry = (InvBillBaseEntryInfo)entryList.get(k);
            for (int z = k; z < entryList.size() - 1; ++z) {
                if (!billEntry.getLot().equals(((InvBillBaseEntryInfo)entryList.get(z)).getLot()) || !billEntry.getMaterial().getId().toString().equals(((InvBillBaseEntryInfo)entryList.get(z)).getMaterial().getId().toString()) || billEntry.getMfg().equals(((InvBillBaseEntryInfo)entryList.get(z)).getMfg()) && billEntry.getExp().equals(((InvBillBaseEntryInfo)entryList.get(z)).getExp())) continue;
                if (!isChildEntry) {
                    throw new InvBizException(InvBizException.DUPLICATELOTSALL, new String[]{String.valueOf(z + 1)});
                }
                throw new MatAssembleException(MatAssembleException.DUPLICATELOTSALL);
            }
        }
    }
}

