/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv.vrule.app.matassemble;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.scm.framework.validator.bizrule.app.AbstractServerVRule;
import com.kingdee.eas.scm.im.inv.InvBillBaseEntryInfo;
import com.kingdee.eas.scm.im.inv.InvBillBaseInfo;
import com.kingdee.eas.scm.im.inv.InvBizException;
import com.kingdee.eas.scm.im.inv.MatAssembleBillInfo;
import com.kingdee.eas.scm.im.inv.MatDisassembleBillInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class CheckMaterialCompanyVRule
extends AbstractServerVRule {
    private String entryName;
    private String entry1Name;

    public CheckMaterialCompanyVRule(Context ctx) {
        super(ctx);
    }

    public CheckMaterialCompanyVRule() {
        this(null);
    }

    public boolean supports(Class<? extends IObjectValue> clazz) {
        if (MatAssembleBillInfo.class.isAssignableFrom(clazz)) {
            this.entryName = "entry";
            this.entry1Name = "entry1";
            return true;
        }
        if (MatDisassembleBillInfo.class.isAssignableFrom(clazz)) {
            this.entryName = "entries";
            this.entry1Name = "entries";
            return true;
        }
        return false;
    }

    public void validate(IObjectValue bean) throws BOSException, EASBizException {
        InvBillBaseInfo invBillBaseInfo = (InvBillBaseInfo)bean;
        IObjectCollection entrys = (IObjectCollection)invBillBaseInfo.get(this.entryName);
        List<String> validMaterialList = this.getMaterialCompanyList(entrys);
        int len = entrys.size();
        for (int j = 0; j < len; ++j) {
            InvBillBaseEntryInfo entry = (InvBillBaseEntryInfo)entrys.getObject(j);
            if (entry.getMaterial() == null || entry.getCompanyOrgUnit() == null) continue;
            if (validMaterialList.indexOf(entry.getMaterial().getId().toString()) < 0) {
                throw new InvBizException(InvBizException.MATERIALNOTFI, new Object[]{entry.getMaterial().getNumber()});
            }
            IObjectCollection entry1s = (IObjectCollection)entry.get(this.entry1Name);
            validMaterialList.addAll(this.getMaterialCompanyList(entry1s));
            for (int i = 0; i < entry1s.size(); ++i) {
                entry = (InvBillBaseEntryInfo)entry1s.getObject(i);
                if (entry.getMaterial() == null || entry.getCompanyOrgUnit() == null || validMaterialList.indexOf(entry.getMaterial().getId().toString()) >= 0) continue;
                throw new InvBizException(InvBizException.MATERIALNOTFI, new Object[]{entry.getMaterial().getNumber()});
            }
        }
    }

    private List<String> getMaterialCompanyList(IObjectCollection entrys) throws BOSException {
        StringBuffer idWhere = new StringBuffer();
        String companyid = null;
        int len = entrys.size();
        for (int i = 0; i < len; ++i) {
            InvBillBaseEntryInfo entry = (InvBillBaseEntryInfo)entrys.getObject(i);
            if (i > 0 && idWhere.length() > 0 && entry.getMaterial() != null) {
                idWhere.append(",");
            } else if (i == 0) {
                companyid = entry.getCompanyOrgUnit().getId().toString();
            }
            if (entry.getMaterial() == null) continue;
            idWhere.append("'").append(entry.getMaterial().getId().toString()).append("'");
        }
        ArrayList<String> result = new ArrayList<String>();
        StringBuffer sSQL = new StringBuffer();
        sSQL.append("Select FMaterialId from T_BD_MATERIALCOMPANYINFO where FCompanyId='").append(companyid).append("'");
        if (idWhere.toString().length() <= 0) {
            return result;
        }
        sSQL.append(" and FMaterialId IN (").append(idWhere.toString()).append(")");
        IRowSet rs = DbUtil.executeQuery((Context)this.getCtx(), (String)sSQL.toString());
        try {
            while (rs.next()) {
                result.add(rs.getString("FMaterialId"));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return result;
    }
}

