/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv.vrule.app.matassemble;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.eas.basedata.master.material.AccountType;
import com.kingdee.eas.basedata.master.material.IMaterialCompanyInfo;
import com.kingdee.eas.basedata.master.material.MaterialCompanyInfoCollection;
import com.kingdee.eas.basedata.master.material.MaterialCompanyInfoFactory;
import com.kingdee.eas.basedata.master.material.MaterialCompanyInfoInfo;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.UsedStatusEnum;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.scm.framework.dataloader.DataTypeEnum;
import com.kingdee.eas.scm.framework.validator.bizrule.app.AbstractServerVRule;
import com.kingdee.eas.scm.im.inv.InvBillBaseEntryInfo;
import com.kingdee.eas.scm.im.inv.InvBillBaseInfo;
import com.kingdee.eas.scm.im.inv.MatAssembleBeforeEntryInfo;
import com.kingdee.eas.scm.im.inv.MatAssembleBillInfo;
import com.kingdee.eas.scm.im.inv.MatAssembleException;
import com.kingdee.eas.scm.im.inv.MatDisassembleAfterEntryInfo;
import com.kingdee.eas.scm.im.inv.MatDisassembleBillInfo;
import com.kingdee.util.NumericExceptionSubItem;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CheckMaterialValidVRule
extends AbstractServerVRule {
    private static final Logger logger = LoggerFactory.getLogger(CheckMaterialValidVRule.class);
    private String entryName;
    private String entry1Name;
    NumericExceptionSubItem MATERIAL_CANT_SAME = MatAssembleException.ASS_MATERIAL_CANT_SAME;

    public CheckMaterialValidVRule(Context ctx) {
        super(ctx);
    }

    public boolean supports(Class<? extends IObjectValue> clazz) {
        if (MatAssembleBillInfo.class.isAssignableFrom(clazz)) {
            this.entryName = "entry";
            this.entry1Name = "entry1";
            return true;
        }
        if (MatDisassembleBillInfo.class.isAssignableFrom(clazz)) {
            this.entryName = "entries";
            this.entry1Name = "entries";
            this.MATERIAL_CANT_SAME = MatAssembleException.DISASS_MATERIAL_CANT_SAME;
            return true;
        }
        return false;
    }

    public void validate(IObjectValue bean) throws BOSException, EASBizException {
        block8: {
            int i;
            MaterialCompanyInfoInfo matComInfo;
            IObjectCollection childEntryColl;
            MaterialInfo beforeMaterialInfo;
            InvBillBaseEntryInfo entryInfo;
            IObjectCollection entryColl;
            InvBillBaseInfo invInfo;
            block7: {
                assert (bean != null);
                invInfo = (InvBillBaseInfo)bean;
                entryColl = invInfo.getEntries();
                entryInfo = null;
                beforeMaterialInfo = null;
                for (int i2 = 0; i2 < entryColl.size(); ++i2) {
                    entryInfo = (InvBillBaseEntryInfo)entryColl.getObject(i2);
                    beforeMaterialInfo = entryInfo.getMaterial();
                    if (beforeMaterialInfo == null) continue;
                    childEntryColl = (IObjectCollection)entryInfo.get(this.entry1Name);
                    for (int j = 0; j < childEntryColl.size(); ++j) {
                        entryInfo = (InvBillBaseEntryInfo)childEntryColl.getObject(j);
                        if (entryInfo.getMaterial() == null || !beforeMaterialInfo.getId().toString().equals(entryInfo.getMaterial().getId().toString())) continue;
                        throw new MatAssembleException(this.MATERIAL_CANT_SAME, new String[]{i2 + 1 + "", j + 1 + ""});
                    }
                }
                matComInfo = null;
                if (!(invInfo instanceof MatAssembleBillInfo)) break block7;
                for (i = 0; i < entryColl.size(); ++i) {
                    BigDecimal processCharge;
                    entryInfo = (InvBillBaseEntryInfo)entryColl.getObject(i);
                    beforeMaterialInfo = entryInfo.getMaterial();
                    boolean isValid = false;
                    if (beforeMaterialInfo == null || entryInfo.getCompanyOrgUnit() == null || (matComInfo = this.getMaterialCompanyInfo(beforeMaterialInfo.getId().toString(), entryInfo.getCompanyOrgUnit().getId().toString())) == null || !AccountType.MOVE_ADD_AVERAGE.equals((Object)matComInfo.getAccountType()) || (processCharge = ((MatAssembleBeforeEntryInfo)entryInfo).getProcessCharge()) != null && processCharge.compareTo(BigDecimal.ZERO) > 0) continue;
                    childEntryColl = (IObjectCollection)entryInfo.get(this.entry1Name);
                    for (int j = 0; j < childEntryColl.size(); ++j) {
                        entryInfo = (InvBillBaseEntryInfo)childEntryColl.getObject(j);
                        if (entryInfo.getMaterial() == null || entryInfo.getCompanyOrgUnit() == null || (matComInfo = this.getMaterialCompanyInfo(entryInfo.getMaterial().getId().toString(), entryInfo.getCompanyOrgUnit().getId().toString())) == null || !AccountType.MOVE_ADD_AVERAGE.equals((Object)matComInfo.getAccountType()) && !AccountType.STANDARDCOST.equals((Object)matComInfo.getAccountType())) continue;
                        isValid = true;
                        break;
                    }
                    if (isValid) continue;
                    throw new MatAssembleException(MatAssembleException.ASS_MATERIAL_UNVALID, new String[]{i + 1 + ""});
                }
                break block8;
            }
            if (!(invInfo instanceof MatDisassembleBillInfo)) break block8;
            for (i = 0; i < entryColl.size(); ++i) {
                entryInfo = (InvBillBaseEntryInfo)entryColl.getObject(i);
                beforeMaterialInfo = entryInfo.getMaterial();
                if (beforeMaterialInfo == null || entryInfo.getCompanyOrgUnit() == null || (matComInfo = this.getMaterialCompanyInfo(beforeMaterialInfo.getId().toString(), entryInfo.getCompanyOrgUnit().getId().toString())) == null || AccountType.MOVE_ADD_AVERAGE.equals((Object)matComInfo.getAccountType()) || AccountType.STANDARDCOST.equals((Object)matComInfo.getAccountType())) continue;
                childEntryColl = (IObjectCollection)entryInfo.get(this.entry1Name);
                for (int j = 0; j < childEntryColl.size(); ++j) {
                    entryInfo = (InvBillBaseEntryInfo)childEntryColl.getObject(j);
                    if (entryInfo.getMaterial() == null || entryInfo.getCompanyOrgUnit() == null || ((MatDisassembleAfterEntryInfo)entryInfo).getProcessCharge() != null && ((MatDisassembleAfterEntryInfo)entryInfo).getProcessCharge().compareTo(BigDecimal.ZERO) > 0 || ((MatDisassembleAfterEntryInfo)entryInfo).getAmount() != null && ((MatDisassembleAfterEntryInfo)entryInfo).getAmount().compareTo(BigDecimal.ZERO) > 0 || (matComInfo = this.getMaterialCompanyInfo(entryInfo.getMaterial().getId().toString(), entryInfo.getCompanyOrgUnit().getId().toString())) == null || !AccountType.MOVE_ADD_AVERAGE.equals((Object)matComInfo.getAccountType())) continue;
                    throw new MatAssembleException(MatAssembleException.DISASS_MATERIAL_UNVALID, new String[]{i + 1 + "", j + 1 + ""});
                }
            }
        }
    }

    private MaterialCompanyInfoInfo getMaterialCompanyInfo(String materialId, String couId) throws BOSException {
        assert (!StringUtils.isEmpty((String)couId));
        assert (StringUtils.isEmpty((String)materialId));
        if (this.getDataCache().contain(materialId + couId, DataTypeEnum.MATERIAL_INVENTORY)) {
            return (MaterialCompanyInfoInfo)this.getDataCache().get(materialId + couId, DataTypeEnum.MATERIAL_COMPANY);
        }
        IMaterialCompanyInfo iMaterialCompany = MaterialCompanyInfoFactory.getLocalInstance((Context)this.getCtx());
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("mateial.id", (Object)materialId));
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)couId));
        filter.getFilterItems().add(new FilterItemInfo("status", (Object)UsedStatusEnum.APPROVED));
        entityViewInfo.setFilter(filter);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("id");
        selector.add("*");
        entityViewInfo.setSelector(selector);
        MaterialCompanyInfoCollection col = iMaterialCompany.getMaterialCompanyInfoCollection(entityViewInfo);
        MaterialCompanyInfoInfo info = null;
        if (col != null && col.size() > 0) {
            info = col.get(0);
        }
        this.getDataCache().put(materialId + couId, (Object)info, DataTypeEnum.MATERIAL_COMPANY);
        return info;
    }
}

