/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv.vrule.app.material;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.eas.basedata.scm.common.BizTypeInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.scm.framework.dataloader.IDataCache;
import com.kingdee.eas.scm.framework.validator.IVRule;
import com.kingdee.eas.scm.im.inv.InvBizException;
import com.kingdee.eas.scm.im.inv.MaterialRequestBillEntryCollection;
import com.kingdee.eas.scm.im.inv.MaterialRequestBillEntryInfo;
import com.kingdee.eas.scm.im.inv.MaterialRequestBillInfo;
import com.kingdee.eas.scm.util.filehandle.ResourceUtil;

public class CheckMaterialRequestEntryOrgUnitVRule
implements IVRule {
    private static final String INV_RESOURCE = "com.kingdee.eas.scm.im.inv.InvAddResource";

    public boolean supports(Class<? extends IObjectValue> clazz) {
        return MaterialRequestBillInfo.class.isAssignableFrom(clazz);
    }

    public void setInjectData(IDataCache injectData) {
    }

    public void validate(IObjectValue bean) throws BOSException, EASBizException {
        assert (bean != null);
        MaterialRequestBillInfo info = (MaterialRequestBillInfo)bean;
        if (!this.isJumpOrg(info.getBizType())) {
            return;
        }
        MaterialRequestBillEntryCollection col = info.getEntry();
        StringBuffer rowInfo = new StringBuffer();
        int size = col.size();
        for (int i = 0; i < size; ++i) {
            MaterialRequestBillEntryInfo entry = col.get(i);
            if (entry.getReceiveStorage() == null || entry.getStorageOrgUnit() == null || !entry.getReceiveStorage().getId().toString().equals(entry.getStorageOrgUnit().getId().toString())) continue;
            rowInfo.append(i + 1).append(ResourceUtil.getMessage((String)INV_RESOURCE, (String)"Comma"));
        }
        if (rowInfo.length() > 0) {
            throw new InvBizException(InvBizException.COMMON, new String[]{ResourceUtil.getMessage((String)INV_RESOURCE, (String)"RECEIVEORG_NOTEQUALS_OUTORG", (String[])new String[]{rowInfo.substring(0, rowInfo.length() - 1)})});
        }
    }

    private boolean isJumpOrg(BizTypeInfo bizTypeInfo) {
        boolean flag = false;
        if (bizTypeInfo == null || bizTypeInfo.getId() == null) {
            return flag;
        }
        String bizTypeID = bizTypeInfo.getId().toString();
        if ("i6DbShN4SLaNlFkX90UXOiQHQ1w=".equals(bizTypeID) || "YJN9V65PSkutQxeUH6F72SQHQ1w=".equals(bizTypeID) || "nhvcdx82RzuTw48FSlV79CQHQ1w=".equals(bizTypeID)) {
            flag = true;
        }
        return flag;
    }
}

