/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv.vrule.app.material;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.eas.basedata.scm.im.inv.BizDirectionEnum;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.scm.common.util.SCMUtils;
import com.kingdee.eas.scm.common.util.StringUtil;
import com.kingdee.eas.scm.framework.validator.bizrule.app.AbstractServerVRule;
import com.kingdee.eas.scm.im.inv.InvBizException;
import com.kingdee.eas.scm.im.inv.MaterialReqBillEntryCollection;
import com.kingdee.eas.scm.im.inv.MaterialReqBillEntryInfo;
import com.kingdee.eas.scm.im.inv.MaterialReqBillInfo;
import com.kingdee.eas.scm.im.inv.app.InvServerUtils;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.HashSet;

public class CheckRedMaterialReqBaseQtyVRule
extends AbstractServerVRule {
    private static final String RESOURCE = "com.kingdee.eas.scm.im.inv.InvAddResource";

    public CheckRedMaterialReqBaseQtyVRule(Context ctx) {
        super(ctx);
    }

    public boolean supports(Class<? extends IObjectValue> clazz) {
        return MaterialReqBillInfo.class.isAssignableFrom(clazz);
    }

    public void validate(IObjectValue bean) throws BOSException, EASBizException {
        assert (bean != null);
        MaterialReqBillInfo info = (MaterialReqBillInfo)bean;
        this.checkRedMaterialReqBaseQty(this.getCtx(), info);
    }

    private void checkRedMaterialReqBaseQty(Context ctx, MaterialReqBillInfo info) throws BOSException, EASBizException {
        BigDecimal baseQty;
        String sourceEntryId;
        MaterialReqBillEntryInfo entryInfo;
        if (info.getSourceBillType() != null && !"50957179-0105-1000-e000-0163c0a812fd463ED552".equals(String.valueOf(info.getSourceBillType().getId())) && !BizDirectionEnum.back.equals((Object)info.getTransactionType().getRiType().getBizDirection())) {
            return;
        }
        HashMap<String, BigDecimal> sourceIdBaseQtyMap = new HashMap<String, BigDecimal>();
        HashSet<String> sourceIdSet = new HashSet<String>();
        MaterialReqBillEntryCollection collection = info.getEntry();
        int size = collection.size();
        for (int i = 0; i < size; ++i) {
            entryInfo = collection.get(i);
            sourceEntryId = entryInfo.getSourceBillEntryId();
            if (StringUtil.isEmpty((String)sourceEntryId)) continue;
            sourceIdSet.add(sourceEntryId);
            if (sourceIdBaseQtyMap.containsKey(sourceEntryId)) {
                baseQty = (BigDecimal)sourceIdBaseQtyMap.get(sourceEntryId);
                baseQty = baseQty.add(entryInfo.getBaseQty());
            } else {
                baseQty = entryInfo.getBaseQty();
            }
            sourceIdBaseQtyMap.put(sourceEntryId, baseQty);
        }
        if (sourceIdSet.size() > 0) {
            HashSet<String> resultSet = new HashSet<String>();
            StringBuffer sql = new StringBuffer();
            sql.append("select FId, FUnReturnedBaseQty from T_IM_MATERIALREQBILLENTRY ").append("\r\n");
            sql.append("where FId in (" + InvServerUtils.generateQuestionMark(sourceIdSet.size()) + ") ").append("\r\n");
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])sourceIdSet.toArray());
            try {
                while (rowSet.next()) {
                    sourceEntryId = rowSet.getString("FId");
                    baseQty = (BigDecimal)sourceIdBaseQtyMap.get(sourceEntryId);
                    BigDecimal unReturnedBaseQty = rowSet.getBigDecimal("FUnReturnedBaseQty");
                    if (baseQty == null || unReturnedBaseQty == null || baseQty.abs().compareTo(unReturnedBaseQty) <= 0) continue;
                    resultSet.add(sourceEntryId);
                }
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
            StringBuffer lineNum = new StringBuffer();
            int size2 = collection.size();
            for (int i = 0; i < size2; ++i) {
                entryInfo = collection.get(i);
                sourceEntryId = entryInfo.getSourceBillEntryId();
                if (!resultSet.contains(sourceEntryId)) continue;
                lineNum.append(i + 1).append(SCMUtils.getResource((String)RESOURCE, (String)"Comma", (Context)ctx));
            }
            if (lineNum.length() > 0) {
                String lineMsg = SCMUtils.getResource((String)RESOURCE, (String)"Line", (String[])new String[]{lineNum.substring(0, lineNum.length() - 1)}, (Context)ctx);
                String msg = SCMUtils.getResource((String)RESOURCE, (String)"RETURN_GT_OUT_QRY", (String[])new String[]{lineMsg}, (Context)ctx);
                throw new InvBizException(InvBizException.COMMON, new String[]{msg});
            }
        }
    }
}

