/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv.vrule.app.other;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.scm.framework.validator.bizrule.app.AbstractServerVRule;
import com.kingdee.eas.scm.im.inv.AdjustException;
import com.kingdee.eas.scm.im.inv.InvBizException;
import com.kingdee.eas.scm.im.inv.OtherInWarehsBillInfo;
import com.kingdee.eas.scm.im.inv.OtherIssueBillInfo;
import com.kingdee.eas.scm.util.constant.SCMConstant;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.LocaleUtils;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.Locale;

public class CheckAdjustDiffVRule
extends AbstractServerVRule {
    public CheckAdjustDiffVRule(Context ctx) {
        super(ctx);
    }

    public boolean supports(Class<? extends IObjectValue> clazz) {
        return OtherIssueBillInfo.class.isAssignableFrom(clazz) || OtherInWarehsBillInfo.class.isAssignableFrom(clazz);
    }

    public void validate(IObjectValue bean) throws BOSException, EASBizException {
        assert (bean != null);
        if (bean instanceof OtherInWarehsBillInfo) {
            this.checkAdjustDiff4OtherInwarehs(this.getCtx(), (OtherInWarehsBillInfo)bean);
        } else if (bean instanceof OtherIssueBillInfo) {
            this.checkAdjustDiff4OtherIssue(this.getCtx(), (OtherIssueBillInfo)bean);
        }
    }

    private void checkAdjustDiff4OtherInwarehs(Context ctx, OtherInWarehsBillInfo billInfo) throws EASBizException, BOSException {
        if (!billInfo.getBizType().getId().toString().equals("mxmcXEczQ52MGxLV1Oyh9SQHQ1w=")) {
            return;
        }
        BigDecimal qty = SCMConstant.BIGDECIMAL_ZERO;
        BigDecimal baseQty = SCMConstant.BIGDECIMAL_ZERO;
        BigDecimal assistQty = SCMConstant.BIGDECIMAL_ZERO;
        String loc = LocaleUtils.getLocaleString((Locale)ctx.getLocale());
        String sql = "select inventory.FCurStoreQty as qty ,inventory.FBaseQty as baseQty,inventory.FCurStoreAssistQty as assistQty,  entry.Fseq as seq ,material.Fnumber as number , material.fname_" + loc + " as name  from  T_IM_OtherInWarehsBill bill inner join T_IM_OtherInWarehsBillEntry entry on bill.fid = entry.fparentid inner join t_im_inventory inventory on  entry.FSourceBillEntryID = inventory.fid inner join T_BD_Material material on inventory.FMaterialID = material.fid where bill.fid = '" + billInfo.getId().toString() + "'";
        String msg = "";
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
            while (rs.next()) {
                qty = rs.getBigDecimal("qty");
                if (this.isNeedAdjust(qty, baseQty = rs.getBigDecimal("baseQty"), assistQty = rs.getBigDecimal("assistQty"))) continue;
                InvBizException invbizException = new InvBizException(InvBizException.HAVE_NO_DIFFER, new Object[]{"[" + rs.getInt("seq") + "]", "[" + rs.getString("number") + "]", "[" + rs.getString("name") + "]"});
                if (msg.length() > 0) {
                    msg = msg + "\n";
                }
                msg = msg + invbizException.getMessage();
            }
            if (msg.length() > 0) {
                throw new AdjustException(AdjustException.PART_NO_DIFFER, new Object[]{msg});
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
    }

    private void checkAdjustDiff4OtherIssue(Context ctx, OtherIssueBillInfo billInfo) throws EASBizException, BOSException {
        if (!billInfo.getBizType().getId().toString().equals("KVe1UEnNT260YmBCLwKZKSQHQ1w=")) {
            return;
        }
        BigDecimal qty = SCMConstant.BIGDECIMAL_ZERO;
        BigDecimal baseQty = SCMConstant.BIGDECIMAL_ZERO;
        BigDecimal assistQty = SCMConstant.BIGDECIMAL_ZERO;
        String loc = LocaleUtils.getLocaleString((Locale)ctx.getLocale());
        String sql = "select inventory.FCurStoreQty as qty ,inventory.FBaseQty as baseQty,inventory.FCurStoreAssistQty as assistQty,  entry.Fseq as seq ,material.Fnumber as number , material.fname_" + loc + " as name  from  T_IM_OtherIssueBill bill inner join T_IM_OtherIssueBillEntry entry on bill.fid = entry.fparentid inner join t_im_inventory inventory on  entry.FSourceBillEntryID = inventory.fid inner join T_BD_Material material on inventory.FMaterialID = material.fid where bill.fid = '" + billInfo.getId().toString() + "'";
        String msg = "";
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
            while (rs.next()) {
                qty = rs.getBigDecimal("qty");
                if (this.isNeedAdjust(qty, baseQty = rs.getBigDecimal("baseQty"), assistQty = rs.getBigDecimal("assistQty"))) continue;
                InvBizException invbizException = new InvBizException(InvBizException.HAVE_NO_DIFFER, new Object[]{"[" + rs.getInt("seq") + "]", "[" + rs.getString("number") + "]", "[" + rs.getString("name") + "]"});
                msg = msg + invbizException.getMessage();
            }
            if (msg.length() > 0) {
                throw new AdjustException(AdjustException.PART_NO_DIFFER, new Object[]{msg});
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
    }

    private boolean isNeedAdjust(BigDecimal qty, BigDecimal baseQty, BigDecimal assistQty) {
        boolean isNeedAdjust = true;
        BigDecimal ZERO = new BigDecimal("0.00");
        qty = qty == null ? ZERO : qty;
        BigDecimal bigDecimal = baseQty = baseQty == null ? ZERO : baseQty;
        if (qty.multiply(baseQty).compareTo(ZERO) <= 0 && !qty.equals(baseQty)) {
            return isNeedAdjust;
        }
        if (qty.compareTo(ZERO) == 0 && baseQty.compareTo(ZERO) == 0 && assistQty.compareTo(ZERO) != 0) {
            return isNeedAdjust;
        }
        isNeedAdjust = false;
        return isNeedAdjust;
    }
}

