/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.im.inv.vrule.app.pur;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.scm.framework.dataloader.IDataCache;
import com.kingdee.eas.scm.framework.validator.IVRule;
import com.kingdee.eas.scm.im.inv.InvBizException;
import com.kingdee.eas.scm.im.inv.PurReceivalBillInfo;
import com.kingdee.eas.scm.im.inv.PurReceivalEntryCollection;
import com.kingdee.eas.scm.im.inv.PurReceivalEntryInfo;
import com.kingdee.eas.scm.util.numeric.NumericUtil;
import java.math.BigDecimal;

public class CheckPurReceivalEntryQtyVRule
implements IVRule {
    public boolean supports(Class<? extends IObjectValue> clazz) {
        return PurReceivalBillInfo.class.isAssignableFrom(clazz);
    }

    public void setInjectData(IDataCache injectData) {
    }

    public void validate(IObjectValue bean) throws BOSException, EASBizException {
        PurReceivalBillInfo info = (PurReceivalBillInfo)bean;
        if (null == info) {
            return;
        }
        PurReceivalEntryCollection entryCol = info.getEntry();
        int size = entryCol.size();
        for (int i = 0; i < size; ++i) {
            PurReceivalEntryInfo entry = entryCol.get(i);
            BigDecimal qualifiedQty = NumericUtil.null2Zero((BigDecimal)entry.getQualifiedQty());
            BigDecimal unqualifiedQty = NumericUtil.null2Zero((BigDecimal)entry.getUnqualifiedQty());
            BigDecimal concessiveRecQty = NumericUtil.null2Zero((BigDecimal)entry.getConcessiveRecQty());
            BigDecimal qty = NumericUtil.null2Zero((BigDecimal)entry.getQty());
            if (qualifiedQty.add(unqualifiedQty).add(concessiveRecQty).compareTo(qty.abs()) <= 0) continue;
            throw new InvBizException(InvBizException.QUALYQTY_CANNOT_ABOVEQTY);
        }
    }
}

